with Ada.Text_IO; use Ada.Text_IO;

with GNU.DB.SQLite3; use GNU.DB.SQLite3;

procedure Demo
is
   --Version : constant String := "$Id: demo.adb,v 1.2 2007/08/24 21:22:42 persan Exp $";

   function List
     (Argc        : Integer;
      Argv        : String_Vectors.Vector;
      ColumnNames : String_Vectors.Vector)
      return Return_Value is
   begin
      for I in Natural'(0) .. Natural (Argc - 1) loop
         Put_Line (ColumnNames.Element (I)  & ": " & Argv.Element (I));
      end loop;

      return SQLITE_OK;
   end List;


   Db      : aliased GNU.DB.SQLite3.Object;
   Table   : Table_Reference := new String_Tables.Vector;
   Result  : Return_Value;
   pragma Warnings (Off, Table);
   pragma Warnings (Off, Result);
begin
   Put_Line ("Opening the file example.db");

   Result := Db.Open ("demo.db");

   Put_Line ("Create a table called DEMO with fields bla, ble and blo");

   Db.Exec ("CREATE TABLE demo(bla INT, ble INT, blo INT);");
   Db.Exec ("CREATE TABLE tare(Name String, Time Float, Data BLOB);");

   New_Line;
   Put_Line ("Insert 10 rows with (100, 200, 300)");

   for I in 1 .. 10 loop
      Db.Exec ("INSERT INTO demo VALUES(" & I'Img & ", 200, 300);");
   end loop;

   New_Line;
   Put_Line ("Select everything in table DEMO");

   New_Line;
   Put_Line ("1: Using get_table");

   Result := Db.Get_Table ("SELECT * FROM demo;", Table);


--     for I in Table.Table'Range loop
--        for J in Table.Table (I)'Range loop
--           Put (To_String (Table.Table (I) (J)));
--           Put (" ");
--        end loop;
--
--        New_Line;
--     end loop;

   New_Line;
   Put_Line ("2: Using exec_with_callback");
   Db.Exec ("SELECT * FROM demo where bla > 4;", List'Unrestricted_Access);
   New_Line;
   Put_Line ("Drop table DEMO");

   Result := Db.Exec ("DROP TABLE demo;");
   Db.Close;

end Demo;
