//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/eng/tools/profileBuilder

package datacollection

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/monitor/mgmt/2021-09-01-preview/datacollection"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type CreatedByType = original.CreatedByType

const (
	CreatedByTypeApplication     CreatedByType = original.CreatedByTypeApplication
	CreatedByTypeKey             CreatedByType = original.CreatedByTypeKey
	CreatedByTypeManagedIdentity CreatedByType = original.CreatedByTypeManagedIdentity
	CreatedByTypeUser            CreatedByType = original.CreatedByTypeUser
)

type KnownColumnDefinitionType = original.KnownColumnDefinitionType

const (
	KnownColumnDefinitionTypeBoolean  KnownColumnDefinitionType = original.KnownColumnDefinitionTypeBoolean
	KnownColumnDefinitionTypeDatetime KnownColumnDefinitionType = original.KnownColumnDefinitionTypeDatetime
	KnownColumnDefinitionTypeDynamic  KnownColumnDefinitionType = original.KnownColumnDefinitionTypeDynamic
	KnownColumnDefinitionTypeInt      KnownColumnDefinitionType = original.KnownColumnDefinitionTypeInt
	KnownColumnDefinitionTypeLong     KnownColumnDefinitionType = original.KnownColumnDefinitionTypeLong
	KnownColumnDefinitionTypeReal     KnownColumnDefinitionType = original.KnownColumnDefinitionTypeReal
	KnownColumnDefinitionTypeString   KnownColumnDefinitionType = original.KnownColumnDefinitionTypeString
)

type KnownDataCollectionEndpointProvisioningState = original.KnownDataCollectionEndpointProvisioningState

const (
	KnownDataCollectionEndpointProvisioningStateCreating  KnownDataCollectionEndpointProvisioningState = original.KnownDataCollectionEndpointProvisioningStateCreating
	KnownDataCollectionEndpointProvisioningStateDeleting  KnownDataCollectionEndpointProvisioningState = original.KnownDataCollectionEndpointProvisioningStateDeleting
	KnownDataCollectionEndpointProvisioningStateFailed    KnownDataCollectionEndpointProvisioningState = original.KnownDataCollectionEndpointProvisioningStateFailed
	KnownDataCollectionEndpointProvisioningStateSucceeded KnownDataCollectionEndpointProvisioningState = original.KnownDataCollectionEndpointProvisioningStateSucceeded
	KnownDataCollectionEndpointProvisioningStateUpdating  KnownDataCollectionEndpointProvisioningState = original.KnownDataCollectionEndpointProvisioningStateUpdating
)

type KnownDataCollectionEndpointResourceKind = original.KnownDataCollectionEndpointResourceKind

const (
	KnownDataCollectionEndpointResourceKindLinux   KnownDataCollectionEndpointResourceKind = original.KnownDataCollectionEndpointResourceKindLinux
	KnownDataCollectionEndpointResourceKindWindows KnownDataCollectionEndpointResourceKind = original.KnownDataCollectionEndpointResourceKindWindows
)

type KnownDataCollectionRuleAssociationProvisioningState = original.KnownDataCollectionRuleAssociationProvisioningState

const (
	KnownDataCollectionRuleAssociationProvisioningStateCreating  KnownDataCollectionRuleAssociationProvisioningState = original.KnownDataCollectionRuleAssociationProvisioningStateCreating
	KnownDataCollectionRuleAssociationProvisioningStateDeleting  KnownDataCollectionRuleAssociationProvisioningState = original.KnownDataCollectionRuleAssociationProvisioningStateDeleting
	KnownDataCollectionRuleAssociationProvisioningStateFailed    KnownDataCollectionRuleAssociationProvisioningState = original.KnownDataCollectionRuleAssociationProvisioningStateFailed
	KnownDataCollectionRuleAssociationProvisioningStateSucceeded KnownDataCollectionRuleAssociationProvisioningState = original.KnownDataCollectionRuleAssociationProvisioningStateSucceeded
	KnownDataCollectionRuleAssociationProvisioningStateUpdating  KnownDataCollectionRuleAssociationProvisioningState = original.KnownDataCollectionRuleAssociationProvisioningStateUpdating
)

type KnownDataCollectionRuleProvisioningState = original.KnownDataCollectionRuleProvisioningState

const (
	KnownDataCollectionRuleProvisioningStateCreating  KnownDataCollectionRuleProvisioningState = original.KnownDataCollectionRuleProvisioningStateCreating
	KnownDataCollectionRuleProvisioningStateDeleting  KnownDataCollectionRuleProvisioningState = original.KnownDataCollectionRuleProvisioningStateDeleting
	KnownDataCollectionRuleProvisioningStateFailed    KnownDataCollectionRuleProvisioningState = original.KnownDataCollectionRuleProvisioningStateFailed
	KnownDataCollectionRuleProvisioningStateSucceeded KnownDataCollectionRuleProvisioningState = original.KnownDataCollectionRuleProvisioningStateSucceeded
	KnownDataCollectionRuleProvisioningStateUpdating  KnownDataCollectionRuleProvisioningState = original.KnownDataCollectionRuleProvisioningStateUpdating
)

type KnownDataCollectionRuleResourceKind = original.KnownDataCollectionRuleResourceKind

const (
	KnownDataCollectionRuleResourceKindLinux   KnownDataCollectionRuleResourceKind = original.KnownDataCollectionRuleResourceKindLinux
	KnownDataCollectionRuleResourceKindWindows KnownDataCollectionRuleResourceKind = original.KnownDataCollectionRuleResourceKindWindows
)

type KnownDataFlowStreams = original.KnownDataFlowStreams

const (
	KnownDataFlowStreamsMicrosoftEvent           KnownDataFlowStreams = original.KnownDataFlowStreamsMicrosoftEvent
	KnownDataFlowStreamsMicrosoftInsightsMetrics KnownDataFlowStreams = original.KnownDataFlowStreamsMicrosoftInsightsMetrics
	KnownDataFlowStreamsMicrosoftPerf            KnownDataFlowStreams = original.KnownDataFlowStreamsMicrosoftPerf
	KnownDataFlowStreamsMicrosoftSyslog          KnownDataFlowStreams = original.KnownDataFlowStreamsMicrosoftSyslog
	KnownDataFlowStreamsMicrosoftWindowsEvent    KnownDataFlowStreams = original.KnownDataFlowStreamsMicrosoftWindowsEvent
)

type KnownExtensionDataSourceStreams = original.KnownExtensionDataSourceStreams

const (
	KnownExtensionDataSourceStreamsMicrosoftEvent           KnownExtensionDataSourceStreams = original.KnownExtensionDataSourceStreamsMicrosoftEvent
	KnownExtensionDataSourceStreamsMicrosoftInsightsMetrics KnownExtensionDataSourceStreams = original.KnownExtensionDataSourceStreamsMicrosoftInsightsMetrics
	KnownExtensionDataSourceStreamsMicrosoftPerf            KnownExtensionDataSourceStreams = original.KnownExtensionDataSourceStreamsMicrosoftPerf
	KnownExtensionDataSourceStreamsMicrosoftSyslog          KnownExtensionDataSourceStreams = original.KnownExtensionDataSourceStreamsMicrosoftSyslog
	KnownExtensionDataSourceStreamsMicrosoftWindowsEvent    KnownExtensionDataSourceStreams = original.KnownExtensionDataSourceStreamsMicrosoftWindowsEvent
)

type KnownLogFileTextSettingsRecordStartTimestampFormat = original.KnownLogFileTextSettingsRecordStartTimestampFormat

const (
	KnownLogFileTextSettingsRecordStartTimestampFormatDdMMMyyyyHHmmsszzz KnownLogFileTextSettingsRecordStartTimestampFormat = original.KnownLogFileTextSettingsRecordStartTimestampFormatDdMMMyyyyHHmmsszzz
	KnownLogFileTextSettingsRecordStartTimestampFormatDdMMyyHHmmss       KnownLogFileTextSettingsRecordStartTimestampFormat = original.KnownLogFileTextSettingsRecordStartTimestampFormatDdMMyyHHmmss
	KnownLogFileTextSettingsRecordStartTimestampFormatISO8601            KnownLogFileTextSettingsRecordStartTimestampFormat = original.KnownLogFileTextSettingsRecordStartTimestampFormatISO8601
	KnownLogFileTextSettingsRecordStartTimestampFormatMDYYYYHHMMSSAMPM   KnownLogFileTextSettingsRecordStartTimestampFormat = original.KnownLogFileTextSettingsRecordStartTimestampFormatMDYYYYHHMMSSAMPM
	KnownLogFileTextSettingsRecordStartTimestampFormatMMMdhhmmss         KnownLogFileTextSettingsRecordStartTimestampFormat = original.KnownLogFileTextSettingsRecordStartTimestampFormatMMMdhhmmss
	KnownLogFileTextSettingsRecordStartTimestampFormatMonDDYYYYHHMMSS    KnownLogFileTextSettingsRecordStartTimestampFormat = original.KnownLogFileTextSettingsRecordStartTimestampFormatMonDDYYYYHHMMSS
	KnownLogFileTextSettingsRecordStartTimestampFormatYyMMddHHmmss       KnownLogFileTextSettingsRecordStartTimestampFormat = original.KnownLogFileTextSettingsRecordStartTimestampFormatYyMMddHHmmss
	KnownLogFileTextSettingsRecordStartTimestampFormatYYYYMMDDHHMMSS     KnownLogFileTextSettingsRecordStartTimestampFormat = original.KnownLogFileTextSettingsRecordStartTimestampFormatYYYYMMDDHHMMSS
	KnownLogFileTextSettingsRecordStartTimestampFormatYyyyMMDdTHHmmssK   KnownLogFileTextSettingsRecordStartTimestampFormat = original.KnownLogFileTextSettingsRecordStartTimestampFormatYyyyMMDdTHHmmssK
)

type KnownPerfCounterDataSourceStreams = original.KnownPerfCounterDataSourceStreams

const (
	KnownPerfCounterDataSourceStreamsMicrosoftInsightsMetrics KnownPerfCounterDataSourceStreams = original.KnownPerfCounterDataSourceStreamsMicrosoftInsightsMetrics
	KnownPerfCounterDataSourceStreamsMicrosoftPerf            KnownPerfCounterDataSourceStreams = original.KnownPerfCounterDataSourceStreamsMicrosoftPerf
)

type KnownPublicNetworkAccessOptions = original.KnownPublicNetworkAccessOptions

const (
	KnownPublicNetworkAccessOptionsDisabled KnownPublicNetworkAccessOptions = original.KnownPublicNetworkAccessOptionsDisabled
	KnownPublicNetworkAccessOptionsEnabled  KnownPublicNetworkAccessOptions = original.KnownPublicNetworkAccessOptionsEnabled
)

type KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNames

const (
	KnownSyslogDataSourceFacilityNamesAsterisk KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesAsterisk
	KnownSyslogDataSourceFacilityNamesAuth     KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesAuth
	KnownSyslogDataSourceFacilityNamesAuthpriv KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesAuthpriv
	KnownSyslogDataSourceFacilityNamesCron     KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesCron
	KnownSyslogDataSourceFacilityNamesDaemon   KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesDaemon
	KnownSyslogDataSourceFacilityNamesKern     KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesKern
	KnownSyslogDataSourceFacilityNamesLocal0   KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesLocal0
	KnownSyslogDataSourceFacilityNamesLocal1   KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesLocal1
	KnownSyslogDataSourceFacilityNamesLocal2   KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesLocal2
	KnownSyslogDataSourceFacilityNamesLocal3   KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesLocal3
	KnownSyslogDataSourceFacilityNamesLocal4   KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesLocal4
	KnownSyslogDataSourceFacilityNamesLocal5   KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesLocal5
	KnownSyslogDataSourceFacilityNamesLocal6   KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesLocal6
	KnownSyslogDataSourceFacilityNamesLocal7   KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesLocal7
	KnownSyslogDataSourceFacilityNamesLpr      KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesLpr
	KnownSyslogDataSourceFacilityNamesMail     KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesMail
	KnownSyslogDataSourceFacilityNamesMark     KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesMark
	KnownSyslogDataSourceFacilityNamesNews     KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesNews
	KnownSyslogDataSourceFacilityNamesSyslog   KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesSyslog
	KnownSyslogDataSourceFacilityNamesUser     KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesUser
	KnownSyslogDataSourceFacilityNamesUucp     KnownSyslogDataSourceFacilityNames = original.KnownSyslogDataSourceFacilityNamesUucp
)

type KnownSyslogDataSourceLogLevels = original.KnownSyslogDataSourceLogLevels

const (
	KnownSyslogDataSourceLogLevelsAlert     KnownSyslogDataSourceLogLevels = original.KnownSyslogDataSourceLogLevelsAlert
	KnownSyslogDataSourceLogLevelsAsterisk  KnownSyslogDataSourceLogLevels = original.KnownSyslogDataSourceLogLevelsAsterisk
	KnownSyslogDataSourceLogLevelsCritical  KnownSyslogDataSourceLogLevels = original.KnownSyslogDataSourceLogLevelsCritical
	KnownSyslogDataSourceLogLevelsDebug     KnownSyslogDataSourceLogLevels = original.KnownSyslogDataSourceLogLevelsDebug
	KnownSyslogDataSourceLogLevelsEmergency KnownSyslogDataSourceLogLevels = original.KnownSyslogDataSourceLogLevelsEmergency
	KnownSyslogDataSourceLogLevelsError     KnownSyslogDataSourceLogLevels = original.KnownSyslogDataSourceLogLevelsError
	KnownSyslogDataSourceLogLevelsInfo      KnownSyslogDataSourceLogLevels = original.KnownSyslogDataSourceLogLevelsInfo
	KnownSyslogDataSourceLogLevelsNotice    KnownSyslogDataSourceLogLevels = original.KnownSyslogDataSourceLogLevelsNotice
	KnownSyslogDataSourceLogLevelsWarning   KnownSyslogDataSourceLogLevels = original.KnownSyslogDataSourceLogLevelsWarning
)

type KnownSyslogDataSourceStreams = original.KnownSyslogDataSourceStreams

const (
	KnownSyslogDataSourceStreamsMicrosoftSyslog KnownSyslogDataSourceStreams = original.KnownSyslogDataSourceStreamsMicrosoftSyslog
)

type KnownWindowsEventLogDataSourceStreams = original.KnownWindowsEventLogDataSourceStreams

const (
	KnownWindowsEventLogDataSourceStreamsMicrosoftEvent        KnownWindowsEventLogDataSourceStreams = original.KnownWindowsEventLogDataSourceStreamsMicrosoftEvent
	KnownWindowsEventLogDataSourceStreamsMicrosoftWindowsEvent KnownWindowsEventLogDataSourceStreams = original.KnownWindowsEventLogDataSourceStreamsMicrosoftWindowsEvent
)

type AzureMonitorMetricsDestination = original.AzureMonitorMetricsDestination
type BaseClient = original.BaseClient
type ColumnDefinition = original.ColumnDefinition
type ConfigurationAccessEndpointSpec = original.ConfigurationAccessEndpointSpec
type DataFlow = original.DataFlow
type DataSourcesSpec = original.DataSourcesSpec
type DestinationsSpec = original.DestinationsSpec
type DestinationsSpecAzureMonitorMetrics = original.DestinationsSpecAzureMonitorMetrics
type Endpoint = original.Endpoint
type EndpointConfigurationAccess = original.EndpointConfigurationAccess
type EndpointLogsIngestion = original.EndpointLogsIngestion
type EndpointNetworkAcls = original.EndpointNetworkAcls
type EndpointResource = original.EndpointResource
type EndpointResourceListResult = original.EndpointResourceListResult
type EndpointResourceListResultIterator = original.EndpointResourceListResultIterator
type EndpointResourceListResultPage = original.EndpointResourceListResultPage
type EndpointResourceProperties = original.EndpointResourceProperties
type EndpointResourceSystemData = original.EndpointResourceSystemData
type EndpointsClient = original.EndpointsClient
type ErrorAdditionalInfo = original.ErrorAdditionalInfo
type ErrorDetail = original.ErrorDetail
type ErrorResponseCommonV2 = original.ErrorResponseCommonV2
type ExtensionDataSource = original.ExtensionDataSource
type IisLogsDataSource = original.IisLogsDataSource
type LogAnalyticsDestination = original.LogAnalyticsDestination
type LogFileSettings = original.LogFileSettings
type LogFileSettingsText = original.LogFileSettingsText
type LogFileTextSettings = original.LogFileTextSettings
type LogFilesDataSource = original.LogFilesDataSource
type LogFilesDataSourceSettings = original.LogFilesDataSourceSettings
type LogsIngestionEndpointSpec = original.LogsIngestionEndpointSpec
type Metadata = original.Metadata
type NetworkRuleSet = original.NetworkRuleSet
type PerfCounterDataSource = original.PerfCounterDataSource
type ResourceForUpdate = original.ResourceForUpdate
type Rule = original.Rule
type RuleAssociation = original.RuleAssociation
type RuleAssociationMetadata = original.RuleAssociationMetadata
type RuleAssociationProxyOnlyResource = original.RuleAssociationProxyOnlyResource
type RuleAssociationProxyOnlyResourceListResult = original.RuleAssociationProxyOnlyResourceListResult
type RuleAssociationProxyOnlyResourceListResultIterator = original.RuleAssociationProxyOnlyResourceListResultIterator
type RuleAssociationProxyOnlyResourceListResultPage = original.RuleAssociationProxyOnlyResourceListResultPage
type RuleAssociationProxyOnlyResourceProperties = original.RuleAssociationProxyOnlyResourceProperties
type RuleAssociationProxyOnlyResourceSystemData = original.RuleAssociationProxyOnlyResourceSystemData
type RuleAssociationsClient = original.RuleAssociationsClient
type RuleDataSources = original.RuleDataSources
type RuleDestinations = original.RuleDestinations
type RuleMetadata = original.RuleMetadata
type RuleResource = original.RuleResource
type RuleResourceListResult = original.RuleResourceListResult
type RuleResourceListResultIterator = original.RuleResourceListResultIterator
type RuleResourceListResultPage = original.RuleResourceListResultPage
type RuleResourceProperties = original.RuleResourceProperties
type RuleResourceSystemData = original.RuleResourceSystemData
type RulesClient = original.RulesClient
type StreamDeclaration = original.StreamDeclaration
type SyslogDataSource = original.SyslogDataSource
type SystemData = original.SystemData
type WindowsEventLogDataSource = original.WindowsEventLogDataSource

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewEndpointResourceListResultIterator(page EndpointResourceListResultPage) EndpointResourceListResultIterator {
	return original.NewEndpointResourceListResultIterator(page)
}
func NewEndpointResourceListResultPage(cur EndpointResourceListResult, getNextPage func(context.Context, EndpointResourceListResult) (EndpointResourceListResult, error)) EndpointResourceListResultPage {
	return original.NewEndpointResourceListResultPage(cur, getNextPage)
}
func NewEndpointsClient(subscriptionID string) EndpointsClient {
	return original.NewEndpointsClient(subscriptionID)
}
func NewEndpointsClientWithBaseURI(baseURI string, subscriptionID string) EndpointsClient {
	return original.NewEndpointsClientWithBaseURI(baseURI, subscriptionID)
}
func NewRuleAssociationProxyOnlyResourceListResultIterator(page RuleAssociationProxyOnlyResourceListResultPage) RuleAssociationProxyOnlyResourceListResultIterator {
	return original.NewRuleAssociationProxyOnlyResourceListResultIterator(page)
}
func NewRuleAssociationProxyOnlyResourceListResultPage(cur RuleAssociationProxyOnlyResourceListResult, getNextPage func(context.Context, RuleAssociationProxyOnlyResourceListResult) (RuleAssociationProxyOnlyResourceListResult, error)) RuleAssociationProxyOnlyResourceListResultPage {
	return original.NewRuleAssociationProxyOnlyResourceListResultPage(cur, getNextPage)
}
func NewRuleAssociationsClient(subscriptionID string) RuleAssociationsClient {
	return original.NewRuleAssociationsClient(subscriptionID)
}
func NewRuleAssociationsClientWithBaseURI(baseURI string, subscriptionID string) RuleAssociationsClient {
	return original.NewRuleAssociationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewRuleResourceListResultIterator(page RuleResourceListResultPage) RuleResourceListResultIterator {
	return original.NewRuleResourceListResultIterator(page)
}
func NewRuleResourceListResultPage(cur RuleResourceListResult, getNextPage func(context.Context, RuleResourceListResult) (RuleResourceListResult, error)) RuleResourceListResultPage {
	return original.NewRuleResourceListResultPage(cur, getNextPage)
}
func NewRulesClient(subscriptionID string) RulesClient {
	return original.NewRulesClient(subscriptionID)
}
func NewRulesClientWithBaseURI(baseURI string, subscriptionID string) RulesClient {
	return original.NewRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleCreatedByTypeValues() []CreatedByType {
	return original.PossibleCreatedByTypeValues()
}
func PossibleKnownColumnDefinitionTypeValues() []KnownColumnDefinitionType {
	return original.PossibleKnownColumnDefinitionTypeValues()
}
func PossibleKnownDataCollectionEndpointProvisioningStateValues() []KnownDataCollectionEndpointProvisioningState {
	return original.PossibleKnownDataCollectionEndpointProvisioningStateValues()
}
func PossibleKnownDataCollectionEndpointResourceKindValues() []KnownDataCollectionEndpointResourceKind {
	return original.PossibleKnownDataCollectionEndpointResourceKindValues()
}
func PossibleKnownDataCollectionRuleAssociationProvisioningStateValues() []KnownDataCollectionRuleAssociationProvisioningState {
	return original.PossibleKnownDataCollectionRuleAssociationProvisioningStateValues()
}
func PossibleKnownDataCollectionRuleProvisioningStateValues() []KnownDataCollectionRuleProvisioningState {
	return original.PossibleKnownDataCollectionRuleProvisioningStateValues()
}
func PossibleKnownDataCollectionRuleResourceKindValues() []KnownDataCollectionRuleResourceKind {
	return original.PossibleKnownDataCollectionRuleResourceKindValues()
}
func PossibleKnownDataFlowStreamsValues() []KnownDataFlowStreams {
	return original.PossibleKnownDataFlowStreamsValues()
}
func PossibleKnownExtensionDataSourceStreamsValues() []KnownExtensionDataSourceStreams {
	return original.PossibleKnownExtensionDataSourceStreamsValues()
}
func PossibleKnownLogFileTextSettingsRecordStartTimestampFormatValues() []KnownLogFileTextSettingsRecordStartTimestampFormat {
	return original.PossibleKnownLogFileTextSettingsRecordStartTimestampFormatValues()
}
func PossibleKnownPerfCounterDataSourceStreamsValues() []KnownPerfCounterDataSourceStreams {
	return original.PossibleKnownPerfCounterDataSourceStreamsValues()
}
func PossibleKnownPublicNetworkAccessOptionsValues() []KnownPublicNetworkAccessOptions {
	return original.PossibleKnownPublicNetworkAccessOptionsValues()
}
func PossibleKnownSyslogDataSourceFacilityNamesValues() []KnownSyslogDataSourceFacilityNames {
	return original.PossibleKnownSyslogDataSourceFacilityNamesValues()
}
func PossibleKnownSyslogDataSourceLogLevelsValues() []KnownSyslogDataSourceLogLevels {
	return original.PossibleKnownSyslogDataSourceLogLevelsValues()
}
func PossibleKnownSyslogDataSourceStreamsValues() []KnownSyslogDataSourceStreams {
	return original.PossibleKnownSyslogDataSourceStreamsValues()
}
func PossibleKnownWindowsEventLogDataSourceStreamsValues() []KnownWindowsEventLogDataSourceStreams {
	return original.PossibleKnownWindowsEventLogDataSourceStreamsValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
