#include "eval/kingEval.h"
#include "osl/record/csaString.h"
#include "osl/record/csaRecord.h"

#include "gtest/gtest.h"

using namespace osl;
using namespace osl::state;
using namespace osl::record;

TEST(KingEffect3, countPieces)
{
  const NumEffectState state(CsaString(
			       "P1-KY-KE-GI-KI * +KI * -KE-OU\n"
			       "P2 * -HI *  *  *  * +NK-GI-KY\n"
			       "P3-FU-FU-FU-FU-FU-FU-FU-FU-FU\n"
			       "P4 *  *  *  *  *  *  *  *  * \n"
			       "P5-KA *  *  *  *  *  *  *  * \n"
			       "P6+FU *  *  *  *  *  *  *  * \n"
			       "P7 * +FU+FU+FU+FU+FU+FU+FU * \n"
			       "P8 * +KA *  *  *  *  * +HI * \n"
			       "P9 *  * +GI+KI+OU+KI+GI * +KY\n"
			       "P+00KE00KY00FU\n"
			       "+\n").getInitialState());
  int piece_count, stand_count, attacked_count;
  bool with_knight, stand_with_knight;
  gpsshogi::King25Effect3::countPieces<BLACK>(state, piece_count, with_knight,
					      stand_count, stand_with_knight,
					      attacked_count);
  ASSERT_EQ(2, piece_count);
  ASSERT_EQ(0, stand_count);
  ASSERT_EQ(1, attacked_count);
  ASSERT_FALSE(with_knight);
  ASSERT_TRUE(stand_with_knight);
}
