# - Find oniguruma
# Find the native Oniguruma includes and library
#
#  ONIGURUMA_INCLUDE_DIRS - where to find oniguruma.h, etc.
#  ONIGURUMA_LIBRARIES    - List of libraries when using oniguruma.
#  ONIGURUMA_FOUND        - True if oniguruma found.


IF (ONIGURUMA_INCLUDE_DIRS)
  # Already in cache, be silent
  SET(ONIGURUMA_FIND_QUIETLY TRUE)
ENDIF ()

FIND_PATH(ONIGURUMA_INCLUDE_DIR oniguruma.h)

SET(ONIGURUMA_NAMES onig)
FIND_LIBRARY(ONIGURUMA_LIBRARY NAMES ${ONIGURUMA_NAMES} )

INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(ONIGURUMA DEFAULT_MSG ONIGURUMA_LIBRARY ONIGURUMA_INCLUDE_DIR)

IF(ONIGURUMA_FOUND)
  SET( ONIGURUMA_LIBRARIES ${ONIGURUMA_LIBRARY} )
  SET( ONIGURUMA_INCLUDE_DIRS ${ONIGURUMA_INCLUDE_DIR} )
ELSE()
  SET( ONIGURUMA_LIBRARIES )
  SET( PONIGURUMA_INCLUDE_DIRS )
ENDIF()

MARK_AS_ADVANCED( ONIGURUMA_LIBRARIES ONIGURUMA_INCLUDE_DIRS )
