import solids;

size(300,0);

real k = 2;
real delta = 30;
real gamma = 10;
real mu = 10;

// points
triple C = unit((-1, 0, 0)) * k;
triple O = O;
triple P1 = rotate(-delta, Y) * rotate(gamma, Z) * (-C) + C;

// vectors
triple ki = -C;
triple kf = P1 - C;

// Planes
pen bg = gray(0.9) + opacity(0.5);

real r = 1.5;
pen p = rgb(0,0.7,0);
draw( Label("$x$",1), O--r*X, p, Arrow3(HookHead3));
draw( Label("$y$",1), O--r*Y, p, Arrow3(HookHead3));
draw( Label("$z$",1), O--r*Z, p, Arrow3(HookHead3));
label("$O$", (0,0,0), W);

// draw the ki vector
path3 ki_p = shift(C) * (O--ki);
draw(Label("$\vec{k_i}$", .5), ki_p, red, Arrow3);

// kf
path3 kf_p = shift(C) * (O--kf);
draw(Label("$\vec{k_f}$", .5), kf_p, red, Arrow3);

// Q
path3 Q_p = O--P1;
draw(Label("$\vec{Q}$", .5), Q_p, red, Arrow3);

// draw the dots
dot("$C$", C, p);
dot("$P_1$", P1, blue);

// rotation plan define by the rotation axis
triple omega = rotate(mu, Z) * -Y;
draw( Label("$\Omega$", 1), O--omega, blue, Arrow3(HookHead3));

// circle generated by the revolution of P around omega
triple C1 = planeproject(omega, P1) * O;
triple C2 = planeproject(omega, P1) * ki;
dot("$C_1$", C1, blue);
draw(O--C1, dashed+blue);
path3 Pcircle = circle(C1, length(P1-C1), omega);
draw(Pcircle, dashed+blue);

// Ewalds sphere
surface Ewalds = shift(C) * scale3(k) * unitsphere;
draw(Ewalds, green+opacity(0.3), render(compression=Zero,merge=true));

// intersection points of this Cricle with the Ewalds sphere
// and the arc, ATTENTION problem de precision lors du calcul
// des intersections. Pour l'instant ne pas utiliser delta > 160
triple P2 = rotate(180, C1, C2) * P1;
path3 Parc = arc(C1, P1, P2, omega, CW);
draw(C1--P1, blue);
dot("$P_2$", P2, blue);
draw(C1--P2, blue);
draw(Parc, blue, Arrows3());


