% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runParallel.r
\name{runParallel}
\alias{runParallel}
\title{runParallel}
\usage{
runParallel(
  onecore,
  reps,
  seed = round(runif(1, 0, 10000)),
  cores = max(1, parallel::detectCores() - 1),
  simplify = TRUE,
  along
)
}
\arguments{
\item{onecore}{function to run the analysis on one core}

\item{reps}{total number of repetitions}

\item{seed}{species the base random number seed.  The seed used for core i will be \code{seed} + \code{i}.}

\item{cores}{number of cores to use, defaulting to one less than the numbmer available}

\item{simplify}{set to FALSE to not create an outer list if a \code{onecore} result has only one element}

\item{along}{see above}
}
\value{
result from combining all the parallel runs, formatting as similar to the result produced from one run as possible
}
\description{
parallel Package Easy Front-End
}
\details{
Given a function \code{onecore} that runs the needed set of simulations on
one CPU core, and given a total number of repetitions \code{reps}, determines
the number of available cores and by default uses one less than that.
By default the number of cores is one less than the number available
on your machine.
reps is divided as evenly as possible over these cores, and batches
are run on the cores using the \code{parallel} package \code{mclapply} function.
The current per-core repetition number is continually updated in
your system's temporary directory (/tmp for Linux, TEMP for Windows)
in a file name progressX.log where X is the core number.
The random number seed is set for each core and is equal to
the scalar \code{seed} - core number + 1.  The default seed is a random
number between 0 and 10000 but it's best if the user provides the
seed so the simulation is reproducible.
The total run time is computed and printed
onefile must create a named list of all the results created during
that one simulation batch.  Elements of this list must be data frames,
vectors, matrices, or arrays.   Upon completion of all batches,
all the results are rbind'd and saved in a single list.

onecore must have an argument \code{reps} that will tell the function
how many simulations to run for one batch, another argument \code{showprogress}
which is a function to be called inside onecore to write to the
progress file for the current core and repetition, and an argument \code{core}
which informs \code{onecore} which sequential core number (batch number) it is
processing.
When calling \code{showprogress} inside \code{onecore}, the arguments, in order,
must be the integer value of the repetition to be noted, the number of reps,
\code{core}, an optional 4th argument \code{other} that can contain a single
character string to add to the output, and an optional 5th argument \code{pr}.
You can set \code{pr=FALSE} to suppress printing and have \code{showprogress}
return the file name for holding progress information if you want to
customize printing.

If any of the objects appearing as list elements produced by onecore
are multi-dimensional arrays, you must specify an integer value for
\code{along}.  This specifies to the \code{abind} package \code{abind} function
the dimension along which to bind the arrays.  For example, if the
first dimension of the array corresponding to repetitions, you would
specify along=1.   All arrays present must use the same \code{along} unless
\code{along} is a named vector and the names match elements of the
simulation result object.
Set \code{simplify=FALSE} if you don't want the result simplified if
onecore produces only one list element.  The default returns the
first (and only) list element rather than the list if there is only one
element.

See \href{https://hbiostat.org/rflow/parallel.html}{here} for examples.
}
\author{
Frank Harrell
}
