package CParse::Char;

use 5.6.0;
use strict;
use warnings;

use CParse::String qw/escape/;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;

    my $char = shift;
    my $wide = shift;

    my $self = {value => $char,
                wide => $wide,
               };
    bless $self, $class;
    return $self;
  }

sub dump_c
  {
    my $self = shift;

    my $value = escape($self->{value});

    return $self->{wide} ? "L'$value'" : "'$value'";
  }

sub get_expr
  {
    my $self = shift;

    my $namespace = shift;

    return new CExpr::Integer ord($self->{value});
  }

1;
