#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2009 Alessio Treglia
#
# This file is part of installation-report-generator.
#
# installation-report-generator is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# installation-report-generator is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with installation-report-generator.  If not, see <http://www.gnu.org/licenses/>.

import thread, time
import irgenerator.globals
from irgenerator.util.sysinfo import SystemInfo
from irgenerator.core.plugcentral import IPlugin, AbstractPlugin

#if not _:
#    _ = lambda x: x # only for test purposes

__version__ = (1,0)

distributions = [
        'Ubuntu',
        'Kubuntu',
        'Xubuntu',
        'Edubuntu',
        'Ubuntu Studio'
        ]

releases = {
    '9.04' : 'Jaunty Jackalope',
    '8.10' : 'Intrepid Ibex',
    '8.04' : 'Hardy Heron',
# "end-of-the-line" for gutsy on April '09 
#    '7.10' : 'Gutsy Gibbon',
    '6.06' : 'Dapper Drake'
    }

template = \
"""#format wiki
#LANGUAGE it
[[BR]]
||<tablestyle="width:37%%; float:right; margin:12px 0px 0px 0px; font-size:10px" style="background-image: url(http://wiki.ubuntu-it.org/NotebookModello?action=AttachFile&amp;do=get&amp;target=template-indice-top-sx.png);  border:none;" 15%% >[[BR]] ||||<style="border:none; background-color:#eae5da;" : 35%%> {*} '''Scheda tecnica'''||<style="background-image: url(http://wiki.ubuntu-it.org/NotebookModello/?action=AttachFile&amp;do=get&amp;target=template-indice-top-dx.png); background-position: top right; border:none; " 15%%>[[BR]] ||
||<#eae5da : 15%% style="border: medium none ;">||<#eae5da : 35%% style="border: medium none ;"(> '''Marca:'''||<#eae5da : 35%% style="border: medium none ;"(> %(vendor)s||<#eae5da : 15%% style="border: medium none ;">||
||<#eae5da : 15%% style="border: medium none ;">||<#eae5da : 35%% style="border: medium none ;"(> '''Modello:'''||<#eae5da : 35%% style="border: medium none ;"(> %(model)s||<#eae5da : 15%% style="border: medium none ;">||
||<#eae5da : 15%% style="border: medium none ;">||<#eae5da : 35%% style="border: medium none ;"(> '''Memoria RAM:'''||<#eae5da : 35%% style="border: medium none ;"(> %(memory)s||<#eae5da : 15%% style="border: medium none ;">||
||<#eae5da : 15%% style="border: medium none ;">||<#eae5da : 35%% style="border: medium none ;"(> '''Processore:'''||<#eae5da : 35%% style="border: medium none ;"(> %(cpu)s||<#eae5da : 15%% style="border: medium none ;">||
||<#eae5da : 15%% style="border: medium none ;">||<#eae5da : 35%% style="border: medium none ;"(> '''Scheda video:'''||<#eae5da : 35%% style="border: medium none ;"(> %(vga)s||<#eae5da : 15%% style="border: medium none ;">||
||<#eae5da : 15%% style="border: medium none ;">||<#eae5da : 35%% style="border: medium none ;"(> '''Distribuzione utilizzata:'''||<#eae5da : 35%% style="border: medium none ;"(>Ubuntu %(release)s «%(codename)s» ||<#eae5da : 15%% style="border: medium none ;">||
||<style="background-image: url(http://wiki.ubuntu-it.org/NotebookModello/?action=AttachFile&amp;do=get&amp;target=template-indice-bot-sx.png); border:none;background-position: bottom left;" 15%% >[[BR]]  ||<style="border:none; background-color:#eae5da;" -2 >[[BR]] ||<style="background-image: url(http://wiki.ubuntu-it.org/NotebookModello/?action=AttachFile&amp;do=get&amp;target=template-indice-bot-dx.png); background-position: bottom right; border:none; " 15%% >[[BR]] ||

||<style="border:none;">[[Immagine(NotebookModello/notebookprova.png,150,)]] ||<style="border:none;">In questa pagina è riportato il resoconto dell'installazione di '''Ubuntu %(release)s''' «'''%(codename)s'''» sul portatile '''%(vendor)s %(model)s'''.||
Inoltre verranno riportate le informazioni generali sul riconoscimento dell'hardware e i possibili metodi di installazione.

= Installazione =

= Rilevamento dell'hardware =

== Dispositivi connessi ==

Per verificare il corretto rilevamento dell'hardware del portatile, digitare in un terminale il seguente comando:
{{{
lspci
}}}

Il comando precedente restituirà una schermata simile alla seguente:
{{{
%(peripherals)s
}}}

== Processore ==

Per visualizzare i dettagli sul processore, aprire in lettura il file `/proc/cpuinfo`, digitando in una finestra di terminale il seguente comando:
{{{
cat /proc/cpuinfo
}}}

Il risultato sarà simile al seguente:
{{{
%(cpuinfo)s
}}}

||<tablestyle="text-align: justify; width:100%%; " style="border:none;" 5%%>[[Immagine(Icone/Piccole/warning.png,100,left)]] ||<style="padding:0.5em; border:none;">'''I valori differiscono a seconda dei modelli di processori, qui si fa riferimento al ''%(cpu)s''.''' ||

= Configurazione dei componenti =

Inserire un elenco dei componenti con le relative istruzioni utili alla loro configurazione. A seconda della situazione, si potranno verificare due casi:
 * Se il componente è stato riconosciuto in modo automatico, inserire il seguente testo:
''Riconosciuto/a automaticamente'' {OK}
 * Se il componente non è stato riconosciuto (o lo è stato soltanto parzialmente), indicare la procedura per configurarlo affinché venga rilevato correttamente.

||<tablestyle="text-align: justify; width:100%%; " style="border:none;" 5%%>[[Immagine(Icone/Piccole/note.png,100,center)]] ||<style="padding:0.5em; border:none;">''Inserire solo i dispositivi il cui funzionamento è stato verificato.'' ||

== Scheda video ==

== Scheda audio ==

== Interfacce di rete ==

== Touchpad ==

== Tasti rapidi ==

== Bluetooth ==

= Ulteriori risorse =

 * [%(website)s Sito ufficiale del produttore]
----
CategoryHardware"""

class UbuntuItWikiPlugin(IPlugin, AbstractPlugin):
    description = _("""This plugin contains the notebook template of \
Ubuntu Italian Community's wiki.

Please submit your report to http://forum.ubuntu-it.org/index.php/board,46.0.html \
or http://qa.alessiotreglia.com""")
    enabled = True
    def __init__(self, active_obj=None, hwconfig=None):
        IPlugin.__init__(self)
        AbstractPlugin.__init__(self, active_obj, hwconfig)
        self.report = '\n'.join(["## Generated by Installation Report Generator %s" % irgenerator.globals.get_version(), template ])
    def __get_the_page(self):
        peripherals = SystemInfo.get_lspci()
        cpuinfo = SystemInfo.get_cpuinfo()
        if self.hwconfig.release.strip() == '':
            self.hwconfig.release = SystemInfo.get_release()
        if self.hwconfig.cpu.strip() == '':
            self.hwconfig.cpu = SystemInfo.get_cpu()
        if self.hwconfig.memory.strip() == '':
            self.hwconfig.memory = SystemInfo.get_memory()
        codename = releases[self.hwconfig.release]
        self.report = self.report % {'vendor':self.hwconfig.vendor, 'model':self.hwconfig.model,
                                 'memory':self.hwconfig.memory, 'cpu':self.hwconfig.cpu,
                                 'release':self.hwconfig.release,'codename':codename, 'vga':self.hwconfig.vga,
                                 'peripherals':peripherals,'cpuinfo':cpuinfo, 'website':self.hwconfig.website}
        time.sleep(0.5)
    def run(self):
        self.obj.activity_check = 1
        self.__get_the_page()
        self.obj.activity_check = -1
        self.obj.report_is_ready()
        #self.obj.update_buttons(button_forward='show')
        #self.obj.view['progressbar_wait'].set_text(_("Press «Forward»"))
        thread.exit()
    def get_report(self):
        return self.report

