/***************************************************************************
 *   Copyright (C) 2006-2007 by Julien Lemoine, Simon Viennot              *
 *   lapinot@tuxfamily.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef JEU_H
#define JEU_H

#include "calcul.h"
#include "tirage.h"

#include <QString>

#include <qthread.h>
#include <qmutex.h>

#include <fstream>
#include <sstream>

typedef set<calcul> stock;

class jeu : public QThread {
  public :
	void run();	//pour lancer un calcul en tche de fond
	
	// DONNEES
	
	tirage tirage_etudie;
	vector<tirage> sous_tirage_etudie;
	vector<stock> grande_base;
	int compteur_simplif;		//nombre de calculs non canoniques
	int compteur_simplif2;		//nombre de calculs dont la valeur n'est pas dans la plage voulue
	
	compte lim_inf_inf;
	compte lim_inf_sup;
	compte lim_sup_inf;
	compte lim_sup_sup;
	
	compte lim_inf;
	compte lim_sup;
	
	//communication au sein de la classe
	bool dernier_sous_tirage;	//indique si on est en train de traiter le dernier sous_tirage ou pas
	int stock_courant;		//stock actuellement utilis
	
	// FONCTIONS
	void etude_tirage();	//fonction principale (bloc monolithique initial)
	void init(const tirage &t, const int &liminf, const int &limsup);	//bloc d'initialisation
	void combinaisons(const calcul& A, const calcul& B);			//calcule les combinaisons de A et B
	void ajouteBase(const calcul& A);					//ajoute un calcul  la base (dans le stock courant)
	void degageNonCano(); 							//supprime les positions non cano du stock courant
	bool dans_la_bonne_plage(const calcul& C);				//dtermine si un calcul a une valeur qu'il faut garder, et modifie
										//les limites si ncessaire
	void degageHorsPlage();							//supprime de la base les positions "hors-plage"
	
	QString afficheBase() const;
	string afficheProbleme() const;
	int distance_a_la_solution() const;
	void afficheInfo() const;						//affichage d'informations en fin de calcul
	int nb_comptes_realises() const;					//nb de comptes raliss par le tirage entre 100 et 999
	int nb_calculs_stockes() const;						//nb de calculs stocks
	vector<bool> comptes_realises() const;					//renvoie un vecteur contenant 0 si le compte n'est pas ralis, 1 sinon
};


class etude_globale {

  public :
	//on etudie quelques tirages pour les tests, et les 13243 pour le gros calcul
	set<tirage> tirages_etudies;
	
	//vecteurs de taille 919
	//pour savoir le nombre de problmes solubles  0,1,2...918 prs, et les probabilits associes
	vector<long> nb_approch;
	vector<long> proba_approch;
	
	//vecteurs de taille 1000 (seuls comptent les lments 100  999)
	//pour un compte donn, stocke le nombre de tirages qui peuvent l'atteindre, et la probabilit associe
	vector<int> nb_comptes;
	vector<long> proba_comptes;
	
	//vecteurs de taille 901 (de 0  900) 
	//contient le nombre de comptes raliss par un tirage, ou la proba associe
	vector<int> nb_cpts_realises;
	vector<long> proba_cpts_realises;
	
	//entier contenant le nombre total de solutions sur l'ensemble des tirages
	int nb_total_solutions;
	
	//fonction principale permettant de calculer tous les paramtres ci-dessus
	//lance une tude sur l'ensemble des tirages
	void grosse_etude(const set<tirage> &st);
};

#endif
