/*==========================================================================

    Ibm2Iso / Iso2ibm.C    - R.Cougnenc 92 - Public Domain

  Utilitaire quick & dirty modifiant un fichier texte DOS en fichier
  texte ISO 8859-1, (Jeu accentue normalise Latin-1 )


  Selon son nom  ( faire un lien ):

        ibm2iso       Passe ascii IBM etendu + CRLF en Unix + ISO
        iso2ibm       Passe Unix + ISO Latin en IBM etendu + CR-LF
 
    cc ibm2iso.c -o ibm2iso
    strip ibm2iso
        mv ibm2iso /usr/local/bin
        ln /usr/local/bin/ibm2iso /usr/local/bin/iso2ibm

==========================================================================*/


#include <stdio.h> 
#include <string.h>

#ifndef MSDOS
#define TMPFILE "/tmp/ibmiso."
char *strstr();
char *strlwr();
#else
#define TMPFILE "ibmiso."
#endif


char tempfile[127]; 

main( int argc, char **argv)
{
  FILE *fi,*ftmp ;
  char ch ;
  char cr = '\r'; 
  int tonix = 1 ;

  strlwr( argv[0] );
  tonix = strstr(argv[0],"ibm2iso" )  ?  1 : 0;

  if( argc < 2 )
  {
     puts("IBM2ISO / ISO2IBM - R.Cougnenc 1992 - Public Domain\n\n");
	 printf("Usage: %s file1 file2 file...\n\n",argv[0] );
	 if( tonix )
        puts("       Passe un fichier texte MSDOS au format UNIX ");
	 else
        puts("       Passe un fichier texte UNIX au format MSDOS ");
        puts("\n Les caracteres accentues IBM sont traduits en ISO 8859-1.\n");

#ifndef MSDOS
	 printf("       Exemple: %s *.c *.h\n\n",argv[0]);
#endif
         return 1 ;
  }

  sprintf(tempfile,"%s%d", TMPFILE, getpid() ) ; /* fichier temporaire */

  while( --argc )
  {
	  printf("Traitement de %s...",argv[argc] );

			/* On s'ecrit dans un fichier temporaire... */
 
      if ( (fi = fopen (argv[argc],"rb")) == NULL )
	  {
 		printf("Fichier %s pas trouve !\n",argv[argc]);
   	 	return 1;
	  }
      buf( fi );

      if ( (ftmp = fopen (tempfile,"wb")) == NULL )
	  {
	 	printf("Fichier %s pas pu etre cree.\n",TMPFILE);
	 	return 1 ;
	  }
      buf( ftmp);

	  if( tonix )

	  	while( fread(&ch,1,1,fi) )
	  	{
			if( ch == 0x0D )
	            	continue ; 
			ibm2iso( (unsigned char *) &ch );
            fwrite (&ch,1,1,ftmp);
	  	}
	  else
 
	  	while( fread(&ch,1,1,fi) )
	  	{
			if( ch == '\n' )
			   fwrite(&cr,1,1,ftmp);
			iso2ibm( (unsigned char *) &ch );
            fwrite (&ch,1,1,ftmp);
	  	}

	  fclose(fi);
	  fclose(ftmp);

			/* Et on recopie le fichier temporaire a la place.*/
 
 
      if ( (fi = fopen (argv[argc],"wb")) == NULL )
	  {
	  	printf("Impossible de reecrire le Fichier %s\n",argv[argc]);
	    	return 1;
	  }
      buf( fi );

      if ( (ftmp = fopen (tempfile,"rb")) == NULL )
	  {
	   	printf("Fichier %s pas pu etre reouvert.\n",TMPFILE);
	   	return 1 ;
	  }
      buf( ftmp );

	  while( fread(&ch,1,1,ftmp) )
	       fwrite (&ch,1,1,fi);

	  fclose(fi);
	  fclose(ftmp);
	  unlink(tempfile);

#ifdef NONON
	  unlink (argv[argc] ) ;           /* supprime l'original   */
          link ( tempfile, argv[argc] ) ;   /* remplace par la copie */
#endif
	  puts ("termine.");
 } /* while --argc */ 
}
/*-----------------------------------------------------------------------*/

buf( FILE *fp )
{
    #ifdef MSDOS
        setvbuf( fp, NULL, _IOFBF, 10240 );
    #endif
}


/*-----------------------------------------------------------------------*/
/*
 *   ibm2iso ( c):  Translates ibm accentuated chars by ISO char.
 *   iso2ibm ( c )  Translates iso accentuated chars to IBM ones.
 *
 *     The character is modified !!!!  (Pointer )
 *
 * (c) Rene Cougnenc 1990
 */

#define NONE    0xfa    /* Car IBM pour remplacer les inexistants */

static unsigned char IsoTable[256]=
{
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,
  0x0b,0x0c,0x0d,0x0e,0x0f,0x10,0x11,0x12,0x13,0x14,NONE,
  0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x20,
  0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,
  0x2c,0x2d,0x2e,0x2f,0x30,0x31,0x32,0x33,0x34,0x35,0x36,
  0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,0x40,0x41,
  0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4a,0x4b,0x4c,
  0x4d,0x4e,0x4f,0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,
  0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f,0x60,0x61,0x62,
  0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6a,0x6b,0x6c,0x6d,
  0x6e,0x6f,0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,
  0x79,0x7a,0x7b,0x7c,0x7d,0x7e,NONE,NONE,NONE,NONE,NONE,
  NONE,NONE,NONE,NONE,NONE,NONE,NONE,NONE,NONE,NONE,NONE,
  NONE,NONE,0x60,0x27,NONE,NONE,NONE,NONE,NONE,NONE,NONE,
  NONE,NONE,NONE,NONE,NONE,NONE,0x20,0xad,0x9b,0x9c,0xfe,
  0x9d,0xb3,0x15,NONE,NONE,0xa6,0xae,0xaa,0x2d,NONE,0xc4,
  0xf8,0xf1,0xfd,NONE,0x27,0xe6,0xe3,NONE,0x2c,NONE,0xb1,
  0xaf,0xac,0xab,NONE,0xa8,0x41,0x41,0x41,0x41,0x8e,0x8f,
  0x92,0x80,0x45,0x90,0x45,0x45,0x49,0x49,0x49,0x49,0x44,
  0xa5,0x4f,0x4f,0x4f,0x4f,0x4f,0x78,0xed,0x55,0x55,0x55,
  0x55,0x59,NONE,0xe1,0x85,0xa0,0x83,0x61,0x84,0x86,0x91,
  0x87,0x8a,0x82,0x88,0x89,0x8d,0xa1,0x8c,0x8b,NONE,0xa4,
  0x95,0xa2,0x93,0x6f,0x94,0xf6,0xed,0x97,0xa3,0x96,0x81,
  0x79,NONE,0x98,
};

#define NOPE    0xb7    /* Car iso pour remplacer les inexistants */

static unsigned char TableIso[256]=
{
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,
  0x0b,0x0c,0x0d,0x0e,0x0f,0x10,0x11,0x12,0x13,0x14,0xa7,
  0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x20,
  0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,
  0x2c,0x2d,0x2e,0x2f,0x30,0x31,0x32,0x33,0x34,0x35,0x36,
  0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,0x40,0x41,
  0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4a,0x4b,0x4c,
  0x4d,0x4e,0x4f,0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,
  0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f,0x60,0x61,0x62,
  0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6a,0x6b,0x6c,0x6d,
  0x6e,0x6f,0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,
  0x79,0x7a,0x7b,0x7c,0x7d,0x7e,0x20,0xc7,0xfc,0xe9,0xe2,
  0xe4,0xe0,0xe5,0xe7,0xea,0xeb,0xe8,0xef,0xee,0xec,0xc4,
  0xc5,0xc9,0xe7,0xc6,0xf4,0xf6,0xf2,0xfb,0xf9,0xff,0xd6,
  0xdc,0xa2,0xa3,0xa5,NOPE,NOPE,0xe1,0xed,0xf3,0xfa,0xf1,
  0xd1,0xaa,0xba,0xbf,0xaf,0xac,0xbd,0xbc,0xa1,0xab,0xbb,
  NOPE,NOPE,NOPE,0xa6,NOPE,NOPE,NOPE,NOPE,NOPE,NOPE,NOPE,
  NOPE,NOPE,NOPE,NOPE,NOPE,NOPE,NOPE,NOPE,NOPE,NOPE,NOPE,
  NOPE,NOPE,NOPE,NOPE,NOPE,NOPE,NOPE,NOPE,NOPE,NOPE,NOPE,
  NOPE,NOPE,NOPE,NOPE,NOPE,NOPE,NOPE,NOPE,NOPE,NOPE,NOPE,
  NOPE,NOPE,NOPE,NOPE,NOPE,0xdf,NOPE,0xb6,NOPE,NOPE,0xb5,
  NOPE,NOPE,NOPE,NOPE,NOPE,NOPE,0xf8,NOPE,NOPE,NOPE,0xb1,
  NOPE,NOPE,NOPE,NOPE,0xf7,NOPE,0xb0,0xb7,0xb7,NOPE,NOPE,
  0xb2,0xa4,0x20
};

iso2ibm( unsigned char *c )
{
    *c = IsoTable[ *c ] ;
}

ibm2iso( unsigned char *c )
{
    *c = TableIso[ *c ] ;
}

/*----------------------------------------------------------------------*/

#ifdef MSDOS
getpid()
{ 
	return 1  ;
}
#endif

#ifndef MSDOS
#ifndef NULL
#define NULL (char *) 0
#endif

#ifdef tolower          /* Utilise la fonction plutot que les macros */
#undef tolower          /* pour rduire la taille du code            */
int tolower();
#endif

char *strlwr( string )
char *string;
{
    char *ptr = string ;

    while( *string )
    {
        *string = tolower( *string );
        string ++ ;
    }

   return (ptr ) ;
}



                                                     /*  T.W. Holm  1988 */
#ifndef NULL
#define NULL (char *) 0
#endif


char *strstr( string, substr )
char *string;
char *substr;
{
char head_string;
char head_substr;

  if ( string == NULL  ||  substr == NULL )
      return( NULL );

  head_substr = *substr++;

  while ( (head_string = *string++) != '\0' )
    if ( head_string == head_substr )
	{
     char *tail_string = string;
     char *tail_substr = substr;

	do  {
	    if ( *tail_substr == '\0' )
		return( string - 1 );
	    } while ( *tail_string++ == *tail_substr++ );
	}

  return( NULL );
}
#endif
