; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=x86-64 -mattr=+xop | FileCheck %s --check-prefix=GENERIC
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=bdver1 | FileCheck %s --check-prefix=BDVER --check-prefix=BDVER12 --check-prefix=BDVER1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=bdver2 | FileCheck %s --check-prefix=BDVER --check-prefix=BDVER12 --check-prefix=BDVER2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=bdver3 | FileCheck %s --check-prefix=BDVER --check-prefix=BDVER3
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=bdver4 | FileCheck %s --check-prefix=BDVER --check-prefix=BDVER4

define void @test_vfrczpd(<2 x double> %a0, <4 x double> %a1, <2 x double> *%a2, <4 x double> *%a3) {
; GENERIC-LABEL: test_vfrczpd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vfrczpd %xmm0, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    vfrczpd %ymm1, %ymm1 # sched: [3:1.00]
; GENERIC-NEXT:    vfrczpd (%rdi), %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    vfrczpd (%rsi), %ymm1 # sched: [10:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    vzeroupper # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vfrczpd:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vfrczpd %xmm0, %xmm0 # sched: [10:1.00]
; BDVER12-NEXT:    vfrczpd %ymm1, %ymm1 # sched: [10:2.00]
; BDVER12-NEXT:    vfrczpd (%rdi), %xmm0 # sched: [15:1.00]
; BDVER12-NEXT:    vfrczpd (%rsi), %ymm1 # sched: [15:2.00]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    vzeroupper # sched: [46:4.00]
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vfrczpd:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vfrczpd %xmm0, %xmm0
; BDVER3-NEXT:    vfrczpd %ymm1, %ymm1
; BDVER3-NEXT:    vfrczpd (%rdi), %xmm0
; BDVER3-NEXT:    vfrczpd (%rsi), %ymm1
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    vzeroupper
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vfrczpd:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vfrczpd %xmm0, %xmm0
; BDVER4-NEXT:    vfrczpd %ymm1, %ymm1
; BDVER4-NEXT:    vfrczpd (%rdi), %xmm0
; BDVER4-NEXT:    vfrczpd (%rsi), %ymm1
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    vzeroupper
; BDVER4-NEXT:    retq
  call void asm sideeffect "vfrczpd $0, $0 \0a\09 vfrczpd $1, $1 \0a\09 vfrczpd $2, $0 \0a\09 vfrczpd $3, $1", "x,x,*m,*m"(<2 x double> %a0, <4 x double> %a1, <2 x double> *%a2, <4 x double> *%a3)
  ret void
}

define void @test_vfrczps(<4 x float> %a0, <4 x double> %a1, <4 x float> *%a2, <4 x double> *%a3) {
; GENERIC-LABEL: test_vfrczps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vfrczps %xmm0, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    vfrczps %ymm1, %ymm1 # sched: [3:1.00]
; GENERIC-NEXT:    vfrczps (%rdi), %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    vfrczps (%rsi), %ymm1 # sched: [10:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    vzeroupper # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vfrczps:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vfrczps %xmm0, %xmm0 # sched: [10:1.00]
; BDVER12-NEXT:    vfrczps %ymm1, %ymm1 # sched: [10:2.00]
; BDVER12-NEXT:    vfrczps (%rdi), %xmm0 # sched: [15:1.00]
; BDVER12-NEXT:    vfrczps (%rsi), %ymm1 # sched: [15:2.00]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    vzeroupper # sched: [46:4.00]
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vfrczps:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vfrczps %xmm0, %xmm0
; BDVER3-NEXT:    vfrczps %ymm1, %ymm1
; BDVER3-NEXT:    vfrczps (%rdi), %xmm0
; BDVER3-NEXT:    vfrczps (%rsi), %ymm1
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    vzeroupper
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vfrczps:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vfrczps %xmm0, %xmm0
; BDVER4-NEXT:    vfrczps %ymm1, %ymm1
; BDVER4-NEXT:    vfrczps (%rdi), %xmm0
; BDVER4-NEXT:    vfrczps (%rsi), %ymm1
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    vzeroupper
; BDVER4-NEXT:    retq
  call void asm sideeffect "vfrczps $0, $0 \0a\09 vfrczps $1, $1 \0a\09 vfrczps $2, $0 \0a\09 vfrczps $3, $1", "x,x,*m,*m"(<4 x float> %a0, <4 x double> %a1, <4 x float> *%a2, <4 x double> *%a3)
  ret void
}

define void @test_vfrczsd(<2 x double> %a0, <2 x double> *%a1) {
; GENERIC-LABEL: test_vfrczsd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vfrczsd %xmm0, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    vfrczsd (%rdi), %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vfrczsd:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vfrczsd %xmm0, %xmm0 # sched: [10:1.00]
; BDVER12-NEXT:    vfrczsd (%rdi), %xmm0 # sched: [15:1.00]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vfrczsd:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vfrczsd %xmm0, %xmm0
; BDVER3-NEXT:    vfrczsd (%rdi), %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vfrczsd:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vfrczsd %xmm0, %xmm0
; BDVER4-NEXT:    vfrczsd (%rdi), %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vfrczsd $0, $0 \0a\09 vfrczsd $1, $0", "x,*m"(<2 x double> %a0, <2 x double> *%a1)
  ret void
}

define void @test_vfrczss(<4 x float> %a0, <4 x double> *%a1) {
; GENERIC-LABEL: test_vfrczss:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vfrczss %xmm0, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    vfrczss (%rdi), %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vfrczss:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vfrczss %xmm0, %xmm0 # sched: [10:1.00]
; BDVER12-NEXT:    vfrczss (%rdi), %xmm0 # sched: [15:1.00]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vfrczss:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vfrczss %xmm0, %xmm0
; BDVER3-NEXT:    vfrczss (%rdi), %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vfrczss:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vfrczss %xmm0, %xmm0
; BDVER4-NEXT:    vfrczss (%rdi), %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vfrczss $0, $0 \0a\09 vfrczss $1, $0", "x,*m"(<4 x float> %a0, <4 x double> *%a1)
  ret void
}

define void @test_vpcmov_128(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3) {
; GENERIC-LABEL: test_vpcmov_128:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpcmov %xmm2, %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    vpcmov (%rdi), %xmm1, %xmm0, %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    vpcmov %xmm2, (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vpcmov_128:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vpcmov %xmm2, %xmm1, %xmm0, %xmm0 # sched: [2:0.50]
; BDVER12-NEXT:    vpcmov (%rdi), %xmm1, %xmm0, %xmm0 # sched: [7:0.50]
; BDVER12-NEXT:    vpcmov %xmm2, (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vpcmov_128:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vpcmov %xmm2, %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpcmov (%rdi), %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpcmov %xmm2, (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vpcmov_128:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vpcmov %xmm2, %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpcmov (%rdi), %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpcmov %xmm2, (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vpcmov $2, $1, $0, $0 \0a\09 vpcmov $3, $1, $0, $0 \0a\09 vpcmov $2, $3, $0, $0", "x,x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3)
  ret void
}

define void @test_vpcmov_256(<4 x i64> %a0, <4 x i64> %a1, <4 x i64> %a2, <4 x i64> *%a3) {
; GENERIC-LABEL: test_vpcmov_256:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpcmov %ymm2, %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; GENERIC-NEXT:    vpcmov (%rdi), %ymm1, %ymm0, %ymm0 # sched: [8:1.00]
; GENERIC-NEXT:    vpcmov %ymm2, (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    vzeroupper # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vpcmov_256:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vpcmov %ymm2, %ymm1, %ymm0, %ymm0 # sched: [2:0.50]
; BDVER12-NEXT:    vpcmov (%rdi), %ymm1, %ymm0, %ymm0 # sched: [7:1.00]
; BDVER12-NEXT:    vpcmov %ymm2, (%rdi), %ymm0, %ymm0 # sched: [7:1.00]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    vzeroupper # sched: [46:4.00]
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vpcmov_256:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vpcmov %ymm2, %ymm1, %ymm0, %ymm0
; BDVER3-NEXT:    vpcmov (%rdi), %ymm1, %ymm0, %ymm0
; BDVER3-NEXT:    vpcmov %ymm2, (%rdi), %ymm0, %ymm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    vzeroupper
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vpcmov_256:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vpcmov %ymm2, %ymm1, %ymm0, %ymm0
; BDVER4-NEXT:    vpcmov (%rdi), %ymm1, %ymm0, %ymm0
; BDVER4-NEXT:    vpcmov %ymm2, (%rdi), %ymm0, %ymm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    vzeroupper
; BDVER4-NEXT:    retq
  call void asm sideeffect "vpcmov $2, $1, $0, $0 \0a\09 vpcmov $3, $1, $0, $0 \0a\09 vpcmov $2, $3, $0, $0", "x,x,x,*m"(<4 x i64> %a0, <4 x i64> %a1, <4 x i64> %a2, <4 x i64> *%a3)
  ret void
}

define void @test_vpcom(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> *%a2) {
; GENERIC-LABEL: test_vpcom:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpcomb $3, %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    vpcomd $3, %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    vpcomq $3, %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    vpcomw $3, %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    vpcomb $3, (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    vpcomd $3, (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    vpcomq $3, (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    vpcomw $3, (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vpcom:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vpcomb $3, %xmm1, %xmm0, %xmm0 # sched: [2:0.50]
; BDVER12-NEXT:    vpcomd $3, %xmm1, %xmm0, %xmm0 # sched: [2:0.50]
; BDVER12-NEXT:    vpcomq $3, %xmm1, %xmm0, %xmm0 # sched: [2:0.50]
; BDVER12-NEXT:    vpcomw $3, %xmm1, %xmm0, %xmm0 # sched: [2:0.50]
; BDVER12-NEXT:    vpcomb $3, (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; BDVER12-NEXT:    vpcomd $3, (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; BDVER12-NEXT:    vpcomq $3, (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; BDVER12-NEXT:    vpcomw $3, (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vpcom:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vpcomb $3, %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpcomd $3, %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpcomq $3, %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpcomw $3, %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpcomb $3, (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    vpcomd $3, (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    vpcomq $3, (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    vpcomw $3, (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vpcom:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vpcomb $3, %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpcomd $3, %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpcomq $3, %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpcomw $3, %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpcomb $3, (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    vpcomd $3, (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    vpcomq $3, (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    vpcomw $3, (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vpcomb $3, $1, $0, $0 \0a\09 vpcomd $3, $1, $0, $0 \0a\09 vpcomq $3, $1, $0, $0 \0a\09 vpcomw $3, $1, $0, $0 \0a\09 vpcomb $3, $2, $0, $0 \0a\09 vpcomd $3, $2, $0, $0 \0a\09 vpcomq $3, $2, $0, $0 \0a\09 vpcomw $3, $2, $0, $0", "x,x,*m,i"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> *%a2, i8 3)
  ret void
}

define void @test_vpcomu(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> *%a2) {
; GENERIC-LABEL: test_vpcomu:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpcomub $3, %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    vpcomud $3, %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    vpcomuq $3, %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    vpcomuw $3, %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    vpcomub $3, (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    vpcomud $3, (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    vpcomuq $3, (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    vpcomuw $3, (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vpcomu:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vpcomub $3, %xmm1, %xmm0, %xmm0 # sched: [2:0.50]
; BDVER12-NEXT:    vpcomud $3, %xmm1, %xmm0, %xmm0 # sched: [2:0.50]
; BDVER12-NEXT:    vpcomuq $3, %xmm1, %xmm0, %xmm0 # sched: [2:0.50]
; BDVER12-NEXT:    vpcomuw $3, %xmm1, %xmm0, %xmm0 # sched: [2:0.50]
; BDVER12-NEXT:    vpcomub $3, (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; BDVER12-NEXT:    vpcomud $3, (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; BDVER12-NEXT:    vpcomuq $3, (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; BDVER12-NEXT:    vpcomuw $3, (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vpcomu:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vpcomub $3, %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpcomud $3, %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpcomuq $3, %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpcomuw $3, %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpcomub $3, (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    vpcomud $3, (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    vpcomuq $3, (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    vpcomuw $3, (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vpcomu:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vpcomub $3, %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpcomud $3, %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpcomuq $3, %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpcomuw $3, %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpcomub $3, (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    vpcomud $3, (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    vpcomuq $3, (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    vpcomuw $3, (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vpcomub $3, $1, $0, $0 \0a\09 vpcomud $3, $1, $0, $0 \0a\09 vpcomuq $3, $1, $0, $0 \0a\09 vpcomuw $3, $1, $0, $0 \0a\09 vpcomub $3, $2, $0, $0 \0a\09 vpcomud $3, $2, $0, $0 \0a\09 vpcomuq $3, $2, $0, $0 \0a\09 vpcomuw $3, $2, $0, $0", "x,x,*m,i"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> *%a2, i8 3)
  ret void
}

define void @test_vpermil2pd_128(<2 x double> %a0, <2 x double> %a1, <2 x double> %a2, <2 x double> *%a3) {
; GENERIC-LABEL: test_vpermil2pd_128:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpermil2pd $3, %xmm2, %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vpermil2pd $3, %xmm2, (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpermil2pd $3, (%rdi), %xmm1, %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vpermil2pd_128:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vpermil2pd $3, %xmm2, %xmm1, %xmm0, %xmm0 # sched: [3:2.00]
; BDVER12-NEXT:    vpermil2pd $3, %xmm2, (%rdi), %xmm0, %xmm0 # sched: [8:2.00]
; BDVER12-NEXT:    vpermil2pd $3, (%rdi), %xmm1, %xmm0, %xmm0 # sched: [8:2.00]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vpermil2pd_128:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vpermil2pd $3, %xmm2, %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpermil2pd $3, %xmm2, (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    vpermil2pd $3, (%rdi), %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vpermil2pd_128:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vpermil2pd $3, %xmm2, %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpermil2pd $3, %xmm2, (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    vpermil2pd $3, (%rdi), %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vpermil2pd $4, $2, $1, $0, $0 \0a\09 vpermil2pd $4, $2, $3, $0, $0 \0a\09 vpermil2pd $4, $3, $1, $0, $0", "x,x,x,*m,i"(<2 x double> %a0, <2 x double> %a1, <2 x double> %a2, <2 x double> *%a3, i8 3)
  ret void
}

define void @test_vpermil2pd_256(<4 x double> %a0, <4 x double> %a1, <4 x double> %a2, <4 x double> *%a3) {
; GENERIC-LABEL: test_vpermil2pd_256:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpermil2pd $3, %ymm2, %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; GENERIC-NEXT:    vpermil2pd $3, %ymm2, (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; GENERIC-NEXT:    vpermil2pd $3, (%rdi), %ymm1, %ymm0, %ymm0 # sched: [8:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    vzeroupper # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vpermil2pd_256:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vpermil2pd $3, %ymm2, %ymm1, %ymm0, %ymm0 # sched: [3:3.00]
; BDVER12-NEXT:    vpermil2pd $3, %ymm2, (%rdi), %ymm0, %ymm0 # sched: [8:3.00]
; BDVER12-NEXT:    vpermil2pd $3, (%rdi), %ymm1, %ymm0, %ymm0 # sched: [8:3.00]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    vzeroupper # sched: [46:4.00]
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vpermil2pd_256:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vpermil2pd $3, %ymm2, %ymm1, %ymm0, %ymm0
; BDVER3-NEXT:    vpermil2pd $3, %ymm2, (%rdi), %ymm0, %ymm0
; BDVER3-NEXT:    vpermil2pd $3, (%rdi), %ymm1, %ymm0, %ymm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    vzeroupper
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vpermil2pd_256:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vpermil2pd $3, %ymm2, %ymm1, %ymm0, %ymm0
; BDVER4-NEXT:    vpermil2pd $3, %ymm2, (%rdi), %ymm0, %ymm0
; BDVER4-NEXT:    vpermil2pd $3, (%rdi), %ymm1, %ymm0, %ymm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    vzeroupper
; BDVER4-NEXT:    retq
  call void asm sideeffect "vpermil2pd $4, $2, $1, $0, $0 \0a\09 vpermil2pd $4, $2, $3, $0, $0 \0a\09 vpermil2pd $4, $3, $1, $0, $0", "x,x,x,*m,i"(<4 x double> %a0, <4 x double> %a1, <4 x double> %a2, <4 x double> *%a3, i8 3)
  ret void
}

define void @test_vpermil2ps_128(<4 x float> %a0, <4 x float> %a1, <4 x float> %a2, <4 x float> *%a3) {
; GENERIC-LABEL: test_vpermil2ps_128:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpermil2ps $3, %xmm2, %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vpermil2ps $3, %xmm2, (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpermil2ps $3, (%rdi), %xmm1, %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vpermil2ps_128:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vpermil2ps $3, %xmm2, %xmm1, %xmm0, %xmm0 # sched: [3:2.00]
; BDVER12-NEXT:    vpermil2ps $3, %xmm2, (%rdi), %xmm0, %xmm0 # sched: [8:2.00]
; BDVER12-NEXT:    vpermil2ps $3, (%rdi), %xmm1, %xmm0, %xmm0 # sched: [8:2.00]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vpermil2ps_128:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vpermil2ps $3, %xmm2, %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpermil2ps $3, %xmm2, (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    vpermil2ps $3, (%rdi), %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vpermil2ps_128:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vpermil2ps $3, %xmm2, %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpermil2ps $3, %xmm2, (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    vpermil2ps $3, (%rdi), %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vpermil2ps $4, $2, $1, $0, $0 \0a\09 vpermil2ps $4, $2, $3, $0, $0 \0a\09 vpermil2ps $4, $3, $1, $0, $0", "x,x,x,*m,i"(<4 x float> %a0, <4 x float> %a1, <4 x float> %a2, <4 x float> *%a3, i8 3)
  ret void
}

define void @test_vpermil2ps_256(<8 x float> %a0, <8 x float> %a1, <8 x float> %a2, <8 x float> *%a3) {
; GENERIC-LABEL: test_vpermil2ps_256:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpermil2ps $3, %ymm2, %ymm1, %ymm0, %ymm0 # sched: [1:1.00]
; GENERIC-NEXT:    vpermil2ps $3, %ymm2, (%rdi), %ymm0, %ymm0 # sched: [8:1.00]
; GENERIC-NEXT:    vpermil2ps $3, (%rdi), %ymm1, %ymm0, %ymm0 # sched: [8:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    vzeroupper # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vpermil2ps_256:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vpermil2ps $3, %ymm2, %ymm1, %ymm0, %ymm0 # sched: [3:3.00]
; BDVER12-NEXT:    vpermil2ps $3, %ymm2, (%rdi), %ymm0, %ymm0 # sched: [8:3.00]
; BDVER12-NEXT:    vpermil2ps $3, (%rdi), %ymm1, %ymm0, %ymm0 # sched: [8:3.00]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    vzeroupper # sched: [46:4.00]
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vpermil2ps_256:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vpermil2ps $3, %ymm2, %ymm1, %ymm0, %ymm0
; BDVER3-NEXT:    vpermil2ps $3, %ymm2, (%rdi), %ymm0, %ymm0
; BDVER3-NEXT:    vpermil2ps $3, (%rdi), %ymm1, %ymm0, %ymm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    vzeroupper
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vpermil2ps_256:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vpermil2ps $3, %ymm2, %ymm1, %ymm0, %ymm0
; BDVER4-NEXT:    vpermil2ps $3, %ymm2, (%rdi), %ymm0, %ymm0
; BDVER4-NEXT:    vpermil2ps $3, (%rdi), %ymm1, %ymm0, %ymm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    vzeroupper
; BDVER4-NEXT:    retq
  call void asm sideeffect "vpermil2ps $4, $2, $1, $0, $0 \0a\09 vpermil2ps $4, $2, $3, $0, $0 \0a\09 vpermil2ps $4, $3, $1, $0, $0", "x,x,x,*m,i"(<8 x float> %a0, <8 x float> %a1, <8 x float> %a2, <8 x float> *%a3, i8 3)
  ret void
}

define void @test_vphaddbd(<2 x i64> %a0, <2 x i64> *%a1) {
; GENERIC-LABEL: test_vphaddbd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vphaddbd %xmm0, %xmm0 # sched: [3:1.50]
; GENERIC-NEXT:    vphaddbd (%rdi), %xmm0 # sched: [9:1.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vphaddbd:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vphaddbd %xmm0, %xmm0 # sched: [2:0.50]
; BDVER12-NEXT:    vphaddbd (%rdi), %xmm0 # sched: [7:0.50]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vphaddbd:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vphaddbd %xmm0, %xmm0
; BDVER3-NEXT:    vphaddbd (%rdi), %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vphaddbd:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vphaddbd %xmm0, %xmm0
; BDVER4-NEXT:    vphaddbd (%rdi), %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vphaddbd $0, $0 \0a\09 vphaddbd $1, $0", "x,*m"(<2 x i64> %a0, <2 x i64> *%a1)
  ret void
}

define void @test_vphaddbq(<2 x i64> %a0, <2 x i64> *%a1) {
; GENERIC-LABEL: test_vphaddbq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vphaddbq %xmm0, %xmm0 # sched: [3:1.50]
; GENERIC-NEXT:    vphaddbq (%rdi), %xmm0 # sched: [9:1.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vphaddbq:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vphaddbq %xmm0, %xmm0 # sched: [2:0.50]
; BDVER12-NEXT:    vphaddbq (%rdi), %xmm0 # sched: [7:0.50]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vphaddbq:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vphaddbq %xmm0, %xmm0
; BDVER3-NEXT:    vphaddbq (%rdi), %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vphaddbq:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vphaddbq %xmm0, %xmm0
; BDVER4-NEXT:    vphaddbq (%rdi), %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vphaddbq $0, $0 \0a\09 vphaddbq $1, $0", "x,*m"(<2 x i64> %a0, <2 x i64> *%a1)
  ret void
}

define void @test_vphaddbw(<2 x i64> %a0, <2 x i64> *%a1) {
; GENERIC-LABEL: test_vphaddbw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vphaddbw %xmm0, %xmm0 # sched: [3:1.50]
; GENERIC-NEXT:    vphaddbw (%rdi), %xmm0 # sched: [9:1.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vphaddbw:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vphaddbw %xmm0, %xmm0 # sched: [2:0.50]
; BDVER12-NEXT:    vphaddbw (%rdi), %xmm0 # sched: [7:0.50]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vphaddbw:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vphaddbw %xmm0, %xmm0
; BDVER3-NEXT:    vphaddbw (%rdi), %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vphaddbw:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vphaddbw %xmm0, %xmm0
; BDVER4-NEXT:    vphaddbw (%rdi), %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vphaddbw $0, $0 \0a\09 vphaddbw $1, $0", "x,*m"(<2 x i64> %a0, <2 x i64> *%a1)
  ret void
}

define void @test_vphadddq(<2 x i64> %a0, <2 x i64> *%a1) {
; GENERIC-LABEL: test_vphadddq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vphadddq %xmm0, %xmm0 # sched: [3:1.50]
; GENERIC-NEXT:    vphadddq (%rdi), %xmm0 # sched: [9:1.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vphadddq:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vphadddq %xmm0, %xmm0 # sched: [2:0.50]
; BDVER12-NEXT:    vphadddq (%rdi), %xmm0 # sched: [7:0.50]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vphadddq:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vphadddq %xmm0, %xmm0
; BDVER3-NEXT:    vphadddq (%rdi), %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vphadddq:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vphadddq %xmm0, %xmm0
; BDVER4-NEXT:    vphadddq (%rdi), %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vphadddq $0, $0 \0a\09 vphadddq $1, $0", "x,*m"(<2 x i64> %a0, <2 x i64> *%a1)
  ret void
}

define void @test_vphaddubd(<2 x i64> %a0, <2 x i64> *%a1) {
; GENERIC-LABEL: test_vphaddubd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vphaddubd %xmm0, %xmm0 # sched: [3:1.50]
; GENERIC-NEXT:    vphaddubd (%rdi), %xmm0 # sched: [9:1.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vphaddubd:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vphaddubd %xmm0, %xmm0 # sched: [2:0.50]
; BDVER12-NEXT:    vphaddubd (%rdi), %xmm0 # sched: [7:0.50]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vphaddubd:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vphaddubd %xmm0, %xmm0
; BDVER3-NEXT:    vphaddubd (%rdi), %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vphaddubd:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vphaddubd %xmm0, %xmm0
; BDVER4-NEXT:    vphaddubd (%rdi), %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vphaddubd $0, $0 \0a\09 vphaddubd $1, $0", "x,*m"(<2 x i64> %a0, <2 x i64> *%a1)
  ret void
}

define void @test_vphaddubq(<2 x i64> %a0, <2 x i64> *%a1) {
; GENERIC-LABEL: test_vphaddubq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vphaddubq %xmm0, %xmm0 # sched: [3:1.50]
; GENERIC-NEXT:    vphaddubq (%rdi), %xmm0 # sched: [9:1.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vphaddubq:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vphaddubq %xmm0, %xmm0 # sched: [2:0.50]
; BDVER12-NEXT:    vphaddubq (%rdi), %xmm0 # sched: [7:0.50]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vphaddubq:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vphaddubq %xmm0, %xmm0
; BDVER3-NEXT:    vphaddubq (%rdi), %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vphaddubq:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vphaddubq %xmm0, %xmm0
; BDVER4-NEXT:    vphaddubq (%rdi), %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vphaddubq $0, $0 \0a\09 vphaddubq $1, $0", "x,*m"(<2 x i64> %a0, <2 x i64> *%a1)
  ret void
}

define void @test_vphaddubw(<2 x i64> %a0, <2 x i64> *%a1) {
; GENERIC-LABEL: test_vphaddubw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vphaddubw %xmm0, %xmm0 # sched: [3:1.50]
; GENERIC-NEXT:    vphaddubw (%rdi), %xmm0 # sched: [9:1.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vphaddubw:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vphaddubw %xmm0, %xmm0 # sched: [2:0.50]
; BDVER12-NEXT:    vphaddubw (%rdi), %xmm0 # sched: [7:0.50]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vphaddubw:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vphaddubw %xmm0, %xmm0
; BDVER3-NEXT:    vphaddubw (%rdi), %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vphaddubw:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vphaddubw %xmm0, %xmm0
; BDVER4-NEXT:    vphaddubw (%rdi), %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vphaddubw $0, $0 \0a\09 vphaddubw $1, $0", "x,*m"(<2 x i64> %a0, <2 x i64> *%a1)
  ret void
}

define void @test_vphaddudq(<2 x i64> %a0, <2 x i64> *%a1) {
; GENERIC-LABEL: test_vphaddudq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vphaddudq %xmm0, %xmm0 # sched: [3:1.50]
; GENERIC-NEXT:    vphaddudq (%rdi), %xmm0 # sched: [9:1.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vphaddudq:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vphaddudq %xmm0, %xmm0 # sched: [2:0.50]
; BDVER12-NEXT:    vphaddudq (%rdi), %xmm0 # sched: [7:0.50]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vphaddudq:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vphaddudq %xmm0, %xmm0
; BDVER3-NEXT:    vphaddudq (%rdi), %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vphaddudq:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vphaddudq %xmm0, %xmm0
; BDVER4-NEXT:    vphaddudq (%rdi), %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vphaddudq $0, $0 \0a\09 vphaddudq $1, $0", "x,*m"(<2 x i64> %a0, <2 x i64> *%a1)
  ret void
}

define void @test_vphadduwd(<2 x i64> %a0, <2 x i64> *%a1) {
; GENERIC-LABEL: test_vphadduwd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vphadduwd %xmm0, %xmm0 # sched: [3:1.50]
; GENERIC-NEXT:    vphadduwd (%rdi), %xmm0 # sched: [9:1.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vphadduwd:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vphadduwd %xmm0, %xmm0 # sched: [2:0.50]
; BDVER12-NEXT:    vphadduwd (%rdi), %xmm0 # sched: [7:0.50]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vphadduwd:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vphadduwd %xmm0, %xmm0
; BDVER3-NEXT:    vphadduwd (%rdi), %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vphadduwd:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vphadduwd %xmm0, %xmm0
; BDVER4-NEXT:    vphadduwd (%rdi), %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vphadduwd $0, $0 \0a\09 vphadduwd $1, $0", "x,*m"(<2 x i64> %a0, <2 x i64> *%a1)
  ret void
}

define void @test_vphadduwq(<2 x i64> %a0, <2 x i64> *%a1) {
; GENERIC-LABEL: test_vphadduwq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vphadduwq %xmm0, %xmm0 # sched: [3:1.50]
; GENERIC-NEXT:    vphadduwq (%rdi), %xmm0 # sched: [9:1.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vphadduwq:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vphadduwq %xmm0, %xmm0 # sched: [2:0.50]
; BDVER12-NEXT:    vphadduwq (%rdi), %xmm0 # sched: [7:0.50]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vphadduwq:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vphadduwq %xmm0, %xmm0
; BDVER3-NEXT:    vphadduwq (%rdi), %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vphadduwq:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vphadduwq %xmm0, %xmm0
; BDVER4-NEXT:    vphadduwq (%rdi), %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vphadduwq $0, $0 \0a\09 vphadduwq $1, $0", "x,*m"(<2 x i64> %a0, <2 x i64> *%a1)
  ret void
}

define void @test_vphaddwd(<2 x i64> %a0, <2 x i64> *%a1) {
; GENERIC-LABEL: test_vphaddwd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vphaddwd %xmm0, %xmm0 # sched: [3:1.50]
; GENERIC-NEXT:    vphaddwd (%rdi), %xmm0 # sched: [9:1.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vphaddwd:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vphaddwd %xmm0, %xmm0 # sched: [2:0.50]
; BDVER12-NEXT:    vphaddwd (%rdi), %xmm0 # sched: [7:0.50]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vphaddwd:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vphaddwd %xmm0, %xmm0
; BDVER3-NEXT:    vphaddwd (%rdi), %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vphaddwd:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vphaddwd %xmm0, %xmm0
; BDVER4-NEXT:    vphaddwd (%rdi), %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vphaddwd $0, $0 \0a\09 vphaddwd $1, $0", "x,*m"(<2 x i64> %a0, <2 x i64> *%a1)
  ret void
}

define void @test_vphaddwq(<2 x i64> %a0, <2 x i64> *%a1) {
; GENERIC-LABEL: test_vphaddwq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vphaddwq %xmm0, %xmm0 # sched: [3:1.50]
; GENERIC-NEXT:    vphaddwq (%rdi), %xmm0 # sched: [9:1.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vphaddwq:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vphaddwq %xmm0, %xmm0 # sched: [2:0.50]
; BDVER12-NEXT:    vphaddwq (%rdi), %xmm0 # sched: [7:0.50]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vphaddwq:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vphaddwq %xmm0, %xmm0
; BDVER3-NEXT:    vphaddwq (%rdi), %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vphaddwq:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vphaddwq %xmm0, %xmm0
; BDVER4-NEXT:    vphaddwq (%rdi), %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vphaddwq $0, $0 \0a\09 vphaddwq $1, $0", "x,*m"(<2 x i64> %a0, <2 x i64> *%a1)
  ret void
}

define void @test_vphsubbw(<2 x i64> %a0, <2 x i64> *%a1) {
; GENERIC-LABEL: test_vphsubbw:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vphsubbw %xmm0, %xmm0 # sched: [3:1.50]
; GENERIC-NEXT:    vphsubbw (%rdi), %xmm0 # sched: [9:1.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vphsubbw:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vphsubbw %xmm0, %xmm0 # sched: [2:0.50]
; BDVER12-NEXT:    vphsubbw (%rdi), %xmm0 # sched: [7:0.50]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vphsubbw:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vphsubbw %xmm0, %xmm0
; BDVER3-NEXT:    vphsubbw (%rdi), %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vphsubbw:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vphsubbw %xmm0, %xmm0
; BDVER4-NEXT:    vphsubbw (%rdi), %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vphsubbw $0, $0 \0a\09 vphsubbw $1, $0", "x,*m"(<2 x i64> %a0, <2 x i64> *%a1)
  ret void
}

define void @test_vphsubdq(<2 x i64> %a0, <2 x i64> *%a1) {
; GENERIC-LABEL: test_vphsubdq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vphsubdq %xmm0, %xmm0 # sched: [3:1.50]
; GENERIC-NEXT:    vphsubdq (%rdi), %xmm0 # sched: [9:1.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vphsubdq:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vphsubdq %xmm0, %xmm0 # sched: [2:0.50]
; BDVER12-NEXT:    vphsubdq (%rdi), %xmm0 # sched: [7:0.50]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vphsubdq:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vphsubdq %xmm0, %xmm0
; BDVER3-NEXT:    vphsubdq (%rdi), %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vphsubdq:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vphsubdq %xmm0, %xmm0
; BDVER4-NEXT:    vphsubdq (%rdi), %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vphsubdq $0, $0 \0a\09 vphsubdq $1, $0", "x,*m"(<2 x i64> %a0, <2 x i64> *%a1)
  ret void
}

define void @test_vphsubwd(<2 x i64> %a0, <2 x i64> *%a1) {
; GENERIC-LABEL: test_vphsubwd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vphsubwd %xmm0, %xmm0 # sched: [3:1.50]
; GENERIC-NEXT:    vphsubwd (%rdi), %xmm0 # sched: [9:1.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vphsubwd:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vphsubwd %xmm0, %xmm0 # sched: [2:0.50]
; BDVER12-NEXT:    vphsubwd (%rdi), %xmm0 # sched: [7:0.50]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vphsubwd:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vphsubwd %xmm0, %xmm0
; BDVER3-NEXT:    vphsubwd (%rdi), %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vphsubwd:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vphsubwd %xmm0, %xmm0
; BDVER4-NEXT:    vphsubwd (%rdi), %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vphsubwd $0, $0 \0a\09 vphsubwd $1, $0", "x,*m"(<2 x i64> %a0, <2 x i64> *%a1)
  ret void
}

define void @test_vpmacsdd(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3) {
; GENERIC-LABEL: test_vpmacsdd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpmacsdd %xmm2, %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    vpmacsdd %xmm2, (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vpmacsdd:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vpmacsdd %xmm2, %xmm1, %xmm0, %xmm0 # sched: [5:2.00]
; BDVER12-NEXT:    vpmacsdd %xmm2, (%rdi), %xmm0, %xmm0 # sched: [10:2.00]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vpmacsdd:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vpmacsdd %xmm2, %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpmacsdd %xmm2, (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vpmacsdd:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vpmacsdd %xmm2, %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpmacsdd %xmm2, (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vpmacsdd $2, $1, $0, $0 \0a\09 vpmacsdd $2, $3, $0, $0", "x,x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3)
  ret void
}

define void @test_vpmacsdqh(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3) {
; GENERIC-LABEL: test_vpmacsdqh:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpmacsdqh %xmm2, %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    vpmacsdqh %xmm2, (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vpmacsdqh:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vpmacsdqh %xmm2, %xmm1, %xmm0, %xmm0 # sched: [4:2.00]
; BDVER12-NEXT:    vpmacsdqh %xmm2, (%rdi), %xmm0, %xmm0 # sched: [10:2.00]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vpmacsdqh:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vpmacsdqh %xmm2, %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpmacsdqh %xmm2, (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vpmacsdqh:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vpmacsdqh %xmm2, %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpmacsdqh %xmm2, (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vpmacsdqh $2, $1, $0, $0 \0a\09 vpmacsdqh $2, $3, $0, $0", "x,x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3)
  ret void
}

define void @test_vpmacsdql(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3) {
; GENERIC-LABEL: test_vpmacsdql:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpmacsdql %xmm2, %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    vpmacsdql %xmm2, (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vpmacsdql:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vpmacsdql %xmm2, %xmm1, %xmm0, %xmm0 # sched: [4:2.00]
; BDVER12-NEXT:    vpmacsdql %xmm2, (%rdi), %xmm0, %xmm0 # sched: [10:2.00]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vpmacsdql:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vpmacsdql %xmm2, %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpmacsdql %xmm2, (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vpmacsdql:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vpmacsdql %xmm2, %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpmacsdql %xmm2, (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vpmacsdql $2, $1, $0, $0 \0a\09 vpmacsdql $2, $3, $0, $0", "x,x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3)
  ret void
}

define void @test_vpmacssdd(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3) {
; GENERIC-LABEL: test_vpmacssdd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpmacssdd %xmm2, %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    vpmacssdd %xmm2, (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vpmacssdd:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vpmacssdd %xmm2, %xmm1, %xmm0, %xmm0 # sched: [5:2.00]
; BDVER12-NEXT:    vpmacssdd %xmm2, (%rdi), %xmm0, %xmm0 # sched: [10:2.00]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vpmacssdd:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vpmacssdd %xmm2, %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpmacssdd %xmm2, (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vpmacssdd:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vpmacssdd %xmm2, %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpmacssdd %xmm2, (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vpmacssdd $2, $1, $0, $0 \0a\09 vpmacssdd $2, $3, $0, $0", "x,x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3)
  ret void
}

define void @test_vpmacssdqh(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3) {
; GENERIC-LABEL: test_vpmacssdqh:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpmacssdqh %xmm2, %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    vpmacssdqh %xmm2, (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vpmacssdqh:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vpmacssdqh %xmm2, %xmm1, %xmm0, %xmm0 # sched: [4:2.00]
; BDVER12-NEXT:    vpmacssdqh %xmm2, (%rdi), %xmm0, %xmm0 # sched: [10:2.00]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vpmacssdqh:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vpmacssdqh %xmm2, %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpmacssdqh %xmm2, (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vpmacssdqh:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vpmacssdqh %xmm2, %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpmacssdqh %xmm2, (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vpmacssdqh $2, $1, $0, $0 \0a\09 vpmacssdqh $2, $3, $0, $0", "x,x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3)
  ret void
}

define void @test_vpmacssdql(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3) {
; GENERIC-LABEL: test_vpmacssdql:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpmacssdql %xmm2, %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    vpmacssdql %xmm2, (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vpmacssdql:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vpmacssdql %xmm2, %xmm1, %xmm0, %xmm0 # sched: [4:2.00]
; BDVER12-NEXT:    vpmacssdql %xmm2, (%rdi), %xmm0, %xmm0 # sched: [10:2.00]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vpmacssdql:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vpmacssdql %xmm2, %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpmacssdql %xmm2, (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vpmacssdql:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vpmacssdql %xmm2, %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpmacssdql %xmm2, (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vpmacssdql $2, $1, $0, $0 \0a\09 vpmacssdql $2, $3, $0, $0", "x,x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3)
  ret void
}

define void @test_vpmacsswd(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3) {
; GENERIC-LABEL: test_vpmacsswd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpmacsswd %xmm2, %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    vpmacsswd %xmm2, (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vpmacsswd:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vpmacsswd %xmm2, %xmm1, %xmm0, %xmm0 # sched: [4:1.00]
; BDVER12-NEXT:    vpmacsswd %xmm2, (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vpmacsswd:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vpmacsswd %xmm2, %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpmacsswd %xmm2, (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vpmacsswd:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vpmacsswd %xmm2, %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpmacsswd %xmm2, (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vpmacsswd $2, $1, $0, $0 \0a\09 vpmacsswd $2, $3, $0, $0", "x,x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3)
  ret void
}

define void @test_vpmacssww(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3) {
; GENERIC-LABEL: test_vpmacssww:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpmacssww %xmm2, %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    vpmacssww %xmm2, (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vpmacssww:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vpmacssww %xmm2, %xmm1, %xmm0, %xmm0 # sched: [4:1.00]
; BDVER12-NEXT:    vpmacssww %xmm2, (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vpmacssww:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vpmacssww %xmm2, %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpmacssww %xmm2, (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vpmacssww:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vpmacssww %xmm2, %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpmacssww %xmm2, (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vpmacssww $2, $1, $0, $0 \0a\09 vpmacssww $2, $3, $0, $0", "x,x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3)
  ret void
}

define void @test_vpmacswd(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3) {
; GENERIC-LABEL: test_vpmacswd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpmacswd %xmm2, %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    vpmacswd %xmm2, (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vpmacswd:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vpmacswd %xmm2, %xmm1, %xmm0, %xmm0 # sched: [4:1.00]
; BDVER12-NEXT:    vpmacswd %xmm2, (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vpmacswd:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vpmacswd %xmm2, %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpmacswd %xmm2, (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vpmacswd:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vpmacswd %xmm2, %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpmacswd %xmm2, (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vpmacswd $2, $1, $0, $0 \0a\09 vpmacswd $2, $3, $0, $0", "x,x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3)
  ret void
}

define void @test_vpmacsww(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3) {
; GENERIC-LABEL: test_vpmacsww:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpmacsww %xmm2, %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    vpmacsww %xmm2, (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vpmacsww:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vpmacsww %xmm2, %xmm1, %xmm0, %xmm0 # sched: [4:1.00]
; BDVER12-NEXT:    vpmacsww %xmm2, (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vpmacsww:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vpmacsww %xmm2, %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpmacsww %xmm2, (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vpmacsww:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vpmacsww %xmm2, %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpmacsww %xmm2, (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vpmacsww $2, $1, $0, $0 \0a\09 vpmacsww $2, $3, $0, $0", "x,x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3)
  ret void
}

define void @test_vpmadcsswd(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3) {
; GENERIC-LABEL: test_vpmadcsswd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpmadcsswd %xmm2, %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    vpmadcsswd %xmm2, (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vpmadcsswd:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vpmadcsswd %xmm2, %xmm1, %xmm0, %xmm0 # sched: [4:1.00]
; BDVER12-NEXT:    vpmadcsswd %xmm2, (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vpmadcsswd:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vpmadcsswd %xmm2, %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpmadcsswd %xmm2, (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vpmadcsswd:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vpmadcsswd %xmm2, %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpmadcsswd %xmm2, (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vpmadcsswd $2, $1, $0, $0 \0a\09 vpmadcsswd $2, $3, $0, $0", "x,x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3)
  ret void
}

define void @test_vpmadcswd(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3) {
; GENERIC-LABEL: test_vpmadcswd:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpmadcswd %xmm2, %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    vpmadcswd %xmm2, (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vpmadcswd:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vpmadcswd %xmm2, %xmm1, %xmm0, %xmm0 # sched: [4:1.00]
; BDVER12-NEXT:    vpmadcswd %xmm2, (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vpmadcswd:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vpmadcswd %xmm2, %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpmadcswd %xmm2, (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vpmadcswd:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vpmadcswd %xmm2, %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpmadcswd %xmm2, (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vpmadcswd $2, $1, $0, $0 \0a\09 vpmadcswd $2, $3, $0, $0", "x,x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3)
  ret void
}

define void @test_vpperm(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3) {
; GENERIC-LABEL: test_vpperm:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpperm %xmm2, %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; GENERIC-NEXT:    vpperm (%rdi), %xmm1, %xmm0, %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    vpperm %xmm2, (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vpperm:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vpperm %xmm2, %xmm1, %xmm0, %xmm0 # sched: [3:2.00]
; BDVER12-NEXT:    vpperm (%rdi), %xmm1, %xmm0, %xmm0 # sched: [8:2.00]
; BDVER12-NEXT:    vpperm %xmm2, (%rdi), %xmm0, %xmm0 # sched: [8:2.00]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vpperm:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vpperm %xmm2, %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpperm (%rdi), %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpperm %xmm2, (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vpperm:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vpperm %xmm2, %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpperm (%rdi), %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpperm %xmm2, (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vpperm $2, $1, $0, $0 \0A\09 vpperm $3, $1, $0, $0 \0A\09 vpperm $2, $3, $0, $0", "x,x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> %a2, <2 x i64> *%a3)
  ret void
}

define void @test_vprot(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> *%a2) {
; GENERIC-LABEL: test_vprot:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vprotb %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vprotd %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vprotq %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vprotw %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vprotb (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vprotd (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vprotq (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vprotw (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vprotb %xmm0, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vprotd %xmm0, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vprotq %xmm0, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vprotw %xmm0, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vprotb $7, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vprotd $7, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vprotq $7, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vprotw $7, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vprotb $7, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vprotd $7, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vprotq $7, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vprotw $7, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vprot:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vprotb %xmm1, %xmm0, %xmm0 # sched: [3:0.50]
; BDVER12-NEXT:    vprotd %xmm1, %xmm0, %xmm0 # sched: [3:0.50]
; BDVER12-NEXT:    vprotq %xmm1, %xmm0, %xmm0 # sched: [3:0.50]
; BDVER12-NEXT:    vprotw %xmm1, %xmm0, %xmm0 # sched: [3:0.50]
; BDVER12-NEXT:    vprotb (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; BDVER12-NEXT:    vprotd (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; BDVER12-NEXT:    vprotq (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; BDVER12-NEXT:    vprotw (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; BDVER12-NEXT:    vprotb %xmm0, (%rdi), %xmm0 # sched: [8:0.50]
; BDVER12-NEXT:    vprotd %xmm0, (%rdi), %xmm0 # sched: [8:0.50]
; BDVER12-NEXT:    vprotq %xmm0, (%rdi), %xmm0 # sched: [8:0.50]
; BDVER12-NEXT:    vprotw %xmm0, (%rdi), %xmm0 # sched: [8:0.50]
; BDVER12-NEXT:    vprotb $7, %xmm0, %xmm0 # sched: [2:0.50]
; BDVER12-NEXT:    vprotd $7, %xmm0, %xmm0 # sched: [2:0.50]
; BDVER12-NEXT:    vprotq $7, %xmm0, %xmm0 # sched: [2:0.50]
; BDVER12-NEXT:    vprotw $7, %xmm0, %xmm0 # sched: [2:0.50]
; BDVER12-NEXT:    vprotb $7, (%rdi), %xmm0 # sched: [7:0.50]
; BDVER12-NEXT:    vprotd $7, (%rdi), %xmm0 # sched: [7:0.50]
; BDVER12-NEXT:    vprotq $7, (%rdi), %xmm0 # sched: [7:0.50]
; BDVER12-NEXT:    vprotw $7, (%rdi), %xmm0 # sched: [7:0.50]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vprot:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vprotb %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vprotd %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vprotq %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vprotw %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vprotb (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    vprotd (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    vprotq (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    vprotw (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    vprotb %xmm0, (%rdi), %xmm0
; BDVER3-NEXT:    vprotd %xmm0, (%rdi), %xmm0
; BDVER3-NEXT:    vprotq %xmm0, (%rdi), %xmm0
; BDVER3-NEXT:    vprotw %xmm0, (%rdi), %xmm0
; BDVER3-NEXT:    vprotb $7, %xmm0, %xmm0
; BDVER3-NEXT:    vprotd $7, %xmm0, %xmm0
; BDVER3-NEXT:    vprotq $7, %xmm0, %xmm0
; BDVER3-NEXT:    vprotw $7, %xmm0, %xmm0
; BDVER3-NEXT:    vprotb $7, (%rdi), %xmm0
; BDVER3-NEXT:    vprotd $7, (%rdi), %xmm0
; BDVER3-NEXT:    vprotq $7, (%rdi), %xmm0
; BDVER3-NEXT:    vprotw $7, (%rdi), %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vprot:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vprotb %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vprotd %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vprotq %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vprotw %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vprotb (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    vprotd (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    vprotq (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    vprotw (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    vprotb %xmm0, (%rdi), %xmm0
; BDVER4-NEXT:    vprotd %xmm0, (%rdi), %xmm0
; BDVER4-NEXT:    vprotq %xmm0, (%rdi), %xmm0
; BDVER4-NEXT:    vprotw %xmm0, (%rdi), %xmm0
; BDVER4-NEXT:    vprotb $7, %xmm0, %xmm0
; BDVER4-NEXT:    vprotd $7, %xmm0, %xmm0
; BDVER4-NEXT:    vprotq $7, %xmm0, %xmm0
; BDVER4-NEXT:    vprotw $7, %xmm0, %xmm0
; BDVER4-NEXT:    vprotb $7, (%rdi), %xmm0
; BDVER4-NEXT:    vprotd $7, (%rdi), %xmm0
; BDVER4-NEXT:    vprotq $7, (%rdi), %xmm0
; BDVER4-NEXT:    vprotw $7, (%rdi), %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vprotb $1, $0, $0 \0A\09 vprotd $1, $0, $0 \0A\09 vprotq $1, $0, $0 \0A\09 vprotw $1, $0, $0 \0A\09 vprotb $2, $0, $0 \0A\09 vprotd $2, $0, $0 \0A\09 vprotq $2, $0, $0 \0A\09 vprotw $2, $0, $0 \0A\09 vprotb $0, $2, $0 \0A\09 vprotd $0, $2, $0 \0A\09 vprotq $0, $2, $0 \0A\09 vprotw $0, $2, $0 \0A\09 vprotb $3, $0, $0 \0A\09 vprotd $3, $0, $0 \0A\09 vprotq $3, $0, $0 \0A\09 vprotw $3, $0, $0 \0A\09 vprotb $3, $2, $0 \0A\09 vprotd $3, $2, $0 \0A\09 vprotq $3, $2, $0 \0A\09 vprotw $3, $2, $0", "x,x,*m,i"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> *%a2, i8 7)
  ret void
}

define void @test_vpsha(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> *%a2) {
; GENERIC-LABEL: test_vpsha:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpshab %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vpshad %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vpshaq %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vpshaw %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vpshab (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpshad (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpshaq (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpshaw (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpshab %xmm0, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpshad %xmm0, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpshaq %xmm0, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpshaw %xmm0, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vpsha:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vpshab %xmm1, %xmm0, %xmm0 # sched: [3:0.50]
; BDVER12-NEXT:    vpshad %xmm1, %xmm0, %xmm0 # sched: [3:0.50]
; BDVER12-NEXT:    vpshaq %xmm1, %xmm0, %xmm0 # sched: [3:0.50]
; BDVER12-NEXT:    vpshaw %xmm1, %xmm0, %xmm0 # sched: [3:0.50]
; BDVER12-NEXT:    vpshab (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; BDVER12-NEXT:    vpshad (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; BDVER12-NEXT:    vpshaq (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; BDVER12-NEXT:    vpshaw (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; BDVER12-NEXT:    vpshab %xmm0, (%rdi), %xmm0 # sched: [8:0.50]
; BDVER12-NEXT:    vpshad %xmm0, (%rdi), %xmm0 # sched: [8:0.50]
; BDVER12-NEXT:    vpshaq %xmm0, (%rdi), %xmm0 # sched: [8:0.50]
; BDVER12-NEXT:    vpshaw %xmm0, (%rdi), %xmm0 # sched: [8:0.50]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vpsha:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vpshab %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpshad %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpshaq %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpshaw %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpshab (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    vpshad (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    vpshaq (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    vpshaw (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    vpshab %xmm0, (%rdi), %xmm0
; BDVER3-NEXT:    vpshad %xmm0, (%rdi), %xmm0
; BDVER3-NEXT:    vpshaq %xmm0, (%rdi), %xmm0
; BDVER3-NEXT:    vpshaw %xmm0, (%rdi), %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vpsha:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vpshab %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpshad %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpshaq %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpshaw %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpshab (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    vpshad (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    vpshaq (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    vpshaw (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    vpshab %xmm0, (%rdi), %xmm0
; BDVER4-NEXT:    vpshad %xmm0, (%rdi), %xmm0
; BDVER4-NEXT:    vpshaq %xmm0, (%rdi), %xmm0
; BDVER4-NEXT:    vpshaw %xmm0, (%rdi), %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vpshab $1, $0, $0 \0A\09 vpshad $1, $0, $0 \0A\09 vpshaq $1, $0, $0 \0A\09 vpshaw $1, $0, $0 \0A\09 vpshab $2, $0, $0 \0A\09 vpshad $2, $0, $0 \0A\09 vpshaq $2, $0, $0 \0A\09 vpshaw $2, $0, $0 \0A\09 vpshab $0, $2, $0 \0A\09 vpshad $0, $2, $0 \0A\09 vpshaq $0, $2, $0 \0A\09 vpshaw $0, $2, $0", "x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> *%a2)
  ret void
}

define void @test_vpshl(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> *%a2) {
; GENERIC-LABEL: test_vpshl:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    vpshlb %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vpshld %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vpshlq %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vpshlw %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    vpshlb (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpshld (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpshlq (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpshlw (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpshlb %xmm0, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpshld %xmm0, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpshlq %xmm0, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    vpshlw %xmm0, (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; BDVER12-LABEL: test_vpshl:
; BDVER12:       # %bb.0:
; BDVER12-NEXT:    #APP
; BDVER12-NEXT:    vpshlb %xmm1, %xmm0, %xmm0 # sched: [3:0.50]
; BDVER12-NEXT:    vpshld %xmm1, %xmm0, %xmm0 # sched: [3:0.50]
; BDVER12-NEXT:    vpshlq %xmm1, %xmm0, %xmm0 # sched: [3:0.50]
; BDVER12-NEXT:    vpshlw %xmm1, %xmm0, %xmm0 # sched: [3:0.50]
; BDVER12-NEXT:    vpshlb (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; BDVER12-NEXT:    vpshld (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; BDVER12-NEXT:    vpshlq (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; BDVER12-NEXT:    vpshlw (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; BDVER12-NEXT:    vpshlb %xmm0, (%rdi), %xmm0 # sched: [8:0.50]
; BDVER12-NEXT:    vpshld %xmm0, (%rdi), %xmm0 # sched: [8:0.50]
; BDVER12-NEXT:    vpshlq %xmm0, (%rdi), %xmm0 # sched: [8:0.50]
; BDVER12-NEXT:    vpshlw %xmm0, (%rdi), %xmm0 # sched: [8:0.50]
; BDVER12-NEXT:    #NO_APP
; BDVER12-NEXT:    retq # sched: [5:1.00]
;
; BDVER3-LABEL: test_vpshl:
; BDVER3:       # %bb.0:
; BDVER3-NEXT:    #APP
; BDVER3-NEXT:    vpshlb %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpshld %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpshlq %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpshlw %xmm1, %xmm0, %xmm0
; BDVER3-NEXT:    vpshlb (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    vpshld (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    vpshlq (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    vpshlw (%rdi), %xmm0, %xmm0
; BDVER3-NEXT:    vpshlb %xmm0, (%rdi), %xmm0
; BDVER3-NEXT:    vpshld %xmm0, (%rdi), %xmm0
; BDVER3-NEXT:    vpshlq %xmm0, (%rdi), %xmm0
; BDVER3-NEXT:    vpshlw %xmm0, (%rdi), %xmm0
; BDVER3-NEXT:    #NO_APP
; BDVER3-NEXT:    retq
;
; BDVER4-LABEL: test_vpshl:
; BDVER4:       # %bb.0:
; BDVER4-NEXT:    #APP
; BDVER4-NEXT:    vpshlb %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpshld %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpshlq %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpshlw %xmm1, %xmm0, %xmm0
; BDVER4-NEXT:    vpshlb (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    vpshld (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    vpshlq (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    vpshlw (%rdi), %xmm0, %xmm0
; BDVER4-NEXT:    vpshlb %xmm0, (%rdi), %xmm0
; BDVER4-NEXT:    vpshld %xmm0, (%rdi), %xmm0
; BDVER4-NEXT:    vpshlq %xmm0, (%rdi), %xmm0
; BDVER4-NEXT:    vpshlw %xmm0, (%rdi), %xmm0
; BDVER4-NEXT:    #NO_APP
; BDVER4-NEXT:    retq
  call void asm sideeffect "vpshlb $1, $0, $0 \0A\09 vpshld $1, $0, $0 \0A\09 vpshlq $1, $0, $0 \0A\09 vpshlw $1, $0, $0 \0A\09 vpshlb $2, $0, $0 \0A\09 vpshld $2, $0, $0 \0A\09 vpshlq $2, $0, $0 \0A\09 vpshlw $2, $0, $0 \0A\09 vpshlb $0, $2, $0 \0A\09 vpshld $0, $2, $0 \0A\09 vpshlq $0, $2, $0 \0A\09 vpshlw $0, $2, $0", "x,x,*m"(<2 x i64> %a0, <2 x i64> %a1, <2 x i64> *%a2)
  ret void
}
