with GNATCOLL.Traces; use GNATCOLL.Traces;
with Ada.Text_IO; use Ada.Text_IO;

procedure Tracename is
   H_PID : Trace_Handle := Create ("trace_pid");
   H_D   : Trace_Handle := Create ("trace_D");
   H_T   : Trace_Handle := Create ("trace_T");
   H_FOO : Trace_Handle := Create ("trace_FOO");
   function getpid return Integer;
   pragma Import (C, getpid, "getpid");

   Pid : constant String := getpid'Img;
   Pidfile : Ada.Text_IO.File_Type;
begin
   Create (Pidfile, Out_File, "tracename.pid");
   Put_Line (Pidfile, Pid);
   Close (Pidfile);

   Parse_Config_File;
   Trace (H_PID, "hello from" & Pid);
   Trace (H_D, "hello from" & Pid);
   Trace (H_T, "hello from" & Pid);
   Trace (H_FOO, "hello from" & Pid);
end Tracename;
