
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileArrowPlottingAttributes.h
    \brief Definition of ArrowPlotting Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef ArrowPlottingAttributes_H
#define ArrowPlottingAttributes_H

#include "magics.h"
#include "CalmIndicator.h"
#include "Colour.h"
namespace magics {

class XmlNode;
class ArrowPlottingAttributes 
{
public:
//  --  constructor
    ArrowPlottingAttributes();
    
//  --  destructor
    virtual ~ArrowPlottingAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const ArrowPlottingAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	double calm_indicator_size_;
	double calm_below_;
	int head_;
	double ratio_;
	double max_speed_;
	double min_speed_;
	int thickness_;
	string unit_system_;
	double unit_velocity_;
	string legend_unit_;
	double fixed_velocity_;
	unique_ptr<CalmIndicator> calm_;
	unique_ptr<Colour> colour_;
	ArrowPosition origin_position_;
	LineStyle style_;
	 

private:
	friend ostream& operator<<(ostream& s,const ArrowPlottingAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

