/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "uPlotBatchApp.h"
#include "Root.h"
#include "MvDebugPrintControl.h"
#include "PlotModBatch.h"
#include "MagPlusBatchService.h"

#include <mars.h>

int main(int argc,char **argv)
{
	// Create Root instance
	Root::Create();

	// Initialize Mars communication
	marsinit(&argc,argv,0,0,0);
	mvSetMarslogLevel();

	// Start uPlot without a window (eg. batch mode or interactive mode
	// without a window)
	uPlotBatchApp app(argc, argv, "uPlotBatch");

	MagPlusBatchService* batch = new MagPlusBatchService();
	MagPlusService::Instance(batch);

	PlotModBatch* pm = new PlotModBatch();
	PlotMod::Instance(pm);

	app.run();
}
