/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File XMText.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef XMText_H
#define XMText_H

#include <string>
using std::string;
#include <Xm/Xm.h>

class Path;

class XMText {
public:

// -- Exceptions
	// None

// -- Contructors

	XMText(Widget);

// -- Destructor

	~XMText(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	void load(const Path&,bool insert = false);
	void map(const Path&);
	void save(const Path&);

	void clear();
	void set(const string&);
	string get();

	void insert(const string&,bool select = false);
	void append(const string&);
	void moveToEnd();

	void selectLine(int);

	void set(double);
	void get(double&);

	void set(int);
	void get(int&);

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	XMText(const XMText&);
	XMText& operator=(const XMText&);

// -- Members
	
	Widget text_;

// -- Methods
	// None

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const XMText& p)
	//	{ p.print(s); return s; }

};

inline void destroy(XMText**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(XMText);
//#endif

#endif
