/* vim: set ts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/* This file is generated from sources in nss/gtests/common/wycheproof
 * automatically and should not be touched manually.
 * Generation is trigged by calling python3 genTestVectors.py */

#ifndef rsa_oaep_2048_sha512_mgf1sha512_vectors_h__
#define rsa_oaep_2048_sha512_mgf1sha512_vectors_h__

#include "testvectors_base/test-structs.h"

const RsaOaepTestVector kRsaOaep2048Sha512Mgf1Sha512WycheproofVectors[] = {

    // Comment:
    // tcID: 1
    {SEC_OID_SHA512,
     CKG_MGF1_SHA512,
     1,
     {},
     {0x10, 0x1f, 0x82, 0xbc, 0xb8, 0x15, 0x79, 0x66, 0xc8, 0xf5, 0x05, 0x31,
      0xf2, 0x94, 0x51, 0x04, 0x16, 0x39, 0x39, 0x43, 0xfa, 0x9d, 0xd5, 0xdc,
      0x05, 0xf8, 0x5b, 0xb8, 0x2f, 0x04, 0x92, 0x50, 0x22, 0x74, 0xe0, 0x7c,
      0xa7, 0xdb, 0xda, 0x2a, 0x7e, 0x16, 0x18, 0x79, 0x81, 0xc9, 0x23, 0xd6,
      0x0c, 0xb6, 0xb4, 0x27, 0x69, 0x3c, 0x6d, 0x7b, 0x10, 0x7e, 0xba, 0xdb,
      0xb6, 0xfc, 0x40, 0x04, 0x92, 0xfb, 0x79, 0x5c, 0xeb, 0xcc, 0x80, 0x4d,
      0x49, 0x8a, 0x7d, 0x3a, 0x07, 0x7c, 0xf3, 0x9c, 0xd0, 0x30, 0xe9, 0x41,
      0x30, 0x8d, 0xc8, 0x70, 0x00, 0xaf, 0x53, 0x80, 0xb3, 0xca, 0x5e, 0x87,
      0x28, 0x31, 0x3e, 0x35, 0xe3, 0x1b, 0x78, 0xed, 0xe9, 0xe5, 0xf0, 0x7c,
      0xde, 0xc8, 0xe3, 0x56, 0x9a, 0xfe, 0x3d, 0x13, 0x46, 0x6d, 0x06, 0xd4,
      0xb7, 0x70, 0x30, 0xd1, 0x46, 0xb3, 0x2c, 0xdd, 0x7d, 0xa5, 0x66, 0xd9,
      0x67, 0x53, 0xfa, 0x44, 0xd6, 0x47, 0x91, 0xe6, 0x87, 0xdc, 0xb3, 0x24,
      0xf5, 0x23, 0x71, 0xc0, 0x19, 0x1b, 0xc9, 0xf1, 0xa5, 0xbc, 0x7b, 0x77,
      0x36, 0xa5, 0xbf, 0x00, 0xd3, 0xfd, 0x51, 0x8b, 0x70, 0xed, 0x6f, 0x4a,
      0xe0, 0xfc, 0xb2, 0x0b, 0xc9, 0x2f, 0xf3, 0xeb, 0x04, 0x8a, 0x6f, 0x76,
      0x75, 0x96, 0x26, 0x31, 0x27, 0xcc, 0xd6, 0x6e, 0x47, 0x4e, 0x8c, 0x27,
      0x52, 0x1f, 0xe2, 0xeb, 0x21, 0xb8, 0xab, 0xb2, 0xc2, 0x3b, 0x91, 0xbb,
      0x16, 0x26, 0x4e, 0x05, 0x82, 0x65, 0xa5, 0x67, 0x49, 0x2b, 0xc5, 0x1c,
      0x4c, 0xd0, 0x33, 0xb1, 0xd8, 0xa5, 0xd7, 0xb5, 0x79, 0x83, 0x60, 0xf4,
      0xc3, 0x71, 0x6d, 0xdb, 0x43, 0x62, 0x2e, 0xa5, 0xdc, 0x9f, 0xcd, 0x36,
      0x81, 0x9e, 0x05, 0xa9, 0x89, 0x25, 0x2d, 0xcc, 0xe8, 0x26, 0x50, 0x67,
      0x11, 0xa2, 0x0f, 0xdb},
     {},
     priv_key_3,
     true},

    // Comment:
    // tcID: 2
    {SEC_OID_SHA512,
     CKG_MGF1_SHA512,
     2,
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {0x35, 0xae, 0xe1, 0xc5, 0x60, 0x44, 0xda, 0x3b, 0x86, 0x6b, 0xfe, 0xd9,
      0x89, 0x69, 0x0d, 0xba, 0xf5, 0x7a, 0xc1, 0x02, 0x11, 0xca, 0x4c, 0x36,
      0x4c, 0x4f, 0x41, 0x27, 0xfe, 0xd0, 0xa5, 0x5b, 0x58, 0x12, 0x17, 0xc7,
      0xe8, 0x54, 0xd1, 0x1f, 0xd1, 0xa1, 0xf9, 0xd5, 0x43, 0x1c, 0x2c, 0x30,
      0x9e, 0x62, 0xa6, 0xf7, 0xc3, 0xc5, 0x96, 0x76, 0x18, 0x2b, 0x28, 0x8e,
      0xdc, 0xcf, 0xa9, 0x61, 0xc7, 0x8c, 0x1b, 0xaa, 0x53, 0xf2, 0xdb, 0x1b,
      0x1b, 0x9a, 0x4d, 0xd0, 0x50, 0x15, 0xf4, 0x18, 0x72, 0xcf, 0x22, 0xac,
      0xfe, 0x3a, 0x07, 0x1d, 0x6a, 0xc1, 0xe8, 0x2b, 0xa6, 0xc3, 0x1f, 0x5c,
      0x2d, 0x93, 0x25, 0x24, 0x7d, 0x6f, 0x2c, 0x9b, 0x03, 0xce, 0x00, 0xc9,
      0x4f, 0x02, 0xfe, 0x33, 0xc5, 0x67, 0x8a, 0x41, 0x49, 0xcf, 0x2f, 0xb7,
      0x0b, 0xbb, 0xd9, 0x95, 0xaf, 0x14, 0x65, 0xe3, 0x81, 0x9c, 0x83, 0xc9,
      0xab, 0x8b, 0x55, 0x08, 0x8f, 0xd5, 0xd7, 0x50, 0x36, 0x61, 0x3b, 0x04,
      0xdf, 0x30, 0x21, 0x13, 0x94, 0x87, 0x00, 0xd7, 0x87, 0x6b, 0x7c, 0xec,
      0x9d, 0x73, 0x37, 0xbf, 0x57, 0x73, 0x34, 0x3d, 0x51, 0xa4, 0x29, 0x8e,
      0x71, 0x7a, 0x4f, 0xae, 0x09, 0xe5, 0x73, 0xfe, 0xa4, 0x12, 0xd8, 0x8b,
      0x83, 0x6e, 0xcd, 0x4f, 0x74, 0xc7, 0xcc, 0x75, 0x00, 0x60, 0x97, 0x23,
      0xb3, 0xf3, 0xa2, 0xa0, 0x0d, 0x85, 0xee, 0x7c, 0xcb, 0xd9, 0x2b, 0xf6,
      0xc0, 0x65, 0x83, 0x30, 0x27, 0xc5, 0xe5, 0x03, 0x10, 0xc6, 0xcf, 0x8f,
      0xe8, 0xd1, 0x3e, 0x2d, 0x82, 0x18, 0xe7, 0x85, 0x33, 0x3a, 0x2e, 0x65,
      0xb5, 0x47, 0xe5, 0xed, 0xa2, 0xf8, 0xf2, 0xf9, 0x60, 0x8f, 0x36, 0x6d,
      0x7e, 0x43, 0x63, 0x6f, 0xca, 0x4f, 0x46, 0x45, 0x0c, 0x76, 0xf0, 0x6d,
      0xd0, 0x8b, 0x00, 0xdb},
     {},
     priv_key_3,
     true},

    // Comment:
    // tcID: 3
    {SEC_OID_SHA512,
     CKG_MGF1_SHA512,
     3,
     {0x54, 0x65, 0x73, 0x74},
     {0x58, 0x87, 0x8d, 0xc8, 0xb9, 0x52, 0x7a, 0x41, 0x6e, 0xc9, 0xbf, 0xbe,
      0x0f, 0x07, 0xfd, 0xee, 0x8d, 0xc5, 0xba, 0xc8, 0xe3, 0x1c, 0xa5, 0x45,
      0xae, 0x7c, 0x6e, 0xf4, 0xa6, 0x8f, 0x2c, 0x6b, 0x2b, 0x73, 0x36, 0x65,
      0x18, 0xed, 0xf8, 0x5f, 0x11, 0x43, 0xc2, 0x7f, 0xba, 0x00, 0xa5, 0xd9,
      0xa9, 0xb0, 0x28, 0x43, 0xad, 0x89, 0x51, 0x63, 0x1d, 0xdf, 0x01, 0xef,
      0x12, 0x38, 0x85, 0x3b, 0x45, 0x93, 0xab, 0xf9, 0x70, 0x1c, 0x62, 0x19,
      0x41, 0xb4, 0xf0, 0x59, 0x31, 0xea, 0xf3, 0x07, 0xc0, 0x6f, 0xaa, 0x7f,
      0xb8, 0x18, 0xdb, 0x8f, 0x85, 0x9c, 0x96, 0xdb, 0xfc, 0x43, 0x26, 0x89,
      0x65, 0x30, 0x3b, 0x44, 0xfc, 0xc6, 0x9a, 0x0e, 0x3c, 0xe6, 0x19, 0x62,
      0x49, 0x07, 0xbc, 0xe0, 0x74, 0x20, 0x5f, 0x11, 0x37, 0x15, 0xe5, 0xe8,
      0x20, 0xbc, 0x8c, 0x6d, 0xda, 0x65, 0x06, 0x64, 0x53, 0x21, 0x57, 0x02,
      0x41, 0x6d, 0xb9, 0x32, 0x0f, 0x54, 0xe6, 0x7f, 0xc9, 0x1e, 0x9d, 0x37,
      0xa8, 0x52, 0x2d, 0x70, 0x1a, 0xa2, 0x29, 0x76, 0x96, 0x6a, 0x99, 0xcb,
      0xc8, 0xfe, 0xc0, 0xe1, 0x2f, 0x2e, 0xb9, 0xb5, 0x70, 0x5b, 0x4d, 0xc7,
      0x7c, 0xaf, 0xf8, 0x2a, 0x36, 0x48, 0x55, 0x50, 0x75, 0x2a, 0x3a, 0x5e,
      0xbd, 0x47, 0xfc, 0x67, 0xd6, 0x6b, 0x68, 0x02, 0x4a, 0x2c, 0x5d, 0xb8,
      0x09, 0xd0, 0x8b, 0xe9, 0x09, 0x0b, 0xb9, 0x6e, 0x18, 0x80, 0x79, 0x25,
      0xb1, 0x8a, 0x75, 0x3e, 0xce, 0x05, 0xf1, 0x62, 0x4f, 0xb1, 0x95, 0x37,
      0xab, 0xe7, 0xfd, 0x66, 0x28, 0x30, 0xd5, 0x66, 0x47, 0xa4, 0x16, 0xdf,
      0x7d, 0xdb, 0x3e, 0x6a, 0x07, 0x31, 0x50, 0xd5, 0x11, 0x2f, 0x60, 0x53,
      0x8b, 0x68, 0x52, 0x43, 0xf1, 0xe4, 0xfd, 0xe2, 0xa5, 0x95, 0x1c, 0x9e,
      0x94, 0x99, 0xec, 0xc4},
     {},
     priv_key_3,
     true},

    // Comment:
    // tcID: 4
    {SEC_OID_SHA512,
     CKG_MGF1_SHA512,
     4,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x28, 0x00, 0xf4, 0x21, 0xc1, 0xc0, 0x78, 0xb8, 0xbe, 0xe9, 0xc4, 0xa4,
      0xf3, 0x55, 0xe1, 0xea, 0x83, 0x4c, 0x5b, 0xca, 0x44, 0x2e, 0x99, 0x86,
      0x79, 0x2a, 0x50, 0xe6, 0x6e, 0x68, 0xc0, 0xb8, 0x12, 0x2c, 0xb8, 0x1b,
      0xb5, 0x9e, 0x00, 0x70, 0xca, 0x04, 0x4c, 0x1c, 0x5b, 0x19, 0x0f, 0x90,
      0x98, 0xdb, 0xda, 0xa9, 0x77, 0xa4, 0x41, 0xa8, 0xa4, 0xc6, 0x28, 0x97,
      0xed, 0xb9, 0x48, 0x49, 0x35, 0x00, 0x7a, 0xad, 0xb6, 0x73, 0x2c, 0x1b,
      0x2b, 0x21, 0x71, 0xae, 0xa3, 0xab, 0x15, 0x13, 0xf2, 0x25, 0xeb, 0xe7,
      0x83, 0x0f, 0xb8, 0x23, 0xec, 0x3f, 0x54, 0x33, 0xbd, 0x8f, 0x3c, 0x3e,
      0x52, 0x77, 0x5b, 0xb4, 0x5f, 0xa9, 0x1a, 0xa0, 0xad, 0x3b, 0x7c, 0x1b,
      0xc6, 0x47, 0xb7, 0x75, 0xe4, 0xde, 0x8e, 0x1b, 0x22, 0xeb, 0x97, 0x10,
      0x41, 0x26, 0x78, 0x78, 0x42, 0x1c, 0xf4, 0x3a, 0x5e, 0x2a, 0x26, 0x75,
      0xb2, 0xc9, 0x40, 0xda, 0xa5, 0x5f, 0x12, 0xa7, 0xc7, 0x9d, 0x87, 0xd4,
      0x5e, 0x08, 0xc5, 0x59, 0x23, 0x62, 0xf5, 0xe0, 0xd7, 0xea, 0x66, 0x8a,
      0xf9, 0x9e, 0xec, 0xd2, 0xf6, 0x0d, 0x7f, 0xc3, 0x79, 0x1e, 0x4f, 0x53,
      0xae, 0xd7, 0x99, 0x31, 0xbd, 0x0b, 0xa9, 0x0f, 0x70, 0x1d, 0xe8, 0x36,
      0xd8, 0xc8, 0xc9, 0xbe, 0x7f, 0x7f, 0x4a, 0xed, 0xcb, 0xe5, 0xc9, 0x23,
      0x83, 0x93, 0x2f, 0x76, 0x2b, 0xec, 0x65, 0xfa, 0x29, 0x8e, 0xb6, 0x44,
      0x87, 0x7d, 0xe2, 0x6e, 0xec, 0x99, 0x51, 0x46, 0xaf, 0x55, 0x1a, 0xd7,
      0x7e, 0xcf, 0xd0, 0x6a, 0x36, 0x70, 0x72, 0x1a, 0xb4, 0xc7, 0x57, 0x7e,
      0x61, 0xc0, 0x48, 0xc5, 0xdd, 0x01, 0xb2, 0x82, 0xcf, 0xc0, 0xfc, 0x96,
      0x3b, 0x92, 0xc7, 0x8e, 0xab, 0xd1, 0x3f, 0xba, 0x64, 0x19, 0x5d, 0x74,
      0xde, 0x48, 0x29, 0xbb},
     {},
     priv_key_3,
     true},

    // Comment:
    // tcID: 5
    {SEC_OID_SHA512,
     CKG_MGF1_SHA512,
     5,
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     {0x65, 0xa7, 0x28, 0x6d, 0x77, 0x96, 0x3a, 0x2d, 0x16, 0x8d, 0xdb, 0x4c,
      0x0e, 0x85, 0x4b, 0xaf, 0x88, 0x98, 0xd1, 0xd2, 0x2c, 0x9d, 0xe5, 0xd4,
      0x96, 0x8e, 0x8b, 0x32, 0x6f, 0x92, 0xed, 0xe2, 0xf1, 0x8f, 0xd2, 0x99,
      0x64, 0x70, 0x82, 0x11, 0xef, 0x63, 0x28, 0xe4, 0xef, 0x16, 0xec, 0x36,
      0xa7, 0x75, 0xb3, 0x6b, 0x45, 0x31, 0xc5, 0x2e, 0x01, 0xc7, 0xcc, 0x00,
      0x58, 0x06, 0x4a, 0xf9, 0x54, 0x79, 0x01, 0x60, 0x01, 0x25, 0x17, 0x13,
      0x4f, 0x17, 0xd9, 0x2a, 0x05, 0x00, 0x0e, 0xbb, 0xa8, 0x4f, 0x51, 0x5f,
      0x90, 0x25, 0x82, 0x78, 0x20, 0x8c, 0xb0, 0xa5, 0xdb, 0x11, 0xd4, 0xb1,
      0xdc, 0x26, 0xd2, 0x04, 0x22, 0x18, 0xd2, 0xfd, 0x62, 0xaa, 0xaf, 0x53,
      0x63, 0x3f, 0xf0, 0xf6, 0x32, 0x43, 0x1a, 0x01, 0x0b, 0x7e, 0x14, 0x97,
      0x1a, 0x41, 0x79, 0x16, 0x44, 0xeb, 0xc1, 0x70, 0x79, 0x2a, 0x61, 0xb5,
      0x54, 0x85, 0x69, 0xf1, 0xb0, 0x26, 0x8c, 0x89, 0x00, 0x74, 0xa4, 0xb0,
      0x7d, 0x8e, 0x62, 0xd4, 0x85, 0x7f, 0x9e, 0x72, 0x0c, 0xb7, 0x30, 0x77,
      0x13, 0x42, 0x4c, 0x70, 0x1f, 0x6f, 0x66, 0x69, 0x81, 0xac, 0x8e, 0x96,
      0xab, 0x06, 0x6f, 0x30, 0x3f, 0xe8, 0x9a, 0x13, 0x8a, 0xbd, 0x57, 0xb2,
      0x4f, 0x03, 0xd9, 0x13, 0x6e, 0xf4, 0x68, 0xcd, 0x85, 0x19, 0x23, 0x5c,
      0xef, 0x7b, 0xab, 0x01, 0x71, 0x78, 0x98, 0x35, 0x7c, 0x0e, 0x4f, 0xf4,
      0xd3, 0x68, 0x57, 0x06, 0xbe, 0xb5, 0xd6, 0x80, 0xda, 0x28, 0x85, 0x55,
      0x6e, 0x84, 0x66, 0x37, 0x72, 0xd6, 0xc2, 0x99, 0xfb, 0xda, 0x67, 0xdf,
      0x2c, 0xd3, 0x25, 0xcb, 0xfd, 0x62, 0x93, 0x28, 0x36, 0x92, 0x0e, 0x07,
      0x51, 0xb0, 0xd8, 0x09, 0x5b, 0x91, 0x4c, 0x18, 0xfb, 0xe5, 0xe3, 0x48,
      0xbc, 0xf4, 0xd8, 0x5c},
     {},
     priv_key_3,
     true},

    // Comment:
    // tcID: 6
    {SEC_OID_SHA512,
     CKG_MGF1_SHA512,
     6,
     {0x61},
     {0x7f, 0xcd, 0xa8, 0x19, 0xb8, 0x41, 0xcf, 0x7c, 0x66, 0x8f, 0x9e, 0xc9,
      0xe7, 0xe1, 0x15, 0x14, 0x6f, 0x99, 0x0c, 0xc4, 0x20, 0xef, 0xef, 0xaf,
      0xe2, 0x39, 0x63, 0x70, 0x76, 0xbf, 0x9e, 0xf1, 0xc4, 0x9e, 0xa6, 0x94,
      0x74, 0xf6, 0x34, 0x95, 0xd9, 0x0c, 0xd3, 0x85, 0x9e, 0x33, 0x5d, 0x32,
      0x3a, 0xb9, 0xa9, 0x67, 0xc6, 0x5f, 0xce, 0xb0, 0xb3, 0x3a, 0x76, 0x01,
      0x42, 0xb0, 0x08, 0x94, 0xd1, 0xac, 0x25, 0xee, 0x7c, 0x28, 0x33, 0xbf,
      0x2d, 0xcd, 0x08, 0x6a, 0x0c, 0xad, 0x64, 0x43, 0x3a, 0xa6, 0x06, 0xf4,
      0x74, 0x7f, 0x14, 0x50, 0x0e, 0xd2, 0x77, 0x94, 0x70, 0xb4, 0x33, 0x9f,
      0x58, 0x0e, 0x2f, 0xa0, 0xa1, 0x4d, 0x87, 0x0d, 0x67, 0x38, 0xe7, 0x26,
      0xa3, 0x4d, 0xda, 0x3f, 0xb7, 0xb8, 0x25, 0x09, 0xed, 0xb6, 0xd6, 0xb9,
      0xbc, 0xae, 0xfe, 0xca, 0x07, 0x7b, 0x2d, 0xc5, 0x82, 0x98, 0x2e, 0xe6,
      0xe2, 0x8f, 0xbf, 0x16, 0x7a, 0x92, 0xb0, 0xff, 0x11, 0x41, 0xd1, 0x0f,
      0xc3, 0xdf, 0xc4, 0x9a, 0xdc, 0xfa, 0xf3, 0x21, 0x15, 0xf9, 0x00, 0xb2,
      0x0c, 0x81, 0x20, 0x94, 0xbc, 0xa9, 0x1b, 0xb1, 0x03, 0x01, 0x61, 0x6a,
      0xf5, 0x03, 0x0e, 0x0a, 0x60, 0x0c, 0x99, 0x3a, 0x24, 0xd9, 0x67, 0x64,
      0x98, 0x67, 0x82, 0xda, 0x08, 0x3e, 0x32, 0x75, 0x69, 0x10, 0x3f, 0x7b,
      0x35, 0x8a, 0x6a, 0x91, 0xd0, 0x5f, 0xcf, 0x89, 0xa9, 0x29, 0x0f, 0xf9,
      0x89, 0xac, 0x8c, 0x0a, 0xcd, 0xae, 0x03, 0x43, 0x8a, 0x44, 0xb1, 0x6c,
      0x7a, 0x3e, 0x06, 0xa1, 0x59, 0x18, 0x69, 0x87, 0x4f, 0x29, 0x46, 0x0b,
      0x0c, 0xe0, 0x9b, 0xd0, 0x22, 0xfc, 0x3c, 0x60, 0x6d, 0x78, 0x5e, 0xcf,
      0xe4, 0xf4, 0xa1, 0x20, 0x29, 0x84, 0x08, 0xcb, 0x42, 0x5e, 0x9a, 0xbc,
      0x71, 0x71, 0xe4, 0xd3},
     {},
     priv_key_3,
     true},

    // Comment:
    // tcID: 7
    {SEC_OID_SHA512,
     CKG_MGF1_SHA512,
     7,
     {0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea,
      0xeb, 0xec, 0xed, 0xee, 0xef, 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5,
      0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff},
     {0xa5, 0x05, 0x3d, 0x46, 0x93, 0x9b, 0xd6, 0xc9, 0x0f, 0x2a, 0x67, 0xf6,
      0x61, 0x30, 0x70, 0xba, 0x40, 0xa8, 0x31, 0x42, 0x88, 0x84, 0xfb, 0xbb,
      0x09, 0xd4, 0x92, 0x3b, 0x97, 0x8f, 0x17, 0xbf, 0x53, 0x8a, 0x59, 0x63,
      0xa0, 0x41, 0x68, 0x75, 0x30, 0x0f, 0x1b, 0x51, 0xd5, 0x68, 0x80, 0xec,
      0xef, 0xbe, 0x58, 0xff, 0x6e, 0xc7, 0xb3, 0x74, 0x0a, 0x64, 0x9f, 0x36,
      0xdb, 0x16, 0xba, 0x6c, 0xab, 0x9b, 0x0e, 0x4e, 0x7a, 0x1e, 0xc6, 0x58,
      0xfa, 0x0f, 0xec, 0x78, 0x13, 0x61, 0xa5, 0x47, 0xa7, 0x18, 0xef, 0x5d,
      0x9f, 0x7d, 0x03, 0x89, 0x2b, 0xc1, 0xb1, 0x86, 0x02, 0x43, 0x6f, 0xbe,
      0x5f, 0xf5, 0xcc, 0x6c, 0x3c, 0xfe, 0x8f, 0x2e, 0x9d, 0xf9, 0x60, 0xed,
      0x89, 0x80, 0x0d, 0xa5, 0x46, 0x63, 0x02, 0x51, 0xd2, 0x92, 0xb0, 0x0a,
      0x60, 0xd1, 0x02, 0x21, 0x1d, 0xb2, 0x8a, 0xd1, 0x84, 0x91, 0x97, 0x09,
      0xd8, 0xd4, 0xa1, 0xab, 0x89, 0xd6, 0x5a, 0xb2, 0xfd, 0xbc, 0xb6, 0x6e,
      0x14, 0x92, 0xc4, 0x52, 0x54, 0x17, 0xee, 0xd8, 0x9a, 0x0b, 0xe2, 0xc6,
      0x7a, 0x79, 0xc5, 0xf8, 0x94, 0x94, 0xee, 0x7e, 0xf9, 0xd3, 0xd0, 0xd7,
      0xdb, 0x2d, 0xe3, 0x4e, 0xc6, 0xbe, 0x58, 0x63, 0x99, 0x3e, 0x8f, 0x64,
      0xe4, 0x60, 0x1b, 0x79, 0x45, 0xb2, 0xea, 0x27, 0x1e, 0xfc, 0x94, 0x1c,
      0x42, 0x53, 0xb0, 0x9d, 0xd3, 0xa3, 0xfd, 0xec, 0x6b, 0x45, 0x03, 0x88,
      0x87, 0x01, 0x8a, 0x50, 0x18, 0x77, 0x1f, 0xe6, 0x0e, 0xb6, 0x7a, 0x68,
      0xbf, 0x97, 0x7e, 0x9d, 0x3c, 0x6b, 0x03, 0x2f, 0xa2, 0x88, 0x68, 0xdf,
      0x58, 0x38, 0x69, 0x02, 0x06, 0x5b, 0xa3, 0xac, 0x7f, 0x02, 0x86, 0x00,
      0xc5, 0xdd, 0x5c, 0x18, 0x05, 0x52, 0xa2, 0x5d, 0x74, 0x1d, 0xb1, 0x27,
      0x63, 0xdc, 0x3b, 0x89},
     {},
     priv_key_3,
     true},

    // Comment:
    // tcID: 8
    {SEC_OID_SHA512,
     CKG_MGF1_SHA512,
     8,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x38, 0xea, 0xd5, 0xce, 0xc1, 0x62, 0x2d, 0x62, 0xe9, 0xf2, 0x7e, 0xb7,
      0xbb, 0x9d, 0x36, 0x9f, 0xc1, 0x3c, 0xf7, 0xd2, 0x12, 0x56, 0xc5, 0xdf,
      0x89, 0x58, 0xdf, 0xfa, 0x1d, 0xf2, 0xdf, 0xba, 0xe0, 0x06, 0xc8, 0x0a,
      0xc4, 0x5e, 0xbc, 0x30, 0x44, 0xa2, 0x0f, 0x8b, 0xa0, 0x24, 0xb7, 0x3c,
      0x2e, 0x03, 0x18, 0x5a, 0x9e, 0x4d, 0x97, 0x5f, 0xe3, 0x07, 0x5e, 0x6e,
      0x11, 0x78, 0x71, 0x16, 0xd1, 0xdd, 0xab, 0xf2, 0xaf, 0x65, 0x90, 0x4e,
      0xc9, 0xa5, 0xb1, 0x45, 0xdb, 0xf1, 0x67, 0x87, 0x2d, 0x06, 0x6e, 0xf4,
      0x90, 0xc4, 0xb9, 0xa7, 0x24, 0x00, 0x0c, 0x44, 0x42, 0x5c, 0xd3, 0x34,
      0x48, 0x28, 0x8e, 0x88, 0x3f, 0xd0, 0x1a, 0xd9, 0x15, 0xb8, 0xa4, 0xd9,
      0xd3, 0xc6, 0x5f, 0xc0, 0xc1, 0x2d, 0x5c, 0x5b, 0xcb, 0x78, 0xb3, 0x23,
      0xdb, 0x20, 0xba, 0x07, 0xe5, 0x7a, 0x18, 0x82, 0x0e, 0x11, 0x54, 0xe9,
      0x46, 0x0d, 0x71, 0xb9, 0x2f, 0x85, 0xae, 0xd9, 0x2c, 0x21, 0x28, 0xc8,
      0x3e, 0x59, 0x85, 0x64, 0x13, 0x8a, 0x97, 0xe0, 0x37, 0x99, 0x66, 0x45,
      0x93, 0x64, 0xbe, 0x6a, 0xa1, 0x66, 0xa8, 0xb6, 0x2c, 0xf7, 0xc5, 0xb8,
      0x06, 0x2d, 0x99, 0xe9, 0x8f, 0xad, 0x15, 0x5c, 0x9f, 0x0f, 0x1c, 0x86,
      0x29, 0xe4, 0x3a, 0x45, 0x67, 0x45, 0x63, 0xf0, 0xd1, 0x42, 0xc3, 0x09,
      0x60, 0x5b, 0xa2, 0xdc, 0xb0, 0x48, 0xa9, 0xd5, 0xc5, 0x8f, 0xeb, 0xa1,
      0x6b, 0x5b, 0x2c, 0x98, 0x8d, 0x93, 0x74, 0x1e, 0x84, 0xec, 0x47, 0xf1,
      0xcb, 0xfe, 0xee, 0x54, 0x0f, 0x10, 0xda, 0xc1, 0x20, 0x73, 0x41, 0x43,
      0xc8, 0x0e, 0x98, 0x72, 0x5c, 0x60, 0x9a, 0xc2, 0x49, 0x55, 0x8f, 0x8a,
      0xc5, 0x8c, 0xb2, 0x17, 0x69, 0x94, 0x11, 0x02, 0xaf, 0x34, 0xaa, 0xf0,
      0x2d, 0x53, 0x8c, 0x55},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     priv_key_3,
     true},

    // Comment:
    // tcID: 9
    {SEC_OID_SHA512,
     CKG_MGF1_SHA512,
     9,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xa4, 0x58, 0x2c, 0x4d, 0xbd, 0x1e, 0x60, 0x06, 0x2e, 0x51, 0x73, 0x31,
      0xf4, 0xd4, 0x9a, 0x67, 0x49, 0x1c, 0x97, 0x5b, 0xbe, 0xeb, 0x58, 0xc5,
      0x3c, 0x21, 0xc1, 0xaa, 0x35, 0x0c, 0x63, 0xd7, 0x49, 0x40, 0xeb, 0xb3,
      0xe6, 0xd8, 0x06, 0x2c, 0xef, 0xb2, 0xf0, 0xcc, 0x64, 0x5b, 0x07, 0xe7,
      0x7e, 0x6b, 0xd3, 0x50, 0xba, 0xab, 0x08, 0x86, 0x26, 0x65, 0xb8, 0x0f,
      0xcb, 0xb5, 0xc3, 0x86, 0xbf, 0xe3, 0x30, 0xea, 0xe7, 0xc4, 0x3a, 0x45,
      0x1d, 0x68, 0xe7, 0x5d, 0xa6, 0xa0, 0x23, 0x0a, 0x5f, 0xfc, 0x45, 0xc9,
      0x70, 0x6c, 0xb5, 0xbf, 0xf4, 0x95, 0x2a, 0xba, 0x08, 0x23, 0x0a, 0x62,
      0x69, 0x29, 0x72, 0x6c, 0xee, 0xa0, 0x68, 0xd5, 0x2c, 0x18, 0xc5, 0x25,
      0xde, 0xc9, 0xd9, 0x48, 0x84, 0xcd, 0x93, 0xa5, 0xb3, 0x9a, 0xcb, 0xcf,
      0x31, 0xa0, 0xa3, 0xc1, 0xd2, 0x8b, 0xc2, 0xff, 0x35, 0x2f, 0xf4, 0x09,
      0x72, 0x24, 0x66, 0x41, 0x02, 0x01, 0x5a, 0x14, 0xd6, 0xd9, 0x66, 0x3d,
      0x91, 0x48, 0x9f, 0x9c, 0xa4, 0xe5, 0xe2, 0x40, 0xa4, 0xd9, 0xc9, 0x37,
      0x07, 0xe0, 0x15, 0xf0, 0x7d, 0xd6, 0x39, 0x8b, 0x30, 0x69, 0x59, 0xd6,
      0xa5, 0x45, 0x61, 0x6a, 0x31, 0x24, 0xb3, 0xa8, 0x7c, 0x8a, 0x17, 0x29,
      0x3b, 0xa3, 0x6f, 0x3c, 0x8a, 0xf4, 0xbe, 0x8b, 0xfc, 0xcb, 0xcc, 0x0f,
      0xda, 0x06, 0x88, 0x1e, 0x05, 0x04, 0x6b, 0x80, 0x88, 0xfa, 0x09, 0xc5,
      0x42, 0xf6, 0xbc, 0x7a, 0x39, 0x7a, 0xb8, 0x2f, 0x47, 0xe0, 0x5d, 0x51,
      0x7e, 0x79, 0xb4, 0x62, 0xfa, 0x77, 0xbe, 0x7f, 0xa1, 0xaf, 0x05, 0xa0,
      0x9b, 0xaa, 0x17, 0xeb, 0xff, 0xe7, 0x3e, 0x38, 0xc3, 0x10, 0x7f, 0x46,
      0x00, 0xd7, 0x5f, 0x9b, 0xec, 0xaa, 0x8a, 0xf6, 0x8e, 0x37, 0xa4, 0xde,
      0xed, 0xfd, 0x9f, 0x10},
     {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09,
      0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13},
     priv_key_3,
     true},

    // Comment:
    // tcID: 10
    {SEC_OID_SHA512,
     CKG_MGF1_SHA512,
     10,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x1b, 0xb7, 0xa6, 0xd1, 0xdb, 0xab, 0x99, 0x46, 0x19, 0xf2, 0x5b, 0xd1,
      0x65, 0x9c, 0x21, 0x5d, 0xfc, 0x12, 0xcc, 0xde, 0x9f, 0x91, 0xec, 0xdb,
      0xce, 0xbe, 0xbd, 0x9c, 0x9d, 0x13, 0x99, 0xab, 0x82, 0x96, 0x03, 0x5f,
      0x43, 0xf0, 0xac, 0x65, 0xc5, 0x6f, 0x56, 0x70, 0x7a, 0xa4, 0xa3, 0x01,
      0x93, 0x9b, 0x74, 0x5a, 0x0d, 0x00, 0x00, 0x65, 0x20, 0x72, 0xab, 0xa5,
      0xc5, 0x14, 0xca, 0x33, 0x1c, 0x9d, 0xd0, 0x6a, 0x2f, 0x1c, 0x01, 0x22,
      0xb1, 0xba, 0x6f, 0x93, 0x89, 0xc6, 0xea, 0x69, 0x04, 0xf3, 0x6c, 0xac,
      0x57, 0x88, 0xd3, 0x39, 0x69, 0x1f, 0xea, 0xbd, 0x34, 0xb6, 0x5b, 0xfa,
      0x45, 0x05, 0xc6, 0x0e, 0x43, 0x97, 0x13, 0x59, 0x1a, 0x8d, 0xdc, 0x6e,
      0xbe, 0x85, 0x13, 0x1b, 0xcf, 0xb3, 0x7f, 0x74, 0x76, 0x12, 0x0d, 0x58,
      0x7f, 0x12, 0x7c, 0xc5, 0x2f, 0x89, 0x14, 0xf0, 0xc7, 0x8a, 0x2e, 0xdd,
      0xdd, 0x1c, 0x6c, 0x52, 0x80, 0xb7, 0x45, 0xde, 0x59, 0x5b, 0xc6, 0xbe,
      0x42, 0x4d, 0x01, 0xd9, 0x9e, 0x58, 0xa8, 0x83, 0x47, 0x42, 0xcd, 0x2f,
      0x08, 0x5b, 0x33, 0x49, 0x66, 0xb6, 0x92, 0xc3, 0xbd, 0x37, 0x2b, 0x94,
      0xc8, 0x46, 0x58, 0x15, 0x48, 0xed, 0x22, 0x80, 0xc6, 0x4b, 0x32, 0x0e,
      0xc1, 0x34, 0x1a, 0xb5, 0x4a, 0x70, 0x2e, 0xf7, 0x04, 0x0f, 0xf6, 0x70,
      0x94, 0xd5, 0x40, 0xdc, 0xb0, 0x80, 0xfd, 0xee, 0xb2, 0x05, 0x0f, 0xff,
      0x66, 0xea, 0xab, 0xfd, 0x5b, 0x66, 0xc9, 0x9a, 0xb4, 0x9d, 0xb5, 0xe6,
      0xc7, 0x2c, 0xb2, 0xd5, 0x30, 0xd5, 0x03, 0xa8, 0x7d, 0x69, 0x1d, 0xcd,
      0xbf, 0xf8, 0x5c, 0x5e, 0x8c, 0x9f, 0xe2, 0x8a, 0x1f, 0x32, 0xfc, 0x4a,
      0x22, 0xa2, 0xa6, 0x7a, 0xe9, 0x58, 0x4a, 0x44, 0x11, 0xf8, 0xdc, 0x03,
      0xd3, 0xe7, 0x6b, 0x55},
     {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a,
      0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15,
      0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f},
     priv_key_3,
     true},

    // Comment: Longest valid message size
    // tcID: 11
    {SEC_OID_SHA512,
     CKG_MGF1_SHA512,
     11,
     {0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78},
     {0x89, 0xbc, 0x06, 0xf1, 0xf1, 0x2c, 0x0b, 0x68, 0x83, 0x52, 0xd3, 0x1d,
      0xdb, 0xe2, 0x2d, 0xe9, 0x2b, 0x3e, 0x8c, 0xe8, 0xe0, 0xf7, 0xd3, 0x4e,
      0x56, 0x63, 0xce, 0xf1, 0xb4, 0x73, 0x40, 0x8c, 0x93, 0x2a, 0xad, 0xe4,
      0xf0, 0x6b, 0x05, 0x6a, 0x52, 0xa4, 0x8a, 0x0b, 0x7c, 0x80, 0xc7, 0x63,
      0xcc, 0xd3, 0x15, 0x5f, 0x9f, 0x42, 0x82, 0xaa, 0x35, 0x0e, 0x9c, 0x49,
      0x4d, 0xcd, 0x99, 0xdc, 0x2f, 0x4c, 0x17, 0xd5, 0x3a, 0xbb, 0xf2, 0x4a,
      0x37, 0x19, 0x4d, 0xb5, 0xf9, 0x87, 0xaa, 0xa1, 0x76, 0x02, 0x8b, 0x25,
      0x70, 0xc8, 0xe7, 0x4a, 0xab, 0x35, 0x6e, 0x23, 0x3e, 0x40, 0x68, 0x12,
      0xa1, 0x7f, 0xac, 0x0b, 0x92, 0xd2, 0x7f, 0x50, 0x3e, 0x6d, 0xcb, 0xa5,
      0x57, 0x87, 0x55, 0xad, 0x33, 0xa1, 0x05, 0xcc, 0xd9, 0x12, 0x04, 0xc8,
      0xed, 0x22, 0xe9, 0x23, 0x49, 0x2f, 0xf0, 0x7d, 0x5a, 0xa7, 0x02, 0x39,
      0x4b, 0x5b, 0x8c, 0xc4, 0x17, 0xe8, 0xe3, 0x90, 0xfc, 0x82, 0x68, 0xca,
      0xb2, 0x46, 0x8a, 0x42, 0x85, 0xa4, 0xfc, 0x32, 0x7a, 0x83, 0x03, 0x8e,
      0x59, 0x11, 0x46, 0x54, 0xdf, 0x7d, 0x4d, 0xd3, 0x29, 0x10, 0xf0, 0xfc,
      0x2e, 0x90, 0x01, 0x77, 0xd4, 0x6a, 0xea, 0x50, 0xa6, 0x1f, 0xb0, 0xe2,
      0x06, 0x69, 0x47, 0xfc, 0x64, 0x8e, 0xf4, 0x0e, 0x22, 0xc2, 0x15, 0x64,
      0x64, 0xfa, 0xd8, 0xbf, 0xab, 0x19, 0xd8, 0xdd, 0x9a, 0x4a, 0xaa, 0x88,
      0x04, 0x02, 0x46, 0x93, 0xfd, 0x2c, 0xd4, 0x5c, 0x23, 0x3c, 0x59, 0xec,
      0x67, 0xbe, 0x03, 0xa8, 0xb2, 0x3f, 0xd8, 0x59, 0x00, 0x3b, 0x2d, 0x01,
      0x54, 0x02, 0x14, 0xb3, 0xc0, 0x66, 0x33, 0xce, 0x27, 0x3a, 0x9a, 0x99,
      0x2d, 0x11, 0xbe, 0xfc, 0x23, 0xef, 0x6b, 0xe3, 0x47, 0x98, 0x52, 0x2c,
      0x07, 0x4f, 0x4f, 0xfd},
     {},
     priv_key_3,
     true},

    // Comment: first byte of l_hash modified
    // tcID: 12
    {SEC_OID_SHA512,
     CKG_MGF1_SHA512,
     12,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xae, 0x26, 0xc9, 0x44, 0x76, 0x74, 0x7f, 0x8a, 0x74, 0x54, 0xa8, 0x0c,
      0x05, 0x40, 0x5b, 0xf3, 0x57, 0x99, 0xca, 0x10, 0x70, 0x34, 0x1b, 0x73,
      0x20, 0x8d, 0xe2, 0x4e, 0x77, 0x87, 0xaf, 0x78, 0x46, 0xde, 0x55, 0xab,
      0x36, 0xc2, 0xd0, 0xfe, 0xac, 0xc1, 0x65, 0x31, 0x97, 0xd4, 0x2c, 0xfd,
      0x02, 0xaa, 0xbd, 0xd5, 0x76, 0x33, 0xa6, 0x9f, 0x7f, 0xe0, 0x9b, 0xdc,
      0x72, 0xc8, 0xed, 0x28, 0xc4, 0xb1, 0x73, 0x6c, 0xa7, 0xb2, 0x85, 0xcc,
      0x68, 0x58, 0x86, 0xa5, 0xec, 0x53, 0x5d, 0xa9, 0xdb, 0x91, 0x96, 0x5b,
      0x29, 0x1c, 0x53, 0xbf, 0x92, 0xb1, 0xae, 0x15, 0x99, 0x74, 0xee, 0x79,
      0x5a, 0xd0, 0xfd, 0xb8, 0xb4, 0x22, 0xc0, 0x6a, 0xeb, 0x78, 0x92, 0x3b,
      0x27, 0xce, 0x67, 0xa7, 0x66, 0xf1, 0x42, 0xd1, 0x0f, 0x96, 0x04, 0x48,
      0x67, 0x9e, 0x5f, 0xd1, 0x17, 0x61, 0x24, 0x59, 0x3d, 0x32, 0xb9, 0xb7,
      0x65, 0x38, 0x62, 0x14, 0x76, 0x37, 0xa7, 0x6a, 0x87, 0x33, 0x2a, 0xcc,
      0x5b, 0xe2, 0xa9, 0x55, 0xe4, 0xbd, 0x2d, 0xe8, 0xb6, 0x3d, 0x87, 0x3f,
      0xf4, 0x49, 0x71, 0x5f, 0x6f, 0x1f, 0x7c, 0x76, 0xe4, 0x08, 0x31, 0x51,
      0xdc, 0x6d, 0x58, 0xa3, 0xe3, 0x14, 0x4c, 0x69, 0x4a, 0x4e, 0xc8, 0x55,
      0x23, 0xfe, 0x71, 0xb2, 0x98, 0xdc, 0xa5, 0xf0, 0x71, 0x66, 0x19, 0xea,
      0x3e, 0x11, 0x82, 0xa9, 0x4c, 0x5a, 0x9f, 0x6e, 0x60, 0x28, 0x44, 0xdf,
      0x92, 0xd1, 0xd2, 0x85, 0x0f, 0xb6, 0x4b, 0xd1, 0xf2, 0x8d, 0xa3, 0x47,
      0xb4, 0x4e, 0x0a, 0xf2, 0x01, 0x7b, 0xad, 0x6b, 0x61, 0xa7, 0x19, 0x0d,
      0xcf, 0xde, 0xd0, 0xdf, 0x48, 0x84, 0x0d, 0x3a, 0x7b, 0xca, 0xd7, 0x96,
      0x74, 0x4c, 0x7b, 0xa5, 0xb2, 0x14, 0x00, 0x2f, 0x93, 0x0b, 0x28, 0xf9,
      0x58, 0xcc, 0x5f, 0x0e},
     {},
     priv_key_3,
     false},

    // Comment: last byte of l_hash modified
    // tcID: 13
    {SEC_OID_SHA512,
     CKG_MGF1_SHA512,
     13,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x17, 0x73, 0xe5, 0xb4, 0x93, 0xec, 0x17, 0xb5, 0x6e, 0x25, 0x08, 0x85,
      0xeb, 0x5f, 0xbc, 0x3d, 0xb1, 0x60, 0xe2, 0xf6, 0xae, 0x55, 0xbc, 0xd6,
      0xa4, 0x3a, 0xbf, 0x01, 0xaa, 0x61, 0xa4, 0xb0, 0xb7, 0xb2, 0xdd, 0x0d,
      0x52, 0x24, 0x28, 0xaf, 0x67, 0x30, 0xff, 0x37, 0x4c, 0x40, 0x77, 0x9c,
      0xa0, 0xc2, 0xbd, 0x80, 0x08, 0xe2, 0x66, 0xed, 0x23, 0x4c, 0x61, 0x33,
      0xad, 0x4c, 0xe1, 0x3f, 0x78, 0x46, 0x8a, 0x0f, 0x82, 0x8a, 0xd8, 0x6a,
      0x8d, 0xd7, 0x86, 0x6f, 0xbf, 0xac, 0x74, 0x1f, 0x66, 0xd9, 0x09, 0xea,
      0x1f, 0x41, 0x5a, 0x73, 0x37, 0xfd, 0x44, 0x9f, 0x5b, 0x2e, 0xc6, 0x2c,
      0x5b, 0xec, 0x32, 0x8d, 0x18, 0xf9, 0xda, 0xe1, 0x93, 0xeb, 0x16, 0x45,
      0xe1, 0xfb, 0x26, 0xbe, 0x42, 0xbc, 0x6e, 0xb9, 0x80, 0xce, 0x56, 0x79,
      0xa8, 0x81, 0x44, 0xa2, 0xdd, 0x1d, 0xf3, 0x2d, 0x8f, 0xc4, 0x8f, 0xd9,
      0xb3, 0xc7, 0x0e, 0x95, 0x56, 0x1f, 0x50, 0xda, 0x32, 0x81, 0x61, 0xd2,
      0xff, 0x65, 0x81, 0x96, 0xf7, 0xf9, 0x8d, 0xa5, 0x63, 0xaf, 0x6e, 0x4c,
      0x1e, 0xd2, 0xdb, 0xe9, 0x92, 0xef, 0x0d, 0xf6, 0x69, 0x32, 0xa4, 0x58,
      0x12, 0x23, 0x42, 0x11, 0x13, 0x1b, 0x43, 0xf6, 0x18, 0xb2, 0x77, 0xc5,
      0x53, 0xfb, 0xc4, 0x08, 0xca, 0x23, 0x69, 0xf3, 0x3e, 0x08, 0x0d, 0x9b,
      0x11, 0x88, 0x21, 0x04, 0x34, 0xc2, 0xd9, 0x0c, 0x3f, 0x8d, 0x03, 0xd8,
      0x92, 0xea, 0xdd, 0x70, 0xaf, 0x1c, 0x43, 0xa8, 0x58, 0x6a, 0x4f, 0x52,
      0x3c, 0x60, 0xfb, 0xba, 0x5c, 0xb9, 0x8e, 0x2b, 0x08, 0x55, 0xdb, 0x41,
      0x3c, 0x2e, 0x99, 0xea, 0x48, 0x63, 0xa1, 0xc2, 0xdb, 0x01, 0x4b, 0x6a,
      0x31, 0xae, 0xe5, 0x64, 0x48, 0xbc, 0x00, 0xa5, 0x87, 0x17, 0xf0, 0x38,
      0x59, 0xdd, 0x65, 0x52},
     {},
     priv_key_3,
     false},

    // Comment: l_hash changed to all 0
    // tcID: 14
    {SEC_OID_SHA512,
     CKG_MGF1_SHA512,
     14,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x6c, 0xff, 0xa2, 0xba, 0xcf, 0x01, 0x04, 0x49, 0x46, 0x0c, 0x15, 0xf4,
      0xe4, 0xd5, 0xba, 0xfd, 0x23, 0xbe, 0x3d, 0x7b, 0xa4, 0xac, 0x69, 0x36,
      0x8a, 0xc0, 0xdb, 0xba, 0x12, 0x68, 0xdf, 0x39, 0xb9, 0x6a, 0x86, 0x3e,
      0x75, 0x9e, 0xb3, 0x1a, 0x3f, 0x9e, 0xac, 0x54, 0x94, 0xe2, 0x9f, 0x71,
      0x0a, 0xfe, 0xec, 0x49, 0x0e, 0xc8, 0x2d, 0x58, 0x26, 0x54, 0xe7, 0x82,
      0xc0, 0x6c, 0xb0, 0x61, 0x3d, 0x9b, 0x15, 0xd8, 0xc0, 0x64, 0x17, 0xe3,
      0x6f, 0x68, 0x6b, 0x71, 0x54, 0x04, 0x94, 0xf5, 0x1e, 0x99, 0x3b, 0xc2,
      0xeb, 0x44, 0x62, 0x9f, 0xd3, 0x29, 0x94, 0x29, 0x06, 0x8e, 0xa8, 0x43,
      0x09, 0x50, 0x48, 0x99, 0xc5, 0xb1, 0xbc, 0xd7, 0xa4, 0x95, 0x99, 0x93,
      0x8f, 0x5b, 0xea, 0x8d, 0x30, 0x81, 0x13, 0xd8, 0x4c, 0x38, 0xac, 0xf7,
      0xeb, 0x90, 0x1c, 0xf3, 0x27, 0x4d, 0xbf, 0xd7, 0x1b, 0x98, 0xf4, 0x20,
      0xa8, 0x33, 0x72, 0x61, 0x3b, 0x4f, 0x43, 0x18, 0x93, 0x08, 0xaa, 0x76,
      0xc9, 0xba, 0x15, 0xf9, 0x76, 0x9c, 0xf4, 0xbc, 0x5d, 0xef, 0x8a, 0xe0,
      0x24, 0x49, 0xc3, 0xb1, 0xee, 0x74, 0xf0, 0x03, 0x2b, 0xf1, 0xa8, 0x35,
      0x67, 0x97, 0xaa, 0xe2, 0x3f, 0x5a, 0x59, 0x8c, 0x3f, 0x33, 0x6d, 0xf8,
      0xd1, 0x95, 0xcf, 0x31, 0xf9, 0xdb, 0xb6, 0x0f, 0xf4, 0xa9, 0xe5, 0xc1,
      0x39, 0x8b, 0xa0, 0x76, 0x62, 0xf3, 0x12, 0x46, 0x17, 0x0f, 0xfa, 0x3b,
      0xd3, 0x8a, 0xb0, 0xb4, 0x2d, 0xbb, 0xb5, 0x55, 0xaf, 0xfd, 0xd4, 0x92,
      0x8a, 0x4b, 0x47, 0x8f, 0x9d, 0x5c, 0xa9, 0xa8, 0xf9, 0x71, 0x9b, 0x0b,
      0x2a, 0x0d, 0x3d, 0xdf, 0xbf, 0x70, 0x83, 0x68, 0x97, 0x0b, 0xcf, 0x02,
      0x7e, 0x48, 0xea, 0x2d, 0x0a, 0xd1, 0x09, 0x49, 0xa2, 0x38, 0xc2, 0x18,
      0xac, 0x71, 0x01, 0xe7},
     {},
     priv_key_3,
     false},

    // Comment: l_hash changed to all 1
    // tcID: 15
    {SEC_OID_SHA512,
     CKG_MGF1_SHA512,
     15,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x92, 0x56, 0xe2, 0x34, 0x12, 0x34, 0xa8, 0x67, 0xea, 0x47, 0x6b, 0xe7,
      0x84, 0x8b, 0x35, 0xaa, 0xd5, 0xe2, 0xd2, 0xcd, 0x91, 0x70, 0x76, 0x8a,
      0xf4, 0xf1, 0x4f, 0xc1, 0xb3, 0x0b, 0xe1, 0x51, 0xce, 0xeb, 0x27, 0x68,
      0x76, 0x7e, 0x09, 0x09, 0x13, 0xe0, 0xe0, 0x58, 0x44, 0x08, 0x8f, 0xa1,
      0x5b, 0x7a, 0x1a, 0x99, 0x77, 0x7b, 0x61, 0x4a, 0x89, 0xe9, 0x9d, 0xe4,
      0x72, 0x04, 0x7d, 0xec, 0xd6, 0xe9, 0x21, 0x4e, 0x6c, 0x02, 0x53, 0x85,
      0xfb, 0xc4, 0x67, 0xc5, 0x33, 0x1f, 0xeb, 0xae, 0x8e, 0x23, 0x07, 0xbb,
      0xb0, 0xf0, 0x15, 0x22, 0x80, 0x24, 0x44, 0x5e, 0x14, 0x2e, 0x79, 0xd9,
      0x1c, 0xb7, 0xa0, 0x0c, 0xce, 0x07, 0xeb, 0xd3, 0x64, 0x74, 0xd6, 0xbb,
      0x21, 0x94, 0xa3, 0x9c, 0xad, 0x1c, 0x11, 0x04, 0x92, 0xac, 0x0e, 0x06,
      0x37, 0xfd, 0xfc, 0xc5, 0x45, 0x3b, 0x03, 0x13, 0x06, 0x54, 0x75, 0xa5,
      0x63, 0xa8, 0x25, 0x7a, 0xa1, 0xea, 0x46, 0x7c, 0x58, 0xcd, 0xee, 0xa0,
      0xe1, 0x39, 0x13, 0x2a, 0x97, 0xaf, 0x3f, 0xc9, 0x0b, 0x3b, 0xd7, 0x0f,
      0x03, 0xc3, 0x37, 0xdb, 0xe7, 0x3e, 0xe8, 0xc9, 0x92, 0xa7, 0x1d, 0x84,
      0x7b, 0xf9, 0xf5, 0x59, 0xe6, 0x66, 0x59, 0x2a, 0x7f, 0x1d, 0x38, 0x76,
      0xcd, 0x16, 0x25, 0xeb, 0xd4, 0x05, 0x6c, 0x6d, 0xe6, 0x07, 0x72, 0x29,
      0xcc, 0x2d, 0xd2, 0x30, 0xcb, 0xc5, 0x1a, 0xe7, 0xa2, 0x81, 0x05, 0xbe,
      0x3d, 0xc3, 0x2f, 0x79, 0x5e, 0xcc, 0x11, 0xb4, 0x5e, 0xd1, 0x07, 0x41,
      0x54, 0xf1, 0xd2, 0x4b, 0x11, 0xab, 0x55, 0x96, 0xd3, 0xf8, 0x82, 0x9a,
      0x5b, 0xe9, 0x76, 0xb2, 0xdb, 0x2d, 0xda, 0x1e, 0x2f, 0xc2, 0x17, 0x43,
      0x84, 0xe6, 0x33, 0x2a, 0x63, 0xa1, 0x9a, 0x73, 0x4c, 0x50, 0xb1, 0xa3,
      0x4e, 0x20, 0x1c, 0xa0},
     {},
     priv_key_3,
     false},

    // Comment: first byte of ps modified
    // tcID: 16
    {SEC_OID_SHA512,
     CKG_MGF1_SHA512,
     16,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x68, 0x08, 0x81, 0x30, 0x38, 0xa5, 0x1b, 0xba, 0xa5, 0xf4, 0x05, 0x4f,
      0x9f, 0xb7, 0x90, 0x6c, 0x30, 0x73, 0x6f, 0xcd, 0x15, 0x0a, 0x1c, 0x70,
      0xb3, 0x54, 0x1d, 0x37, 0x07, 0x26, 0x30, 0x57, 0x14, 0x25, 0x03, 0xbf,
      0x28, 0x5b, 0xda, 0x1d, 0xeb, 0xd1, 0xd6, 0xc5, 0x49, 0x12, 0x69, 0x62,
      0x72, 0x45, 0xcd, 0x64, 0x9a, 0x02, 0x7d, 0x0e, 0xdc, 0xb4, 0x35, 0x8f,
      0xf9, 0xfa, 0xd8, 0x3c, 0x06, 0x44, 0xeb, 0xd8, 0xc3, 0xde, 0xe5, 0xbe,
      0x6f, 0xdf, 0xc1, 0xee, 0xf4, 0x43, 0xbc, 0xd9, 0xcd, 0x55, 0x30, 0xb0,
      0x88, 0xf9, 0xf9, 0x70, 0x62, 0x3b, 0x38, 0x0b, 0xbe, 0xb0, 0xb9, 0x45,
      0xc7, 0x47, 0x37, 0x17, 0x7c, 0x6b, 0x14, 0x85, 0xc5, 0xde, 0x2a, 0x0a,
      0xad, 0x57, 0x6c, 0xa7, 0x9d, 0x05, 0xb4, 0x1e, 0xc7, 0xc5, 0x29, 0x75,
      0x50, 0x3f, 0x3a, 0xf2, 0xcb, 0xc7, 0x72, 0x11, 0x6a, 0x27, 0x73, 0x16,
      0x87, 0xaa, 0xdf, 0x16, 0xfa, 0x47, 0x04, 0xcf, 0xe5, 0x62, 0x23, 0x33,
      0x6c, 0x64, 0xe2, 0xd8, 0xda, 0xa6, 0xa5, 0xfb, 0x75, 0xe4, 0x7c, 0x0f,
      0xde, 0x2b, 0xef, 0x7c, 0x48, 0xbe, 0xb4, 0x63, 0x17, 0xb3, 0xe6, 0x37,
      0xc5, 0xbf, 0xce, 0x3f, 0xf4, 0xfd, 0x56, 0x54, 0xb2, 0x4a, 0xc6, 0x40,
      0x1a, 0xb3, 0x46, 0xfc, 0xf7, 0xe2, 0x14, 0xc6, 0x74, 0xe0, 0x99, 0xeb,
      0x9d, 0x93, 0x3c, 0xd1, 0x48, 0x4e, 0x70, 0xfc, 0xef, 0xaf, 0xf0, 0x49,
      0x8c, 0x8f, 0xd8, 0x67, 0x2e, 0x35, 0x31, 0x2d, 0x0b, 0xff, 0x87, 0xe2,
      0x44, 0xdf, 0x3b, 0xb4, 0xa3, 0xc3, 0xf6, 0x4d, 0x73, 0xfb, 0x06, 0x06,
      0xab, 0x46, 0xb8, 0x84, 0x8e, 0x14, 0x0a, 0x91, 0xfa, 0x3d, 0xa0, 0x8e,
      0xc1, 0x04, 0xbc, 0xee, 0x48, 0x33, 0x60, 0x04, 0x8c, 0xb1, 0x59, 0x6a,
      0x25, 0xb5, 0x61, 0x06},
     {},
     priv_key_3,
     false},

    // Comment: ps terminated by 0xff
    // tcID: 17
    {SEC_OID_SHA512,
     CKG_MGF1_SHA512,
     17,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x76, 0x96, 0xed, 0xf1, 0xc0, 0x6a, 0x6b, 0x77, 0x2a, 0x95, 0x96, 0x46,
      0x65, 0xcb, 0xeb, 0x28, 0xf9, 0x2f, 0xdd, 0xe1, 0x2a, 0xb0, 0x92, 0xd7,
      0xcf, 0x18, 0x81, 0x6e, 0xf5, 0x20, 0x95, 0x03, 0xd6, 0x41, 0x6c, 0x9f,
      0x4b, 0x24, 0xa5, 0xe4, 0xe1, 0xf8, 0x28, 0xbd, 0x93, 0x63, 0x45, 0x94,
      0xb6, 0xa5, 0x97, 0xa8, 0x60, 0x05, 0x90, 0x0d, 0x47, 0xe6, 0xb4, 0x67,
      0x33, 0x7c, 0xe9, 0x60, 0x23, 0x39, 0x29, 0x58, 0xe3, 0x0e, 0x4a, 0xf4,
      0x3e, 0x7a, 0xdf, 0x2a, 0x61, 0xb5, 0x23, 0x51, 0x7e, 0x29, 0x9d, 0xd1,
      0x00, 0x92, 0x39, 0x8d, 0x1b, 0x13, 0xc2, 0x27, 0xb8, 0x46, 0xa9, 0xff,
      0x8c, 0x79, 0x2b, 0x0b, 0x1d, 0xc4, 0x13, 0x45, 0x9d, 0x9b, 0xa4, 0x54,
      0x3c, 0x81, 0xdb, 0x46, 0x09, 0xdc, 0x6e, 0x17, 0xe5, 0xb9, 0x9f, 0x04,
      0x15, 0x44, 0x44, 0xef, 0x3b, 0x23, 0x5e, 0x51, 0x7e, 0x2b, 0x49, 0x3f,
      0x7f, 0xa1, 0xcf, 0x6e, 0x72, 0x71, 0xaa, 0x16, 0x96, 0x10, 0x77, 0xf6,
      0x84, 0x3a, 0x31, 0x70, 0xaa, 0x61, 0xa0, 0xc4, 0xd5, 0x7c, 0x04, 0x11,
      0xa5, 0x18, 0xcd, 0x35, 0xc0, 0xeb, 0x63, 0xe5, 0x0b, 0x94, 0x79, 0xe7,
      0xb6, 0xd4, 0x1e, 0xa7, 0x93, 0xa6, 0xac, 0xee, 0xe1, 0xcd, 0x89, 0x20,
      0x04, 0xdd, 0x35, 0x93, 0x4e, 0xa3, 0x83, 0x79, 0x9e, 0xaf, 0x12, 0x34,
      0x7a, 0xa1, 0x84, 0xc9, 0xbe, 0x87, 0xef, 0x1c, 0x24, 0x44, 0x07, 0xac,
      0xfe, 0xf2, 0x4f, 0x97, 0x3a, 0x71, 0x27, 0xe6, 0x14, 0xc5, 0x7c, 0xc1,
      0x1a, 0x81, 0x61, 0xb9, 0x2d, 0x57, 0xec, 0xb6, 0x77, 0x40, 0xfc, 0x29,
      0x16, 0x4c, 0x53, 0x41, 0x3a, 0x9a, 0x9e, 0x21, 0x6a, 0x5b, 0x3a, 0x29,
      0x0d, 0x58, 0x5a, 0x5c, 0x0d, 0x9a, 0x26, 0xbf, 0xeb, 0x6b, 0x04, 0x5b,
      0x6b, 0xcf, 0x5c, 0x4f},
     {},
     priv_key_3,
     false},

    // Comment: ps is all zero
    // tcID: 18
    {SEC_OID_SHA512,
     CKG_MGF1_SHA512,
     18,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xa7, 0xb2, 0x7e, 0x1b, 0xb0, 0x07, 0xbe, 0xf7, 0x34, 0x44, 0x7c, 0x7e,
      0x9a, 0x2b, 0x37, 0xe0, 0x6a, 0x17, 0x21, 0xae, 0xcf, 0x74, 0x52, 0xf7,
      0x3d, 0xa7, 0x4f, 0xf3, 0x81, 0x76, 0x2b, 0x14, 0x89, 0xc6, 0xeb, 0xa6,
      0x2e, 0x34, 0x8e, 0xf4, 0xc4, 0xc6, 0x22, 0x7a, 0x91, 0x00, 0x25, 0xe8,
      0x97, 0x07, 0x29, 0x02, 0x3c, 0xdc, 0x62, 0x8d, 0x97, 0xf9, 0xd6, 0x7e,
      0x81, 0xa3, 0x6e, 0x05, 0xd8, 0x3f, 0xf6, 0x25, 0xda, 0xae, 0xe0, 0x51,
      0x83, 0x04, 0x2d, 0x5f, 0x14, 0x90, 0xc6, 0xd5, 0xab, 0x63, 0x47, 0xe9,
      0x4f, 0x33, 0xa8, 0x8f, 0xf6, 0x92, 0xcc, 0x13, 0x88, 0xac, 0x01, 0xfd,
      0x1d, 0x7f, 0xd5, 0xca, 0x5a, 0x02, 0x6a, 0xf5, 0xfe, 0x75, 0x55, 0x1a,
      0x76, 0xa8, 0xbf, 0x51, 0xb5, 0xa8, 0x8e, 0x6d, 0x7f, 0x9e, 0x99, 0x77,
      0xa9, 0x1c, 0x53, 0x54, 0x50, 0xf2, 0x79, 0x14, 0x55, 0x6a, 0x9b, 0xda,
      0x14, 0x97, 0xdc, 0x58, 0xdd, 0x74, 0xb6, 0xf2, 0x7b, 0x8a, 0x33, 0xd8,
      0xeb, 0x15, 0x7e, 0x03, 0xc3, 0xc5, 0xd8, 0x74, 0x23, 0x2f, 0x1b, 0x2e,
      0x7c, 0x13, 0x13, 0x87, 0x56, 0xc8, 0x1e, 0x4d, 0xe0, 0x0d, 0x53, 0x62,
      0x9d, 0x6c, 0xbe, 0x7c, 0x7e, 0xe9, 0xb3, 0x0f, 0xf5, 0x5b, 0x5f, 0x31,
      0x47, 0x5e, 0x2e, 0xf3, 0xe9, 0x6a, 0xa0, 0x1f, 0x60, 0x4b, 0xb3, 0x82,
      0xf5, 0xec, 0xb0, 0x61, 0x5d, 0x19, 0x5c, 0x01, 0x1d, 0x40, 0x5e, 0x72,
      0xfd, 0x55, 0x10, 0xad, 0xad, 0x46, 0x9e, 0x88, 0xe4, 0x2a, 0x5c, 0x61,
      0x41, 0x5c, 0x61, 0x47, 0xe2, 0xe4, 0x71, 0xf2, 0x8a, 0xc7, 0x1c, 0x97,
      0x04, 0x4f, 0xb5, 0xdf, 0x89, 0x2c, 0xdc, 0x48, 0x2c, 0xaa, 0xc4, 0xc2,
      0x35, 0x00, 0x33, 0xe0, 0x0b, 0x43, 0xa1, 0x22, 0x1d, 0x00, 0x08, 0xc6,
      0x3f, 0xb8, 0xf0, 0xb7},
     {},
     priv_key_3,
     false},

    // Comment: ps replaced by 0xff's
    // tcID: 19
    {SEC_OID_SHA512,
     CKG_MGF1_SHA512,
     19,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xa0, 0xc8, 0xb1, 0xed, 0x6d, 0xfb, 0xaa, 0x3e, 0x73, 0x8a, 0x3f, 0x63,
      0x82, 0xa9, 0xd0, 0x10, 0xf7, 0x28, 0x1d, 0x9f, 0x0e, 0xe9, 0xde, 0x03,
      0x43, 0x6d, 0xb9, 0x2c, 0xb5, 0x17, 0x38, 0xaa, 0x31, 0x5b, 0xca, 0x19,
      0x4a, 0x9b, 0xd9, 0x08, 0x34, 0x0b, 0x0c, 0x3e, 0x1f, 0xc8, 0x52, 0x3c,
      0xe5, 0x71, 0x1a, 0xb0, 0xf9, 0xb3, 0xf9, 0xe0, 0x09, 0xec, 0x09, 0xe1,
      0x25, 0x28, 0x05, 0x80, 0x9e, 0xac, 0xfc, 0x20, 0x59, 0x57, 0x9d, 0x45,
      0xbe, 0x3d, 0x4e, 0x26, 0xba, 0x9c, 0x6b, 0xe2, 0xf3, 0x5c, 0x2c, 0xa3,
      0xf0, 0x08, 0x76, 0xa0, 0x97, 0xd0, 0xba, 0x97, 0x19, 0xac, 0x97, 0x98,
      0xc2, 0x05, 0xfd, 0x8b, 0x44, 0xfd, 0x23, 0x9f, 0x5b, 0xd2, 0x1f, 0x7b,
      0x26, 0x4d, 0x88, 0x3a, 0x1a, 0xa7, 0x60, 0xc6, 0x0a, 0x22, 0x6c, 0x9b,
      0x9c, 0x43, 0x09, 0x0e, 0x6d, 0x91, 0x33, 0x5a, 0x1f, 0x0e, 0xa0, 0x4e,
      0x51, 0x51, 0x63, 0x18, 0x07, 0xa2, 0xf1, 0xe1, 0x3f, 0xcb, 0xb5, 0xda,
      0x9d, 0x98, 0x86, 0x7c, 0xe9, 0xfd, 0x44, 0x8e, 0xf1, 0xa1, 0x16, 0xf7,
      0x79, 0x93, 0x3d, 0xae, 0x65, 0xe5, 0x28, 0x40, 0x53, 0xdb, 0xd2, 0xd0,
      0x04, 0xcd, 0xab, 0xf7, 0xc3, 0xbf, 0x5e, 0xb2, 0xca, 0xb2, 0x5b, 0x0e,
      0x64, 0x6b, 0x25, 0xd3, 0x4d, 0x27, 0x7a, 0x4b, 0x20, 0x69, 0x6f, 0x2e,
      0x6c, 0xf7, 0x35, 0xad, 0x8a, 0xcf, 0x6a, 0x99, 0x98, 0x58, 0xd8, 0x08,
      0x62, 0x7a, 0x04, 0x9f, 0xc4, 0xac, 0xf5, 0xa5, 0x07, 0x47, 0x76, 0x20,
      0x46, 0x8d, 0xdf, 0xa1, 0x1b, 0x56, 0xd2, 0x8b, 0x63, 0xe4, 0x6b, 0xa8,
      0x8e, 0xe9, 0x01, 0x33, 0x99, 0x0e, 0x0f, 0x4b, 0xcc, 0x2e, 0xe5, 0x3a,
      0xcc, 0x15, 0x0a, 0xb3, 0xf0, 0xc6, 0xff, 0xa1, 0x01, 0x5b, 0xcb, 0xd2,
      0x9f, 0x9d, 0x2d, 0x69},
     {},
     priv_key_3,
     false},

    // Comment: seed is all 0
    // tcID: 20
    {SEC_OID_SHA512,
     CKG_MGF1_SHA512,
     20,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xac, 0xaf, 0x31, 0x6a, 0x29, 0xcb, 0xd8, 0x05, 0x13, 0x2b, 0x0c, 0x43,
      0xa4, 0x58, 0x97, 0x61, 0xa5, 0x4a, 0xef, 0x92, 0x8e, 0x40, 0x36, 0xb1,
      0x5b, 0x38, 0x9a, 0x9c, 0x17, 0xa0, 0x4c, 0x86, 0xee, 0x6d, 0x59, 0x5c,
      0x06, 0x4c, 0xda, 0xbe, 0x38, 0x34, 0x14, 0xe4, 0x14, 0x20, 0xbe, 0x7e,
      0x70, 0x16, 0x3d, 0x89, 0x82, 0x27, 0x74, 0x37, 0x4e, 0xa8, 0x5b, 0xef,
      0xbd, 0x3f, 0x3f, 0xc7, 0xdd, 0xdc, 0x3d, 0xe1, 0xf1, 0xff, 0xa2, 0xbd,
      0x59, 0x5d, 0xbc, 0x67, 0x8a, 0x03, 0xc0, 0xed, 0x64, 0x3a, 0xb4, 0xee,
      0x54, 0x0c, 0x8e, 0x3f, 0xfa, 0xf8, 0x6f, 0xca, 0x0f, 0x39, 0xeb, 0x4f,
      0x79, 0x5e, 0x9c, 0x38, 0x70, 0x45, 0xab, 0x2f, 0x37, 0x8f, 0x24, 0x6a,
      0x2f, 0xf7, 0x46, 0xdc, 0x3c, 0xc1, 0xdf, 0x8f, 0x61, 0x58, 0xf1, 0x65,
      0x81, 0x23, 0x15, 0x14, 0xfb, 0x22, 0xf6, 0xe1, 0x69, 0xb1, 0x31, 0x99,
      0xc4, 0x23, 0x9c, 0x18, 0x27, 0x76, 0x7a, 0xec, 0x25, 0x6d, 0x84, 0xf7,
      0x29, 0x73, 0x99, 0x16, 0xf7, 0xd4, 0x3a, 0x01, 0x5a, 0x33, 0x1c, 0x56,
      0x09, 0x9e, 0x8d, 0x33, 0xd6, 0x6d, 0xf6, 0x35, 0x2a, 0x45, 0x93, 0x56,
      0xd9, 0xd9, 0x81, 0xbf, 0x46, 0x7d, 0xd8, 0x8f, 0xc1, 0x15, 0xeb, 0x88,
      0xb4, 0xb2, 0x2b, 0xfc, 0xb3, 0x33, 0xfa, 0xcc, 0x97, 0xd2, 0x95, 0xd7,
      0x2c, 0xb0, 0x69, 0x84, 0xcd, 0x12, 0xb6, 0x70, 0xa5, 0x39, 0x40, 0x0a,
      0x71, 0x9d, 0x11, 0x80, 0x9a, 0x73, 0xf8, 0xc4, 0x40, 0x6a, 0x67, 0x7e,
      0xb6, 0x28, 0x5d, 0xa5, 0x57, 0xf8, 0xf6, 0x9b, 0xd0, 0x06, 0xda, 0x2c,
      0x28, 0x6a, 0x64, 0xcb, 0xbc, 0xaf, 0x2f, 0x2a, 0x08, 0x3a, 0x8e, 0x5b,
      0xaf, 0x56, 0x0c, 0x9d, 0x6f, 0xd7, 0x03, 0xad, 0x15, 0x44, 0x41, 0x3e,
      0xb0, 0xc3, 0xfc, 0xe7},
     {},
     priv_key_3,
     true},

    // Comment: seed is all 1
    // tcID: 21
    {SEC_OID_SHA512,
     CKG_MGF1_SHA512,
     21,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x0e, 0x55, 0x69, 0x75, 0x6d, 0x22, 0xd8, 0x2b, 0x91, 0x2a, 0xc1, 0x5e,
      0x90, 0x20, 0x90, 0x06, 0xc5, 0x2f, 0x6a, 0x48, 0xa4, 0x99, 0xe2, 0x42,
      0xc6, 0x60, 0x3e, 0xec, 0xfc, 0x20, 0x87, 0xc3, 0x17, 0x5c, 0x4d, 0x18,
      0xf4, 0x2b, 0xf6, 0xbb, 0x6b, 0x20, 0x1b, 0x9c, 0xeb, 0xdd, 0x8a, 0x97,
      0xa7, 0xb3, 0x2e, 0x4e, 0x7e, 0x75, 0xe0, 0x34, 0xec, 0xb9, 0x6b, 0xf0,
      0x01, 0x3b, 0x2f, 0x52, 0xba, 0x03, 0x6a, 0xb2, 0x92, 0x9c, 0x16, 0x39,
      0x62, 0xf0, 0x8c, 0xfd, 0x96, 0xce, 0x78, 0x09, 0x12, 0xbb, 0xeb, 0xca,
      0xb7, 0x79, 0x8b, 0x5c, 0xb3, 0xea, 0xb9, 0x1b, 0x82, 0xb0, 0x1d, 0xd1,
      0x98, 0x3c, 0x1b, 0xee, 0x76, 0x33, 0x4a, 0x71, 0xfa, 0x93, 0xad, 0x24,
      0x68, 0xa7, 0x99, 0xaf, 0xed, 0x4c, 0xaa, 0x12, 0x84, 0xfc, 0x01, 0x22,
      0x5c, 0xf2, 0x25, 0xbc, 0x0c, 0xef, 0xf3, 0x5a, 0x65, 0x69, 0xb7, 0x6b,
      0x5c, 0xb5, 0x7b, 0xe2, 0x14, 0xda, 0x94, 0x87, 0x2e, 0xba, 0x8a, 0x73,
      0xcd, 0x51, 0xac, 0xf9, 0x17, 0xa6, 0x27, 0xef, 0x17, 0x54, 0x7a, 0xf3,
      0x8b, 0xcb, 0x80, 0x54, 0x85, 0x26, 0x20, 0x63, 0xf8, 0x0c, 0x0d, 0xaa,
      0xb6, 0x09, 0xa4, 0x04, 0x67, 0xf7, 0x3f, 0xde, 0xde, 0x74, 0x4d, 0xb1,
      0x16, 0x84, 0x2c, 0xfc, 0xbe, 0x4b, 0x1e, 0xa7, 0x46, 0x8f, 0xcf, 0xc2,
      0x58, 0xe2, 0x06, 0x9a, 0xfa, 0xf2, 0xc5, 0x52, 0xb3, 0xbe, 0x86, 0x45,
      0x17, 0xa7, 0xb0, 0xc7, 0x1d, 0x46, 0x76, 0x5e, 0x95, 0x73, 0xf0, 0x64,
      0x3c, 0xc7, 0x62, 0xad, 0x21, 0x82, 0x69, 0x20, 0xde, 0x1a, 0xb3, 0xd1,
      0x16, 0x49, 0x6b, 0x71, 0x36, 0x6b, 0x2f, 0x6e, 0xb4, 0x87, 0xd8, 0xb4,
      0xcf, 0x8b, 0x1d, 0x6d, 0x67, 0x3d, 0xa1, 0xb3, 0x8f, 0xbb, 0xf1, 0xe1,
      0x16, 0x15, 0xb1, 0x08},
     {},
     priv_key_3,
     true},

    // Comment: First byte is 1
    // tcID: 22
    {SEC_OID_SHA512,
     CKG_MGF1_SHA512,
     22,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x27, 0xf0, 0x8c, 0x9e, 0xfb, 0x8b, 0xae, 0x28, 0x41, 0xe6, 0x73, 0x97,
      0xd0, 0xbb, 0xb2, 0xe8, 0x52, 0xc6, 0xd8, 0x44, 0xb0, 0xb8, 0x3e, 0xb0,
      0xd3, 0x12, 0x4c, 0xe3, 0x15, 0x90, 0x20, 0xac, 0x4b, 0xc7, 0x50, 0x37,
      0x7f, 0x11, 0x63, 0x0c, 0xda, 0x69, 0x56, 0x95, 0x4c, 0xc9, 0xdd, 0x8a,
      0xc5, 0xfe, 0x58, 0x6e, 0x73, 0xc0, 0x45, 0xec, 0x8a, 0xf9, 0x6e, 0xbb,
      0xc2, 0xbb, 0x6c, 0x0a, 0x3b, 0xb7, 0x0c, 0x8d, 0x67, 0xca, 0xc5, 0xe9,
      0x72, 0xb3, 0x8b, 0x20, 0x90, 0x13, 0x39, 0xce, 0x11, 0x8e, 0x26, 0x8a,
      0x8a, 0x59, 0x67, 0x5a, 0x6d, 0xd3, 0xdb, 0x05, 0xf0, 0xf9, 0xc4, 0x89,
      0x00, 0x61, 0xd0, 0x40, 0xa8, 0x73, 0x4f, 0xd4, 0x56, 0x17, 0x6d, 0x1f,
      0x4e, 0xf8, 0x11, 0x29, 0xc7, 0xb3, 0xda, 0xf2, 0xed, 0xdb, 0x2f, 0x4c,
      0x72, 0x25, 0x1f, 0xa5, 0x25, 0x50, 0x11, 0x84, 0x96, 0x23, 0x04, 0x61,
      0xb5, 0x83, 0x12, 0x2d, 0xf9, 0xf1, 0x12, 0x59, 0x9c, 0xee, 0x73, 0x72,
      0x62, 0x9b, 0x17, 0x04, 0x03, 0x03, 0x85, 0xc9, 0x88, 0xc3, 0x72, 0xe4,
      0x89, 0x20, 0x07, 0x77, 0x70, 0x98, 0xd3, 0xbb, 0x27, 0x85, 0x78, 0xe3,
      0x06, 0xe5, 0xa3, 0x7b, 0x89, 0xb7, 0x66, 0x53, 0x21, 0x63, 0x5b, 0x24,
      0x56, 0x40, 0x55, 0xf9, 0xf4, 0xad, 0xe4, 0xe2, 0xc7, 0x00, 0x70, 0x14,
      0xdb, 0x3a, 0xdd, 0x80, 0x93, 0x65, 0x9c, 0x28, 0x53, 0x38, 0xff, 0x37,
      0x0f, 0xf7, 0xe6, 0x44, 0xce, 0xd7, 0x01, 0xa7, 0xf8, 0xc1, 0x31, 0x07,
      0x3f, 0x86, 0x51, 0x99, 0x47, 0x58, 0xd0, 0x39, 0x42, 0x24, 0xcd, 0x22,
      0x71, 0x27, 0x54, 0x43, 0xc0, 0x79, 0xa3, 0x12, 0x1d, 0xf8, 0x25, 0x02,
      0x4a, 0xfe, 0xc8, 0x39, 0x40, 0x6c, 0xd4, 0x10, 0xf2, 0x0f, 0xc8, 0x29,
      0xaa, 0x54, 0x27, 0x02},
     {},
     priv_key_3,
     false},

    // Comment: m is 0
    // tcID: 23
    {SEC_OID_SHA512,
     CKG_MGF1_SHA512,
     23,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00},
     {},
     priv_key_3,
     false},

    // Comment: m is 1
    // tcID: 24
    {SEC_OID_SHA512,
     CKG_MGF1_SHA512,
     24,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x01},
     {},
     priv_key_3,
     false},

    // Comment: m is n-1
    // tcID: 25
    {SEC_OID_SHA512,
     CKG_MGF1_SHA512,
     25,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xc2, 0xc4, 0xa8, 0x60, 0x23, 0x6d, 0x3c, 0x90, 0x96, 0xa0, 0x76, 0xd6,
      0xba, 0x51, 0x07, 0xe0, 0xf7, 0xbd, 0x81, 0xe1, 0xba, 0x91, 0x6f, 0x73,
      0x75, 0x72, 0x4b, 0xd2, 0xb0, 0xb0, 0xb6, 0x39, 0x56, 0x81, 0x37, 0x15,
      0xa3, 0x45, 0x7a, 0xb0, 0x45, 0x8b, 0x71, 0xfb, 0x35, 0xa4, 0x5b, 0x27,
      0xf9, 0xef, 0x7a, 0xc3, 0xe5, 0x79, 0xde, 0xa4, 0x5d, 0xfb, 0xfd, 0x07,
      0x81, 0x9e, 0xd6, 0xb7, 0x02, 0x1a, 0xa5, 0x33, 0x6c, 0x58, 0x44, 0x2a,
      0xad, 0xd9, 0x6c, 0xa9, 0xee, 0x9d, 0x32, 0x47, 0x3e, 0x9d, 0x92, 0x78,
      0x56, 0x2b, 0x4d, 0x10, 0x25, 0x8a, 0xde, 0x6a, 0x98, 0xfb, 0x1c, 0x7c,
      0xfd, 0xc3, 0xb3, 0x71, 0x6e, 0xf5, 0xde, 0xc5, 0x8c, 0xf7, 0x3b, 0x35,
      0x9f, 0x38, 0x95, 0x99, 0xb4, 0xb5, 0x86, 0x5a, 0x98, 0x63, 0x51, 0x9e,
      0xb0, 0x01, 0xc3, 0x24, 0x38, 0x7d, 0xa7, 0x55, 0x45, 0x0d, 0xb3, 0x41,
      0x30, 0x93, 0x60, 0xe3, 0x80, 0x7c, 0x05, 0x65, 0xb8, 0xe2, 0xc4, 0x4f,
      0xbd, 0x5e, 0x6e, 0x8d, 0x04, 0xd0, 0x06, 0xd7, 0xee, 0x76, 0x8b, 0x8e,
      0x84, 0x36, 0x08, 0x2a, 0x90, 0xfa, 0x0e, 0x83, 0x7f, 0x32, 0xf4, 0x60,
      0x87, 0xab, 0x4a, 0x0d, 0x9b, 0xe2, 0x8a, 0xa7, 0xda, 0x17, 0x94, 0xce,
      0xb0, 0x17, 0x2a, 0x7f, 0x50, 0xed, 0x20, 0xf6, 0xdf, 0x64, 0x1e, 0xfb,
      0xcb, 0xfd, 0x2a, 0xac, 0x89, 0x77, 0x5c, 0x76, 0x1a, 0x73, 0x10, 0x09,
      0x3c, 0x67, 0x1c, 0x97, 0x7f, 0xa1, 0x8b, 0x0d, 0x6e, 0x01, 0xfb, 0x25,
      0xf7, 0xa4, 0x32, 0xb4, 0x2c, 0x65, 0x35, 0x97, 0x84, 0xc6, 0x89, 0x20,
      0x57, 0x19, 0xc1, 0xcf, 0x6e, 0x3a, 0x65, 0xda, 0xe2, 0xda, 0x43, 0x4c,
      0x32, 0x6d, 0xde, 0x81, 0xbb, 0x6f, 0xff, 0xfb, 0xdb, 0xf6, 0xde, 0x5c,
      0x16, 0xbb, 0xa7, 0x48},
     {},
     priv_key_3,
     false},

    // Comment: added n to c
    // tcID: 26
    {SEC_OID_SHA512,
     CKG_MGF1_SHA512,
     26,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xea, 0xc5, 0x9c, 0x81, 0xe5, 0x2d, 0xb5, 0x49, 0x55, 0x8a, 0x3b, 0x7b,
      0xad, 0xa6, 0xe9, 0xcb, 0x7b, 0x09, 0xdd, 0xab, 0xfe, 0xc0, 0x08, 0xf9,
      0xee, 0x9c, 0x9c, 0xb9, 0x1f, 0x19, 0x76, 0xf1, 0x68, 0xad, 0xef, 0x31,
      0x58, 0xe3, 0x7b, 0x21, 0x0f, 0x8f, 0xbe, 0x17, 0x90, 0xbd, 0x6a, 0xb8,
      0x92, 0xcb, 0x55, 0x6d, 0x5d, 0x1e, 0x20, 0x4d, 0x02, 0xc2, 0x25, 0x9f,
      0x6f, 0x58, 0x1f, 0x00, 0x37, 0x1b, 0x1f, 0xe1, 0x22, 0xcb, 0x70, 0x45,
      0xd8, 0xfa, 0xde, 0x58, 0x92, 0x48, 0x47, 0x5b, 0x30, 0xc3, 0x7e, 0x5f,
      0xd9, 0x3b, 0x05, 0x34, 0x11, 0xca, 0x32, 0x9e, 0x56, 0x8a, 0x58, 0xbb,
      0x50, 0x3b, 0x0f, 0x25, 0xce, 0x9e, 0xf9, 0x66, 0x3a, 0x32, 0xb7, 0x51,
      0x65, 0x80, 0x4d, 0x0f, 0x99, 0x94, 0x14, 0x75, 0xbb, 0x4e, 0xe8, 0xae,
      0xf1, 0x28, 0x3b, 0x9c, 0x7a, 0x9a, 0x9b, 0x8f, 0xa3, 0x37, 0xd9, 0xb6,
      0xe3, 0x5c, 0xa1, 0xbe, 0x25, 0xdb, 0x18, 0x0d, 0x80, 0x80, 0x4c, 0x24,
      0x1b, 0x67, 0x33, 0xe6, 0x28, 0x32, 0xfc, 0xb8, 0xc6, 0x60, 0xf2, 0x19,
      0x7d, 0xd4, 0xf4, 0xfd, 0x87, 0x07, 0x8e, 0x46, 0xf8, 0x51, 0x43, 0xb4,
      0x36, 0x82, 0xe3, 0x3f, 0x58, 0xee, 0x33, 0xb7, 0x4a, 0x35, 0x7d, 0x05,
      0x88, 0xdf, 0xf4, 0x3d, 0xd0, 0x6c, 0x6b, 0xe4, 0xab, 0x49, 0xe8, 0x1f,
      0x4f, 0x90, 0x5a, 0x22, 0xb5, 0x63, 0xc2, 0x70, 0x44, 0x01, 0xc6, 0x4d,
      0xc3, 0xe4, 0xff, 0x06, 0x6c, 0x3a, 0xdc, 0x54, 0x1d, 0x57, 0x15, 0xfd,
      0x76, 0x74, 0x03, 0x1e, 0x62, 0xd5, 0xa7, 0xb2, 0x39, 0x8d, 0xe0, 0x9e,
      0xb8, 0xda, 0x0a, 0x95, 0x4b, 0x3c, 0x18, 0x5d, 0xb2, 0x9b, 0x3f, 0xe2,
      0x6e, 0x00, 0xa6, 0x10, 0x67, 0x41, 0x3f, 0xb6, 0x40, 0x10, 0x3b, 0xd0,
      0xf5, 0x03, 0xd1, 0x04},
     {},
     priv_key_3,
     false},

    // Comment: ciphertext is empty
    // tcID: 27
    {SEC_OID_SHA512,
     CKG_MGF1_SHA512,
     27,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {},
     {},
     priv_key_3,
     false},

    // Comment: prepended bytes to ciphertext
    // tcID: 28
    {SEC_OID_SHA512,
     CKG_MGF1_SHA512,
     28,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x00, 0x00, 0x28, 0x00, 0xf4, 0x21, 0xc1, 0xc0, 0x78, 0xb8, 0xbe, 0xe9,
      0xc4, 0xa4, 0xf3, 0x55, 0xe1, 0xea, 0x83, 0x4c, 0x5b, 0xca, 0x44, 0x2e,
      0x99, 0x86, 0x79, 0x2a, 0x50, 0xe6, 0x6e, 0x68, 0xc0, 0xb8, 0x12, 0x2c,
      0xb8, 0x1b, 0xb5, 0x9e, 0x00, 0x70, 0xca, 0x04, 0x4c, 0x1c, 0x5b, 0x19,
      0x0f, 0x90, 0x98, 0xdb, 0xda, 0xa9, 0x77, 0xa4, 0x41, 0xa8, 0xa4, 0xc6,
      0x28, 0x97, 0xed, 0xb9, 0x48, 0x49, 0x35, 0x00, 0x7a, 0xad, 0xb6, 0x73,
      0x2c, 0x1b, 0x2b, 0x21, 0x71, 0xae, 0xa3, 0xab, 0x15, 0x13, 0xf2, 0x25,
      0xeb, 0xe7, 0x83, 0x0f, 0xb8, 0x23, 0xec, 0x3f, 0x54, 0x33, 0xbd, 0x8f,
      0x3c, 0x3e, 0x52, 0x77, 0x5b, 0xb4, 0x5f, 0xa9, 0x1a, 0xa0, 0xad, 0x3b,
      0x7c, 0x1b, 0xc6, 0x47, 0xb7, 0x75, 0xe4, 0xde, 0x8e, 0x1b, 0x22, 0xeb,
      0x97, 0x10, 0x41, 0x26, 0x78, 0x78, 0x42, 0x1c, 0xf4, 0x3a, 0x5e, 0x2a,
      0x26, 0x75, 0xb2, 0xc9, 0x40, 0xda, 0xa5, 0x5f, 0x12, 0xa7, 0xc7, 0x9d,
      0x87, 0xd4, 0x5e, 0x08, 0xc5, 0x59, 0x23, 0x62, 0xf5, 0xe0, 0xd7, 0xea,
      0x66, 0x8a, 0xf9, 0x9e, 0xec, 0xd2, 0xf6, 0x0d, 0x7f, 0xc3, 0x79, 0x1e,
      0x4f, 0x53, 0xae, 0xd7, 0x99, 0x31, 0xbd, 0x0b, 0xa9, 0x0f, 0x70, 0x1d,
      0xe8, 0x36, 0xd8, 0xc8, 0xc9, 0xbe, 0x7f, 0x7f, 0x4a, 0xed, 0xcb, 0xe5,
      0xc9, 0x23, 0x83, 0x93, 0x2f, 0x76, 0x2b, 0xec, 0x65, 0xfa, 0x29, 0x8e,
      0xb6, 0x44, 0x87, 0x7d, 0xe2, 0x6e, 0xec, 0x99, 0x51, 0x46, 0xaf, 0x55,
      0x1a, 0xd7, 0x7e, 0xcf, 0xd0, 0x6a, 0x36, 0x70, 0x72, 0x1a, 0xb4, 0xc7,
      0x57, 0x7e, 0x61, 0xc0, 0x48, 0xc5, 0xdd, 0x01, 0xb2, 0x82, 0xcf, 0xc0,
      0xfc, 0x96, 0x3b, 0x92, 0xc7, 0x8e, 0xab, 0xd1, 0x3f, 0xba, 0x64, 0x19,
      0x5d, 0x74, 0xde, 0x48, 0x29, 0xbb},
     {},
     priv_key_3,
     false},

    // Comment: appended bytes to ciphertext
    // tcID: 29
    {SEC_OID_SHA512,
     CKG_MGF1_SHA512,
     29,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x28, 0x00, 0xf4, 0x21, 0xc1, 0xc0, 0x78, 0xb8, 0xbe, 0xe9, 0xc4, 0xa4,
      0xf3, 0x55, 0xe1, 0xea, 0x83, 0x4c, 0x5b, 0xca, 0x44, 0x2e, 0x99, 0x86,
      0x79, 0x2a, 0x50, 0xe6, 0x6e, 0x68, 0xc0, 0xb8, 0x12, 0x2c, 0xb8, 0x1b,
      0xb5, 0x9e, 0x00, 0x70, 0xca, 0x04, 0x4c, 0x1c, 0x5b, 0x19, 0x0f, 0x90,
      0x98, 0xdb, 0xda, 0xa9, 0x77, 0xa4, 0x41, 0xa8, 0xa4, 0xc6, 0x28, 0x97,
      0xed, 0xb9, 0x48, 0x49, 0x35, 0x00, 0x7a, 0xad, 0xb6, 0x73, 0x2c, 0x1b,
      0x2b, 0x21, 0x71, 0xae, 0xa3, 0xab, 0x15, 0x13, 0xf2, 0x25, 0xeb, 0xe7,
      0x83, 0x0f, 0xb8, 0x23, 0xec, 0x3f, 0x54, 0x33, 0xbd, 0x8f, 0x3c, 0x3e,
      0x52, 0x77, 0x5b, 0xb4, 0x5f, 0xa9, 0x1a, 0xa0, 0xad, 0x3b, 0x7c, 0x1b,
      0xc6, 0x47, 0xb7, 0x75, 0xe4, 0xde, 0x8e, 0x1b, 0x22, 0xeb, 0x97, 0x10,
      0x41, 0x26, 0x78, 0x78, 0x42, 0x1c, 0xf4, 0x3a, 0x5e, 0x2a, 0x26, 0x75,
      0xb2, 0xc9, 0x40, 0xda, 0xa5, 0x5f, 0x12, 0xa7, 0xc7, 0x9d, 0x87, 0xd4,
      0x5e, 0x08, 0xc5, 0x59, 0x23, 0x62, 0xf5, 0xe0, 0xd7, 0xea, 0x66, 0x8a,
      0xf9, 0x9e, 0xec, 0xd2, 0xf6, 0x0d, 0x7f, 0xc3, 0x79, 0x1e, 0x4f, 0x53,
      0xae, 0xd7, 0x99, 0x31, 0xbd, 0x0b, 0xa9, 0x0f, 0x70, 0x1d, 0xe8, 0x36,
      0xd8, 0xc8, 0xc9, 0xbe, 0x7f, 0x7f, 0x4a, 0xed, 0xcb, 0xe5, 0xc9, 0x23,
      0x83, 0x93, 0x2f, 0x76, 0x2b, 0xec, 0x65, 0xfa, 0x29, 0x8e, 0xb6, 0x44,
      0x87, 0x7d, 0xe2, 0x6e, 0xec, 0x99, 0x51, 0x46, 0xaf, 0x55, 0x1a, 0xd7,
      0x7e, 0xcf, 0xd0, 0x6a, 0x36, 0x70, 0x72, 0x1a, 0xb4, 0xc7, 0x57, 0x7e,
      0x61, 0xc0, 0x48, 0xc5, 0xdd, 0x01, 0xb2, 0x82, 0xcf, 0xc0, 0xfc, 0x96,
      0x3b, 0x92, 0xc7, 0x8e, 0xab, 0xd1, 0x3f, 0xba, 0x64, 0x19, 0x5d, 0x74,
      0xde, 0x48, 0x29, 0xbb, 0x00, 0x00},
     {},
     priv_key_3,
     false},

    // Comment: truncated ciphertext
    // tcID: 30
    {SEC_OID_SHA512,
     CKG_MGF1_SHA512,
     30,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x00, 0xf4, 0x21, 0xc1, 0xc0, 0x78, 0xb8, 0xbe, 0xe9, 0xc4, 0xa4, 0xf3,
      0x55, 0xe1, 0xea, 0x83, 0x4c, 0x5b, 0xca, 0x44, 0x2e, 0x99, 0x86, 0x79,
      0x2a, 0x50, 0xe6, 0x6e, 0x68, 0xc0, 0xb8, 0x12, 0x2c, 0xb8, 0x1b, 0xb5,
      0x9e, 0x00, 0x70, 0xca, 0x04, 0x4c, 0x1c, 0x5b, 0x19, 0x0f, 0x90, 0x98,
      0xdb, 0xda, 0xa9, 0x77, 0xa4, 0x41, 0xa8, 0xa4, 0xc6, 0x28, 0x97, 0xed,
      0xb9, 0x48, 0x49, 0x35, 0x00, 0x7a, 0xad, 0xb6, 0x73, 0x2c, 0x1b, 0x2b,
      0x21, 0x71, 0xae, 0xa3, 0xab, 0x15, 0x13, 0xf2, 0x25, 0xeb, 0xe7, 0x83,
      0x0f, 0xb8, 0x23, 0xec, 0x3f, 0x54, 0x33, 0xbd, 0x8f, 0x3c, 0x3e, 0x52,
      0x77, 0x5b, 0xb4, 0x5f, 0xa9, 0x1a, 0xa0, 0xad, 0x3b, 0x7c, 0x1b, 0xc6,
      0x47, 0xb7, 0x75, 0xe4, 0xde, 0x8e, 0x1b, 0x22, 0xeb, 0x97, 0x10, 0x41,
      0x26, 0x78, 0x78, 0x42, 0x1c, 0xf4, 0x3a, 0x5e, 0x2a, 0x26, 0x75, 0xb2,
      0xc9, 0x40, 0xda, 0xa5, 0x5f, 0x12, 0xa7, 0xc7, 0x9d, 0x87, 0xd4, 0x5e,
      0x08, 0xc5, 0x59, 0x23, 0x62, 0xf5, 0xe0, 0xd7, 0xea, 0x66, 0x8a, 0xf9,
      0x9e, 0xec, 0xd2, 0xf6, 0x0d, 0x7f, 0xc3, 0x79, 0x1e, 0x4f, 0x53, 0xae,
      0xd7, 0x99, 0x31, 0xbd, 0x0b, 0xa9, 0x0f, 0x70, 0x1d, 0xe8, 0x36, 0xd8,
      0xc8, 0xc9, 0xbe, 0x7f, 0x7f, 0x4a, 0xed, 0xcb, 0xe5, 0xc9, 0x23, 0x83,
      0x93, 0x2f, 0x76, 0x2b, 0xec, 0x65, 0xfa, 0x29, 0x8e, 0xb6, 0x44, 0x87,
      0x7d, 0xe2, 0x6e, 0xec, 0x99, 0x51, 0x46, 0xaf, 0x55, 0x1a, 0xd7, 0x7e,
      0xcf, 0xd0, 0x6a, 0x36, 0x70, 0x72, 0x1a, 0xb4, 0xc7, 0x57, 0x7e, 0x61,
      0xc0, 0x48, 0xc5, 0xdd, 0x01, 0xb2, 0x82, 0xcf, 0xc0, 0xfc, 0x96, 0x3b,
      0x92, 0xc7, 0x8e, 0xab, 0xd1, 0x3f, 0xba, 0x64, 0x19, 0x5d, 0x74, 0xde,
      0x48, 0x29, 0xbb},
     {},
     priv_key_3,
     false},

    // Comment: em has a large hamming weight
    // tcID: 31
    {SEC_OID_SHA512,
     CKG_MGF1_SHA512,
     31,
     {0x6b, 0x2e, 0x7b, 0x31, 0x52, 0xa8, 0xeb, 0x66, 0x38, 0x99, 0xce, 0x78,
      0xd5, 0xc1, 0x96, 0x46, 0x2d, 0x53, 0x99, 0x72, 0x0e, 0x85, 0xcb, 0x69,
      0xfd, 0x27, 0x14, 0xb0, 0x98, 0x42, 0xdb, 0x9d, 0xad, 0x68, 0x3e, 0xcb,
      0x27, 0xf7, 0x79, 0x38, 0x18, 0x2f, 0x14, 0x16, 0x8e, 0x76, 0xab, 0x7d,
      0xc0, 0x39, 0xc2, 0x24, 0xff, 0x26, 0xc4, 0x63, 0x13, 0x44, 0x44, 0x2d,
      0x81, 0xaf, 0xef, 0x7a, 0x77, 0x61, 0x01, 0xaf, 0x2d, 0x19, 0xc4, 0x5b,
      0xc7, 0x60, 0x95, 0x82, 0xee, 0xda, 0xa9, 0xc1, 0xc1, 0xa1, 0xd3, 0x64,
      0x19, 0x41, 0x86, 0xb7, 0x67, 0xe6, 0x32, 0x9f, 0x7c, 0x3d, 0xaf, 0x2c,
      0xa2, 0x63, 0x48, 0xd9, 0xf6, 0xd2, 0xa8, 0x0b, 0x0d, 0x01, 0x84, 0x17,
      0x60, 0x6c, 0xf2, 0x25, 0x6d, 0x28, 0xb7, 0x82, 0xac, 0xe1, 0x7b, 0x84,
      0x63, 0xeb, 0x77, 0x3c, 0xfa, 0xc1},
     {0xbb, 0xd7, 0x9d, 0xc8, 0xea, 0xa9, 0x10, 0x1a, 0xa6, 0x41, 0xce, 0x15,
      0x22, 0x35, 0xba, 0x3d, 0x80, 0x4b, 0x48, 0xec, 0x5e, 0x3d, 0xfe, 0x69,
      0x84, 0x2f, 0x12, 0x5d, 0x81, 0x5d, 0x6a, 0x56, 0xbd, 0xb7, 0x74, 0x85,
      0x7c, 0x0b, 0xc0, 0x96, 0x6a, 0xea, 0xb1, 0xd9, 0xc7, 0x74, 0xe9, 0x21,
      0x85, 0x2f, 0xf2, 0xb8, 0x4d, 0x0a, 0x44, 0x01, 0x63, 0x82, 0xd0, 0xe0,
      0x91, 0xc3, 0x53, 0x4f, 0x0d, 0x38, 0xf4, 0xd5, 0xc0, 0xea, 0x27, 0x74,
      0x4f, 0xe3, 0x20, 0xbb, 0x08, 0x47, 0x52, 0x1a, 0xb5, 0x47, 0x4f, 0x22,
      0xd4, 0x53, 0x85, 0x62, 0x73, 0x09, 0x09, 0xfa, 0x44, 0x96, 0xa0, 0xc2,
      0x62, 0xfd, 0xd9, 0xb6, 0x2b, 0x42, 0x2e, 0xd4, 0xca, 0x9a, 0xa3, 0x0f,
      0x9c, 0xd7, 0xcb, 0xff, 0xe2, 0x2b, 0x37, 0x47, 0xb0, 0xf2, 0xea, 0xfe,
      0x1a, 0xec, 0xbf, 0x0f, 0x75, 0x06, 0x01, 0x6a, 0xfc, 0x9c, 0xb3, 0x41,
      0x47, 0x10, 0xfa, 0x3f, 0x46, 0xdd, 0x77, 0x9b, 0x21, 0x62, 0x25, 0x79,
      0xb7, 0x8a, 0xa7, 0xb5, 0x80, 0xe5, 0x96, 0x0d, 0x6c, 0x21, 0xda, 0x81,
      0xb2, 0x1b, 0x11, 0x2e, 0xe7, 0xe2, 0xd3, 0x3f, 0x3d, 0x67, 0xdc, 0xee,
      0xe1, 0xf0, 0x7c, 0xb3, 0xbc, 0xe8, 0xd7, 0xbc, 0xf8, 0x67, 0x8a, 0x07,
      0xe5, 0x54, 0x98, 0x01, 0x84, 0x70, 0xa7, 0x14, 0xe0, 0x0c, 0xe9, 0xab,
      0x79, 0x6e, 0xbc, 0xd3, 0x35, 0x24, 0x0c, 0x20, 0x2c, 0x82, 0xac, 0x18,
      0xc4, 0xc8, 0xc4, 0x7b, 0x2f, 0xff, 0xba, 0x69, 0x74, 0x32, 0x2e, 0x0e,
      0x55, 0x62, 0x4a, 0x2f, 0x0b, 0x7e, 0x8f, 0x3d, 0xff, 0x1a, 0xb4, 0xe7,
      0x3b, 0xcc, 0x65, 0x15, 0x8f, 0x6e, 0x3d, 0x06, 0xf7, 0xe3, 0x75, 0x35,
      0xb4, 0x13, 0xa7, 0x46, 0x79, 0x79, 0xcb, 0x5a, 0x74, 0x8b, 0x91, 0x31,
      0x3e, 0x3b, 0x7b, 0xf7},
     {0x83, 0xf0, 0xdb, 0x4e, 0x0d, 0xae, 0x69, 0x49, 0x33, 0x73, 0x73, 0xa0,
      0xd7, 0x8c, 0x4b, 0x20, 0xc1, 0x5a, 0x13, 0xcb, 0xd4, 0xe2, 0xad, 0xb8,
      0x85, 0xc3, 0x3e, 0x0e, 0xf4, 0xc9, 0x76, 0x46, 0x67, 0xa8, 0x70, 0x6d,
      0x05, 0x9d, 0x1d, 0x89, 0x15, 0x23, 0xd0, 0x52, 0xe0, 0xed, 0xc1, 0xd8,
      0xb5, 0xc9, 0x59, 0xee, 0xbc, 0x34, 0x0c, 0xe5, 0xd4, 0x15, 0x59, 0xa8,
      0x9a, 0x1a, 0xeb, 0x56, 0x00, 0x00, 0x00, 0x00},
     priv_key_3,
     true}};

#endif  // rsa_oaep_2048_sha512_mgf1sha512_vectors_h__
