# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-3914 (lcms)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63952);
 script_cve_id("CVE-2009-0793", "CVE-2009-0723", "CVE-2009-0733", "CVE-2009-0581");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Fedora Core 9 FEDORA-2009-3914 (lcms)";
 script_name(name);

 desc = "The remote host is missing an update to lcms
announced via advisory FEDORA-2009-3914.

LittleCMS intends to be a small-footprint, speed optimized color management
engine in open source form.

Update Information:

CVE-2009-0793  The patch was given by lcms upstream on the lcms announce
mailing list.

http://sourceforge.net/mailarchive/message.php?msg_name=49EB3510.9060703%40littlecms.com

ChangeLog:

* Wed Apr 22 2009 kwizart < kwizart at gmail.com > - 1.18-2
- Add lcms-CVE-2009-0793.patch from 1.18a

References:

[ 1 ] Bug #492353 - CVE-2009-0793 lcms: Null pointer dereference (DoS) by handling transformations of monochrome profiles
https://bugzilla.redhat.com/show_bug.cgi?id=492353

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update lcms' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-3914

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 9 FEDORA-2009-3914 (lcms)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"lcms", rpm:"lcms~1.18~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lcms-devel", rpm:"lcms-devel~1.18~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lcms-libs", rpm:"lcms-libs~1.18~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-lcms", rpm:"python-lcms~1.18~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lcms-debuginfo", rpm:"lcms-debuginfo~1.18~2.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
