# This script was written by Vlatko Kosturjak <kost@linux.hr>
#
# Distributed under GPL v2+
#
# TODO:
# - report back banners grabbed
# - script_oid
# - sign the script

if(description)
{
 script_id(80002);
 script_version ("$Revision: 8062 $");
 name = "portbunny (NASL wrapper)";
 script_name(name);
 script_tag(name:"risk_factor", value:"None");
 
 desc = "
This plugin runs portbunny scan to find open ports.
Portbunny is (Linux only) kernel module port scanner 
suitable for large internal portscans.
This is experimental plugin, use with care.
See the section 'plugins options' to configure it

";

 script_description(desc);
 
 summary = "Performs portscan";
 script_summary(summary);
 
 script_category(ACT_SCANNER);
 
 script_copyright("This script is Copyright (C) 2008 Vlatko Kosturjak");
 family = "Port scanners";
 script_family(family);

 script_add_preference(name:"Wait longer for triggers to return", type:"checkbox", value: "no");
 script_dependencies("ping_host.nasl");
 if(defined_func("script_mandatory_keys")) 
  script_mandatory_keys("Tools/Present/portbunny");

 exit(0);
}

# script_mandatory_keys compatibility:
include ("toolcheck.inc");
exit_if_not_found (toolname: "portbunny");
# end of script_mandatory_keys compatibility

ip = get_host_ip();
esc_ip = ""; l = strlen(ip);
for (i = 0; i < l; i ++) 
  if (ip[i] == '.')
    esc_ip = strcat(esc_ip, "\.");
  else
    esc_ip = strcat(esc_ip, ip[i]);

 i = 0;
 argv[i++] = "portbunny";
 argv[i++] = "-u";

 p = script_get_preference("Wait longer for triggers to return");
 if ( p) argv[i++] = "-w";

 argv[i++] = ip;
 pr = get_preference("port_range");
 if (! pr) pr = "1-65535"; 
 if (pr == "default" )
 {
	 n = 0;
	 str = "";
	 while ( port = scanner_get_port(n) )
	 {
		 if ( n > 0 ) str += "," + string(port);
		 else str = string(port);
		 n ++;
	 }
	 pr=str;
 }
 argv[i++] = "-p";
 argv[i++] = pr;


 res = pread(cmd: "portbunny", argv: argv, cd: 1, nice: 5);

# debug
#	display("\n====DEBUG===\n");
#	display(res);
#	display("\n====DEBUG===\n");

# IP_ADDRESS:PORT:TYPE:FULL_BANNER
# 127.0.0.1     53      OPEN            domain
# 127.0.0.1     80      OPEN            http

n_ports = 0;

foreach line(split(res))
{
  v = eregmatch(string: line, pattern: '^'+esc_ip+'[ \t]*([0-9]+)[ \t]*([A-Z]+)[ \t]*([A-Za-z0-9]*)');
# debug
#	display (":");
#	if (isnull(v)) display ("null:"+esc_ip);
#	else display (v[1]+":"+v[2]+":"+v[3]);
#	display ("\n");
  if (! isnull(v) && v[2] == "OPEN")
  {
	n_ports++;
	port = v[1];
	proto = "tcp";
   scanner_add_port(proto: proto, port: port);
  }
}

if (n_ports == 0)
{
	security_note(port:0, proto:"tcp",data:"Host does not have any open TCP port");
}

set_kb_item(name: "Host/scanned", value: TRUE);
set_kb_item(name: 'Host/scanners/portbunny', value: TRUE);
if (pr == '1-65535')
  set_kb_item(name: "Host/full_scan", value: TRUE);

scanner_status(current: 65535, total: 65535);

exit (0);
