###############################################################################
# OpenVAS Vulnerability Test
# $Id:secpod_freetype_detect_lin.nasl 1793 2009-04-22 13:00:34Z apr $
#
# FreeType Version Detection (Linux)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900626);
  script_version("Revision: 1.0 ");
  script_tag(name:"risk_factor", value:"None");
  script_name("FreeType Version Detection (Linux)");
  desc = "
  Overview : The script detects the installed version of FreeType and saves
  the result in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set KB for the version of FreeType");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

binFiles = find_file(file_name:"freetype-config",file_path:"/", useregex:TRUE,
                    regexpar:"$", sock:sock);
foreach binName (binFiles)
{
  ftVer = get_bin_version(full_prog_name:chomp(binName), sock:sock,
                  version_argv:"--ftversion",ver_pattern:"[0-9.]+");
  if(ftVer[0] != NULL)
  {
    set_kb_item(name:"FreeType/Linux/Ver", value:ftVer[0]);
    security_note(data:"FreeType version " + ftVer[0] +
             " running at location " + binName + " was detected on the host");
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
