Minutes from 30th OpenVDB TSC meeting, October 24th, 2019, (GMT)

Attendees: *Nick* A., *Dan* B., *Jeff* L., *Ken* M., *Peter* C.

Additional Attendees: Bruce Chernia (Intel), John Mertic (LF)

Agenda:

1) Confirm quorum
2) Secretary
3) EasyCLA
4) Dropping Support ABI 2/3 (PR534)
5) New Methods for Const Copying Grids (OVDB-54/PR535)
6) OpFactory Deconstructor (OVDB-102/PR531)
7) Tree vs Tool Methods (OVDB-121/PR539/PR536)
8) Next Meeting

1) Quorum was confirmed.

2) Secretary was Dan Bailey

3) EasyCLA

EasyCLA has been working for Ken and Nick using ICLA and for Dan using CCLA.
Jeff having issues with CCLA, John to follow up on helping track down the issue
Jeff is facing. Peter signed up to CCLA but hasn't submitted a PR since it was
switched on. Goal is to get this working for all TSC members before requesting
external contributors to use it. Autodesk have used EasyCLA for OpenColorIO, so
be smooth for them.

Confusion over which email is important, the one attached to GitHub account, the
one in the commit or the one in the DCO sign-off. From a legal standpoint, John
confirms that the DCO one most important, but not clear which one EasyCLA is
actually relying on.

No problem merging TSC PRs with failed EasyCLA checks as we have all signed
paper CLA.

4) Dropping Support ABI 2/3 (PR534)

Unanimous consent, Dan to merge.

5) New Methods for Const Copying Grids (OVDB-54/PR535)

Peter and Dan discussing method names on PR, but currently unresolved. Request
for others to contribute.

6) OpFactory Deconstructor (OVDB-102/PR531)

Nick votes that this change should go in, Dan to merge once approved.

7) Counting and Tree vs Tool Methods (OVDB-121/PR539/PR536)

Ken submitted PR536 for a new nodeCount() method implemented on Tree, Dan
submitted draft PR539 for nodeCount() and activeVoxelCount() implemented as
tools. Dan's nodeCount() implementation marginally faster than Ken's due to
threading but also more complicated, activeVoxelCount() significantly faster
than current implementation due to threading. Ken would prefer counting methods
to live on tree as convenient. TreeBase print method also needs counting
functionality so there's a snowball effect.

General question as to which methods should live on tree and which in tools. Dan
proposed line should be between functionality that benefits from threading, ie
navigates more than just one path through the tree. Some cases like merging and
topology methods would clearly benefit in terms of performance if extracted.
Counting functionality is closer to the line.

Ken's priorities are that the methods should be intuitive, performant and not
require exposing private tree data. Potential cost of asking people to change
their code a consideration too.

Dan feels that the breadth-first merge is fairly representative and noted that
it required just one private member access in RootNode. Dan to look into the
details again and to consider how this could be provided in a safe way.

Jeff proposed making TreeBase methods non-virtual and using dispatch. One option
is to introduce TreeBase::apply() to perform dispatch of a compile-time list of
grid types. Peter and Ken against limiting core functionality like counting to
only be available for known grid types. Jeff and Nick suggested mechanism to
register types at compile time. Peter proposed introducing a counting visitor
pattern.

NodeManager leaf node pointer caching was a performance bottleneck in
activeVoxelCount(), Ken highlighted that the NodeManager could be optionally
cached only up to a certain level, Dan to look into this.

Time. No clear direction yet, discussion to continue.

8) Next Meeting

Next planned meeting is:

October 31st 2019. 3pm-4pm EDT (GMT-4). Costumes encouraged.
