/*************************************************
*    The PMW Music Typesetter - 3rd incarnation  *
*************************************************/

/* Copyright (c) Philip Hazel, 2020 */

/* This file contains one function, which sets up the current version string,
the version in binary for comparison, and the copyright string. The version
string includes the date of compilation. It is a fiddly bit of code, but we
want the string in a particular format. */

#include "pmwhdr.h"

#define version    4500      /* In fixed-point format */
#define testing    ""
#define COPYRIGHT  US"Copyright (c) Philip Hazel 2020"

void version_init(void)
{
uschar *p;
uschar today[20];
copyright = COPYRIGHT;
Ustrcpy(today, __DATE__);
if (today[4] == ' ') today[4] = '0';
today[3] = today[6] = '-';
version_fixed  = version;
p = version_string + format_sprintf(version_string, "%f%s%s (Built ", version,
  (version%1000 == 0)? ".00" : (version%100 == 0)? "0" : "", testing);

/* We used to use Ustrncat() to extract and re-arrange the date string, but GCC
now warns when the whole string isn't copied. */

(void)memcpy(p, today+4, 3);
(void)memcpy(p+3, today, 4);
(void)memcpy(p+7, today+7, 4);
(void)memcpy(p+11, ")\0", 2);
}

/* End of version.c */
