# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_discriminator, rest_field
from ._enums import (
    AnalyzeConversationInputKind,
    AnalyzeConversationOperationActionKind,
    AnalyzeConversationOperationResultsKind,
    AnalyzeConversationResultKind,
    ExtraInformationKind,
    InputModality,
    ProjectKind,
    RedactionPolicyKind,
    ResolutionKind,
    TargetProjectKind,
)

if TYPE_CHECKING:
    from .. import models as _models


class ResolutionBase(_Model):
    """The abstract base class for entity resolutions.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AgeResolution, AreaResolution, BooleanResolution, CurrencyResolution, DateTimeResolution,
    InformationResolution, LengthResolution, NumberResolution, NumericRangeResolution,
    OrdinalResolution, SpeedResolution, TemperatureResolution, TemporalSpanResolution,
    VolumeResolution, WeightResolution

    :ivar resolution_kind: The entity resolution object kind. Required. Known values are:
     "BooleanResolution", "DateTimeResolution", "NumberResolution", "OrdinalResolution",
     "SpeedResolution", "WeightResolution", "LengthResolution", "VolumeResolution",
     "AreaResolution", "AgeResolution", "InformationResolution", "TemperatureResolution",
     "CurrencyResolution", "NumericRangeResolution", and "TemporalSpanResolution".
    :vartype resolution_kind: str or ~azure.ai.language.conversations.models.ResolutionKind
    """

    __mapping__: Dict[str, _Model] = {}
    resolution_kind: str = rest_discriminator(
        name="resolutionKind", visibility=["read", "create", "update", "delete", "query"]
    )
    """The entity resolution object kind. Required. Known values are: \"BooleanResolution\",
     \"DateTimeResolution\", \"NumberResolution\", \"OrdinalResolution\", \"SpeedResolution\",
     \"WeightResolution\", \"LengthResolution\", \"VolumeResolution\", \"AreaResolution\",
     \"AgeResolution\", \"InformationResolution\", \"TemperatureResolution\",
     \"CurrencyResolution\", \"NumericRangeResolution\", and \"TemporalSpanResolution\"."""

    @overload
    def __init__(
        self,
        *,
        resolution_kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AgeResolution(ResolutionBase, discriminator="AgeResolution"):
    """Represents the Age entity resolution model.

    :ivar resolution_kind: Represents the Age entity resolution model. Required. Resolution of an
     age entity
    :vartype resolution_kind: str or ~azure.ai.language.conversations.models.AGE_RESOLUTION
    :ivar value: The numeric value that the extracted text denotes. Required.
    :vartype value: float
    :ivar unit: The Age Unit of measurement. Required. Known values are: "Unspecified", "Year",
     "Month", "Week", and "Day".
    :vartype unit: str or ~azure.ai.language.conversations.models.AgeUnit
    """

    resolution_kind: Literal[ResolutionKind.AGE_RESOLUTION] = rest_discriminator(name="resolutionKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Represents the Age entity resolution model. Required. Resolution of an age entity"""
    value: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The numeric value that the extracted text denotes. Required."""
    unit: Union[str, "_models.AgeUnit"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The Age Unit of measurement. Required. Known values are: \"Unspecified\", \"Year\", \"Month\",
     \"Week\", and \"Day\"."""

    @overload
    def __init__(
        self,
        *,
        value: float,
        unit: Union[str, "_models.AgeUnit"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, resolution_kind=ResolutionKind.AGE_RESOLUTION, **kwargs)


class AnalysisConfig(_Model):
    """This is the parameter set of either the Orchestration project itself or one of the target
    services.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ConversationConfig, QuestionAnsweringConfig

    :ivar target_project_kind: The type of a target service. Required. Known values are: "Luis",
     "Conversation", "QuestionAnswering", and "NonLinked".
    :vartype target_project_kind: str or ~azure.ai.language.conversations.models.TargetProjectKind
    :ivar api_version: The API version to use when call a specific target service.
    :vartype api_version: str
    """

    __mapping__: Dict[str, _Model] = {}
    target_project_kind: str = rest_discriminator(
        name="targetProjectKind", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of a target service. Required. Known values are: \"Luis\", \"Conversation\",
     \"QuestionAnswering\", and \"NonLinked\"."""
    api_version: Optional[str] = rest_field(
        name="apiVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The API version to use when call a specific target service."""

    @overload
    def __init__(
        self,
        *,
        target_project_kind: str,
        api_version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AnalyzeConversationActionResult(_Model):
    """The base class of a conversation input task result.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ConversationActionResult, ConversationalAITaskResult

    :ivar kind: The base class of a conversation input task result. Required. Known values are:
     "ConversationResult" and "ConversationalAIResult".
    :vartype kind: str or ~azure.ai.language.conversations.models.AnalyzeConversationResultKind
    """

    __mapping__: Dict[str, _Model] = {}
    kind: str = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])
    """The base class of a conversation input task result. Required. Known values are:
     \"ConversationResult\" and \"ConversationalAIResult\"."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AnalyzeConversationInput(_Model):
    """The base class of a conversation input task.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ConversationLanguageUnderstandingInput, ConversationalAITask

    :ivar kind: The base class of a conversation input task. Required. Known values are:
     "Conversation" and "ConversationalAI".
    :vartype kind: str or ~azure.ai.language.conversations.models.AnalyzeConversationInputKind
    """

    __mapping__: Dict[str, _Model] = {}
    kind: str = rest_discriminator(name="kind", visibility=["read", "create", "query"])
    """The base class of a conversation input task. Required. Known values are: \"Conversation\" and
     \"ConversationalAI\"."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AnalyzeConversationOperationAction(_Model):
    """Base class for a long-running conversation input task.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    PiiOperationAction, SummarizationOperationAction, CustomSummarizationOperationAction

    :ivar name: task name.
    :vartype name: str
    :ivar kind: Enumeration of supported analysis tasks on a collection of conversations. Required.
     Known values are: "ConversationalSummarizationTask", "ConversationalPIITask", and
     "CustomConversationalSummarizationTask".
    :vartype kind: str or
     ~azure.ai.language.conversations.models.AnalyzeConversationOperationActionKind
    """

    __mapping__: Dict[str, _Model] = {}
    name: Optional[str] = rest_field(name="taskName", visibility=["read", "create", "update", "delete", "query"])
    """task name."""
    kind: str = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])
    """Enumeration of supported analysis tasks on a collection of conversations. Required. Known
     values are: \"ConversationalSummarizationTask\", \"ConversationalPIITask\", and
     \"CustomConversationalSummarizationTask\"."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
        name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AnalyzeConversationOperationInput(_Model):
    """It is a wrap up a Question Answering KB response.

    :ivar display_name: Display name for the analysis job.
    :vartype display_name: str
    :ivar conversation_input: Analysis Input. Required.
    :vartype conversation_input:
     ~azure.ai.language.conversations.models._models.MultiLanguageConversationInput
    :ivar actions: Set of tasks to execute on the input conversation. Required.
    :vartype actions:
     list[~azure.ai.language.conversations.models._models.AnalyzeConversationOperationAction]
    :ivar cancel_after: Optional duration in seconds after which the job will be canceled if not
     completed.
    :vartype cancel_after: float
    """

    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display name for the analysis job."""
    conversation_input: "_models._models.MultiLanguageConversationInput" = rest_field(
        name="analysisInput", visibility=["read", "create", "query"]
    )
    """Analysis Input. Required."""
    actions: List["_models._models.AnalyzeConversationOperationAction"] = rest_field(
        name="tasks", visibility=["read", "create", "update", "delete", "query"]
    )
    """Set of tasks to execute on the input conversation. Required."""
    cancel_after: Optional[float] = rest_field(
        name="cancelAfter", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional duration in seconds after which the job will be canceled if not completed."""

    @overload
    def __init__(
        self,
        *,
        conversation_input: "_models._models.MultiLanguageConversationInput",
        actions: List["_models._models.AnalyzeConversationOperationAction"],
        display_name: Optional[str] = None,
        cancel_after: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AnalyzeConversationOperationResult(_Model):
    """Container for results of all tasks in the conversation job.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ConversationPiiOperationResult, SummarizationOperationResult,
    CustomSummarizationOperationResult

    :ivar last_update_date_time: The last updated time in UTC for the task. Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: The status of the task at the mentioned last update time. Required. Known values
     are: "notStarted", "running", "succeeded", "partiallyCompleted", "failed", "cancelled", and
     "cancelling".
    :vartype status: str or ~azure.ai.language.conversations.models.ConversationActionState
    :ivar name: task name.
    :vartype name: str
    :ivar kind: discriminator kind. Required. Known values are:
     "conversationalSummarizationResults", "conversationalPIIResults", and
     "customConversationalSummarizationResults".
    :vartype kind: str or
     ~azure.ai.language.conversations.models.AnalyzeConversationOperationResultsKind
    """

    __mapping__: Dict[str, _Model] = {}
    last_update_date_time: datetime.datetime = rest_field(
        name="lastUpdateDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The last updated time in UTC for the task. Required."""
    status: Union[str, "_models.ConversationActionState"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of the task at the mentioned last update time. Required. Known values are:
     \"notStarted\", \"running\", \"succeeded\", \"partiallyCompleted\", \"failed\", \"cancelled\",
     and \"cancelling\"."""
    name: Optional[str] = rest_field(name="taskName", visibility=["read", "create", "update", "delete", "query"])
    """task name."""
    kind: str = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])
    """discriminator kind. Required. Known values are: \"conversationalSummarizationResults\",
     \"conversationalPIIResults\", and \"customConversationalSummarizationResults\"."""

    @overload
    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.ConversationActionState"],
        kind: str,
        name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AnalyzeConversationOperationState(_Model):
    """Contains the status of the submitted job for analyzing a conversation, along with related
    statistics.

    :ivar display_name: display name.
    :vartype display_name: str
    :ivar created_date_time: Date and time job created. Required.
    :vartype created_date_time: ~datetime.datetime
    :ivar expiration_date_time: Date and time job expires.
    :vartype expiration_date_time: ~datetime.datetime
    :ivar job_id: job ID. Required.
    :vartype job_id: str
    :ivar last_updated_date_time: last updated date and time. Required.
    :vartype last_updated_date_time: ~datetime.datetime
    :ivar status: status. Required. Known values are: "notStarted", "running", "succeeded",
     "partiallyCompleted", "failed", "cancelled", and "cancelling".
    :vartype status: str or ~azure.ai.language.conversations.models.ConversationActionState
    :ivar errors: errors.
    :vartype errors: list[~azure.ai.language.conversations.models.ConversationError]
    :ivar next_link: next link.
    :vartype next_link: str
    :ivar actions: Contains the state for the tasks that are being executed as part of the
     submitted job for analyzing a conversation. Required.
    :vartype actions: ~azure.ai.language.conversations.models.ConversationActions
    :ivar statistics: Contains the statistics for the submitted job.
    :vartype statistics: ~azure.ai.language.conversations.models.ConversationRequestStatistics
    """

    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """display name."""
    created_date_time: datetime.datetime = rest_field(
        name="createdDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Date and time job created. Required."""
    expiration_date_time: Optional[datetime.datetime] = rest_field(
        name="expirationDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Date and time job expires."""
    job_id: str = rest_field(name="jobId", visibility=["read"])
    """job ID. Required."""
    last_updated_date_time: datetime.datetime = rest_field(
        name="lastUpdatedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """last updated date and time. Required."""
    status: Union[str, "_models.ConversationActionState"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """status. Required. Known values are: \"notStarted\", \"running\", \"succeeded\",
     \"partiallyCompleted\", \"failed\", \"cancelled\", and \"cancelling\"."""
    errors: Optional[List["_models.ConversationError"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """errors."""
    next_link: Optional[str] = rest_field(name="nextLink", visibility=["read", "create", "update", "delete", "query"])
    """next link."""
    actions: "_models.ConversationActions" = rest_field(
        name="tasks", visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains the state for the tasks that are being executed as part of the submitted job for
     analyzing a conversation. Required."""
    statistics: Optional["_models.ConversationRequestStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains the statistics for the submitted job."""

    @overload
    def __init__(
        self,
        *,
        created_date_time: datetime.datetime,
        last_updated_date_time: datetime.datetime,
        status: Union[str, "_models.ConversationActionState"],
        actions: "_models.ConversationActions",
        display_name: Optional[str] = None,
        expiration_date_time: Optional[datetime.datetime] = None,
        errors: Optional[List["_models.ConversationError"]] = None,
        next_link: Optional[str] = None,
        statistics: Optional["_models.ConversationRequestStatistics"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AnalyzeConversationResult(_Model):
    """Represents a conversation analysis response.

    :ivar query: The conversation utterance given by the caller. Required.
    :vartype query: str
    :ivar detected_language: The system detected language for the query in BCP 47 language
     representation..
    :vartype detected_language: str
    :ivar prediction: The prediction result of a conversation project. Required.
    :vartype prediction: ~azure.ai.language.conversations.models.PredictionBase
    """

    query: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The conversation utterance given by the caller. Required."""
    detected_language: Optional[str] = rest_field(
        name="detectedLanguage", visibility=["read", "create", "update", "delete", "query"]
    )
    """The system detected language for the query in BCP 47 language representation.."""
    prediction: "_models.PredictionBase" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The prediction result of a conversation project. Required."""

    @overload
    def __init__(
        self,
        *,
        query: str,
        prediction: "_models.PredictionBase",
        detected_language: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AnswerSpan(_Model):
    """Answer span object of QnA.

    :ivar text: Predicted text of answer span.
    :vartype text: str
    :ivar confidence_score: Predicted score of answer span, value ranges from 0 to 1.
    :vartype confidence_score: float
    :ivar offset: The answer span offset from the start of answer.
    :vartype offset: int
    :ivar length: The length of the answer span.
    :vartype length: int
    """

    text: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Predicted text of answer span."""
    confidence_score: Optional[float] = rest_field(
        name="confidenceScore", visibility=["read", "create", "update", "delete", "query"]
    )
    """Predicted score of answer span, value ranges from 0 to 1."""
    offset: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The answer span offset from the start of answer."""
    length: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The length of the answer span."""

    @overload
    def __init__(
        self,
        *,
        text: Optional[str] = None,
        confidence_score: Optional[float] = None,
        offset: Optional[int] = None,
        length: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AnswersResult(_Model):
    """Represents List of Question Answers.

    :ivar answers: Represents Answer Result list.
    :vartype answers: list[~azure.ai.language.conversations.models.KnowledgeBaseAnswer]
    """

    answers: Optional[List["_models.KnowledgeBaseAnswer"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents Answer Result list."""

    @overload
    def __init__(
        self,
        *,
        answers: Optional[List["_models.KnowledgeBaseAnswer"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AreaResolution(ResolutionBase, discriminator="AreaResolution"):
    """Represents the area entity resolution model.

    :ivar resolution_kind: Represents the area entity resolution model. Required. Resolution of an
     area entity
    :vartype resolution_kind: str or ~azure.ai.language.conversations.models.AREA_RESOLUTION
    :ivar value: The numeric value that the extracted text denotes. Required.
    :vartype value: float
    :ivar unit: The area Unit of measurement. Required. Known values are: "Unspecified",
     "SquareKilometer", "SquareHectometer", "SquareDecameter", "SquareDecimeter", "SquareMeter",
     "SquareCentimeter", "SquareMillimeter", "SquareInch", "SquareFoot", "SquareMile", "SquareYard",
     and "Acre".
    :vartype unit: str or ~azure.ai.language.conversations.models.AreaUnit
    """

    resolution_kind: Literal[ResolutionKind.AREA_RESOLUTION] = rest_discriminator(name="resolutionKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Represents the area entity resolution model. Required. Resolution of an area entity"""
    value: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The numeric value that the extracted text denotes. Required."""
    unit: Union[str, "_models.AreaUnit"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The area Unit of measurement. Required. Known values are: \"Unspecified\", \"SquareKilometer\",
     \"SquareHectometer\", \"SquareDecameter\", \"SquareDecimeter\", \"SquareMeter\",
     \"SquareCentimeter\", \"SquareMillimeter\", \"SquareInch\", \"SquareFoot\", \"SquareMile\",
     \"SquareYard\", and \"Acre\"."""

    @overload
    def __init__(
        self,
        *,
        value: float,
        unit: Union[str, "_models.AreaUnit"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, resolution_kind=ResolutionKind.AREA_RESOLUTION, **kwargs)


class AudioTiming(_Model):
    """Audio timing information.

    :ivar offset: Offset from the start of speech audio, in ticks. 1 tick = 100 nanoseconds.
    :vartype offset: int
    :ivar duration: Duration of word articulation, in ticks. 1 tick = 100 nanoseconds.
    :vartype duration: int
    """

    offset: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Offset from the start of speech audio, in ticks. 1 tick = 100 nanoseconds."""
    duration: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Duration of word articulation, in ticks. 1 tick = 100 nanoseconds."""

    @overload
    def __init__(
        self,
        *,
        offset: Optional[int] = None,
        duration: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BaseRedactionPolicy(_Model):
    """The abstract base class for RedactionPolicy.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CharacterMaskPolicyType, EntityMaskTypePolicyType, NoMaskPolicyType

    :ivar policy_kind: The entity RedactionPolicy object kind. Required. Known values are:
     "noMask", "characterMask", and "entityMask".
    :vartype policy_kind: str or ~azure.ai.language.conversations.models.RedactionPolicyKind
    """

    __mapping__: Dict[str, _Model] = {}
    policy_kind: str = rest_discriminator(name="policyKind", visibility=["read", "create", "update", "delete", "query"])
    """The entity RedactionPolicy object kind. Required. Known values are: \"noMask\",
     \"characterMask\", and \"entityMask\"."""

    @overload
    def __init__(
        self,
        *,
        policy_kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BooleanResolution(ResolutionBase, discriminator="BooleanResolution"):
    """A resolution for boolean expressions.

    :ivar resolution_kind: A resolution for boolean expressions. Required. Resolution of a boolean
     entity
    :vartype resolution_kind: str or ~azure.ai.language.conversations.models.BOOLEAN_RESOLUTION
    :ivar value: A resolution for boolean expressions. Required.
    :vartype value: bool
    """

    resolution_kind: Literal[ResolutionKind.BOOLEAN_RESOLUTION] = rest_discriminator(name="resolutionKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A resolution for boolean expressions. Required. Resolution of a boolean entity"""
    value: bool = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A resolution for boolean expressions. Required."""

    @overload
    def __init__(
        self,
        *,
        value: bool,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, resolution_kind=ResolutionKind.BOOLEAN_RESOLUTION, **kwargs)


class CharacterMaskPolicyType(BaseRedactionPolicy, discriminator="characterMask"):
    """Represents the policy of masking with a redaction character.

    :ivar policy_kind: The entity RedactionPolicy object kind. Required. Mask detected entities
     with redaction character
    :vartype policy_kind: str or ~azure.ai.language.conversations.models.CHARACTER_MASK
    :ivar redaction_character: Optional parameter to use a Custom Character to be used for
     redaction in PII responses. Default character will be * as before. We allow specific ascii
     characters for redaction. Known values are: "!", "#", "$", "%", "&", "*", "+", "-", "=", "?",
     "@", "^", "_", and "~".
    :vartype redaction_character: str or ~azure.ai.language.conversations.models.RedactionCharacter
    """

    policy_kind: Literal[RedactionPolicyKind.CHARACTER_MASK] = rest_discriminator(name="policyKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The entity RedactionPolicy object kind. Required. Mask detected entities with redaction
     character"""
    redaction_character: Optional[Union[str, "_models._enums.RedactionCharacter"]] = rest_field(
        name="redactionCharacter", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional parameter to use a Custom Character to be used for redaction in PII responses. Default
     character will be * as before. We allow specific ascii characters for redaction. Known values
     are: \"!\", \"#\", \"$\", \"%\", \"&\", \"*\", \"+\", \"-\", \"=\", \"?\", \"@\", \"^\", \"_\",
     and \"~\"."""

    @overload
    def __init__(
        self,
        *,
        redaction_character: Optional[Union[str, "_models._enums.RedactionCharacter"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, policy_kind=RedactionPolicyKind.CHARACTER_MASK, **kwargs)


class ConversationActionContent(_Model):
    """Input parameters necessary for a Conversation task.

    :ivar project_name: The name of the project to use. Required.
    :vartype project_name: str
    :ivar deployment_name: The name of the deployment to use. Required.
    :vartype deployment_name: str
    :ivar verbose: If true, the service will return more detailed information in the response.
    :vartype verbose: bool
    :ivar is_logging_enabled: If true, the service will keep the query for further review.
    :vartype is_logging_enabled: bool
    :ivar string_index_type: Specifies the method used to interpret string offsets.  Defaults to
     Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
     `https://aka.ms/text-analytics-offsets <https://aka.ms/text-analytics-offsets>`_. Known values
     are: "TextElements_v8", "UnicodeCodePoint", and "Utf16CodeUnit".
    :vartype string_index_type: str or ~azure.ai.language.conversations.models.StringIndexType
    :ivar direct_target: The name of a target project to forward the request to.
    :vartype direct_target: str
    :ivar target_project_parameters: A dictionary representing the parameters for each target
     project.
    :vartype target_project_parameters: dict[str,
     ~azure.ai.language.conversations.models.AnalysisConfig]
    """

    project_name: str = rest_field(name="projectName", visibility=["read", "create", "update", "delete", "query"])
    """The name of the project to use. Required."""
    deployment_name: str = rest_field(name="deploymentName", visibility=["read", "create", "update", "delete", "query"])
    """The name of the deployment to use. Required."""
    verbose: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """If true, the service will return more detailed information in the response."""
    is_logging_enabled: Optional[bool] = rest_field(
        name="isLoggingEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """If true, the service will keep the query for further review."""
    string_index_type: Optional[Union[str, "_models.StringIndexType"]] = rest_field(
        name="stringIndexType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the method used to interpret string offsets.  Defaults to Text Elements (Graphemes)
     according to Unicode v8.0.0. For additional information see
     `https://aka.ms/text-analytics-offsets <https://aka.ms/text-analytics-offsets>`_. Known values
     are: \"TextElements_v8\", \"UnicodeCodePoint\", and \"Utf16CodeUnit\"."""
    direct_target: Optional[str] = rest_field(
        name="directTarget", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of a target project to forward the request to."""
    target_project_parameters: Optional[Dict[str, "_models.AnalysisConfig"]] = rest_field(
        name="targetProjectParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """A dictionary representing the parameters for each target project."""

    @overload
    def __init__(
        self,
        *,
        project_name: str,
        deployment_name: str,
        verbose: Optional[bool] = None,
        is_logging_enabled: Optional[bool] = None,
        string_index_type: Optional[Union[str, "_models.StringIndexType"]] = None,
        direct_target: Optional[str] = None,
        target_project_parameters: Optional[Dict[str, "_models.AnalysisConfig"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConversationActionResult(AnalyzeConversationActionResult, discriminator="ConversationResult"):
    """The results of a Conversation task.

    :ivar kind: The results of a Conversation task. Required. Conversation result task kind
    :vartype kind: str or ~azure.ai.language.conversations.models.CONVERSATION_RESULT
    :ivar result: Represents a conversation analysis response. Required.
    :vartype result: ~azure.ai.language.conversations.models.AnalyzeConversationResult
    """

    kind: Literal[AnalyzeConversationResultKind.CONVERSATION_RESULT] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The results of a Conversation task. Required. Conversation result task kind"""
    result: "_models.AnalyzeConversationResult" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents a conversation analysis response. Required."""

    @overload
    def __init__(
        self,
        *,
        result: "_models.AnalyzeConversationResult",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeConversationResultKind.CONVERSATION_RESULT, **kwargs)


class ConversationActions(_Model):
    """Contains the state for the tasks that are being executed as part of the submitted job for
    analyzing a conversation.

    :ivar completed: Count of tasks that finished successfully. Required.
    :vartype completed: int
    :ivar failed: Count of tasks that failed. Required.
    :vartype failed: int
    :ivar in_progress: Count of tasks that are currently in progress. Required.
    :vartype in_progress: int
    :ivar total: Total count of tasks submitted as part of the job. Required.
    :vartype total: int
    :ivar task_results: List of results from tasks (if available).
    :vartype task_results:
     list[~azure.ai.language.conversations.models.AnalyzeConversationOperationResult]
    """

    completed: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Count of tasks that finished successfully. Required."""
    failed: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Count of tasks that failed. Required."""
    in_progress: int = rest_field(name="inProgress", visibility=["read", "create", "update", "delete", "query"])
    """Count of tasks that are currently in progress. Required."""
    total: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Total count of tasks submitted as part of the job. Required."""
    task_results: Optional[List["_models.AnalyzeConversationOperationResult"]] = rest_field(
        name="items", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of results from tasks (if available)."""

    @overload
    def __init__(
        self,
        *,
        completed: int,
        failed: int,
        in_progress: int,
        total: int,
        task_results: Optional[List["_models.AnalyzeConversationOperationResult"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConversationalAIActionContent(_Model):
    """Input parameters base for a Conversation task.

    :ivar project_name: The name of the project to use. Required.
    :vartype project_name: str
    :ivar deployment_name: The name of the deployment to use. Required.
    :vartype deployment_name: str
    :ivar string_index_type: Specifies the method used to interpret string offsets.  Defaults to
     Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
     `https://aka.ms/text-analytics-offsets <https://aka.ms/text-analytics-offsets>`_. Known values
     are: "TextElements_v8", "UnicodeCodePoint", and "Utf16CodeUnit".
    :vartype string_index_type: str or ~azure.ai.language.conversations.models.StringIndexType
    """

    project_name: str = rest_field(name="projectName", visibility=["read", "create", "update", "delete", "query"])
    """The name of the project to use. Required."""
    deployment_name: str = rest_field(name="deploymentName", visibility=["read", "create", "update", "delete", "query"])
    """The name of the deployment to use. Required."""
    string_index_type: Optional[Union[str, "_models.StringIndexType"]] = rest_field(
        name="stringIndexType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the method used to interpret string offsets.  Defaults to Text Elements (Graphemes)
     according to Unicode v8.0.0. For additional information see
     `https://aka.ms/text-analytics-offsets <https://aka.ms/text-analytics-offsets>`_. Known values
     are: \"TextElements_v8\", \"UnicodeCodePoint\", and \"Utf16CodeUnit\"."""

    @overload
    def __init__(
        self,
        *,
        project_name: str,
        deployment_name: str,
        string_index_type: Optional[Union[str, "_models.StringIndexType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConversationalAIAnalysis(_Model):
    """Multiple multi-turn conversations analyzed.

    :ivar id: The ID of the conversation. Required.
    :vartype id: str
    :ivar intents: The intent classification results for this conversation. Required.
    :vartype intents: list[~azure.ai.language.conversations.models.ConversationalAIIntent]
    :ivar entities: Global entities that are matched but not associated with any specific intent.
    :vartype entities: list[~azure.ai.language.conversations.models.ConversationalAIEntity]
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the conversation. Required."""
    intents: List["_models.ConversationalAIIntent"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The intent classification results for this conversation. Required."""
    entities: Optional[List["_models.ConversationalAIEntity"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Global entities that are matched but not associated with any specific intent."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        intents: List["_models.ConversationalAIIntent"],
        entities: Optional[List["_models.ConversationalAIEntity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConversationalAIAnalysisInput(_Model):
    """The input ConversationItem and its optional parameters.

    :ivar conversations: List of multiple conversations. Required.
    :vartype conversations: list[~azure.ai.language.conversations.models.TextConversation]
    """

    conversations: List["_models.TextConversation"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of multiple conversations. Required."""

    @overload
    def __init__(
        self,
        *,
        conversations: List["_models.TextConversation"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConversationalAIEntity(_Model):
    """The entity associated with this intent.

    :ivar name: The entity name or category. Required.
    :vartype name: str
    :ivar text: The detected text of the entity. Required.
    :vartype text: str
    :ivar confidence_score: The confidence score of the entity detection (0.0 to 1.0). Required.
    :vartype confidence_score: float
    :ivar offset: The starting index of the entity in the query. Required.
    :vartype offset: int
    :ivar length: The length of the detected entity text. Required.
    :vartype length: int
    :ivar conversation_item_id: The ID of the conversation item where the entity appears. Required.
    :vartype conversation_item_id: str
    :ivar conversation_item_index: The index of the conversation item where the entity appears.
    :vartype conversation_item_index: int
    :ivar resolutions: Entity resolution details, if available.
    :vartype resolutions: list[~azure.ai.language.conversations.models.ResolutionBase]
    :ivar extra_information: Additional entity metadata.
    :vartype extra_information:
     list[~azure.ai.language.conversations.models.ConversationEntityExtraInformation]
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The entity name or category. Required."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The detected text of the entity. Required."""
    confidence_score: float = rest_field(
        name="confidenceScore", visibility=["read", "create", "update", "delete", "query"]
    )
    """The confidence score of the entity detection (0.0 to 1.0). Required."""
    offset: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The starting index of the entity in the query. Required."""
    length: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The length of the detected entity text. Required."""
    conversation_item_id: str = rest_field(
        name="conversationItemId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The ID of the conversation item where the entity appears. Required."""
    conversation_item_index: Optional[int] = rest_field(
        name="conversationItemIndex", visibility=["read", "create", "update", "delete", "query"]
    )
    """The index of the conversation item where the entity appears."""
    resolutions: Optional[List["_models.ResolutionBase"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Entity resolution details, if available."""
    extra_information: Optional[List["_models.ConversationEntityExtraInformation"]] = rest_field(
        name="extraInformation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional entity metadata."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        text: str,
        confidence_score: float,
        offset: int,
        length: int,
        conversation_item_id: str,
        conversation_item_index: Optional[int] = None,
        resolutions: Optional[List["_models.ResolutionBase"]] = None,
        extra_information: Optional[List["_models.ConversationEntityExtraInformation"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConversationalAIIntent(_Model):
    """The intent classification result for this conversation.

    :ivar name: The name of the detected intent. Required.
    :vartype name: str
    :ivar type: The type of intent, either "action" or "question". Required.
    :vartype type: str
    :ivar conversation_item_ranges: The ranges of conversation items where this intent was
     identified. Required.
    :vartype conversation_item_ranges:
     list[~azure.ai.language.conversations.models.ConversationItemRange]
    :ivar entities: The entities associated with this intent. Required.
    :vartype entities: list[~azure.ai.language.conversations.models.ConversationalAIEntity]
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the detected intent. Required."""
    type: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The type of intent, either \"action\" or \"question\". Required."""
    conversation_item_ranges: List["_models.ConversationItemRange"] = rest_field(
        name="conversationItemRanges", visibility=["read", "create", "update", "delete", "query"]
    )
    """The ranges of conversation items where this intent was identified. Required."""
    entities: List["_models.ConversationalAIEntity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The entities associated with this intent. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        type: str,
        conversation_item_ranges: List["_models.ConversationItemRange"],
        entities: List["_models.ConversationalAIEntity"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConversationalAIResult(_Model):
    """Represents the conversational analysis response.

    :ivar conversations: Multiple multi-turn conversations analyzed. Required.
    :vartype conversations: list[~azure.ai.language.conversations.models.ConversationalAIAnalysis]
    :ivar warnings: Any warnings encountered during processing.
    :vartype warnings: list[str]
    """

    conversations: List["_models.ConversationalAIAnalysis"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Multiple multi-turn conversations analyzed. Required."""
    warnings: Optional[List[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Any warnings encountered during processing."""

    @overload
    def __init__(
        self,
        *,
        conversations: List["_models.ConversationalAIAnalysis"],
        warnings: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConversationalAITask(AnalyzeConversationInput, discriminator="ConversationalAI"):
    """A conversational AI task.

    :ivar kind: Task kind. Required. Conversation task kind
    :vartype kind: str or ~azure.ai.language.conversations.models.CONVERSATIONAL_AI
    :ivar analysis_input: The input ConversationItem and its optional parameters. Required.
    :vartype analysis_input: ~azure.ai.language.conversations.models.ConversationalAIAnalysisInput
    :ivar parameters: Input parameters necessary for a Conversation language understanding task.
     Required.
    :vartype parameters: ~azure.ai.language.conversations.models.ConversationalAIActionContent
    """

    kind: Literal[AnalyzeConversationInputKind.CONVERSATIONAL_AI] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Task kind. Required. Conversation task kind"""
    analysis_input: "_models.ConversationalAIAnalysisInput" = rest_field(
        name="analysisInput", visibility=["read", "create", "update", "delete", "query"]
    )
    """The input ConversationItem and its optional parameters. Required."""
    parameters: "_models.ConversationalAIActionContent" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Input parameters necessary for a Conversation language understanding task. Required."""

    @overload
    def __init__(
        self,
        *,
        analysis_input: "_models.ConversationalAIAnalysisInput",
        parameters: "_models.ConversationalAIActionContent",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeConversationInputKind.CONVERSATIONAL_AI, **kwargs)


class ConversationalAITaskResult(AnalyzeConversationActionResult, discriminator="ConversationalAIResult"):
    """The results of a ConversationalAI task.

    :ivar kind: The results of a Conversational AI task. Required. Conversation result task kind
    :vartype kind: str or ~azure.ai.language.conversations.models.CONVERSATIONAL_AI_RESULT
    :ivar result: Represents the conversational analysis response. Required.
    :vartype result: ~azure.ai.language.conversations.models.ConversationalAIResult
    """

    kind: Literal[AnalyzeConversationResultKind.CONVERSATIONAL_AI_RESULT] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The results of a Conversational AI task. Required. Conversation result task kind"""
    result: "_models.ConversationalAIResult" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Represents the conversational analysis response. Required."""

    @overload
    def __init__(
        self,
        *,
        result: "_models.ConversationalAIResult",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeConversationResultKind.CONVERSATIONAL_AI_RESULT, **kwargs)


class ConversationalPiiResult(_Model):
    """Conversation PII result item.

    :ivar id: Unique, non-empty conversation identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered in processing the document. Required.
    :vartype warnings: list[~azure.ai.language.conversations.models.InputWarning]
    :ivar statistics: If showStats=true was specified in the request this field will contain
     information about the conversation payload.
    :vartype statistics: ~azure.ai.language.conversations.models.ConversationStatistics
    :ivar conversation_items: List of conversationItems. Required.
    :vartype conversation_items:
     list[~azure.ai.language.conversations.models.ConversationPiiItemResult]
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique, non-empty conversation identifier. Required."""
    warnings: List["_models.InputWarning"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Warnings encountered in processing the document. Required."""
    statistics: Optional["_models.ConversationStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """If showStats=true was specified in the request this field will contain information about the
     conversation payload."""
    conversation_items: List["_models.ConversationPiiItemResult"] = rest_field(
        name="conversationItems", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of conversationItems. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: List["_models.InputWarning"],
        conversation_items: List["_models.ConversationPiiItemResult"],
        statistics: Optional["_models.ConversationStatistics"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConversationAnalysisInput(_Model):
    """The input ConversationItem and its optional parameters.

    :ivar conversation_item: The abstract base for a user input formatted conversation (e.g., Text,
     Transcript). Required.
    :vartype conversation_item: ~azure.ai.language.conversations.models.TextConversationItem
    """

    conversation_item: "_models.TextConversationItem" = rest_field(
        name="conversationItem", visibility=["read", "create", "update", "delete", "query"]
    )
    """The abstract base for a user input formatted conversation (e.g., Text, Transcript). Required."""

    @overload
    def __init__(
        self,
        *,
        conversation_item: "_models.TextConversationItem",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConversationCallingConfig(_Model):
    """The option to set to call a Conversation project.

    :ivar language: The language of the query in BCP 47 language representation.
    :vartype language: str
    :ivar verbose: If true, the service will return more detailed information.
    :vartype verbose: bool
    :ivar is_logging_enabled: If true, the query will be saved for customers to further review in
     authoring, to improve the model quality.
    :vartype is_logging_enabled: bool
    """

    language: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The language of the query in BCP 47 language representation."""
    verbose: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """If true, the service will return more detailed information."""
    is_logging_enabled: Optional[bool] = rest_field(
        name="isLoggingEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """If true, the query will be saved for customers to further review in authoring, to improve the
     model quality."""

    @overload
    def __init__(
        self,
        *,
        language: Optional[str] = None,
        verbose: Optional[bool] = None,
        is_logging_enabled: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConversationConfig(AnalysisConfig, discriminator="Conversation"):
    """This is a set of request parameters for Customized Conversation projects.

    :ivar api_version: The API version to use when call a specific target service.
    :vartype api_version: str
    :ivar target_project_kind: This is a set of request parameters for Customized Conversation
     projects. Required. Conversation target service type
    :vartype target_project_kind: str or ~azure.ai.language.conversations.models.CONVERSATION
    :ivar calling_options: The option to set to call a Conversation project.
    :vartype calling_options: ~azure.ai.language.conversations.models.ConversationCallingConfig
    """

    target_project_kind: Literal[TargetProjectKind.CONVERSATION] = rest_discriminator(name="targetProjectKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """This is a set of request parameters for Customized Conversation projects. Required.
     Conversation target service type"""
    calling_options: Optional["_models.ConversationCallingConfig"] = rest_field(
        name="callingOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """The option to set to call a Conversation project."""

    @overload
    def __init__(
        self,
        *,
        api_version: Optional[str] = None,
        calling_options: Optional["_models.ConversationCallingConfig"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, target_project_kind=TargetProjectKind.CONVERSATION, **kwargs)


class ConversationEntity(_Model):
    """The entity extraction result of a Conversation project.

    :ivar category: The entity category. Required.
    :vartype category: str
    :ivar text: The predicted entity text. Required.
    :vartype text: str
    :ivar offset: The starting index of this entity in the query. Required.
    :vartype offset: int
    :ivar length: The length of the text. Required.
    :vartype length: int
    :ivar confidence: The entity confidence score. Required.
    :vartype confidence: float
    :ivar resolutions: The collection of entity resolution objects.
    :vartype resolutions: list[~azure.ai.language.conversations.models.ResolutionBase]
    :ivar extra_information: The collection of entity extra information objects.
    :vartype extra_information:
     list[~azure.ai.language.conversations.models.ConversationEntityExtraInformation]
    """

    category: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The entity category. Required."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The predicted entity text. Required."""
    offset: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The starting index of this entity in the query. Required."""
    length: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The length of the text. Required."""
    confidence: float = rest_field(name="confidenceScore", visibility=["read", "create", "update", "delete", "query"])
    """The entity confidence score. Required."""
    resolutions: Optional[List["_models.ResolutionBase"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The collection of entity resolution objects."""
    extra_information: Optional[List["_models.ConversationEntityExtraInformation"]] = rest_field(
        name="extraInformation", visibility=["read", "create", "update", "delete", "query"]
    )
    """The collection of entity extra information objects."""

    @overload
    def __init__(
        self,
        *,
        category: str,
        text: str,
        offset: int,
        length: int,
        confidence: float,
        resolutions: Optional[List["_models.ResolutionBase"]] = None,
        extra_information: Optional[List["_models.ConversationEntityExtraInformation"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConversationEntityExtraInformation(_Model):
    """The abstract base object for entity extra information.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    EntitySubtype, ListKey, RegexKey

    :ivar extra_information_kind: The extra information object kind. Required. Known values are:
     "EntitySubtype", "ListKey", and "RegexKey".
    :vartype extra_information_kind: str or
     ~azure.ai.language.conversations.models.ExtraInformationKind
    """

    __mapping__: Dict[str, _Model] = {}
    extra_information_kind: str = rest_discriminator(
        name="extraInformationKind", visibility=["read", "create", "update", "delete", "query"]
    )
    """The extra information object kind. Required. Known values are: \"EntitySubtype\", \"ListKey\",
     and \"RegexKey\"."""

    @overload
    def __init__(
        self,
        *,
        extra_information_kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConversationError(_Model):
    """The error object.

    :ivar code: One of a server-defined set of error codes. Required. Known values are:
     "InvalidRequest", "InvalidArgument", "Unauthorized", "Forbidden", "NotFound",
     "ProjectNotFound", "OperationNotFound", "AzureCognitiveSearchNotFound",
     "AzureCognitiveSearchIndexNotFound", "TooManyRequests", "AzureCognitiveSearchThrottling",
     "AzureCognitiveSearchIndexLimitReached", "InternalServerError", "ServiceUnavailable",
     "Timeout", "QuotaExceeded", "Conflict", and "Warning".
    :vartype code: str or ~azure.ai.language.conversations.models.ConversationErrorCode
    :ivar message: A human-readable representation of the error. Required.
    :vartype message: str
    :ivar target: The target of the error.
    :vartype target: str
    :ivar details: An array of details about specific errors that led to this reported error.
    :vartype details: list[~azure.ai.language.conversations.models.ConversationError]
    :ivar innererror: An object containing more specific information than the current object about
     the error.
    :vartype innererror: ~azure.ai.language.conversations.models.InnerErrorModel
    """

    code: Union[str, "_models.ConversationErrorCode"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """One of a server-defined set of error codes. Required. Known values are: \"InvalidRequest\",
     \"InvalidArgument\", \"Unauthorized\", \"Forbidden\", \"NotFound\", \"ProjectNotFound\",
     \"OperationNotFound\", \"AzureCognitiveSearchNotFound\", \"AzureCognitiveSearchIndexNotFound\",
     \"TooManyRequests\", \"AzureCognitiveSearchThrottling\",
     \"AzureCognitiveSearchIndexLimitReached\", \"InternalServerError\", \"ServiceUnavailable\",
     \"Timeout\", \"QuotaExceeded\", \"Conflict\", and \"Warning\"."""
    message: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A human-readable representation of the error. Required."""
    target: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The target of the error."""
    details: Optional[List["_models.ConversationError"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """An array of details about specific errors that led to this reported error."""
    innererror: Optional["_models.InnerErrorModel"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """An object containing more specific information than the current object about the error."""

    @overload
    def __init__(
        self,
        *,
        code: Union[str, "_models.ConversationErrorCode"],
        message: str,
        target: Optional[str] = None,
        details: Optional[List["_models.ConversationError"]] = None,
        innererror: Optional["_models.InnerErrorModel"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConversationInput(_Model):
    """Complete ordered set of utterances (spoken or written) by one or more speakers to be used for
    analysis.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    TextConversation, TranscriptConversation

    :ivar id: Unique identifier for the conversation. Required.
    :vartype id: str
    :ivar language: Language of the conversation item in BCP-47 format. Required.
    :vartype language: str
    :ivar modality: modality. Required. Known values are: "transcript" and "text".
    :vartype modality: str or ~azure.ai.language.conversations.models.InputModality
    :ivar domain: domain. Known values are: "finance", "healthcare", and "generic".
    :vartype domain: str or ~azure.ai.language.conversations.models.ConversationDomain
    """

    __mapping__: Dict[str, _Model] = {}
    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique identifier for the conversation. Required."""
    language: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Language of the conversation item in BCP-47 format. Required."""
    modality: str = rest_discriminator(name="modality", visibility=["read", "create", "update", "delete", "query"])
    """modality. Required. Known values are: \"transcript\" and \"text\"."""
    domain: Optional[Union[str, "_models.ConversationDomain"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """domain. Known values are: \"finance\", \"healthcare\", and \"generic\"."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        language: str,
        modality: str,
        domain: Optional[Union[str, "_models.ConversationDomain"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConversationIntent(_Model):
    """The intent classification result of a Conversation project.

    :ivar category: A predicted class. Required.
    :vartype category: str
    :ivar confidence: The confidence score of the class from 0.0 to 1.0. Required.
    :vartype confidence: float
    """

    category: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A predicted class. Required."""
    confidence: float = rest_field(name="confidenceScore", visibility=["read", "create", "update", "delete", "query"])
    """The confidence score of the class from 0.0 to 1.0. Required."""

    @overload
    def __init__(
        self,
        *,
        category: str,
        confidence: float,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConversationItemLevelTiming(_Model):
    """Audio timing at the conversation item level.

    :ivar offset: Offset from the start of speech audio, in ticks. 1 tick = 100 nanoseconds.
    :vartype offset: int
    :ivar duration: Duration of word articulation, in ticks. 1 tick = 100 nanoseconds.
    :vartype duration: int
    """

    offset: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Offset from the start of speech audio, in ticks. 1 tick = 100 nanoseconds."""
    duration: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Duration of word articulation, in ticks. 1 tick = 100 nanoseconds."""

    @overload
    def __init__(
        self,
        *,
        offset: Optional[int] = None,
        duration: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConversationItemRange(_Model):
    """The ranges of conversation items where this intent was identified.

    :ivar offset: The starting index of the intent occurrence within the conversation. Required.
    :vartype offset: int
    :ivar count: The number of continuous conversation items for this intent. Required.
    :vartype count: int
    """

    offset: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The starting index of the intent occurrence within the conversation. Required."""
    count: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of continuous conversation items for this intent. Required."""

    @overload
    def __init__(
        self,
        *,
        offset: int,
        count: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConversationLanguageUnderstandingInput(AnalyzeConversationInput, discriminator="Conversation"):
    """The input for a conversation language understanding task.

    :ivar kind: Task kind. Required. Conversation task kind
    :vartype kind: str or ~azure.ai.language.conversations.models.CONVERSATION
    :ivar conversation_input: The input ConversationItem and its optional parameters. Required.
    :vartype conversation_input: ~azure.ai.language.conversations.models.ConversationAnalysisInput
    :ivar action_content: Input parameters necessary for a Conversation language understanding
     task. Required.
    :vartype action_content: ~azure.ai.language.conversations.models.ConversationActionContent
    """

    kind: Literal[AnalyzeConversationInputKind.CONVERSATION] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Task kind. Required. Conversation task kind"""
    conversation_input: "_models.ConversationAnalysisInput" = rest_field(
        name="analysisInput", visibility=["read", "create", "update", "delete", "query"]
    )
    """The input ConversationItem and its optional parameters. Required."""
    action_content: "_models.ConversationActionContent" = rest_field(
        name="parameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Input parameters necessary for a Conversation language understanding task. Required."""

    @overload
    def __init__(
        self,
        *,
        conversation_input: "_models.ConversationAnalysisInput",
        action_content: "_models.ConversationActionContent",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeConversationInputKind.CONVERSATION, **kwargs)


class ConversationPiiActionContent(_Model):
    """Supported parameters for a conversational pii task.

    :ivar logging_opt_out: logging opt out.
    :vartype logging_opt_out: bool
    :ivar model_version: model version.
    :vartype model_version: str
    :ivar pii_categories: Array of ConversationPIICategories.
    :vartype pii_categories: list[str or
     ~azure.ai.language.conversations.models.ConversationPiiCategories]
    :ivar redact_audio_timing: Flag to indicate if response should include audio stream offset and
     duration for any detected entities to be redacted. By default, audio timing of redacted
     entities are not included.
    :vartype redact_audio_timing: bool
    :ivar redaction_source: For transcript conversations, this parameter provides information
     regarding which content type (ITN, Text, Lexical, Masked ITN) should be used for entity
     detection. The details of the entities detected - like the offset, length and the text itself -
     will correspond to the text type selected here. Known values are: "lexical", "itn",
     "maskedItn", and "text".
    :vartype redaction_source: str or ~azure.ai.language.conversations.models.TranscriptContentType
    :ivar redaction_character: Optional parameter to use a Custom Character to be used for
     redaction in PII responses. Default character will be * as before. We allow specific ascii
     characters for redaction. Known values are: "!", "#", "$", "%", "&", "*", "+", "-", "=", "?",
     "@", "^", "_", and "~".
    :vartype redaction_character: str or ~azure.ai.language.conversations.models.RedactionCharacter
    :ivar exclude_pii_categories: List of categories that need to be excluded instead of included.
    :vartype exclude_pii_categories: list[str or
     ~azure.ai.language.conversations.models.ConversationPiiCategoryExclusions]
    :ivar redaction_policy: Optional parameter determine what type of redaction to use.
    :vartype redaction_policy: ~azure.ai.language.conversations.models._models.BaseRedactionPolicy
    """

    logging_opt_out: Optional[bool] = rest_field(
        name="loggingOptOut", visibility=["read", "create", "update", "delete", "query"]
    )
    """logging opt out."""
    model_version: Optional[str] = rest_field(
        name="modelVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """model version."""
    pii_categories: Optional[List[Union[str, "_models._enums.ConversationPiiCategories"]]] = rest_field(
        name="piiCategories", visibility=["read", "create", "update", "delete", "query"]
    )
    """Array of ConversationPIICategories."""
    redact_audio_timing: Optional[bool] = rest_field(
        name="redactAudioTiming", visibility=["read", "create", "update", "delete", "query"]
    )
    """Flag to indicate if response should include audio stream offset and duration for any detected
     entities to be redacted. By default, audio timing of redacted entities are not included."""
    redaction_source: Optional[Union[str, "_models._enums.TranscriptContentType"]] = rest_field(
        name="redactionSource", visibility=["read", "create", "update", "delete", "query"]
    )
    """For transcript conversations, this parameter provides information regarding which content type
     (ITN, Text, Lexical, Masked ITN) should be used for entity detection. The details of the
     entities detected - like the offset, length and the text itself - will correspond to the text
     type selected here. Known values are: \"lexical\", \"itn\", \"maskedItn\", and \"text\"."""
    redaction_character: Optional[Union[str, "_models._enums.RedactionCharacter"]] = rest_field(
        name="redactionCharacter", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional parameter to use a Custom Character to be used for redaction in PII responses. Default
     character will be * as before. We allow specific ascii characters for redaction. Known values
     are: \"!\", \"#\", \"$\", \"%\", \"&\", \"*\", \"+\", \"-\", \"=\", \"?\", \"@\", \"^\", \"_\",
     and \"~\"."""
    exclude_pii_categories: Optional[List[Union[str, "_models._enums.ConversationPiiCategoryExclusions"]]] = rest_field(
        name="excludePiiCategories", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of categories that need to be excluded instead of included."""
    redaction_policy: Optional["_models._models.BaseRedactionPolicy"] = rest_field(
        name="redactionPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional parameter determine what type of redaction to use."""

    @overload
    def __init__(
        self,
        *,
        logging_opt_out: Optional[bool] = None,
        model_version: Optional[str] = None,
        pii_categories: Optional[List[Union[str, "_models._enums.ConversationPiiCategories"]]] = None,
        redact_audio_timing: Optional[bool] = None,
        redaction_source: Optional[Union[str, "_models._enums.TranscriptContentType"]] = None,
        redaction_character: Optional[Union[str, "_models._enums.RedactionCharacter"]] = None,
        exclude_pii_categories: Optional[List[Union[str, "_models._enums.ConversationPiiCategoryExclusions"]]] = None,
        redaction_policy: Optional["_models._models.BaseRedactionPolicy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConversationPiiItemResult(_Model):
    """The result from PII detection and redaction operation for each conversation.

    :ivar id: Id of the result. Required.
    :vartype id: str
    :ivar redacted_content: Transcript content response that the service generates, with all
     necessary personally identifiable information redacted. Required.
    :vartype redacted_content: ~azure.ai.language.conversations.models.RedactedTranscriptContent
    :ivar entities: Array of Entities. Required.
    :vartype entities: list[~azure.ai.language.conversations.models.NamedEntity]
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Id of the result. Required."""
    redacted_content: "_models.RedactedTranscriptContent" = rest_field(
        name="redactedContent", visibility=["read", "create", "update", "delete", "query"]
    )
    """Transcript content response that the service generates, with all necessary personally
     identifiable information redacted. Required."""
    entities: List["_models.NamedEntity"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Array of Entities. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        redacted_content: "_models.RedactedTranscriptContent",
        entities: List["_models.NamedEntity"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConversationPiiOperationResult(AnalyzeConversationOperationResult, discriminator="conversationalPIIResults"):
    """Result from the personally identifiable information detection and redaction operation performed
    on a list of conversations.

    :ivar last_update_date_time: The last updated time in UTC for the task. Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: The status of the task at the mentioned last update time. Required. Known values
     are: "notStarted", "running", "succeeded", "partiallyCompleted", "failed", "cancelled", and
     "cancelling".
    :vartype status: str or ~azure.ai.language.conversations.models.ConversationActionState
    :ivar name: task name.
    :vartype name: str
    :ivar kind: discriminator kind. Required. Conversational PII Results
    :vartype kind: str or ~azure.ai.language.conversations.models.PII_OPERATION_RESULTS
    :ivar results: results. Required.
    :vartype results: ~azure.ai.language.conversations.models.ConversationPiiResults
    """

    kind: Literal[AnalyzeConversationOperationResultsKind.PII_OPERATION_RESULTS] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """discriminator kind. Required. Conversational PII Results"""
    results: "_models.ConversationPiiResults" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """results. Required."""

    @overload
    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.ConversationActionState"],
        results: "_models.ConversationPiiResults",
        name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeConversationOperationResultsKind.PII_OPERATION_RESULTS, **kwargs)


class ConversationPiiResults(_Model):
    """The result from PII detection and redaction operation for each conversation.

    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.language.conversations.models.DocumentError]
    :ivar statistics: statistics.
    :vartype statistics: ~azure.ai.language.conversations.models.RequestStatistics
    :ivar model_version: This field indicates which model is used for scoring. Required.
    :vartype model_version: str
    :ivar conversations: array of conversations. Required.
    :vartype conversations: list[~azure.ai.language.conversations.models.ConversationalPiiResult]
    """

    errors: List["_models.DocumentError"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Errors by document id. Required."""
    statistics: Optional["_models.RequestStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """statistics."""
    model_version: str = rest_field(name="modelVersion", visibility=["read", "create", "update", "delete", "query"])
    """This field indicates which model is used for scoring. Required."""
    conversations: List["_models.ConversationalPiiResult"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """array of conversations. Required."""

    @overload
    def __init__(
        self,
        *,
        errors: List["_models.DocumentError"],
        model_version: str,
        conversations: List["_models.ConversationalPiiResult"],
        statistics: Optional["_models.RequestStatistics"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PredictionBase(_Model):
    """This is the base class of prediction.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ConversationPrediction, OrchestrationPrediction

    :ivar project_kind: The type of the project. Required. Known values are: "Conversation",
     "Orchestration", and "ConversationalAI".
    :vartype project_kind: str or ~azure.ai.language.conversations.models.ProjectKind
    :ivar top_intent: The intent with the highest score.
    :vartype top_intent: str
    """

    __mapping__: Dict[str, _Model] = {}
    project_kind: str = rest_discriminator(
        name="projectKind", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of the project. Required. Known values are: \"Conversation\", \"Orchestration\", and
     \"ConversationalAI\"."""
    top_intent: Optional[str] = rest_field(name="topIntent", visibility=["read", "create", "update", "delete", "query"])
    """The intent with the highest score."""

    @overload
    def __init__(
        self,
        *,
        project_kind: str,
        top_intent: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConversationPrediction(PredictionBase, discriminator="Conversation"):
    """Represents the prediction section of a Conversation project.

    :ivar top_intent: The intent with the highest score.
    :vartype top_intent: str
    :ivar project_kind: Represents the prediction section of a Conversation project. Required.
     Conversation type
    :vartype project_kind: str or ~azure.ai.language.conversations.models.CONVERSATION
    :ivar intents: The intent classification results. Required.
    :vartype intents: list[~azure.ai.language.conversations.models.ConversationIntent]
    :ivar entities: The entity extraction results. Required.
    :vartype entities: list[~azure.ai.language.conversations.models.ConversationEntity]
    """

    project_kind: Literal[ProjectKind.CONVERSATION] = rest_discriminator(name="projectKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Represents the prediction section of a Conversation project. Required. Conversation type"""
    intents: List["_models.ConversationIntent"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The intent classification results. Required."""
    entities: List["_models.ConversationEntity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The entity extraction results. Required."""

    @overload
    def __init__(
        self,
        *,
        intents: List["_models.ConversationIntent"],
        entities: List["_models.ConversationEntity"],
        top_intent: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, project_kind=ProjectKind.CONVERSATION, **kwargs)


class ConversationRequestStatistics(_Model):
    """if showStats=true was specified in the request, this field contains information about the
    request payload.

    :ivar documents_count: Number of documents submitted in the request. Required.
    :vartype documents_count: int
    :ivar valid_documents_count: Number of valid documents. This excludes empty, over-size limit or
     non-supported languages documents. Required.
    :vartype valid_documents_count: int
    :ivar erroneous_documents_count: Number of invalid documents. This includes empty, over-size
     limit or non-supported languages documents. Required.
    :vartype erroneous_documents_count: int
    :ivar transactions_count: Number of transactions for the request. Required.
    :vartype transactions_count: int
    :ivar conversations_count: Number of conversations submitted in the request. Required.
    :vartype conversations_count: int
    :ivar valid_conversations_count: Number of conversation documents. This excludes documents that
     are empty, over the size limit, or in unsupported languages. Required.
    :vartype valid_conversations_count: int
    :ivar erroneous_conversations_count: Number of invalid documents. This includes documents that
     are empty, over the size limit, or in unsupported languages. Required.
    :vartype erroneous_conversations_count: int
    """

    documents_count: int = rest_field(name="documentsCount", visibility=["read", "create", "update", "delete", "query"])
    """Number of documents submitted in the request. Required."""
    valid_documents_count: int = rest_field(
        name="validDocumentsCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of valid documents. This excludes empty, over-size limit or non-supported languages
     documents. Required."""
    erroneous_documents_count: int = rest_field(
        name="erroneousDocumentsCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of invalid documents. This includes empty, over-size limit or non-supported languages
     documents. Required."""
    transactions_count: int = rest_field(
        name="transactionsCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of transactions for the request. Required."""
    conversations_count: int = rest_field(
        name="conversationsCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of conversations submitted in the request. Required."""
    valid_conversations_count: int = rest_field(
        name="validConversationsCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of conversation documents. This excludes documents that are empty, over the size limit,
     or in unsupported languages. Required."""
    erroneous_conversations_count: int = rest_field(
        name="erroneousConversationsCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of invalid documents. This includes documents that are empty, over the size limit, or in
     unsupported languages. Required."""

    @overload
    def __init__(
        self,
        *,
        documents_count: int,
        valid_documents_count: int,
        erroneous_documents_count: int,
        transactions_count: int,
        conversations_count: int,
        valid_conversations_count: int,
        erroneous_conversations_count: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConversationResult(_Model):
    """The response returned by a Conversation project.

    :ivar query: The same query given in request. Required.
    :vartype query: str
    :ivar detected_language: The detected language from the query in BCP 47 language
     representation.
    :vartype detected_language: str
    :ivar prediction: The predicted result for the query.
    :vartype prediction: ~azure.ai.language.conversations.models.ConversationPrediction
    """

    query: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The same query given in request. Required."""
    detected_language: Optional[str] = rest_field(
        name="detectedLanguage", visibility=["read", "create", "update", "delete", "query"]
    )
    """The detected language from the query in BCP 47 language representation."""
    prediction: Optional["_models.ConversationPrediction"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The predicted result for the query."""

    @overload
    def __init__(
        self,
        *,
        query: str,
        detected_language: Optional[str] = None,
        prediction: Optional["_models.ConversationPrediction"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConversationsSummaryResult(_Model):
    """Conversations Summary Result.

    :ivar id: Unique, non-empty conversation identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered in processing the document. Required.
    :vartype warnings: list[~azure.ai.language.conversations.models.InputWarning]
    :ivar statistics: If showStats=true was specified in the request this field will contain
     information about the conversation payload.
    :vartype statistics: ~azure.ai.language.conversations.models.ConversationStatistics
    :ivar summaries: array of summaries. Required.
    :vartype summaries: list[~azure.ai.language.conversations.models.SummaryResultItem]
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique, non-empty conversation identifier. Required."""
    warnings: List["_models.InputWarning"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Warnings encountered in processing the document. Required."""
    statistics: Optional["_models.ConversationStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """If showStats=true was specified in the request this field will contain information about the
     conversation payload."""
    summaries: List["_models.SummaryResultItem"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """array of summaries. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: List["_models.InputWarning"],
        summaries: List["_models.SummaryResultItem"],
        statistics: Optional["_models.ConversationStatistics"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConversationStatistics(_Model):
    """If showStats=true was specified in the request, this field contains information about the
    conversation payload.

    :ivar transactions_count: Number of text units for the request. Required.
    :vartype transactions_count: int
    """

    transactions_count: int = rest_field(
        name="transactionsCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of text units for the request. Required."""

    @overload
    def __init__(
        self,
        *,
        transactions_count: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConversationSummarizationActionContent(_Model):
    """Supported parameters for pre-build conversational summarization task.

    :ivar logging_opt_out: logging opt out.
    :vartype logging_opt_out: bool
    :ivar model_version: model version.
    :vartype model_version: str
    :ivar sentence_count: It controls the approximate number of sentences in the output summaries.
    :vartype sentence_count: int
    :ivar string_index_type: String index type. Known values are: "TextElements_v8",
     "UnicodeCodePoint", and "Utf16CodeUnit".
    :vartype string_index_type: str or ~azure.ai.language.conversations.models.StringIndexType
    :ivar summary_length: (NOTE: Recommended to use summaryLength over sentenceCount) Controls the
     approximate length of the output summaries. Known values are: "short", "medium", and "long".
    :vartype summary_length: str or ~azure.ai.language.conversations.models.SummaryLengthBucket
    :ivar summary_aspects: Array of Summary Aspects. Required.
    :vartype summary_aspects: list[str or ~azure.ai.language.conversations.models.SummaryAspect]
    :ivar instruction: a text field to allow customers to use natural language to describe their
     needs for summarization.
    :vartype instruction: str
    """

    logging_opt_out: Optional[bool] = rest_field(
        name="loggingOptOut", visibility=["read", "create", "update", "delete", "query"]
    )
    """logging opt out."""
    model_version: Optional[str] = rest_field(
        name="modelVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """model version."""
    sentence_count: Optional[int] = rest_field(
        name="sentenceCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """It controls the approximate number of sentences in the output summaries."""
    string_index_type: Optional[Union[str, "_models.StringIndexType"]] = rest_field(
        name="stringIndexType", visibility=["read", "create", "update", "delete", "query"]
    )
    """String index type. Known values are: \"TextElements_v8\", \"UnicodeCodePoint\", and
     \"Utf16CodeUnit\"."""
    summary_length: Optional[Union[str, "_models.SummaryLengthBucket"]] = rest_field(
        name="summaryLength", visibility=["read", "create", "update", "delete", "query"]
    )
    """(NOTE: Recommended to use summaryLength over sentenceCount) Controls the approximate length of
     the output summaries. Known values are: \"short\", \"medium\", and \"long\"."""
    summary_aspects: List[Union[str, "_models.SummaryAspect"]] = rest_field(
        name="summaryAspects", visibility=["read", "create", "update", "delete", "query"]
    )
    """Array of Summary Aspects. Required."""
    instruction: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """a text field to allow customers to use natural language to describe their needs for
     summarization."""

    @overload
    def __init__(
        self,
        *,
        summary_aspects: List[Union[str, "_models.SummaryAspect"]],
        logging_opt_out: Optional[bool] = None,
        model_version: Optional[str] = None,
        sentence_count: Optional[int] = None,
        string_index_type: Optional[Union[str, "_models.StringIndexType"]] = None,
        summary_length: Optional[Union[str, "_models.SummaryLengthBucket"]] = None,
        instruction: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TargetIntentResult(_Model):
    """This is the base class of an intent prediction.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ConversationTargetIntentResult, NonLinkedTargetIntentResult,
    QuestionAnsweringTargetIntentResult

    :ivar target_project_kind: This is the base class of an intent prediction. Required. Known
     values are: "Luis", "Conversation", "QuestionAnswering", and "NonLinked".
    :vartype target_project_kind: str or ~azure.ai.language.conversations.models.TargetProjectKind
    :ivar api_version: The API version used to call a target service.
    :vartype api_version: str
    :ivar confidence: The prediction score and it ranges from 0.0 to 1.0. Required.
    :vartype confidence: float
    """

    __mapping__: Dict[str, _Model] = {}
    target_project_kind: str = rest_discriminator(
        name="targetProjectKind", visibility=["read", "create", "update", "delete", "query"]
    )
    """This is the base class of an intent prediction. Required. Known values are: \"Luis\",
     \"Conversation\", \"QuestionAnswering\", and \"NonLinked\"."""
    api_version: Optional[str] = rest_field(
        name="apiVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The API version used to call a target service."""
    confidence: float = rest_field(name="confidenceScore", visibility=["read", "create", "update", "delete", "query"])
    """The prediction score and it ranges from 0.0 to 1.0. Required."""

    @overload
    def __init__(
        self,
        *,
        target_project_kind: str,
        confidence: float,
        api_version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConversationTargetIntentResult(TargetIntentResult, discriminator="Conversation"):
    """A wrap up of Conversation project response.

    :ivar api_version: The API version used to call a target service.
    :vartype api_version: str
    :ivar confidence: The prediction score and it ranges from 0.0 to 1.0. Required.
    :vartype confidence: float
    :ivar target_project_kind: A wrap up of Conversation project response. Required. Conversation
     target service type
    :vartype target_project_kind: str or ~azure.ai.language.conversations.models.CONVERSATION
    :ivar result: The actual response from a Conversation project.
    :vartype result: ~azure.ai.language.conversations.models.ConversationResult
    """

    target_project_kind: Literal[TargetProjectKind.CONVERSATION] = rest_discriminator(name="targetProjectKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A wrap up of Conversation project response. Required. Conversation target service type"""
    result: Optional["_models.ConversationResult"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The actual response from a Conversation project."""

    @overload
    def __init__(
        self,
        *,
        confidence: float,
        api_version: Optional[str] = None,
        result: Optional["_models.ConversationResult"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, target_project_kind=TargetProjectKind.CONVERSATION, **kwargs)


class CurrencyResolution(ResolutionBase, discriminator="CurrencyResolution"):
    """Represents the currency entity resolution model.

    :ivar resolution_kind: Represents the currency entity resolution model. Required. Resolution of
     a currency entity
    :vartype resolution_kind: str or ~azure.ai.language.conversations.models.CURRENCY_RESOLUTION
    :ivar iso4217: The alphabetic code based on another ISO standard, ISO 3166, which lists the
     codes for country names. The first two letters of the ISO 4217 three-letter code are the same
     as the code for the country name, and, where possible, the third letter corresponds to the
     first letter of the currency name.
    :vartype iso4217: str
    :ivar value: The money amount captured in the extracted entity. Required.
    :vartype value: float
    :ivar unit: The unit of the amount captured in the extracted entity. Required.
    :vartype unit: str
    """

    resolution_kind: Literal[ResolutionKind.CURRENCY_RESOLUTION] = rest_discriminator(name="resolutionKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Represents the currency entity resolution model. Required. Resolution of a currency entity"""
    iso4217: Optional[str] = rest_field(name="ISO4217", visibility=["read", "create", "update", "delete", "query"])
    """The alphabetic code based on another ISO standard, ISO 3166, which lists the codes for country
     names. The first two letters of the ISO 4217 three-letter code are the same as the code for the
     country name, and, where possible, the third letter corresponds to the first letter of the
     currency name."""
    value: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The money amount captured in the extracted entity. Required."""
    unit: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unit of the amount captured in the extracted entity. Required."""

    @overload
    def __init__(
        self,
        *,
        value: float,
        unit: str,
        iso4217: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, resolution_kind=ResolutionKind.CURRENCY_RESOLUTION, **kwargs)


class CustomConversationSummarizationActionContent(_Model):  # pylint: disable=name-too-long
    """Supported parameters for a custom conversation summarization task.

    :ivar logging_opt_out: logging opt out.
    :vartype logging_opt_out: bool
    :ivar project_name: This field indicates the project name for the model. Required.
    :vartype project_name: str
    :ivar deployment_name: This field indicates the deployment name for the model. Required.
    :vartype deployment_name: str
    :ivar sentence_count: It controls the approximate number of sentences in the output summaries.
    :vartype sentence_count: int
    :ivar string_index_type: String index type. Known values are: "TextElements_v8",
     "UnicodeCodePoint", and "Utf16CodeUnit".
    :vartype string_index_type: str or ~azure.ai.language.conversations.models.StringIndexType
    :ivar summary_length: Controls the approximate length of the output summaries. Recommended to
     use summaryLength over sentenceCount. Known values are: "short", "medium", and "long".
    :vartype summary_length: str or ~azure.ai.language.conversations.models.SummaryLengthBucket
    :ivar summary_aspects: Array of Summary Aspects. Required.
    :vartype summary_aspects: list[str or ~azure.ai.language.conversations.models.SummaryAspect]
    """

    logging_opt_out: Optional[bool] = rest_field(
        name="loggingOptOut", visibility=["read", "create", "update", "delete", "query"]
    )
    """logging opt out."""
    project_name: str = rest_field(name="projectName", visibility=["read", "create", "update", "delete", "query"])
    """This field indicates the project name for the model. Required."""
    deployment_name: str = rest_field(name="deploymentName", visibility=["read", "create", "update", "delete", "query"])
    """This field indicates the deployment name for the model. Required."""
    sentence_count: Optional[int] = rest_field(
        name="sentenceCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """It controls the approximate number of sentences in the output summaries."""
    string_index_type: Optional[Union[str, "_models.StringIndexType"]] = rest_field(
        name="stringIndexType", visibility=["read", "create", "update", "delete", "query"]
    )
    """String index type. Known values are: \"TextElements_v8\", \"UnicodeCodePoint\", and
     \"Utf16CodeUnit\"."""
    summary_length: Optional[Union[str, "_models.SummaryLengthBucket"]] = rest_field(
        name="summaryLength", visibility=["read", "create", "update", "delete", "query"]
    )
    """Controls the approximate length of the output summaries. Recommended to use summaryLength over
     sentenceCount. Known values are: \"short\", \"medium\", and \"long\"."""
    summary_aspects: List[Union[str, "_models.SummaryAspect"]] = rest_field(
        name="summaryAspects", visibility=["read", "create", "update", "delete", "query"]
    )
    """Array of Summary Aspects. Required."""

    @overload
    def __init__(
        self,
        *,
        project_name: str,
        deployment_name: str,
        summary_aspects: List[Union[str, "_models.SummaryAspect"]],
        logging_opt_out: Optional[bool] = None,
        sentence_count: Optional[int] = None,
        string_index_type: Optional[Union[str, "_models.StringIndexType"]] = None,
        summary_length: Optional[Union[str, "_models.SummaryLengthBucket"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CustomSummarizationOperationAction(
    AnalyzeConversationOperationAction, discriminator="CustomConversationalSummarizationTask"
):
    """Task definition for custom conversational summarization.

    :ivar name: task name.
    :vartype name: str
    :ivar kind: discriminator kind. Required. Custom Conversational Summarization Task
    :vartype kind: str or
     ~azure.ai.language.conversations.models.CUSTOM_CONVERSATIONAL_SUMMARIZATION_TASK
    :ivar action_content: parameters.
    :vartype action_content:
     ~azure.ai.language.conversations.models._models.CustomConversationSummarizationActionContent
    """

    kind: Literal[AnalyzeConversationOperationActionKind.CUSTOM_CONVERSATIONAL_SUMMARIZATION_TASK] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """discriminator kind. Required. Custom Conversational Summarization Task"""
    action_content: Optional["_models._models.CustomConversationSummarizationActionContent"] = rest_field(
        name="parameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """parameters."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        action_content: Optional["_models._models.CustomConversationSummarizationActionContent"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(
            *args, kind=AnalyzeConversationOperationActionKind.CUSTOM_CONVERSATIONAL_SUMMARIZATION_TASK, **kwargs
        )


class CustomSummarizationOperationResult(
    AnalyzeConversationOperationResult, discriminator="customConversationalSummarizationResults"
):
    """Result for the custom summarization task on the conversation.

    :ivar last_update_date_time: The last updated time in UTC for the task. Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: The status of the task at the mentioned last update time. Required. Known values
     are: "notStarted", "running", "succeeded", "partiallyCompleted", "failed", "cancelled", and
     "cancelling".
    :vartype status: str or ~azure.ai.language.conversations.models.ConversationActionState
    :ivar name: task name.
    :vartype name: str
    :ivar kind: discriminator kind. Required. Custom Conversational Summarization Results
    :vartype kind: str or
     ~azure.ai.language.conversations.models.CUSTOM_SUMMARIZATION_OPERATION_RESULTS
    :ivar results: Custom Summary Result. Required.
    :vartype results: ~azure.ai.language.conversations.models.CustomSummaryResult
    """

    kind: Literal[AnalyzeConversationOperationResultsKind.CUSTOM_SUMMARIZATION_OPERATION_RESULTS] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """discriminator kind. Required. Custom Conversational Summarization Results"""
    results: "_models.CustomSummaryResult" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Custom Summary Result. Required."""

    @overload
    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.ConversationActionState"],
        results: "_models.CustomSummaryResult",
        name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(
            *args, kind=AnalyzeConversationOperationResultsKind.CUSTOM_SUMMARIZATION_OPERATION_RESULTS, **kwargs
        )


class CustomSummaryResult(_Model):
    """Custom Summary Results.

    :ivar conversations: array of conversations. Required.
    :vartype conversations:
     list[~azure.ai.language.conversations.models.ConversationsSummaryResult]
    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.language.conversations.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.language.conversations.models.RequestStatistics
    :ivar project_name: This field indicates the project name for the model. Required.
    :vartype project_name: str
    :ivar deployment_name: This field indicates the deployment name for the model. Required.
    :vartype deployment_name: str
    """

    conversations: List["_models.ConversationsSummaryResult"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """array of conversations. Required."""
    errors: List["_models.DocumentError"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Errors by document id. Required."""
    statistics: Optional["_models.RequestStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """if showStats=true was specified in the request this field will contain information about the
     request payload."""
    project_name: str = rest_field(name="projectName", visibility=["read", "create", "update", "delete", "query"])
    """This field indicates the project name for the model. Required."""
    deployment_name: str = rest_field(name="deploymentName", visibility=["read", "create", "update", "delete", "query"])
    """This field indicates the deployment name for the model. Required."""

    @overload
    def __init__(
        self,
        *,
        conversations: List["_models.ConversationsSummaryResult"],
        errors: List["_models.DocumentError"],
        project_name: str,
        deployment_name: str,
        statistics: Optional["_models.RequestStatistics"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DateTimeResolution(ResolutionBase, discriminator="DateTimeResolution"):
    """A resolution for datetime entity instances.

    :ivar resolution_kind: A resolution for datetime entity instances. Required. Resolution of a
     date/time entity
    :vartype resolution_kind: str or ~azure.ai.language.conversations.models.DATE_TIME_RESOLUTION
    :ivar timex: An extended ISO 8601 date/time representation as described in
     (`https://github.com/Microsoft/Recognizers-Text/blob/master/Patterns/English/English-DateTime.yaml
     <https://github.com/Microsoft/Recognizers-Text/blob/master/Patterns/English/English-DateTime.yaml>`_).
     Required.
    :vartype timex: str
    :ivar date_time_sub_kind: The DateTime SubKind. Required. Known values are: "Time", "Date",
     "DateTime", "Duration", and "Set".
    :vartype date_time_sub_kind: str or ~azure.ai.language.conversations.models.DateTimeSubKind
    :ivar value: The actual time that the extracted text denote. Required.
    :vartype value: str
    :ivar modifier: An optional modifier of a date/time instance. Known values are: "AfterApprox",
     "Before", "BeforeStart", "Approx", "ReferenceUndefined", "SinceEnd", "AfterMid", "Start",
     "After", "BeforeEnd", "Until", "End", "Less", "Since", "AfterStart", "BeforeApprox", "Mid", and
     "More".
    :vartype modifier: str or ~azure.ai.language.conversations.models.TemporalModifier
    """

    resolution_kind: Literal[ResolutionKind.DATE_TIME_RESOLUTION] = rest_discriminator(name="resolutionKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A resolution for datetime entity instances. Required. Resolution of a date/time entity"""
    timex: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An extended ISO 8601 date/time representation as described in
     (`https://github.com/Microsoft/Recognizers-Text/blob/master/Patterns/English/English-DateTime.yaml
     <https://github.com/Microsoft/Recognizers-Text/blob/master/Patterns/English/English-DateTime.yaml>`_).
     Required."""
    date_time_sub_kind: Union[str, "_models.DateTimeSubKind"] = rest_field(
        name="dateTimeSubKind", visibility=["read", "create", "update", "delete", "query"]
    )
    """The DateTime SubKind. Required. Known values are: \"Time\", \"Date\", \"DateTime\",
     \"Duration\", and \"Set\"."""
    value: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The actual time that the extracted text denote. Required."""
    modifier: Optional[Union[str, "_models.TemporalModifier"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """An optional modifier of a date/time instance. Known values are: \"AfterApprox\", \"Before\",
     \"BeforeStart\", \"Approx\", \"ReferenceUndefined\", \"SinceEnd\", \"AfterMid\", \"Start\",
     \"After\", \"BeforeEnd\", \"Until\", \"End\", \"Less\", \"Since\", \"AfterStart\",
     \"BeforeApprox\", \"Mid\", and \"More\"."""

    @overload
    def __init__(
        self,
        *,
        timex: str,
        date_time_sub_kind: Union[str, "_models.DateTimeSubKind"],
        value: str,
        modifier: Optional[Union[str, "_models.TemporalModifier"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, resolution_kind=ResolutionKind.DATE_TIME_RESOLUTION, **kwargs)


class DocumentError(_Model):
    """Contains details of errors encountered during a job execution.

    :ivar id: The ID of the input document. Required.
    :vartype id: str
    :ivar error: Error encountered. Required.
    :vartype error: ~azure.ai.language.conversations.models.ConversationError
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the input document. Required."""
    error: "_models.ConversationError" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error encountered. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        error: "_models.ConversationError",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EntityMaskTypePolicyType(BaseRedactionPolicy, discriminator="entityMask"):
    """Represents the policy of masking PII with the entity type.

    :ivar policy_kind: The entity OverlapPolicy object kind. Required. Mask detected entities with
     entity type
    :vartype policy_kind: str or ~azure.ai.language.conversations.models.ENTITY_MASK
    """

    policy_kind: Literal[RedactionPolicyKind.ENTITY_MASK] = rest_discriminator(name="policyKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The entity OverlapPolicy object kind. Required. Mask detected entities with entity type"""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, policy_kind=RedactionPolicyKind.ENTITY_MASK, **kwargs)


class EntitySubtype(ConversationEntityExtraInformation, discriminator="EntitySubtype"):
    """The concrete entity Subtype model of extra information.

    :ivar extra_information_kind: The extra information object kind. Required. Entity subtype extra
     information kind
    :vartype extra_information_kind: str or ~azure.ai.language.conversations.models.ENTITY_SUBTYPE
    :ivar value: The Subtype of an extracted entity type.
    :vartype value: str
    :ivar tags: List of entity tags. Tags express similarities between entity categories for the
     extracted entity type.
    :vartype tags: list[~azure.ai.language.conversations.models.EntityTag]
    """

    extra_information_kind: Literal[ExtraInformationKind.ENTITY_SUBTYPE] = rest_discriminator(name="extraInformationKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The extra information object kind. Required. Entity subtype extra information kind"""
    value: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The Subtype of an extracted entity type."""
    tags: Optional[List["_models.EntityTag"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of entity tags. Tags express similarities between entity categories for the extracted
     entity type."""

    @overload
    def __init__(
        self,
        *,
        value: Optional[str] = None,
        tags: Optional[List["_models.EntityTag"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, extra_information_kind=ExtraInformationKind.ENTITY_SUBTYPE, **kwargs)


class EntityTag(_Model):
    """Tags express similarities between entity categories for the extracted entity type.

    :ivar name: The name of the tag. Required.
    :vartype name: str
    :ivar confidence_score: The confidence score of the tag for the extracted entity between 0.0
     and 1.0.
    :vartype confidence_score: float
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the tag. Required."""
    confidence_score: Optional[float] = rest_field(
        name="confidenceScore", visibility=["read", "create", "update", "delete", "query"]
    )
    """The confidence score of the tag for the extracted entity between 0.0 and 1.0."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        confidence_score: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object. Required.
    :vartype error: ~azure.ai.language.conversations.models.ConversationError
    """

    error: "_models.ConversationError" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object. Required."""

    @overload
    def __init__(
        self,
        *,
        error: "_models.ConversationError",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InformationResolution(ResolutionBase, discriminator="InformationResolution"):
    """Represents the information (data) entity resolution model.

    :ivar resolution_kind: Represents the information (data) entity resolution model. Required.
     Resolution of an information entity
    :vartype resolution_kind: str or ~azure.ai.language.conversations.models.INFORMATION_RESOLUTION
    :ivar value: The numeric value that the extracted text denotes. Required.
    :vartype value: float
    :ivar unit: The information (data) Unit of measurement. Required. Known values are:
     "Unspecified", "Bit", "Kilobit", "Megabit", "Gigabit", "Terabit", "Petabit", "Byte",
     "Kilobyte", "Megabyte", "Gigabyte", "Terabyte", and "Petabyte".
    :vartype unit: str or ~azure.ai.language.conversations.models.InformationUnit
    """

    resolution_kind: Literal[ResolutionKind.INFORMATION_RESOLUTION] = rest_discriminator(name="resolutionKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Represents the information (data) entity resolution model. Required. Resolution of an
     information entity"""
    value: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The numeric value that the extracted text denotes. Required."""
    unit: Union[str, "_models.InformationUnit"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The information (data) Unit of measurement. Required. Known values are: \"Unspecified\",
     \"Bit\", \"Kilobit\", \"Megabit\", \"Gigabit\", \"Terabit\", \"Petabit\", \"Byte\",
     \"Kilobyte\", \"Megabyte\", \"Gigabyte\", \"Terabyte\", and \"Petabyte\"."""

    @overload
    def __init__(
        self,
        *,
        value: float,
        unit: Union[str, "_models.InformationUnit"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, resolution_kind=ResolutionKind.INFORMATION_RESOLUTION, **kwargs)


class InnerErrorModel(_Model):
    """An object containing more specific information about the error. As per Microsoft One API
    guidelines -
    `https://github.com/Microsoft/api-guidelines/blob/vNext/Guidelines.md#7102-error-condition-responses
    <https://github.com/Microsoft/api-guidelines/blob/vNext/Guidelines.md#7102-error-condition-responses>`_.

    :ivar code: One of a server-defined set of error codes. Required. Known values are:
     "InvalidRequest", "InvalidParameterValue", "KnowledgeBaseNotFound",
     "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling", "ExtractionFailure",
     "InvalidRequestBodyFormat", "EmptyRequest", "MissingInputDocuments", "InvalidDocument",
     "ModelVersionIncorrect", "InvalidDocumentBatch", "UnsupportedLanguageCode", and
     "InvalidCountryHint".
    :vartype code: str or ~azure.ai.language.conversations.models.InnerErrorCode
    :ivar message: Error message. Required.
    :vartype message: str
    :ivar details: Error details.
    :vartype details: dict[str, str]
    :ivar target: Error target.
    :vartype target: str
    :ivar innererror: An object containing more specific information than the current object about
     the error.
    :vartype innererror: ~azure.ai.language.conversations.models.InnerErrorModel
    """

    code: Union[str, "_models.InnerErrorCode"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """One of a server-defined set of error codes. Required. Known values are: \"InvalidRequest\",
     \"InvalidParameterValue\", \"KnowledgeBaseNotFound\", \"AzureCognitiveSearchNotFound\",
     \"AzureCognitiveSearchThrottling\", \"ExtractionFailure\", \"InvalidRequestBodyFormat\",
     \"EmptyRequest\", \"MissingInputDocuments\", \"InvalidDocument\", \"ModelVersionIncorrect\",
     \"InvalidDocumentBatch\", \"UnsupportedLanguageCode\", and \"InvalidCountryHint\"."""
    message: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error message. Required."""
    details: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error details."""
    target: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error target."""
    innererror: Optional["_models.InnerErrorModel"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """An object containing more specific information than the current object about the error."""

    @overload
    def __init__(
        self,
        *,
        code: Union[str, "_models.InnerErrorCode"],
        message: str,
        details: Optional[Dict[str, str]] = None,
        target: Optional[str] = None,
        innererror: Optional["_models.InnerErrorModel"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InputWarning(_Model):
    """Contains details of warnings encountered during a job execution.

    :ivar code: Warning code. Required.
    :vartype code: str
    :ivar message: Warning message. Required.
    :vartype message: str
    :ivar target_ref: A JSON pointer reference indicating the target object.
    :vartype target_ref: str
    """

    code: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Warning code. Required."""
    message: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Warning message. Required."""
    target_ref: Optional[str] = rest_field(name="targetRef", visibility=["read", "create", "update", "delete", "query"])
    """A JSON pointer reference indicating the target object."""

    @overload
    def __init__(
        self,
        *,
        code: str,
        message: str,
        target_ref: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ItemizedSummaryContext(_Model):
    """Context of the summary with a conversation item ID.

    :ivar offset: Start position for the context. Use of different 'stringIndexType' values can
     affect the offset returned. Required.
    :vartype offset: int
    :ivar length: The length of the context. Use of different 'stringIndexType' values can affect
     the length returned. Required.
    :vartype length: int
    :ivar conversation_item_id: Reference to the ID of ConversationItem. Required.
    :vartype conversation_item_id: str
    """

    offset: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Start position for the context. Use of different 'stringIndexType' values can affect the offset
     returned. Required."""
    length: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The length of the context. Use of different 'stringIndexType' values can affect the length
     returned. Required."""
    conversation_item_id: str = rest_field(
        name="conversationItemId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Reference to the ID of ConversationItem. Required."""

    @overload
    def __init__(
        self,
        *,
        offset: int,
        length: int,
        conversation_item_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KnowledgeBaseAnswer(_Model):
    """Represents knowledge base answer.

    :ivar questions: List of questions associated with the answer.
    :vartype questions: list[str]
    :ivar answer: Answer text.
    :vartype answer: str
    :ivar confidence: Answer confidence score, value ranges from 0 to 1.
    :vartype confidence: float
    :ivar qna_id: ID of the QnA result.
    :vartype qna_id: int
    :ivar source: Source of QnA result.
    :vartype source: str
    :ivar metadata: Metadata associated with the answer, useful to categorize or filter question
     answers.
    :vartype metadata: dict[str, str]
    :ivar dialog: Dialog associated with Answer.
    :vartype dialog: ~azure.ai.language.conversations.models.KnowledgeBaseAnswerDialog
    :ivar short_answer: Answer span object of QnA with respect to user's question.
    :vartype short_answer: ~azure.ai.language.conversations.models.AnswerSpan
    """

    questions: Optional[List[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of questions associated with the answer."""
    answer: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Answer text."""
    confidence: Optional[float] = rest_field(
        name="confidenceScore", visibility=["read", "create", "update", "delete", "query"]
    )
    """Answer confidence score, value ranges from 0 to 1."""
    qna_id: Optional[int] = rest_field(name="id", visibility=["read", "create", "update", "delete", "query"])
    """ID of the QnA result."""
    source: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Source of QnA result."""
    metadata: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Metadata associated with the answer, useful to categorize or filter question answers."""
    dialog: Optional["_models.KnowledgeBaseAnswerDialog"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Dialog associated with Answer."""
    short_answer: Optional["_models.AnswerSpan"] = rest_field(
        name="answerSpan", visibility=["read", "create", "update", "delete", "query"]
    )
    """Answer span object of QnA with respect to user's question."""

    @overload
    def __init__(
        self,
        *,
        questions: Optional[List[str]] = None,
        answer: Optional[str] = None,
        confidence: Optional[float] = None,
        qna_id: Optional[int] = None,
        source: Optional[str] = None,
        metadata: Optional[Dict[str, str]] = None,
        dialog: Optional["_models.KnowledgeBaseAnswerDialog"] = None,
        short_answer: Optional["_models.AnswerSpan"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KnowledgeBaseAnswerContext(_Model):
    """Context object with previous QnA's information.

    :ivar previous_qna_id: Previous turn top answer result QnA ID. Required.
    :vartype previous_qna_id: int
    :ivar previous_question: Previous user query.
    :vartype previous_question: str
    """

    previous_qna_id: int = rest_field(name="previousQnaId", visibility=["read", "create", "update", "delete", "query"])
    """Previous turn top answer result QnA ID. Required."""
    previous_question: Optional[str] = rest_field(
        name="previousUserQuery", visibility=["read", "create", "update", "delete", "query"]
    )
    """Previous user query."""

    @overload
    def __init__(
        self,
        *,
        previous_qna_id: int,
        previous_question: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KnowledgeBaseAnswerDialog(_Model):
    """Dialog associated with Answer.

    :ivar is_context_only: To mark if a prompt is relevant only with a previous question or not. If
     true, do not include this QnA as search result for queries without context; otherwise, if
     false, ignores context and includes this QnA in search result.
    :vartype is_context_only: bool
    :ivar prompts: List of prompts associated with the answer.
    :vartype prompts: list[~azure.ai.language.conversations.models.KnowledgeBaseAnswerPrompt]
    """

    is_context_only: Optional[bool] = rest_field(
        name="isContextOnly", visibility=["read", "create", "update", "delete", "query"]
    )
    """To mark if a prompt is relevant only with a previous question or not. If true, do not include
     this QnA as search result for queries without context; otherwise, if false, ignores context and
     includes this QnA in search result."""
    prompts: Optional[List["_models.KnowledgeBaseAnswerPrompt"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of prompts associated with the answer."""

    @overload
    def __init__(
        self,
        *,
        is_context_only: Optional[bool] = None,
        prompts: Optional[List["_models.KnowledgeBaseAnswerPrompt"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KnowledgeBaseAnswerPrompt(_Model):
    """Prompt for an answer.

    :ivar display_order: Index of the prompt - used in ordering of the prompts.
    :vartype display_order: int
    :ivar qna_id: QnA ID corresponding to the prompt.
    :vartype qna_id: int
    :ivar display_text: Text displayed to represent a follow up question prompt.
    :vartype display_text: str
    """

    display_order: Optional[int] = rest_field(
        name="displayOrder", visibility=["read", "create", "update", "delete", "query"]
    )
    """Index of the prompt - used in ordering of the prompts."""
    qna_id: Optional[int] = rest_field(name="qnaId", visibility=["read", "create", "update", "delete", "query"])
    """QnA ID corresponding to the prompt."""
    display_text: Optional[str] = rest_field(
        name="displayText", visibility=["read", "create", "update", "delete", "query"]
    )
    """Text displayed to represent a follow up question prompt."""

    @overload
    def __init__(
        self,
        *,
        display_order: Optional[int] = None,
        qna_id: Optional[int] = None,
        display_text: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LengthResolution(ResolutionBase, discriminator="LengthResolution"):
    """Represents the length entity resolution model.

    :ivar resolution_kind: Represents the length entity resolution model. Required. Resolution of a
     length entity
    :vartype resolution_kind: str or ~azure.ai.language.conversations.models.LENGTH_RESOLUTION
    :ivar value: The numeric value that the extracted text denotes. Required.
    :vartype value: float
    :ivar unit: The length Unit of measurement. Required. Known values are: "Unspecified",
     "Kilometer", "Hectometer", "Decameter", "Meter", "Decimeter", "Centimeter", "Millimeter",
     "Micrometer", "Nanometer", "Picometer", "Mile", "Yard", "Inch", "Foot", "LightYear", and "Pt".
    :vartype unit: str or ~azure.ai.language.conversations.models.LengthUnit
    """

    resolution_kind: Literal[ResolutionKind.LENGTH_RESOLUTION] = rest_discriminator(name="resolutionKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Represents the length entity resolution model. Required. Resolution of a length entity"""
    value: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The numeric value that the extracted text denotes. Required."""
    unit: Union[str, "_models.LengthUnit"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The length Unit of measurement. Required. Known values are: \"Unspecified\", \"Kilometer\",
     \"Hectometer\", \"Decameter\", \"Meter\", \"Decimeter\", \"Centimeter\", \"Millimeter\",
     \"Micrometer\", \"Nanometer\", \"Picometer\", \"Mile\", \"Yard\", \"Inch\", \"Foot\",
     \"LightYear\", and \"Pt\"."""

    @overload
    def __init__(
        self,
        *,
        value: float,
        unit: Union[str, "_models.LengthUnit"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, resolution_kind=ResolutionKind.LENGTH_RESOLUTION, **kwargs)


class ListKey(ConversationEntityExtraInformation, discriminator="ListKey"):
    """The list key extra data kind.

    :ivar extra_information_kind: The list key extra data kind. Required. List key extra
     information kind
    :vartype extra_information_kind: str or ~azure.ai.language.conversations.models.LIST_KEY
    :ivar key: The canonical form of the extracted entity.
    :vartype key: str
    """

    extra_information_kind: Literal[ExtraInformationKind.LIST_KEY] = rest_discriminator(name="extraInformationKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The list key extra data kind. Required. List key extra information kind"""
    key: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The canonical form of the extracted entity."""

    @overload
    def __init__(
        self,
        *,
        key: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, extra_information_kind=ExtraInformationKind.LIST_KEY, **kwargs)


class MetadataFilter(_Model):
    """Find QnAs that are associated with the given list of metadata.

    :ivar metadata: List of metadata.
    :vartype metadata: list[~azure.ai.language.conversations.models.MetadataRecord]
    :ivar logical_operation: Operation used to join metadata filters. Known values are: "AND" and
     "OR".
    :vartype logical_operation: str or ~azure.ai.language.conversations.models.LogicalOperationKind
    """

    metadata: Optional[List["_models.MetadataRecord"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of metadata."""
    logical_operation: Optional[Union[str, "_models.LogicalOperationKind"]] = rest_field(
        name="logicalOperation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Operation used to join metadata filters. Known values are: \"AND\" and \"OR\"."""

    @overload
    def __init__(
        self,
        *,
        metadata: Optional[List["_models.MetadataRecord"]] = None,
        logical_operation: Optional[Union[str, "_models.LogicalOperationKind"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MetadataRecord(_Model):
    """Object to provide the key value pair for each metadata.

    :ivar key: Metadata Key from Metadata dictionary used in the QnA. Required.
    :vartype key: str
    :ivar value: Metadata Value from Metadata dictionary used in the QnA. Required.
    :vartype value: str
    """

    key: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Metadata Key from Metadata dictionary used in the QnA. Required."""
    value: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Metadata Value from Metadata dictionary used in the QnA. Required."""

    @overload
    def __init__(
        self,
        *,
        key: str,
        value: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MultiLanguageConversationInput(_Model):
    """Multi Language Conversation Analysis Input.

    :ivar conversations: Array of conversation items. Required.
    :vartype conversations: list[~azure.ai.language.conversations.models.ConversationInput]
    """

    conversations: List["_models.ConversationInput"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Array of conversation items. Required."""

    @overload
    def __init__(
        self,
        *,
        conversations: List["_models.ConversationInput"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NamedEntity(_Model):
    """Text that has been categorized into pre-defined classes or types such as: person, location,
    event, product, and organization.

    :ivar text: Entity text as appears in the request. Required.
    :vartype text: str
    :ivar category: Entity type. Required.
    :vartype category: str
    :ivar subcategory: (Optional) Entity sub type.
    :vartype subcategory: str
    :ivar offset: Start position for the entity text. Use of different 'stringIndexType' values can
     affect the offset returned. Required.
    :vartype offset: int
    :ivar length: Length for the entity text. Use of different 'stringIndexType' values can affect
     the length returned. Required.
    :vartype length: int
    :ivar confidence_score: Confidence score between 0 and 1 of the extracted entity. Required.
    :vartype confidence_score: float
    :ivar mask: Exact mask text to mask the PII entity.
    :vartype mask: str
    :ivar mask_offset: Offset of the mask text.
    :vartype mask_offset: int
    :ivar mask_length: Length of the mask text.
    :vartype mask_length: int
    """

    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Entity text as appears in the request. Required."""
    category: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Entity type. Required."""
    subcategory: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """(Optional) Entity sub type."""
    offset: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Start position for the entity text. Use of different 'stringIndexType' values can affect the
     offset returned. Required."""
    length: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Length for the entity text. Use of different 'stringIndexType' values can affect the length
     returned. Required."""
    confidence_score: float = rest_field(
        name="confidenceScore", visibility=["read", "create", "update", "delete", "query"]
    )
    """Confidence score between 0 and 1 of the extracted entity. Required."""
    mask: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Exact mask text to mask the PII entity."""
    mask_offset: Optional[int] = rest_field(
        name="maskOffset", visibility=["read", "create", "update", "delete", "query"]
    )
    """Offset of the mask text."""
    mask_length: Optional[int] = rest_field(
        name="maskLength", visibility=["read", "create", "update", "delete", "query"]
    )
    """Length of the mask text."""

    @overload
    def __init__(
        self,
        *,
        text: str,
        category: str,
        offset: int,
        length: int,
        confidence_score: float,
        subcategory: Optional[str] = None,
        mask: Optional[str] = None,
        mask_offset: Optional[int] = None,
        mask_length: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NoMaskPolicyType(BaseRedactionPolicy, discriminator="noMask"):
    """Represents the policy of not masking found PII.

    :ivar policy_kind: The entity RedactionPolicy object kind. Required. Do not mask detected
     entities
    :vartype policy_kind: str or ~azure.ai.language.conversations.models.NO_MASK
    """

    policy_kind: Literal[RedactionPolicyKind.NO_MASK] = rest_discriminator(name="policyKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The entity RedactionPolicy object kind. Required. Do not mask detected entities"""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, policy_kind=RedactionPolicyKind.NO_MASK, **kwargs)


class NonLinkedTargetIntentResult(TargetIntentResult, discriminator="NonLinked"):
    """A wrap up of non-linked intent response.

    :ivar api_version: The API version used to call a target service.
    :vartype api_version: str
    :ivar confidence: The prediction score and it ranges from 0.0 to 1.0. Required.
    :vartype confidence: float
    :ivar target_project_kind: The actual response from a Conversation project. Required. NonLinked
     target service type
    :vartype target_project_kind: str or ~azure.ai.language.conversations.models.NON_LINKED
    :ivar result: The actual response from a Conversation project.
    :vartype result: ~azure.ai.language.conversations.models.ConversationResult
    """

    target_project_kind: Literal[TargetProjectKind.NON_LINKED] = rest_discriminator(name="targetProjectKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The actual response from a Conversation project. Required. NonLinked target service type"""
    result: Optional["_models.ConversationResult"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The actual response from a Conversation project."""

    @overload
    def __init__(
        self,
        *,
        confidence: float,
        api_version: Optional[str] = None,
        result: Optional["_models.ConversationResult"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, target_project_kind=TargetProjectKind.NON_LINKED, **kwargs)


class NumberResolution(ResolutionBase, discriminator="NumberResolution"):
    """A resolution for numeric entity instances.

    :ivar resolution_kind: A resolution for numeric entity instances. Required. Resolution of a
     number entity
    :vartype resolution_kind: str or ~azure.ai.language.conversations.models.NUMBER_RESOLUTION
    :ivar number_kind: The type of the extracted number entity. Required. Known values are:
     "Integer", "Decimal", "Power", "Fraction", "Percent", and "Unspecified".
    :vartype number_kind: str or ~azure.ai.language.conversations.models.NumberKind
    :ivar value: A numeric representation of what the extracted text denotes. Required.
    :vartype value: float
    """

    resolution_kind: Literal[ResolutionKind.NUMBER_RESOLUTION] = rest_discriminator(name="resolutionKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A resolution for numeric entity instances. Required. Resolution of a number entity"""
    number_kind: Union[str, "_models.NumberKind"] = rest_field(
        name="numberKind", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of the extracted number entity. Required. Known values are: \"Integer\", \"Decimal\",
     \"Power\", \"Fraction\", \"Percent\", and \"Unspecified\"."""
    value: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A numeric representation of what the extracted text denotes. Required."""

    @overload
    def __init__(
        self,
        *,
        number_kind: Union[str, "_models.NumberKind"],
        value: float,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, resolution_kind=ResolutionKind.NUMBER_RESOLUTION, **kwargs)


class NumericRangeResolution(ResolutionBase, discriminator="NumericRangeResolution"):
    """represents the resolution of numeric intervals.

    :ivar resolution_kind: represents the resolution of numeric intervals. Required. Resolution of
     a numeric range entity
    :vartype resolution_kind: str or
     ~azure.ai.language.conversations.models.NUMERIC_RANGE_RESOLUTION
    :ivar range_kind: The kind of range that the resolution object represents. Required. Known
     values are: "Number", "Speed", "Weight", "Length", "Volume", "Area", "Age", "Information",
     "Temperature", and "Currency".
    :vartype range_kind: str or ~azure.ai.language.conversations.models.RangeKind
    :ivar minimum: The beginning value of  the interval. Required.
    :vartype minimum: float
    :ivar maximum: The ending value of the interval. Required.
    :vartype maximum: float
    """

    resolution_kind: Literal[ResolutionKind.NUMERIC_RANGE_RESOLUTION] = rest_discriminator(name="resolutionKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """represents the resolution of numeric intervals. Required. Resolution of a numeric range entity"""
    range_kind: Union[str, "_models.RangeKind"] = rest_field(
        name="rangeKind", visibility=["read", "create", "update", "delete", "query"]
    )
    """The kind of range that the resolution object represents. Required. Known values are:
     \"Number\", \"Speed\", \"Weight\", \"Length\", \"Volume\", \"Area\", \"Age\", \"Information\",
     \"Temperature\", and \"Currency\"."""
    minimum: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The beginning value of  the interval. Required."""
    maximum: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ending value of the interval. Required."""

    @overload
    def __init__(
        self,
        *,
        range_kind: Union[str, "_models.RangeKind"],
        minimum: float,
        maximum: float,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, resolution_kind=ResolutionKind.NUMERIC_RANGE_RESOLUTION, **kwargs)


class OrchestrationPrediction(PredictionBase, discriminator="Orchestration"):
    """This represents the prediction result of an Orchestration project.

    :ivar top_intent: The intent with the highest score.
    :vartype top_intent: str
    :ivar project_kind: This represents the prediction result of an Orchestration project.
     Required. Orchestration type
    :vartype project_kind: str or ~azure.ai.language.conversations.models.ORCHESTRATION
    :ivar intents: A dictionary that contains all intents. A key is an intent name and a value is
     its confidence score and target type. The top intent's value also contains the actual response
     from the target project. Required.
    :vartype intents: dict[str, ~azure.ai.language.conversations.models.TargetIntentResult]
    """

    project_kind: Literal[ProjectKind.ORCHESTRATION] = rest_discriminator(name="projectKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """This represents the prediction result of an Orchestration project. Required. Orchestration type"""
    intents: Dict[str, "_models.TargetIntentResult"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A dictionary that contains all intents. A key is an intent name and a value is its confidence
     score and target type. The top intent's value also contains the actual response from the target
     project. Required."""

    @overload
    def __init__(
        self,
        *,
        intents: Dict[str, "_models.TargetIntentResult"],
        top_intent: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, project_kind=ProjectKind.ORCHESTRATION, **kwargs)


class OrdinalResolution(ResolutionBase, discriminator="OrdinalResolution"):
    """A resolution for ordinal numbers entity instances.

    :ivar resolution_kind: A resolution for ordinal numbers entity instances. Required. Resolution
     of an ordinal entity
    :vartype resolution_kind: str or ~azure.ai.language.conversations.models.ORDINAL_RESOLUTION
    :ivar offset: The offset with respect to the reference (e.g., offset = -1 indicates the second
     to last). Required.
    :vartype offset: str
    :ivar relative_to: The reference point that the ordinal number denotes. Required. Known values
     are: "Current", "End", and "Start".
    :vartype relative_to: str or ~azure.ai.language.conversations.models.RelativeTo
    :ivar value: A simple arithmetic expression that the ordinal denotes. Required.
    :vartype value: str
    """

    resolution_kind: Literal[ResolutionKind.ORDINAL_RESOLUTION] = rest_discriminator(name="resolutionKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """A resolution for ordinal numbers entity instances. Required. Resolution of an ordinal entity"""
    offset: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The offset with respect to the reference (e.g., offset = -1 indicates the second to last).
     Required."""
    relative_to: Union[str, "_models.RelativeTo"] = rest_field(
        name="relativeTo", visibility=["read", "create", "update", "delete", "query"]
    )
    """The reference point that the ordinal number denotes. Required. Known values are: \"Current\",
     \"End\", and \"Start\"."""
    value: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A simple arithmetic expression that the ordinal denotes. Required."""

    @overload
    def __init__(
        self,
        *,
        offset: str,
        relative_to: Union[str, "_models.RelativeTo"],
        value: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, resolution_kind=ResolutionKind.ORDINAL_RESOLUTION, **kwargs)


class PiiOperationAction(AnalyzeConversationOperationAction, discriminator="ConversationalPIITask"):
    """Task definition for a PII redaction in conversations.

    :ivar name: task name.
    :vartype name: str
    :ivar kind: discriminator kind. Required. Conversational PII Task
    :vartype kind: str or ~azure.ai.language.conversations.models.CONVERSATIONAL_PII_TASK
    :ivar action_content: parameters.
    :vartype action_content:
     ~azure.ai.language.conversations.models._models.ConversationPiiActionContent
    """

    kind: Literal[AnalyzeConversationOperationActionKind.CONVERSATIONAL_PII_TASK] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """discriminator kind. Required. Conversational PII Task"""
    action_content: Optional["_models._models.ConversationPiiActionContent"] = rest_field(
        name="parameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """parameters."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        action_content: Optional["_models._models.ConversationPiiActionContent"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeConversationOperationActionKind.CONVERSATIONAL_PII_TASK, **kwargs)


class QueryFilters(_Model):
    """filters over knowledge base.

    :ivar metadata_filter: filters over knowledge base.
    :vartype metadata_filter: ~azure.ai.language.conversations.models.MetadataFilter
    :ivar source_filter: filters over knowledge base.
    :vartype source_filter: list[str]
    :ivar logical_operation: Logical operation used to join metadata filter with source filter.
     Known values are: "AND" and "OR".
    :vartype logical_operation: str or ~azure.ai.language.conversations.models.LogicalOperationKind
    """

    metadata_filter: Optional["_models.MetadataFilter"] = rest_field(
        name="metadataFilter", visibility=["read", "create", "update", "delete", "query"]
    )
    """filters over knowledge base."""
    source_filter: Optional[List[str]] = rest_field(
        name="sourceFilter", visibility=["read", "create", "update", "delete", "query"]
    )
    """filters over knowledge base."""
    logical_operation: Optional[Union[str, "_models.LogicalOperationKind"]] = rest_field(
        name="logicalOperation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Logical operation used to join metadata filter with source filter. Known values are: \"AND\"
     and \"OR\"."""

    @overload
    def __init__(
        self,
        *,
        metadata_filter: Optional["_models.MetadataFilter"] = None,
        source_filter: Optional[List[str]] = None,
        logical_operation: Optional[Union[str, "_models.LogicalOperationKind"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class QuestionAnsweringConfig(AnalysisConfig, discriminator="QuestionAnswering"):
    """This is a set of request parameters for Question Answering knowledge bases.

    :ivar api_version: The API version to use when call a specific target service.
    :vartype api_version: str
    :ivar target_project_kind: This is a set of request parameters for Question Answering knowledge
     bases. Required. QuestionAnswering target service type
    :vartype target_project_kind: str or ~azure.ai.language.conversations.models.QUESTION_ANSWERING
    :ivar calling_options: The options sent to a Question Answering KB.
    :vartype calling_options: ~azure.ai.language.conversations.models.QuestionAnswersConfig
    """

    target_project_kind: Literal[TargetProjectKind.QUESTION_ANSWERING] = rest_discriminator(name="targetProjectKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """This is a set of request parameters for Question Answering knowledge bases. Required.
     QuestionAnswering target service type"""
    calling_options: Optional["_models.QuestionAnswersConfig"] = rest_field(
        name="callingOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """The options sent to a Question Answering KB."""

    @overload
    def __init__(
        self,
        *,
        api_version: Optional[str] = None,
        calling_options: Optional["_models.QuestionAnswersConfig"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, target_project_kind=TargetProjectKind.QUESTION_ANSWERING, **kwargs)


class QuestionAnsweringTargetIntentResult(TargetIntentResult, discriminator="QuestionAnswering"):
    """It is a wrap up a Question Answering KB response.

    :ivar api_version: The API version used to call a target service.
    :vartype api_version: str
    :ivar confidence: The prediction score and it ranges from 0.0 to 1.0. Required.
    :vartype confidence: float
    :ivar target_project_kind: It is a wrap up a Question Answering KB response. Required.
     QuestionAnswering target service type
    :vartype target_project_kind: str or ~azure.ai.language.conversations.models.QUESTION_ANSWERING
    :ivar result: The generated answer by a Question Answering KB.
    :vartype result: ~azure.ai.language.conversations.models.AnswersResult
    """

    target_project_kind: Literal[TargetProjectKind.QUESTION_ANSWERING] = rest_discriminator(name="targetProjectKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """It is a wrap up a Question Answering KB response. Required. QuestionAnswering target service
     type"""
    result: Optional["_models.AnswersResult"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The generated answer by a Question Answering KB."""

    @overload
    def __init__(
        self,
        *,
        confidence: float,
        api_version: Optional[str] = None,
        result: Optional["_models.AnswersResult"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, target_project_kind=TargetProjectKind.QUESTION_ANSWERING, **kwargs)


class QuestionAnswersConfig(_Model):
    """Parameters to query a knowledge base.

    :ivar qna_id: Exact QnA ID to fetch from the knowledge base, this field takes priority over
     question.
    :vartype qna_id: int
    :ivar question: User question to query against the knowledge base.
    :vartype question: str
    :ivar top: Max number of answers to be returned for the question.
    :vartype top: int
    :ivar user_id: Unique identifier for the user.
    :vartype user_id: str
    :ivar confidence_threshold: Minimum threshold score for answers, value ranges from 0 to 1.
    :vartype confidence_threshold: float
    :ivar answer_context: Context object with previous QnA's information.
    :vartype answer_context: ~azure.ai.language.conversations.models.KnowledgeBaseAnswerContext
    :ivar ranker_kind: Type of ranker to be used. Known values are: "Default" and "QuestionOnly".
    :vartype ranker_kind: str or ~azure.ai.language.conversations.models.RankerKind
    :ivar filters: Filter QnAs based on given metadata list and knowledge base sources.
    :vartype filters: ~azure.ai.language.conversations.models.QueryFilters
    :ivar short_answer_options: To configure Answer span prediction feature.
    :vartype short_answer_options: ~azure.ai.language.conversations.models.ShortAnswerConfig
    :ivar include_unstructured_sources: (Optional) Flag to enable Query over Unstructured Sources.
    :vartype include_unstructured_sources: bool
    """

    qna_id: Optional[int] = rest_field(name="qnaId", visibility=["read", "create", "update", "delete", "query"])
    """Exact QnA ID to fetch from the knowledge base, this field takes priority over question."""
    question: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """User question to query against the knowledge base."""
    top: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Max number of answers to be returned for the question."""
    user_id: Optional[str] = rest_field(name="userId", visibility=["read", "create", "update", "delete", "query"])
    """Unique identifier for the user."""
    confidence_threshold: Optional[float] = rest_field(
        name="confidenceScoreThreshold", visibility=["read", "create", "update", "delete", "query"]
    )
    """Minimum threshold score for answers, value ranges from 0 to 1."""
    answer_context: Optional["_models.KnowledgeBaseAnswerContext"] = rest_field(
        name="context", visibility=["read", "create", "update", "delete", "query"]
    )
    """Context object with previous QnA's information."""
    ranker_kind: Optional[Union[str, "_models.RankerKind"]] = rest_field(
        name="rankerType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of ranker to be used. Known values are: \"Default\" and \"QuestionOnly\"."""
    filters: Optional["_models.QueryFilters"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Filter QnAs based on given metadata list and knowledge base sources."""
    short_answer_options: Optional["_models.ShortAnswerConfig"] = rest_field(
        name="answerSpanRequest", visibility=["read", "create", "update", "delete", "query"]
    )
    """To configure Answer span prediction feature."""
    include_unstructured_sources: Optional[bool] = rest_field(
        name="includeUnstructuredSources", visibility=["read", "create", "update", "delete", "query"]
    )
    """(Optional) Flag to enable Query over Unstructured Sources."""

    @overload
    def __init__(
        self,
        *,
        qna_id: Optional[int] = None,
        question: Optional[str] = None,
        top: Optional[int] = None,
        user_id: Optional[str] = None,
        confidence_threshold: Optional[float] = None,
        answer_context: Optional["_models.KnowledgeBaseAnswerContext"] = None,
        ranker_kind: Optional[Union[str, "_models.RankerKind"]] = None,
        filters: Optional["_models.QueryFilters"] = None,
        short_answer_options: Optional["_models.ShortAnswerConfig"] = None,
        include_unstructured_sources: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RedactedTranscriptContent(_Model):
    """Transcript content response that the service generates, with all necessary personally
    identifiable information redacted.

    :ivar inverse_text_normalized: Redacted output for input in inverse-text-normalized format.
    :vartype inverse_text_normalized: str
    :ivar masked_inverse_text_normalized: Redacted output for input in masked
     inverse-text-normalized format.
    :vartype masked_inverse_text_normalized: str
    :ivar text: Redacted output for input in text (Microsoft's speech-to-text 'display') format.
    :vartype text: str
    :ivar lexical: Redacted output for input in lexical format.
    :vartype lexical: str
    :ivar audio_timings: List of redacted audio segments.
    :vartype audio_timings: list[~azure.ai.language.conversations.models.AudioTiming]
    """

    inverse_text_normalized: Optional[str] = rest_field(
        name="itn", visibility=["read", "create", "update", "delete", "query"]
    )
    """Redacted output for input in inverse-text-normalized format."""
    masked_inverse_text_normalized: Optional[str] = rest_field(
        name="maskedItn", visibility=["read", "create", "update", "delete", "query"]
    )
    """Redacted output for input in masked inverse-text-normalized format."""
    text: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Redacted output for input in text (Microsoft's speech-to-text 'display') format."""
    lexical: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Redacted output for input in lexical format."""
    audio_timings: Optional[List["_models.AudioTiming"]] = rest_field(
        name="audioTimings", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of redacted audio segments."""

    @overload
    def __init__(
        self,
        *,
        inverse_text_normalized: Optional[str] = None,
        masked_inverse_text_normalized: Optional[str] = None,
        text: Optional[str] = None,
        lexical: Optional[str] = None,
        audio_timings: Optional[List["_models.AudioTiming"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RegexKey(ConversationEntityExtraInformation, discriminator="RegexKey"):
    """The regex key extra data kind.

    :ivar extra_information_kind: The regex key extra data kind. Required. Regex key extra
     information kind
    :vartype extra_information_kind: str or ~azure.ai.language.conversations.models.REGEX_KEY
    :ivar key: The key of the regex pattern used in extracting the entity.
    :vartype key: str
    :ivar regex_pattern: The .NET regex pattern used in extracting the entity. Please visit
     `https://learn.microsoft.com/dotnet/standard/base-types/regular-expressions
     <https://learn.microsoft.com/dotnet/standard/base-types/regular-expressions>`_ for more
     information about .NET regular expressions.
    :vartype regex_pattern: str
    """

    extra_information_kind: Literal[ExtraInformationKind.REGEX_KEY] = rest_discriminator(name="extraInformationKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The regex key extra data kind. Required. Regex key extra information kind"""
    key: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The key of the regex pattern used in extracting the entity."""
    regex_pattern: Optional[str] = rest_field(
        name="regexPattern", visibility=["read", "create", "update", "delete", "query"]
    )
    """The .NET regex pattern used in extracting the entity. Please visit
     `https://learn.microsoft.com/dotnet/standard/base-types/regular-expressions
     <https://learn.microsoft.com/dotnet/standard/base-types/regular-expressions>`_ for more
     information about .NET regular expressions."""

    @overload
    def __init__(
        self,
        *,
        key: Optional[str] = None,
        regex_pattern: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, extra_information_kind=ExtraInformationKind.REGEX_KEY, **kwargs)


class RequestStatistics(_Model):
    """if showStats=true was specified in the request this field will contain information about the
    request payload.

    :ivar documents_count: Number of documents submitted in the request. Required.
    :vartype documents_count: int
    :ivar valid_documents_count: Number of valid documents. This excludes empty, over-size limit or
     non-supported languages documents. Required.
    :vartype valid_documents_count: int
    :ivar erroneous_documents_count: Number of invalid documents. This includes empty, over-size
     limit or non-supported languages documents. Required.
    :vartype erroneous_documents_count: int
    :ivar transactions_count: Number of transactions for the request. Required.
    :vartype transactions_count: int
    """

    documents_count: int = rest_field(name="documentsCount", visibility=["read", "create", "update", "delete", "query"])
    """Number of documents submitted in the request. Required."""
    valid_documents_count: int = rest_field(
        name="validDocumentsCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of valid documents. This excludes empty, over-size limit or non-supported languages
     documents. Required."""
    erroneous_documents_count: int = rest_field(
        name="erroneousDocumentsCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of invalid documents. This includes empty, over-size limit or non-supported languages
     documents. Required."""
    transactions_count: int = rest_field(
        name="transactionsCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of transactions for the request. Required."""

    @overload
    def __init__(
        self,
        *,
        documents_count: int,
        valid_documents_count: int,
        erroneous_documents_count: int,
        transactions_count: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ShortAnswerConfig(_Model):
    """To configure Answer span prediction feature.

    :ivar enable: Enable or disable Answer Span prediction.
    :vartype enable: bool
    :ivar confidence_threshold: Minimum threshold score required to include an answer span, value
     ranges from 0 to 1.
    :vartype confidence_threshold: float
    :ivar top: Number of Top answers to be considered for span prediction from 1 to 10.
    :vartype top: int
    """

    enable: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Enable or disable Answer Span prediction."""
    confidence_threshold: Optional[float] = rest_field(
        name="confidenceScoreThreshold", visibility=["read", "create", "update", "delete", "query"]
    )
    """Minimum threshold score required to include an answer span, value ranges from 0 to 1."""
    top: Optional[int] = rest_field(
        name="topAnswersWithSpan", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of Top answers to be considered for span prediction from 1 to 10."""

    @overload
    def __init__(
        self,
        *,
        enable: Optional[bool] = None,
        confidence_threshold: Optional[float] = None,
        top: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SpeedResolution(ResolutionBase, discriminator="SpeedResolution"):
    """Represents the speed entity resolution model.

    :ivar resolution_kind: Represents the speed entity resolution model. Required. Resolution of a
     speed entity
    :vartype resolution_kind: str or ~azure.ai.language.conversations.models.SPEED_RESOLUTION
    :ivar value: The numeric value that the extracted text denotes. Required.
    :vartype value: float
    :ivar unit: The speed Unit of measurement. Required. Known values are: "Unspecified",
     "MetersPerSecond", "KilometersPerHour", "KilometersPerMinute", "KilometersPerSecond",
     "MilesPerHour", "Knot", "FootPerSecond", "FootPerMinute", "YardsPerMinute", "YardsPerSecond",
     "MetersPerMillisecond", "CentimetersPerMillisecond", and "KilometersPerMillisecond".
    :vartype unit: str or ~azure.ai.language.conversations.models.SpeedUnit
    """

    resolution_kind: Literal[ResolutionKind.SPEED_RESOLUTION] = rest_discriminator(name="resolutionKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Represents the speed entity resolution model. Required. Resolution of a speed entity"""
    value: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The numeric value that the extracted text denotes. Required."""
    unit: Union[str, "_models.SpeedUnit"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The speed Unit of measurement. Required. Known values are: \"Unspecified\",
     \"MetersPerSecond\", \"KilometersPerHour\", \"KilometersPerMinute\", \"KilometersPerSecond\",
     \"MilesPerHour\", \"Knot\", \"FootPerSecond\", \"FootPerMinute\", \"YardsPerMinute\",
     \"YardsPerSecond\", \"MetersPerMillisecond\", \"CentimetersPerMillisecond\", and
     \"KilometersPerMillisecond\"."""

    @overload
    def __init__(
        self,
        *,
        value: float,
        unit: Union[str, "_models.SpeedUnit"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, resolution_kind=ResolutionKind.SPEED_RESOLUTION, **kwargs)


class SummarizationOperationAction(AnalyzeConversationOperationAction, discriminator="ConversationalSummarizationTask"):
    """Task definition for conversational summarization.

    :ivar name: task name.
    :vartype name: str
    :ivar kind: discriminator kind. Required. Conversational Summarization Task
    :vartype kind: str or ~azure.ai.language.conversations.models.CONVERSATIONAL_SUMMARIZATION_TASK
    :ivar action_content: parameters.
    :vartype action_content:
     ~azure.ai.language.conversations.models._models.ConversationSummarizationActionContent
    """

    kind: Literal[AnalyzeConversationOperationActionKind.CONVERSATIONAL_SUMMARIZATION_TASK] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """discriminator kind. Required. Conversational Summarization Task"""
    action_content: Optional["_models._models.ConversationSummarizationActionContent"] = rest_field(
        name="parameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """parameters."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        action_content: Optional["_models._models.ConversationSummarizationActionContent"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeConversationOperationActionKind.CONVERSATIONAL_SUMMARIZATION_TASK, **kwargs)


class SummarizationOperationResult(
    AnalyzeConversationOperationResult, discriminator="conversationalSummarizationResults"
):
    """Result for the summarization task on the conversation.

    :ivar last_update_date_time: The last updated time in UTC for the task. Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: The status of the task at the mentioned last update time. Required. Known values
     are: "notStarted", "running", "succeeded", "partiallyCompleted", "failed", "cancelled", and
     "cancelling".
    :vartype status: str or ~azure.ai.language.conversations.models.ConversationActionState
    :ivar name: task name.
    :vartype name: str
    :ivar kind: discriminator kind. Required. Conversational Summarization Results
    :vartype kind: str or ~azure.ai.language.conversations.models.SUMMARIZATION_OPERATION_RESULTS
    :ivar results: results. Required.
    :vartype results: ~azure.ai.language.conversations.models.SummaryResult
    """

    kind: Literal[AnalyzeConversationOperationResultsKind.SUMMARIZATION_OPERATION_RESULTS] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """discriminator kind. Required. Conversational Summarization Results"""
    results: "_models.SummaryResult" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """results. Required."""

    @overload
    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.ConversationActionState"],
        results: "_models.SummaryResult",
        name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeConversationOperationResultsKind.SUMMARIZATION_OPERATION_RESULTS, **kwargs)


class SummaryResult(_Model):
    """Summary Results.

    :ivar conversations: array of conversations. Required.
    :vartype conversations:
     list[~azure.ai.language.conversations.models.ConversationsSummaryResult]
    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.language.conversations.models.DocumentError]
    :ivar statistics: statistics.
    :vartype statistics: ~azure.ai.language.conversations.models.RequestStatistics
    :ivar model_version: This field indicates which model is used for scoring. Required.
    :vartype model_version: str
    """

    conversations: List["_models.ConversationsSummaryResult"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """array of conversations. Required."""
    errors: List["_models.DocumentError"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Errors by document id. Required."""
    statistics: Optional["_models.RequestStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """statistics."""
    model_version: str = rest_field(name="modelVersion", visibility=["read", "create", "update", "delete", "query"])
    """This field indicates which model is used for scoring. Required."""

    @overload
    def __init__(
        self,
        *,
        conversations: List["_models.ConversationsSummaryResult"],
        errors: List["_models.DocumentError"],
        model_version: str,
        statistics: Optional["_models.RequestStatistics"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SummaryResultItem(_Model):
    """Summary Result Item.

    :ivar aspect: aspect. Required.
    :vartype aspect: str
    :ivar text: text. Required.
    :vartype text: str
    :ivar contexts: Context list of the summary.
    :vartype contexts: list[~azure.ai.language.conversations.models.ItemizedSummaryContext]
    """

    aspect: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """aspect. Required."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """text. Required."""
    contexts: Optional[List["_models.ItemizedSummaryContext"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Context list of the summary."""

    @overload
    def __init__(
        self,
        *,
        aspect: str,
        text: str,
        contexts: Optional[List["_models.ItemizedSummaryContext"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TemperatureResolution(ResolutionBase, discriminator="TemperatureResolution"):
    """Represents the temperature entity resolution model.

    :ivar resolution_kind: Represents the temperature entity resolution model. Required. Resolution
     of a temperature entity
    :vartype resolution_kind: str or ~azure.ai.language.conversations.models.TEMPERATURE_RESOLUTION
    :ivar value: The numeric value that the extracted text denotes. Required.
    :vartype value: float
    :ivar unit: The temperature Unit of measurement. Required. Known values are: "Unspecified",
     "Fahrenheit", "Kelvin", "Rankine", and "Celsius".
    :vartype unit: str or ~azure.ai.language.conversations.models.TemperatureUnit
    """

    resolution_kind: Literal[ResolutionKind.TEMPERATURE_RESOLUTION] = rest_discriminator(name="resolutionKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Represents the temperature entity resolution model. Required. Resolution of a temperature
     entity"""
    value: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The numeric value that the extracted text denotes. Required."""
    unit: Union[str, "_models.TemperatureUnit"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The temperature Unit of measurement. Required. Known values are: \"Unspecified\",
     \"Fahrenheit\", \"Kelvin\", \"Rankine\", and \"Celsius\"."""

    @overload
    def __init__(
        self,
        *,
        value: float,
        unit: Union[str, "_models.TemperatureUnit"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, resolution_kind=ResolutionKind.TEMPERATURE_RESOLUTION, **kwargs)


class TemporalSpanResolution(ResolutionBase, discriminator="TemporalSpanResolution"):
    """represents the resolution of a date and/or time span.

    :ivar resolution_kind: represents the resolution of a date and/or time span. Required.
     Resolution of a temporal span entity
    :vartype resolution_kind: str or
     ~azure.ai.language.conversations.models.TEMPORAL_SPAN_RESOLUTION
    :ivar begin: represents the resolution of a date and/or time span. An extended ISO 8601
     date/time representation as described in
     (`https://github.com/Microsoft/Recognizers-Text/blob/master/Patterns/English/English-DateTime.yaml
     <https://github.com/Microsoft/Recognizers-Text/blob/master/Patterns/English/English-DateTime.yaml>`_).
    :vartype begin: str
    :ivar end: represents the resolution of a date and/or time span. An extended ISO 8601 date/time
     representation as described in
     (`https://github.com/Microsoft/Recognizers-Text/blob/master/Patterns/English/English-DateTime.yaml
     <https://github.com/Microsoft/Recognizers-Text/blob/master/Patterns/English/English-DateTime.yaml>`_).
    :vartype end: str
    :ivar duration: An optional duration value formatted based on the ISO 8601
     (`https://en.wikipedia.org/wiki/ISO_8601#Durations
     <https://en.wikipedia.org/wiki/ISO_8601#Durations>`_).
    :vartype duration: str
    :ivar modifier: An optional modifier of a date/time instance. Known values are: "AfterApprox",
     "Before", "BeforeStart", "Approx", "ReferenceUndefined", "SinceEnd", "AfterMid", "Start",
     "After", "BeforeEnd", "Until", "End", "Less", "Since", "AfterStart", "BeforeApprox", "Mid", and
     "More".
    :vartype modifier: str or ~azure.ai.language.conversations.models.TemporalModifier
    :ivar timex: An optional triplet containing the beginning, the end, and the duration all stated
     as ISO 8601 formatted strings.
    :vartype timex: str
    """

    resolution_kind: Literal[ResolutionKind.TEMPORAL_SPAN_RESOLUTION] = rest_discriminator(name="resolutionKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """represents the resolution of a date and/or time span. Required. Resolution of a temporal span
     entity"""
    begin: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """represents the resolution of a date and/or time span. An extended ISO 8601 date/time
     representation as described in
     (`https://github.com/Microsoft/Recognizers-Text/blob/master/Patterns/English/English-DateTime.yaml
     <https://github.com/Microsoft/Recognizers-Text/blob/master/Patterns/English/English-DateTime.yaml>`_)."""
    end: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """represents the resolution of a date and/or time span. An extended ISO 8601 date/time
     representation as described in
     (`https://github.com/Microsoft/Recognizers-Text/blob/master/Patterns/English/English-DateTime.yaml
     <https://github.com/Microsoft/Recognizers-Text/blob/master/Patterns/English/English-DateTime.yaml>`_)."""
    duration: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An optional duration value formatted based on the ISO 8601
     (`https://en.wikipedia.org/wiki/ISO_8601#Durations
     <https://en.wikipedia.org/wiki/ISO_8601#Durations>`_)."""
    modifier: Optional[Union[str, "_models.TemporalModifier"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """An optional modifier of a date/time instance. Known values are: \"AfterApprox\", \"Before\",
     \"BeforeStart\", \"Approx\", \"ReferenceUndefined\", \"SinceEnd\", \"AfterMid\", \"Start\",
     \"After\", \"BeforeEnd\", \"Until\", \"End\", \"Less\", \"Since\", \"AfterStart\",
     \"BeforeApprox\", \"Mid\", and \"More\"."""
    timex: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An optional triplet containing the beginning, the end, and the duration all stated as ISO 8601
     formatted strings."""

    @overload
    def __init__(
        self,
        *,
        begin: Optional[str] = None,
        end: Optional[str] = None,
        duration: Optional[str] = None,
        modifier: Optional[Union[str, "_models.TemporalModifier"]] = None,
        timex: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, resolution_kind=ResolutionKind.TEMPORAL_SPAN_RESOLUTION, **kwargs)


class TextConversation(ConversationInput, discriminator="text"):
    """model for text conversation.

    :ivar id: Unique identifier for the conversation. Required.
    :vartype id: str
    :ivar language: Language of the conversation item in BCP-47 format. Required.
    :vartype language: str
    :ivar domain: domain. Known values are: "finance", "healthcare", and "generic".
    :vartype domain: str or ~azure.ai.language.conversations.models.ConversationDomain
    :ivar modality: modality discriminator. Required. Text input modality
    :vartype modality: str or ~azure.ai.language.conversations.models.TEXT
    :ivar conversation_items: Ordered list of text conversation items in the conversation.
     Required.
    :vartype conversation_items: list[~azure.ai.language.conversations.models.TextConversationItem]
    """

    modality: Literal[InputModality.TEXT] = rest_discriminator(name="modality", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """modality discriminator. Required. Text input modality"""
    conversation_items: List["_models.TextConversationItem"] = rest_field(
        name="conversationItems", visibility=["read", "create", "update", "delete", "query"]
    )
    """Ordered list of text conversation items in the conversation. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        language: str,
        conversation_items: List["_models.TextConversationItem"],
        domain: Optional[Union[str, "_models.ConversationDomain"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, modality=InputModality.TEXT, **kwargs)


class TextConversationItem(_Model):
    """The text modality of an input conversation.

    :ivar id: The ID of a conversation item. Required.
    :vartype id: str
    :ivar participant_id: The participant ID of a conversation item. Required.
    :vartype participant_id: str
    :ivar language: The override language of a conversation item in BCP 47 language representation.
    :vartype language: str
    :ivar modality: Enumeration of supported conversational modalities. Known values are:
     "transcript" and "text".
    :vartype modality: str or ~azure.ai.language.conversations.models.InputModality
    :ivar role: Role of the participant. Known values are: "customer", "agent", and "generic".
    :vartype role: str or ~azure.ai.language.conversations.models.ParticipantRole
    :ivar text: The text input. Required.
    :vartype text: str
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of a conversation item. Required."""
    participant_id: str = rest_field(name="participantId", visibility=["read", "create", "update", "delete", "query"])
    """The participant ID of a conversation item. Required."""
    language: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The override language of a conversation item in BCP 47 language representation."""
    modality: Optional[Union[str, "_models.InputModality"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Enumeration of supported conversational modalities. Known values are: \"transcript\" and
     \"text\"."""
    role: Optional[Union[str, "_models.ParticipantRole"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Role of the participant. Known values are: \"customer\", \"agent\", and \"generic\"."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The text input. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        participant_id: str,
        text: str,
        language: Optional[str] = None,
        modality: Optional[Union[str, "_models.InputModality"]] = None,
        role: Optional[Union[str, "_models.ParticipantRole"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TranscriptConversation(ConversationInput, discriminator="transcript"):
    """model for transcript conversation.

    :ivar id: Unique identifier for the conversation. Required.
    :vartype id: str
    :ivar language: Language of the conversation item in BCP-47 format. Required.
    :vartype language: str
    :ivar domain: domain. Known values are: "finance", "healthcare", and "generic".
    :vartype domain: str or ~azure.ai.language.conversations.models.ConversationDomain
    :ivar modality: modality discriminator. Required. Transcript input modality
    :vartype modality: str or ~azure.ai.language.conversations.models.TRANSCRIPT
    :ivar conversation_items: Ordered list of transcript conversation items in the conversation.
     Required.
    :vartype conversation_items:
     list[~azure.ai.language.conversations.models._models.TranscriptConversationItem]
    """

    modality: Literal[InputModality.TRANSCRIPT] = rest_discriminator(name="modality", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """modality discriminator. Required. Transcript input modality"""
    conversation_items: List["_models._models.TranscriptConversationItem"] = rest_field(
        name="conversationItems", visibility=["read", "create", "update", "delete", "query"]
    )
    """Ordered list of transcript conversation items in the conversation. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        language: str,
        conversation_items: List["_models._models.TranscriptConversationItem"],
        domain: Optional[Union[str, "_models.ConversationDomain"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, modality=InputModality.TRANSCRIPT, **kwargs)


class TranscriptConversationItem(_Model):
    """Additional properties for supporting transcript conversation.

    :ivar id: The ID of a conversation item. Required.
    :vartype id: str
    :ivar participant_id: The participant ID of a conversation item. Required.
    :vartype participant_id: str
    :ivar language: The override language of a conversation item in BCP 47 language representation.
    :vartype language: str
    :ivar modality: Enumeration of supported conversational modalities. Known values are:
     "transcript" and "text".
    :vartype modality: str or ~azure.ai.language.conversations.models.InputModality
    :ivar role: Role of the participant. Known values are: "customer", "agent", and "generic".
    :vartype role: str or ~azure.ai.language.conversations.models.ParticipantRole
    :ivar inverse_text_normalized: Inverse text normalization (ITN) representation of input. The
     inverse-text-normalized form is the recognized text from Microsoft's speech-to-text API, with
     phone numbers, numbers, abbreviations, and other transformations applied. Required.
    :vartype inverse_text_normalized: str
    :ivar masked_inverse_text_normalized: Inverse-text-normalized format with profanity masking
     applied. Required.
    :vartype masked_inverse_text_normalized: str
    :ivar text: Display form of the recognized text from the speech-to-text API, with punctuation
     and capitalization added. Required.
    :vartype text: str
    :ivar lexical: Lexical form of the recognized text from the speech-to-text API, with the actual
     words recognized. Required.
    :vartype lexical: str
    :ivar word_level_timings: List of word-level audio timing information.
    :vartype word_level_timings:
     list[~azure.ai.language.conversations.models._models.WordLevelTiming]
    :ivar conversation_item_level_timing: Audio timing at the conversation item level. This still
     can help with AI quality if word-level audio timings are not available.
    :vartype conversation_item_level_timing:
     ~azure.ai.language.conversations.models._models.ConversationItemLevelTiming
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of a conversation item. Required."""
    participant_id: str = rest_field(name="participantId", visibility=["read", "create", "update", "delete", "query"])
    """The participant ID of a conversation item. Required."""
    language: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The override language of a conversation item in BCP 47 language representation."""
    modality: Optional[Union[str, "_models.InputModality"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Enumeration of supported conversational modalities. Known values are: \"transcript\" and
     \"text\"."""
    role: Optional[Union[str, "_models.ParticipantRole"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Role of the participant. Known values are: \"customer\", \"agent\", and \"generic\"."""
    inverse_text_normalized: str = rest_field(name="itn", visibility=["read", "create", "update", "delete", "query"])
    """Inverse text normalization (ITN) representation of input. The inverse-text-normalized form is
     the recognized text from Microsoft's speech-to-text API, with phone numbers, numbers,
     abbreviations, and other transformations applied. Required."""
    masked_inverse_text_normalized: str = rest_field(
        name="maskedItn", visibility=["read", "create", "update", "delete", "query"]
    )
    """Inverse-text-normalized format with profanity masking applied. Required."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Display form of the recognized text from the speech-to-text API, with punctuation and
     capitalization added. Required."""
    lexical: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Lexical form of the recognized text from the speech-to-text API, with the actual words
     recognized. Required."""
    word_level_timings: Optional[List["_models._models.WordLevelTiming"]] = rest_field(
        name="wordLevelTimings", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of word-level audio timing information."""
    conversation_item_level_timing: Optional["_models._models.ConversationItemLevelTiming"] = rest_field(
        name="conversationItemLevelTiming", visibility=["read", "create", "update", "delete", "query"]
    )
    """Audio timing at the conversation item level. This still can help with AI quality if word-level
     audio timings are not available."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        participant_id: str,
        inverse_text_normalized: str,
        masked_inverse_text_normalized: str,
        text: str,
        lexical: str,
        language: Optional[str] = None,
        modality: Optional[Union[str, "_models.InputModality"]] = None,
        role: Optional[Union[str, "_models.ParticipantRole"]] = None,
        word_level_timings: Optional[List["_models._models.WordLevelTiming"]] = None,
        conversation_item_level_timing: Optional["_models._models.ConversationItemLevelTiming"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VolumeResolution(ResolutionBase, discriminator="VolumeResolution"):
    """Represents the volume entity resolution model.

    :ivar resolution_kind: Represents the volume entity resolution model. Required. Resolution of a
     volume entity
    :vartype resolution_kind: str or ~azure.ai.language.conversations.models.VOLUME_RESOLUTION
    :ivar value: The numeric value that the extracted text denotes. Required.
    :vartype value: float
    :ivar unit: The Volume Unit of measurement. Required. Known values are: "Unspecified",
     "CubicMeter", "CubicCentimeter", "CubicMillimeter", "Hectoliter", "Decaliter", "Liter",
     "Centiliter", "Milliliter", "CubicYard", "CubicInch", "CubicFoot", "CubicMile", "FluidOunce",
     "Teaspoon", "Tablespoon", "Pint", "Quart", "Cup", "Gill", "Pinch", "FluidDram", "Barrel",
     "Minim", "Cord", "Peck", "Bushel", and "Hogshead".
    :vartype unit: str or ~azure.ai.language.conversations.models.VolumeUnit
    """

    resolution_kind: Literal[ResolutionKind.VOLUME_RESOLUTION] = rest_discriminator(name="resolutionKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Represents the volume entity resolution model. Required. Resolution of a volume entity"""
    value: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The numeric value that the extracted text denotes. Required."""
    unit: Union[str, "_models.VolumeUnit"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The Volume Unit of measurement. Required. Known values are: \"Unspecified\", \"CubicMeter\",
     \"CubicCentimeter\", \"CubicMillimeter\", \"Hectoliter\", \"Decaliter\", \"Liter\",
     \"Centiliter\", \"Milliliter\", \"CubicYard\", \"CubicInch\", \"CubicFoot\", \"CubicMile\",
     \"FluidOunce\", \"Teaspoon\", \"Tablespoon\", \"Pint\", \"Quart\", \"Cup\", \"Gill\",
     \"Pinch\", \"FluidDram\", \"Barrel\", \"Minim\", \"Cord\", \"Peck\", \"Bushel\", and
     \"Hogshead\"."""

    @overload
    def __init__(
        self,
        *,
        value: float,
        unit: Union[str, "_models.VolumeUnit"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, resolution_kind=ResolutionKind.VOLUME_RESOLUTION, **kwargs)


class WeightResolution(ResolutionBase, discriminator="WeightResolution"):
    """Represents the weight entity resolution model.

    :ivar resolution_kind: Represents the weight entity resolution model. Required. Resolution of a
     weight entity
    :vartype resolution_kind: str or ~azure.ai.language.conversations.models.WEIGHT_RESOLUTION
    :ivar value: The numeric value that the extracted text denotes. Required.
    :vartype value: float
    :ivar unit: The weight Unit of measurement. Required. Known values are: "Unspecified",
     "Kilogram", "Gram", "Milligram", "Gallon", "MetricTon", "Ton", "Pound", "Ounce", "Grain",
     "PennyWeight", "LongTonBritish", "ShortTonUS", "ShortHundredWeightUS", "Stone", and "Dram".
    :vartype unit: str or ~azure.ai.language.conversations.models.WeightUnit
    """

    resolution_kind: Literal[ResolutionKind.WEIGHT_RESOLUTION] = rest_discriminator(name="resolutionKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Represents the weight entity resolution model. Required. Resolution of a weight entity"""
    value: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The numeric value that the extracted text denotes. Required."""
    unit: Union[str, "_models.WeightUnit"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The weight Unit of measurement. Required. Known values are: \"Unspecified\", \"Kilogram\",
     \"Gram\", \"Milligram\", \"Gallon\", \"MetricTon\", \"Ton\", \"Pound\", \"Ounce\", \"Grain\",
     \"PennyWeight\", \"LongTonBritish\", \"ShortTonUS\", \"ShortHundredWeightUS\", \"Stone\", and
     \"Dram\"."""

    @overload
    def __init__(
        self,
        *,
        value: float,
        unit: Union[str, "_models.WeightUnit"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, resolution_kind=ResolutionKind.WEIGHT_RESOLUTION, **kwargs)


class WordLevelTiming(_Model):
    """Word-level timing information that the speech-to-text API generates. The words in this object
    should have 1:1 correspondence with the lexical input to allow for audio redaction.

    :ivar offset: Offset from the start of speech audio, in ticks. 1 tick = 100 nanoseconds.
    :vartype offset: int
    :ivar duration: Duration of word articulation, in ticks. 1 tick = 100 nanoseconds.
    :vartype duration: int
    :ivar word: Recognized word.
    :vartype word: str
    """

    offset: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Offset from the start of speech audio, in ticks. 1 tick = 100 nanoseconds."""
    duration: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Duration of word articulation, in ticks. 1 tick = 100 nanoseconds."""
    word: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Recognized word."""

    @overload
    def __init__(
        self,
        *,
        offset: Optional[int] = None,
        duration: Optional[int] = None,
        word: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
