# coding: UTF-8
import unittest
import jpgrid

class TestReference(unittest.TestCase):
	def test_lv1(self):
		self.assertEqual("5438", jpgrid.encodeLv1(36,138))
	
	def test_prefectures(self):
		# http://www.stat.go.jp/data/mesh/pdf/gaiyo1.pdf
		# page. 15
		def dms(d,m,s):
			return float(d) + (float(m) + float(s)/60)/60.0
		
		dataset = [
			("北海道", "札幌市", "6441-42-77", ("43","03","30"), ("141","20","15")), 
			("青森県", "青森市", "6140-15-89", ("40","49","00"), ("140","44","15")), 
			("岩手県", "盛岡市", "5941-41-42", ("39","42","00"), ("141","09","00")), 
			("宮城県", "仙台市", "5740-36-29", ("38","16","00"), ("140","51","45")), 
			("秋田県", "秋田市", "5940-40-68", ("39","43","00"), ("140","06","00")), 
			("山形県", "山形市", "5740-22-89", ("38","14","00"), ("140","21","45")), 
			("福島県", "福島市", "5640-53-07", ("37","45","00"), ("140","27","45")), 
			("茨城県", "水戸市", "5440-43-15", ("36","20","30"), ("140","26","15")), 
			("栃木県", "宇都宮市", "5439-67-70", ("36","33","30"), ("139","52","30")), 
			("群馬県", "前橋市", "5439-40-64", ("36","23","00"), ("139","03","00")), 
			("埼玉県", "さいたま市", "5339-65-21", ("35","51","00"), ("139","38","15")), 
			("千葉県", "千葉市", "5340-30-29", ("35","36","00"), ("140","06","45")), 
			("東京都", "新宿区", "5339-45-25", ("35","41","00"), ("139","41","15")), 
			("神奈川県", "横浜市", "5339-15-31", ("35","26","30"), ("139","38","15")), 
			("新潟県", "新潟市", "5639-60-81", ("37","54","00"), ("139","00","45")), 
			("富山県", "富山市", "5537-01-36", ("36","41","30"), ("137","12","00")), 
			("石川県", "金沢市", "5436-75-10", ("36","35","30"), ("136","37","30")), 
			("福井県", "福井市", "5436-01-77", ("36","03","30"), ("136","12","45")), 
			("山梨県", "甲府市", "5338-34-95", ("35","39","30"), ("138","33","45")), 
			("長野県", "長野市", "5438-71-84", ("36","39","00"), ("138","10","30")), 
			("岐阜県", "岐阜市", "5336-05-67", ("35","23","00"), ("136","42","45")), 
			("静岡県", "静岡市", "5238-33-70", ("34","58","30"), ("138","22","30")), 
			("愛知県", "名古屋市", "5236-67-12", ("35","10","30"), ("136","54","00")), 
			("三重県", "津市", "5236-04-70", ("34","43","30"), ("136","30","00")), 
			("滋賀県", "大津市", "5235-46-09", ("35","00","00"), ("135","51","45")), 
			("京都府", "京都市", "5235-46-20", ("35","01","00"), ("135","45","00")), 
			("大阪府", "大阪市", "5235-04-21", ("34","41","00"), ("135","30","45")), 
			("兵庫県", "神戸市", "5235-01-24", ("34","41","00"), ("135","10","30")), 
			("奈良県", "奈良市", "5235-06-26", ("34","41","00"), ("135","49","30")), 
			("和歌山県", "和歌山市", "5135-21-73", ("34","13","30"), ("135","09","45")), 
			("鳥取県", "鳥取市", "5334-21-09", ("35","30","00"), ("134","14","15")), 
			("島根県", "松江市", "5333-10-64", ("35","28","00"), ("133","03","00")), 
			("岡山県", "岡山市", "5133-77-94", ("34","39","30"), ("133","55","30")), 
			("広島県", "広島市", "5132-43-76", ("34","23","30"), ("132","27","00")), 
			("山口県", "山口市", "5131-23-27", ("34","11","00"), ("131","27","45")), 
			("徳島県", "徳島市", "5134-04-74", ("34","03","30"), ("134","33","00")), 
			("香川県", "高松市", "5134-40-03", ("34","20","00"), ("134","02","15")), 
			("愛媛県", "松山市", "5032-66-01", ("33","50","00"), ("132","45","45")), 
			("高知県", "高知市", "5033-24-72", ("33","33","30"), ("133","31","30")), 
			("福岡県", "福岡市", "5030-33-23", ("33","36","00"), ("130","24","45")), 
			("佐賀県", "佐賀市", "4930-62-93", ("33","14","30"), ("130","17","15")), 
			("長崎県", "長崎市", "4929-06-99", ("32","44","30"), ("129","51","45")), 
			("熊本県", "熊本市", "4930-15-49", ("32","47","00"), ("130","44","15")), 
			("大分県", "大分市", "4931-64-89", ("33","14","00"), ("131","36","45")), 
			("宮崎県", "宮崎市", "4731-63-93", ("31","54","30"), ("131","24","45")), 
			("鹿児島県", "鹿児島市", "4730-24-74", ("31","33","30"), ("130","33","00")), 
			("沖縄県", "那覇市", "3927-25-54", ("26","12","30"), ("127","40","30"))
			]
		
		for data in dataset:
			# encode
			self.assertEqual(data[2].replace("-",""), jpgrid.encode(dms(*data[3]), dms(*data[4])))
			t = jpgrid.decode(data[2].replace("-",""))
			# decode
			self.assertTrue(t[0] > dms(*data[3]))
			self.assertTrue(t[0] < dms(*data[3]) + 1.5/80.0)
			self.assertTrue(t[1] > dms(*data[4]))
			self.assertTrue(t[1] < dms(*data[4]) + 1.0/80.0)

if __name__=='__main__':
	unittest.main()
