//
// C++ Implementation: CPrefEdit
//
// Description: 
//
//
// Author: Harald Krippel <harald@the-develop.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <QtGui>

#include "CQcakeDlg.hpp"
#include "CPrefEdit.hpp"
#include "mainwindow.hpp"
#include "networkaccessmanager.hpp"

CPrefEditDlg::CPrefEditDlg(QString strTitle, QWidget * parent, QString tmppath, int tmpfps, int tmpphfps,Qt::WFlags f)
: CQcakeDlg(parent, f)
{
   ui.setupUi(this);
   
   connect(ui.buttonBox, SIGNAL(accepted()), this, SLOT(slotEditData()));
   connect(ui.buttonBox, SIGNAL(rejected()), this, SLOT(slotGetData()));
   connect(ui.toolButton1, SIGNAL(pressed()), this, SLOT(slotGetEditor()));

   ui.editor->setText(tmppath);
   editorpath = tmppath;
   fps=tmpfps;
   phfps=tmpphfps;
   ui.checkBoxFPS->setChecked(fps);
   ui.checkBoxPHFPS->setChecked(phfps);

   myParent = parent;
   setWindowTitle(strTitle);
   loadFromSettings();
}

CPrefEditDlg::~CPrefEditDlg() {
}

void CPrefEditDlg::slotGetEditor()
{
    QString fileName =
            QFileDialog::getOpenFileName(this, tr("Editor"),
                                         QString(QDir::homePath ()),
                                         tr("Files (*)"));

    qWarning( fileName.toAscii() );
    if(!fileName.isEmpty()){
      ui.editor->setText(fileName);
      editorpath = fileName;
    }
}

QString CPrefEditDlg::geteditpath()
{
  return editorpath;
}

int CPrefEditDlg::getfps()
{
  return fps;
}

int CPrefEditDlg::getphfps()
{
  return phfps;
}

void CPrefEditDlg::slotGetData()
{
    reject();
    qWarning( "CPrefEditDlg::slotGetData(): Geht !" );
}

void CPrefEditDlg::slotEditData()
{
   QSettings settings;
// general
    editorpath = ui.editor->text();
    fps=ui.checkBoxFPS->isChecked() ? 1 : 0;
    phfps=ui.checkBoxPHFPS->isChecked() ? 1 : 0;
// proxy
    settings.beginGroup(QLatin1String("proxy"));
    settings.setValue(QLatin1String("enabled"), ui.proxySupport->isChecked());
    settings.setValue(QLatin1String("type"), ui.proxyType->currentIndex());
    settings.setValue(QLatin1String("hostName"), ui.proxyHostName->text());
    settings.setValue(QLatin1String("port"), ui.proxyPort->text());
    settings.setValue(QLatin1String("userName"), ui.proxyUserName->text());
    settings.setValue(QLatin1String("password"), ui.proxyPassword->text());
    settings.endGroup();
    MainWindow::networkAccessManager()->loadSettings();

    accept();
    qWarning( "CPrefEditDlg::slotEditData(): Geht !" );
}

void CPrefEditDlg::loadFromSettings()
{
    QSettings settings;
// Proxy
    settings.beginGroup(QLatin1String("proxy"));
    ui.proxySupport->setChecked(settings.value(QLatin1String("enabled"), false).toBool());
    ui.proxyType->setCurrentIndex(settings.value(QLatin1String("type"), 0).toInt());
    ui.proxyHostName->setText(settings.value(QLatin1String("hostName")).toString());
    ui.proxyPort->setValue(settings.value(QLatin1String("port"), 1080).toInt());
    ui.proxyUserName->setText(settings.value(QLatin1String("userName")).toString());
    ui.proxyPassword->setText(settings.value(QLatin1String("password")).toString());
    settings.endGroup();
}

