/***************************************************************************
                          opmltree.cpp  -  description
                             -------------------
    begin                : Tue 20 JAN  12 16:54:22 CET 2007
    copyright            : (C) 2007 by Harald Krippel
    email                : harald@the-develop.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <QtGui>

#include "opmltree.hpp"
#include "listviews.hpp"
#include "main.h"
#include "glcontrol.hpp"

OpmlTree::OpmlTree(QWidget *parent)
    : QTreeWidget(parent)
{

    setContextMenuPolicy ( Qt::CustomContextMenu );
    QStringList labels;
    labels << tr("Project") << tr("Type") << tr("ID");

//    header()->setResizeMode(QHeaderView::Stretch);
    header()->setResizeMode(QHeaderView::ResizeToContents);
    
    setHeaderLabels(labels);
    initRMB();
//    folderIcon.addPixmap(style()->standardPixmap(QStyle::SP_DirClosedIcon),
//                         QIcon::Normal, QIcon::Off);
//    folderIcon.addPixmap(style()->standardPixmap(QStyle::SP_DirOpenIcon),
//                         QIcon::Normal, QIcon::On);
//    bookmarkIcon.addPixmap(style()->standardPixmap(QStyle::SP_FileIcon));
}

bool OpmlTree::read(QIODevice *device)
{
    QString errorStr;
    int errorLine;
    int errorColumn;

    if (!domDocument.setContent(device, true, &errorStr, &errorLine,
                                &errorColumn)) {
        QMessageBox::information(window(), tr("DOM QCake"),
                                 tr("Parse error at line %1, column %2:\n%3")
                                 .arg(errorLine)
                                 .arg(errorColumn)
                                 .arg(errorStr));
        return false;
    }

    
    QDomElement root = domDocument.documentElement();
    if (root.tagName() != "opml") {
        QMessageBox::information(window(), tr("DOM QCake"),
                                 tr("The file is not an OPML file."));
        return false;
    } else if (root.hasAttribute("version")
               && root.attribute("version") != "1.0") {
        QMessageBox::information(window(), tr("DOM QCake"),
                                 tr("The file is not an OPML version 1.0 "
                                    "file."));
        return false;
    }

    clear();

    disconnect(this, SIGNAL(itemClicked(QTreeWidgetItem *, int)),
            this, SLOT(updateDomElement(QTreeWidgetItem *, int)));
    disconnect(this, SIGNAL( customContextMenuRequested(const QPoint)),
            this, SLOT( slotRMB( const QPoint& )));
               
    // create the tree view out of the DOM
    QDomElement child = root.firstChildElement("body");

//    FolderListItem *rootItem = new FolderListItem( this, rootItem );
//    rootItem->setText( 0,"ROOT" );
    while (!child.isNull()) {
//        parseFolderElement(child, rootItem);
        parseFolderElement(child);
        child = child.nextSiblingElement();
    }
    
    connect(this, SIGNAL(itemClicked(QTreeWidgetItem *, int)),
            this, SLOT(updateDomElement(QTreeWidgetItem *, int)));
    connect(this, SIGNAL( customContextMenuRequested(const QPoint)),
            this, SLOT( slotRMB( const QPoint& )));

    return true;
}

bool OpmlTree::write(QIODevice *device)
{
    const int IndentSize = 4;
    QDomDocument sdomdoc;

    getListView(&sdomdoc);
    QTextStream out(device);
    sdomdoc.save(out, IndentSize);
    return true;
}

void OpmlTree::parseFolderElement(const QDomElement &element, FolderListItem *parentItem)
{
    FolderListItem *thisItem = 0;
    FolderListItem *nextItem = 0;
    int a=0;
    
    QDomNode node = element.firstChild();
    while ( !node.isNull() )
    {
    	if ( node.isElement() && node.nodeName()== "outline" )
      	{
		if ( parentItem == 0 )
        	{
			thisItem = new FolderListItem( this, thisItem );
        	}
        	else
        	{
			thisItem = new FolderListItem( parentItem, thisItem );
        	}
		thisItem->setText( 0, node.toElement().attribute( "text" ) );
		thisItem->setText( 1, node.toElement().attribute( "type" ) );
		thisItem->setText( 2, node.toElement().attribute( "tmpid" ) );

        	if(g_nextid < node.toElement().attribute( "tmpid" ).toInt() )
        	{
        	  g_nextid = node.toElement().attribute( "tmpid" ).toInt();
        	}

        	for(a=0; a< node.attributes().count();a++)
        	{
//        		if(strstr(node.attributes().item(a).nodeName(),"text")==NULL &&
//        		strstr(node.attributes().item(a).nodeName(),"type")==NULL)
        		if((node.attributes().item(a).nodeName() != "text") &&
        		   (node.attributes().item(a).nodeName() != "type"))
        		{
        			nextItem = new FolderListItem( thisItem, nextItem );
                		nextItem->setText( 0, node.attributes().item(a).nodeName() );
	        		nextItem->setText( 1, node.attributes().item(a).nodeValue() );
			}
     		}                           
		// recursive build of the tree
        	parseFolderElement(node.toElement(),  thisItem);
	}
	node = node.nextSibling();
    }
    g_nextid++;
}

void OpmlTree::updateDomElement(QTreeWidgetItem *item, int column)
{
        Q_UNUSED(item);
        Q_UNUSED(column);
}
void OpmlTree::getListView(QDomDocument *domdoc)
{
    QDomElement root = domdoc->createElement( "opml" );
    domdoc->appendChild( root );

    root.setAttribute( "version", "1.0" );

    // Header
    QDomElement head = domdoc->createElement( "head" );
    root.appendChild( head );

    QDomElement title = domdoc->createElement( "title" );
    head.appendChild( title );

    QDomText t = domdoc->createTextNode( "Nonamed.xml" );
    title.appendChild( t );

    // Body
    QDomElement body = domdoc->createElement( "body" );
    root.appendChild( body );
    buildDomTree(&body,(FolderListItem *)(this->invisibleRootItem ()),domdoc);
}

void OpmlTree::buildDomTree( QDomElement *parentElement, FolderListItem *parentItem, QDomDocument *domdoc )
{
    QTreeWidgetItem *i = parentItem;
    QDomElement outline;
    int a,b;

    for(a=0; a < i->childCount (); a++) {
    QTreeWidgetItem *ichild = i->child(a);
    if(ichild != NULL) {
        if(ichild->text(1) == "OPTION" ||
         ichild->text(1) == "LAMP" ||
         ichild->text(1) == "CAMERA" ||
         ichild->text(1) == "OBJECT" ||
         ichild->text(1) == "BARRIER" ||
         ichild->text(1) == "BODY" ||
         ichild->text(1) == "PARTSYS" ||
         ichild->text(1) == "WAVESYS" ||
         ichild->text(1) == "FIRE" ||
         ichild->text(1) == "FOG" ||
         ichild->text(1) == "PLAYER" ||
         ichild->text(1) == "SKY" ||
         ichild->text(1) == "TERRAIN" ||
         ichild->text(1) == "SHADER" ||
         ichild->text(1) == "CURSOR" ||
         ichild->text(1) == "SPL" ||
         ichild->text(1) == "JS" ||
         ichild->text(1) == "PYTHON" ||
         ichild->text(1) == "SOUND" ||
         ichild->text(1) == "MEDIA" ||
         ichild->text(1) == "GUI-TXT" ||
         ichild->text(1) == "GUI-INPUT" ||
         ichild->text(1) == "GUI-BUTTON" ||
         ichild->text(1) == "GUI-OSBUTTON" ||
         ichild->text(1) == "GLOBAL" ||
         ichild->text(1) == "NETWORK" ||
         ichild->text(1) == "INTRO" ||
         ichild->text(1) == "LEVEL" ||
         ichild->text(1) == "SCENE" ||
         ichild->text(1) == "HISCORE" ||
         ichild->text(1) == "END") {
           outline = domdoc->createElement( "outline" );
           for(b=0; b< ichild->childCount (); b++) {
             QTreeWidgetItem *achild = ichild->child(b);
             if(achild != NULL) {
               if(!(achild->text(1) == "OPTION" ||
                achild->text(1) == "LAMP" ||
                achild->text(1) == "CAMERA" ||
                achild->text(1) == "OBJECT" ||
                achild->text(1) == "BARRIER" ||
                achild->text(1) == "BODY" ||
                achild->text(1) == "PARTSYS" ||
                achild->text(1) == "WAVESYS" ||
                achild->text(1) == "FIRE" ||
                achild->text(1) == "FOG" ||
                achild->text(1) == "PLAYER" ||
                achild->text(1) == "SKY" ||
                achild->text(1) == "TERRAIN" ||
                achild->text(1) == "SHADER" ||
                achild->text(1) == "CURSOR" ||
                achild->text(1) == "SPL" ||
                achild->text(1) == "JS" ||
                achild->text(1) == "PYTHON" ||
                achild->text(1) == "SOUND" ||
                achild->text(1) == "MEDIA" ||
                achild->text(1) == "GUI-TXT" ||
                achild->text(1) == "GUI-INPUT" ||
                achild->text(1) == "GUI-BUTTON" ||
                achild->text(1) == "GUI-OSBUTTON" ||
                achild->text(1) == "GLOBAL" ||
                achild->text(1) == "NETWORK" ||
                achild->text(1) == "INTRO" ||
                achild->text(1) == "LEVEL" ||
                achild->text(1) == "SCENE" ||
                achild->text(1) == "HISCORE" ||
                achild->text(1) == "END")) {
                    outline.setAttribute( achild->text(0), achild->text(1) );
                }
            }
         }
         outline.setAttribute( "tmpid", ichild->text(2) );
         outline.setAttribute( "type", ichild->text(1) );
         outline.setAttribute( "text", ichild->text(0) );
         parentElement->appendChild( outline );
        }
        QString msg = ichild->text(0) + " OK !";
        qWarning( msg.toAscii() );
        buildDomTree(&outline,(FolderListItem *)(ichild),domdoc);
     }
    }
}
// init actions
void OpmlTree::initRMB()
{
    rmbAddScene = new QAction(tr("add Scene"), this);
    rmbAddScene->setStatusTip(tr("add scene to project"));
    connect(rmbAddScene, SIGNAL(triggered()), this, SLOT(slotAddScene()));
    rmbLoadObject = new QAction(tr("load Object"), this);
    rmbLoadObject->setStatusTip(tr("load object to scene"));
    connect(rmbLoadObject, SIGNAL(triggered()), this, SLOT(slotLoadObject()));
    rmbAddBarrier = new QAction(tr("add BARRIER"), this);
    rmbAddBarrier->setStatusTip(tr("add barrier to scene"));
    connect(rmbAddBarrier, SIGNAL(triggered()), this, SLOT(slotAddBarrier()));
    rmbAddBody = new QAction(tr("add BODY"), this);
    rmbAddBody->setStatusTip(tr("add body to scene"));
    connect(rmbAddBody, SIGNAL(triggered()), this, SLOT(slotAddBody()));
    rmbAddFire = new QAction(tr("add Fire"), this);
    rmbAddFire->setStatusTip(tr("add fire to scene"));
    connect(rmbAddFire, SIGNAL(triggered()), this, SLOT(slotAddFire()));
    rmbAddPartSys = new QAction(tr("add PARTSYS"), this);
    rmbAddPartSys->setStatusTip(tr("add partikelsystem to scene"));
    connect(rmbAddPartSys, SIGNAL(triggered()), this, SLOT(slotAddPartSys()));
    rmbAddWaveSys = new QAction(tr("add WAVESYS"), this);
    rmbAddWaveSys->setStatusTip(tr("add wavesystem to scene"));
    connect(rmbAddWaveSys, SIGNAL(triggered()), this, SLOT(slotAddWaveSys()));
    rmbAddCamera = new QAction(tr("add CAMERA"), this);
    rmbAddCamera->setStatusTip(tr("add camera to scene"));
    connect(rmbAddCamera, SIGNAL(triggered()), this, SLOT(slotAddCamera()));
    rmbViewCamera = new QAction(tr("view CAMERA"), this);
    rmbViewCamera->setStatusTip(tr("view CAMERA"));
    connect(rmbViewCamera, SIGNAL(triggered()), this, SLOT(slotViewCamera()));
    rmbAddFog = new QAction(tr("add FOG"), this);
    rmbAddFog->setStatusTip(tr("add fog to scene"));
    connect(rmbAddFog, SIGNAL(triggered()), this, SLOT(slotAddFog()));
    rmbAddPlayer = new QAction(tr("add PLAYER"), this);
    rmbAddPlayer->setStatusTip(tr("add player to scene"));
    connect(rmbAddPlayer, SIGNAL(triggered()), this, SLOT(slotAddPlayer()));
    rmbAddSky = new QAction(tr("add SKY"), this);
    rmbAddSky->setStatusTip(tr("add dynamic sky to scene"));
    connect(rmbAddSky, SIGNAL(triggered()), this, SLOT(slotAddSky()));
    rmbAddShader = new QAction(tr("add Shader"), this);
    rmbAddShader->setStatusTip(tr("add shader to scene"));
    connect(rmbAddShader, SIGNAL(triggered()), this, SLOT(slotAddShader()));
    rmbAddCursor = new QAction(tr("add Cursor"), this);
    rmbAddCursor->setStatusTip(tr("add 3D Cursor to scene"));
    connect(rmbAddCursor, SIGNAL(triggered()), this, SLOT(slotAddCursor()));
    rmbAddSpl = new QAction(tr("add SPL"), this);
    rmbAddSpl->setStatusTip(tr("add SPL Script to scene"));
    connect(rmbAddSpl, SIGNAL(triggered()), this, SLOT(slotAddSpl()));
    rmbAddQts = new QAction(tr("add JS"), this);
    rmbAddQts->setStatusTip(tr("add Java Script to scene"));
    connect(rmbAddQts, SIGNAL(triggered()), this, SLOT(slotAddQts()));
    rmbAddPython = new QAction(tr("add PYTHON"), this);
    rmbAddQts->setStatusTip(tr("add Python Script to scene"));
    connect(rmbAddPython, SIGNAL(triggered()), this, SLOT(slotAddPython()));
    rmbAddSound = new QAction(tr("add SOUND"), this);
    rmbAddSound->setStatusTip(tr("add sound to scene"));
    connect(rmbAddSound, SIGNAL(triggered()), this, SLOT(slotAddSound()));
    rmbAddMedia = new QAction(tr("add MEDIA"), this);
    rmbAddMedia->setStatusTip(tr("add media to scene"));
    connect(rmbAddMedia, SIGNAL(triggered()), this, SLOT(slotAddMedia()));
    rmbAddGUITXT = new QAction(tr("add GUI-Text"), this);
    rmbAddGUITXT->setStatusTip(tr("add GUI-Text to scene"));
    connect(rmbAddGUITXT, SIGNAL(triggered()), this, SLOT(slotAddGUITXT()));
    rmbAddGUIInput = new QAction(tr("add GUI-Input"), this);
    rmbAddGUIInput->setStatusTip(tr("add GUI-Input to scene"));
    connect(rmbAddGUIInput, SIGNAL(triggered()), this, SLOT(slotAddGUIInput()));
    rmbAddGUIButton = new QAction(tr("add GUI-Button"), this);
    rmbAddGUIButton->setStatusTip(tr("add GUI-Button to scene"));
    connect(rmbAddGUIButton, SIGNAL(triggered()), this, SLOT(slotAddGUIButton()));
    rmbAddGUIOSButton = new QAction(tr("add GUI-OSButton"), this);
    rmbAddGUIOSButton->setStatusTip(tr("add GUI-OSButton to scene"));
    connect(rmbAddGUIOSButton, SIGNAL(triggered()), this, SLOT(slotAddGUIOSButton()));
    rmbAddLamp = new QAction(tr("add Lamp"), this);
    rmbAddLamp->setStatusTip(tr("add Lamp to scene"));
    connect(rmbAddLamp, SIGNAL(triggered()), this, SLOT(slotAddLamp()));
    rmbDelete = new QAction(tr("delete"), this);
    rmbDelete->setStatusTip(tr("delete the selected item"));
    connect(rmbDelete, SIGNAL(triggered()), this, SLOT(slotDelete()));
}
void OpmlTree::slotRMB( const QPoint & pos )
{
    QTreeWidgetItem *item = itemAt(pos);

   qWarning("slot RMB");

   if( item )
   {
     folderitem = item;
     if(item->text(1)=="LAMP")
     {
       QMenu menu(this);
       menu.addAction(rmbAddScene);
       menu.addAction(rmbLoadObject);
//       menu.addAction(rmbAddBarrier);
//       menu.addAction(rmbAddBody);
       menu.addAction(rmbAddFire);
       menu.addAction(rmbAddPartSys);
//       menu.addAction(rmbAddWaveSys);
//       menu.addAction(rmbAddCamera);
//       menu.addAction(rmbViewCamera);
//       menu.addAction(rmbAddFog);
//       menu.addAction(rmbAddPlayer);
//       menu.addAction(rmbAddSky);
//       menu.addAction(rmbAddShader);
//       menu.addAction(rmbAddCursor);
       menu.addAction(rmbAddSpl);
       menu.addAction(rmbAddQts);
       menu.addAction(rmbAddPython);
//       menu.addAction(rmbAddSound);
//       menu.addAction(rmbAddMedia);
//       menu.addAction(rmbAddGUITXT);
//       menu.addAction(rmbAddGUIInput);
//       menu.addAction(rmbAddGUIButton);
//       menu.addAction(rmbAddGUIOSButton);
//       menu.addAction(rmbAddLamp);
       menu.addAction(rmbDelete);
       menu.exec(mapToGlobal(pos));
     }
    if(item->text(1)=="CAMERA")
    {
       QMenu menu(this);
//       menu.addAction(rmbAddScene);
       menu.addAction(rmbLoadObject);
//       menu.addAction(rmbAddBarrier);
//       menu.addAction(rmbAddBody);
//       menu.addAction(rmbAddFire);
//       menu.addAction(rmbAddPartSys);
//       menu.addAction(rmbAddWaveSys);
//       menu.addAction(rmbAddCamera);
       menu.addAction(rmbViewCamera);
//       menu.addAction(rmbAddFog);
//       menu.addAction(rmbAddPlayer);
//       menu.addAction(rmbAddSky);
//       menu.addAction(rmbAddShader);
//       menu.addAction(rmbAddCursor);
       menu.addAction(rmbAddSpl);
       menu.addAction(rmbAddQts);
       menu.addAction(rmbAddPython);
//       menu.addAction(rmbAddSound);
//       menu.addAction(rmbAddMedia);
//       menu.addAction(rmbAddGUITXT);
//       menu.addAction(rmbAddGUIInput);
//       menu.addAction(rmbAddGUIButton);
//       menu.addAction(rmbAddGUIOSButton);
//       menu.addAction(rmbAddLamp);
       menu.addAction(rmbDelete);
       menu.exec(mapToGlobal(pos));
    }
    if(item->text(1)=="OBJECT")
    {
       QMenu menu(this);
//       menu.addAction(rmbAddScene);
       menu.addAction(rmbLoadObject);
//       menu.addAction(rmbAddBarrier);
//       menu.addAction(rmbAddBody);
       menu.addAction(rmbAddFire);
       menu.addAction(rmbAddPartSys);
       menu.addAction(rmbAddWaveSys);
       menu.addAction(rmbAddCamera);
//       menu.addAction(rmbViewCamera);
//       menu.addAction(rmbAddFog);
//       menu.addAction(rmbAddPlayer);
//       menu.addAction(rmbAddSky);
//       menu.addAction(rmbAddShader);
//       menu.addAction(rmbAddCursor);
       menu.addAction(rmbAddSpl);
       menu.addAction(rmbAddQts);
       menu.addAction(rmbAddPython);
//       menu.addAction(rmbAddSound);
//       menu.addAction(rmbAddMedia);
//       menu.addAction(rmbAddGUITXT);
//       menu.addAction(rmbAddGUIInput);
//       menu.addAction(rmbAddGUIButton);
//       menu.addAction(rmbAddGUIOSButton);
//       menu.addAction(rmbAddLamp);
       menu.addAction(rmbDelete);
       menu.exec(mapToGlobal(pos));
    }
    if(item->text(1)=="FIRE")
    {
       QMenu menu(this);
//       menu.addAction(rmbAddScene);
       menu.addAction(rmbLoadObject);
//       menu.addAction(rmbAddBarrier);
//       menu.addAction(rmbAddBody);
       menu.addAction(rmbAddFire);
       menu.addAction(rmbAddPartSys);
       menu.addAction(rmbAddWaveSys);
       menu.addAction(rmbAddCamera);
//       menu.addAction(rmbViewCamera);
//       menu.addAction(rmbAddFog);
//       menu.addAction(rmbAddPlayer);
//       menu.addAction(rmbAddSky);
//       menu.addAction(rmbAddShader);
//       menu.addAction(rmbAddCursor);
       menu.addAction(rmbAddSpl);
       menu.addAction(rmbAddQts);
       menu.addAction(rmbAddPython);
//       menu.addAction(rmbAddSound);
//       menu.addAction(rmbAddMedia);
//       menu.addAction(rmbAddGUITXT);
//       menu.addAction(rmbAddGUIInput);
//       menu.addAction(rmbAddGUIButton);
//       menu.addAction(rmbAddGUIOSButton);
//       menu.addAction(rmbAddLamp);
       menu.addAction(rmbDelete);
       menu.exec(mapToGlobal(pos));
    }
    if(item->text(1)=="PARTSYS")
    {
       QMenu menu(this);
//       menu.addAction(rmbAddScene);
       menu.addAction(rmbLoadObject);
//       menu.addAction(rmbAddBarrier);
//       menu.addAction(rmbAddBody);
       menu.addAction(rmbAddFire);
       menu.addAction(rmbAddPartSys);
       menu.addAction(rmbAddWaveSys);
       menu.addAction(rmbAddCamera);
//       menu.addAction(rmbViewCamera);
//       menu.addAction(rmbAddFog);
//       menu.addAction(rmbAddPlayer);
//       menu.addAction(rmbAddSky);
//       menu.addAction(rmbAddShader);
//       menu.addAction(rmbAddCursor);
       menu.addAction(rmbAddSpl);
       menu.addAction(rmbAddQts);
       menu.addAction(rmbAddPython);
//       menu.addAction(rmbAddSound);
//       menu.addAction(rmbAddMedia);
//       menu.addAction(rmbAddGUITXT);
//       menu.addAction(rmbAddGUIInput);
//       menu.addAction(rmbAddGUIButton);
//       menu.addAction(rmbAddGUIOSButton);
//       menu.addAction(rmbAddLamp);
       menu.addAction(rmbDelete);
       menu.exec(mapToGlobal(pos));
    }
    if(item->text(1)=="WAVESYS")
    {
       QMenu menu(this);
//       menu.addAction(rmbAddScene);
       menu.addAction(rmbLoadObject);
//       menu.addAction(rmbAddBarrier);
//       menu.addAction(rmbAddBody);
       menu.addAction(rmbAddFire);
       menu.addAction(rmbAddPartSys);
       menu.addAction(rmbAddWaveSys);
       menu.addAction(rmbAddCamera);
//       menu.addAction(rmbViewCamera);
//       menu.addAction(rmbAddFog);
//       menu.addAction(rmbAddPlayer);
//       menu.addAction(rmbAddSky);
//       menu.addAction(rmbAddShader);
//       menu.addAction(rmbAddCursor);
//       menu.addAction(rmbAddSpl);
//       menu.addAction(rmbAddQts);
//       menu.addAction(rmbAddPython);
//       menu.addAction(rmbAddSound);
//       menu.addAction(rmbAddMedia);
//       menu.addAction(rmbAddGUITXT);
//       menu.addAction(rmbAddGUIInput);
//       menu.addAction(rmbAddGUIButton);
//       menu.addAction(rmbAddGUIOSButton);
//       menu.addAction(rmbAddLamp);
       menu.addAction(rmbDelete);
       menu.exec(mapToGlobal(pos));
    }
    if(item->text(1)=="FOG")
    {
       QMenu menu(this);
//       menu.addAction(rmbAddScene);
//       menu.addAction(rmbLoadObject);
//       menu.addAction(rmbAddBarrier);
//       menu.addAction(rmbAddBody);
//       menu.addAction(rmbAddFire);
//       menu.addAction(rmbAddPartSys);
//       menu.addAction(rmbAddWaveSys);
//       menu.addAction(rmbAddCamera);
//       menu.addAction(rmbViewCamera);
//       menu.addAction(rmbAddFog);
//       menu.addAction(rmbAddPlayer);
//       menu.addAction(rmbAddSky);
//       menu.addAction(rmbAddShader);
//       menu.addAction(rmbAddCursor);
       menu.addAction(rmbAddSpl);
       menu.addAction(rmbAddQts);
       menu.addAction(rmbAddPython);
//       menu.addAction(rmbAddSound);
//       menu.addAction(rmbAddMedia);
//       menu.addAction(rmbAddGUITXT);
//       menu.addAction(rmbAddGUIInput);
//       menu.addAction(rmbAddGUIButton);
//       menu.addAction(rmbAddGUIOSButton);
//       menu.addAction(rmbAddLamp);
       menu.addAction(rmbDelete);
       menu.exec(mapToGlobal(pos));
    }
    if(item->text(1)=="INTRO")
    {
       QMenu menu(this);
       menu.addAction(rmbAddScene);
//       menu.addAction(rmbLoadObject);
//       menu.addAction(rmbAddBarrier);
//       menu.addAction(rmbAddBody);
//       menu.addAction(rmbAddFire);
//       menu.addAction(rmbAddPartSys);
//       menu.addAction(rmbAddWaveSys);
//       menu.addAction(rmbAddCamera);
//       menu.addAction(rmbViewCamera);
//       menu.addAction(rmbAddFog);
//       menu.addAction(rmbAddPlayer);
//       menu.addAction(rmbAddSky);
//       menu.addAction(rmbAddShader);
//       menu.addAction(rmbAddCursor);
//       menu.addAction(rmbAddSpl);
//       menu.addAction(rmbAddQts);
//       menu.addAction(rmbAddPython);
//       menu.addAction(rmbAddSound);
//       menu.addAction(rmbAddMedia);
//       menu.addAction(rmbAddGUITXT);
//       menu.addAction(rmbAddGUIInput);
//       menu.addAction(rmbAddGUIButton);
//       menu.addAction(rmbAddGUIOSButton);
//       menu.addAction(rmbAddLamp);
//       menu.addAction(rmbDelete);
       menu.exec(mapToGlobal(pos));
    }
    if(item->text(1)=="PLAYER")
    {
       QMenu menu(this);
//       menu.addAction(rmbAddScene);
       menu.addAction(rmbLoadObject);
//       menu.addAction(rmbAddBarrier);
//       menu.addAction(rmbAddBody);
       menu.addAction(rmbAddFire);
       menu.addAction(rmbAddPartSys);
       menu.addAction(rmbAddWaveSys);
//       menu.addAction(rmbAddCamera);
//       menu.addAction(rmbViewCamera);
//       menu.addAction(rmbAddFog);
//       menu.addAction(rmbAddPlayer);
//       menu.addAction(rmbAddSky);
//       menu.addAction(rmbAddShader);
//       menu.addAction(rmbAddCursor);
       menu.addAction(rmbAddSpl);
       menu.addAction(rmbAddQts);
       menu.addAction(rmbAddPython);
//       menu.addAction(rmbAddSound);
//       menu.addAction(rmbAddMedia);
//       menu.addAction(rmbAddGUITXT);
//       menu.addAction(rmbAddGUIInput);
//       menu.addAction(rmbAddGUIButton);
//       menu.addAction(rmbAddGUIOSButton);
//       menu.addAction(rmbAddLamp);
       menu.addAction(rmbDelete);
       menu.exec(mapToGlobal(pos));
    }
    if(item->text(1)=="SCENE")
    {
       QMenu menu(this);
//       menu.addAction(rmbAddScene);
       menu.addAction(rmbLoadObject);
       menu.addAction(rmbAddBarrier);
       menu.addAction(rmbAddBody);
       menu.addAction(rmbAddFire);
       menu.addAction(rmbAddPartSys);
       menu.addAction(rmbAddWaveSys);
       menu.addAction(rmbAddCamera);
//       menu.addAction(rmbViewCamera);
       menu.addAction(rmbAddFog);
       menu.addAction(rmbAddPlayer);
       menu.addAction(rmbAddSky);
       menu.addAction(rmbAddShader);
       menu.addAction(rmbAddCursor);
       menu.addAction(rmbAddSpl);
       menu.addAction(rmbAddQts);
       menu.addAction(rmbAddPython);
       menu.addAction(rmbAddSound);
       menu.addAction(rmbAddMedia);
       menu.addAction(rmbAddGUITXT);
       menu.addAction(rmbAddGUIInput);
       menu.addAction(rmbAddGUIButton);
       menu.addAction(rmbAddGUIOSButton);
       menu.addAction(rmbAddLamp);
       menu.exec(mapToGlobal(pos));
//       menu.addAction(rmbDelete);
    }
    if(item->text(1)=="LEVEL")
    {
       QMenu menu(this);
       menu.addAction(rmbAddScene);
//       menu.addAction(rmbLoadObject);
//       menu.addAction(rmbAddBarrier);
//       menu.addAction(rmbAddBody);
//       menu.addAction(rmbAddFire);
//       menu.addAction(rmbAddPartSys);
//       menu.addAction(rmbAddWaveSys);
//       menu.addAction(rmbAddCamera);
//       menu.addAction(rmbViewCamera);
//       menu.addAction(rmbAddFog);
//       menu.addAction(rmbAddPlayer);
//       menu.addAction(rmbAddSky);
//       menu.addAction(rmbAddShader);
//       menu.addAction(rmbAddCursor);
//       menu.addAction(rmbAddSpl);
//       menu.addAction(rmbAddQts);
//       menu.addAction(rmbAddPython);
//       menu.addAction(rmbAddSound);
//       menu.addAction(rmbAddMedia);
//       menu.addAction(rmbAddGUITXT);
//       menu.addAction(rmbAddGUIInput);
//       menu.addAction(rmbAddGUIButton);
//       menu.addAction(rmbAddGUIOSButton);
//       menu.addAction(rmbAddLamp);
//       menu.addAction(rmbDelete);
       menu.exec(mapToGlobal(pos));
    }
    if(item->text(1)=="BARRIER")
    {
       QMenu menu(this);
//       menu.addAction(rmbAddScene);
       menu.addAction(rmbLoadObject);
//       menu.addAction(rmbAddBarrier);
//       menu.addAction(rmbAddBody);
       menu.addAction(rmbAddFire);
       menu.addAction(rmbAddPartSys);
       menu.addAction(rmbAddWaveSys);
       menu.addAction(rmbAddCamera);
//       menu.addAction(rmbViewCamera);
//       menu.addAction(rmbAddFog);
//       menu.addAction(rmbAddPlayer);
//       menu.addAction(rmbAddSky);
//       menu.addAction(rmbAddShader);
//       menu.addAction(rmbAddCursor);
       menu.addAction(rmbAddSpl);
       menu.addAction(rmbAddQts);
       menu.addAction(rmbAddPython);
//       menu.addAction(rmbAddSound);
//       menu.addAction(rmbAddMedia);
//       menu.addAction(rmbAddGUITXT);
//       menu.addAction(rmbAddGUIInput);
//       menu.addAction(rmbAddGUIButton);
//       menu.addAction(rmbAddGUIOSButton);
//       menu.addAction(rmbAddLamp);
       menu.addAction(rmbDelete);
       menu.exec(mapToGlobal(pos));
    }
    if(item->text(1)=="END")
    {
       QMenu menu(this);
       menu.addAction(rmbAddScene);
//       menu.addAction(rmbLoadObject);
//       menu.addAction(rmbAddBarrier);
//       menu.addAction(rmbAddBody);
//       menu.addAction(rmbAddFire);
//       menu.addAction(rmbAddPartSys);
//       menu.addAction(rmbAddWaveSys);
//       menu.addAction(rmbAddCamera);
//       menu.addAction(rmbViewCamera);
//       menu.addAction(rmbAddFog);
//       menu.addAction(rmbAddPlayer);
//       menu.addAction(rmbAddSky);
//       menu.addAction(rmbAddShader);
//       menu.addAction(rmbAddCursor);
//       menu.addAction(rmbAddSpl);
//       menu.addAction(rmbAddQts);
//       menu.addAction(rmbAddPython);
//       menu.addAction(rmbAddSound);
//       menu.addAction(rmbAddMedia);
//       menu.addAction(rmbAddGUITXT);
//       menu.addAction(rmbAddGUIInput);
//       menu.addAction(rmbAddGUIButton);
//       menu.addAction(rmbAddGUIOSButton);
//       menu.addAction(rmbAddLamp);
//       menu.addAction(rmbDelete);
       menu.exec(mapToGlobal(pos));
    }
    if(item->text(1)=="OPTION")
    {
       QMenu menu(this);
       menu.addAction(rmbAddScene);
//       menu.addAction(rmbLoadObject);
//       menu.addAction(rmbAddBarrier);
//       menu.addAction(rmbAddBody);
//       menu.addAction(rmbAddFire);
//       menu.addAction(rmbAddPartSys);
//       menu.addAction(rmbAddWaveSys);
//       menu.addAction(rmbAddCamera);
//       menu.addAction(rmbViewCamera);
//       menu.addAction(rmbAddFog);
//       menu.addAction(rmbAddPlayer);
//       menu.addAction(rmbAddSky);
//       menu.addAction(rmbAddShader);
//       menu.addAction(rmbAddCursor);
//       menu.addAction(rmbAddSpl);
//       menu.addAction(rmbAddQts);
//       menu.addAction(rmbAddPython);
//       menu.addAction(rmbAddSound);
//       menu.addAction(rmbAddMedia);
//       menu.addAction(rmbAddGUITXT);
//       menu.addAction(rmbAddGUIInput);
//       menu.addAction(rmbAddGUIButton);
//       menu.addAction(rmbAddGUIOSButton);
//       menu.addAction(rmbAddLamp);
//       menu.addAction(rmbDelete);
       menu.exec(mapToGlobal(pos));
    }
    if(item->text(1)=="BODY")
    {
       QMenu menu(this);
//       menu.addAction(rmbAddScene);
       menu.addAction(rmbLoadObject);
//       menu.addAction(rmbAddBarrier);
//       menu.addAction(rmbAddBody);
       menu.addAction(rmbAddFire);
       menu.addAction(rmbAddPartSys);
       menu.addAction(rmbAddWaveSys);
//       menu.addAction(rmbAddCamera);
//       menu.addAction(rmbViewCamera);
//       menu.addAction(rmbAddFog);
//       menu.addAction(rmbAddPlayer);
//       menu.addAction(rmbAddSky);
//       menu.addAction(rmbAddShader);
//       menu.addAction(rmbAddCursor);
       menu.addAction(rmbAddSpl);
       menu.addAction(rmbAddQts);
       menu.addAction(rmbAddPython);
//       menu.addAction(rmbAddSound);
//       menu.addAction(rmbAddMedia);
//       menu.addAction(rmbAddGUITXT);
//       menu.addAction(rmbAddGUIInput);
//       menu.addAction(rmbAddGUIButton);
//       menu.addAction(rmbAddGUIOSButton);
//       menu.addAction(rmbAddLamp);
       menu.addAction(rmbDelete);
       menu.exec(mapToGlobal(pos));
    }
    if(item->text(1)=="SKY")
    {
       QMenu menu(this);
//       menu.addAction(rmbAddScene);
//       menu.addAction(rmbLoadObject);
//       menu.addAction(rmbAddBarrier);
//       menu.addAction(rmbAddBody);
//       menu.addAction(rmbAddFire);
//       menu.addAction(rmbAddPartSys);
//       menu.addAction(rmbAddWaveSys);
//       menu.addAction(rmbAddCamera);
//       menu.addAction(rmbViewCamera);
//       menu.addAction(rmbAddFog);
//       menu.addAction(rmbAddPlayer);
//       menu.addAction(rmbAddSky);
//       menu.addAction(rmbAddShader);
//       menu.addAction(rmbAddCursor);
       menu.addAction(rmbAddSpl);
       menu.addAction(rmbAddQts);
       menu.addAction(rmbAddPython);
//       menu.addAction(rmbAddSound);
//       menu.addAction(rmbAddMedia);
//       menu.addAction(rmbAddGUITXT);
//       menu.addAction(rmbAddGUIInput);
//       menu.addAction(rmbAddGUIButton);
//       menu.addAction(rmbAddGUIOSButton);
//       menu.addAction(rmbAddLamp);
       menu.addAction(rmbDelete);
       menu.exec(mapToGlobal(pos));
    }
    if(item->text(1)=="HISCORE")
    {
       QMenu menu(this);
       menu.addAction(rmbAddScene);
//       menu.addAction(rmbLoadObject);
//       menu.addAction(rmbAddBarrier);
//       menu.addAction(rmbAddBody);
//       menu.addAction(rmbAddFire);
//       menu.addAction(rmbAddPartSys);
//       menu.addAction(rmbAddWaveSys);
//       menu.addAction(rmbAddCamera);
//       menu.addAction(rmbViewCamera);
//       menu.addAction(rmbAddFog);
//       menu.addAction(rmbAddPlayer);
//       menu.addAction(rmbAddSky);
//       menu.addAction(rmbAddShader);
//       menu.addAction(rmbAddCursor);
//       menu.addAction(rmbAddSpl);
//       menu.addAction(rmbAddQts);
//       menu.addAction(rmbAddPython);
//       menu.addAction(rmbAddSound);
//       menu.addAction(rmbAddMedia);
//       menu.addAction(rmbAddGUITXT);
//       menu.addAction(rmbAddGUIInput);
//       menu.addAction(rmbAddGUIButton);
//       menu.addAction(rmbAddGUIOSButton);
//       menu.addAction(rmbAddLamp);
//       menu.addAction(rmbDelete);
       menu.exec(mapToGlobal(pos));
    }
    if(item->text(1)=="SOUND")
    {
       QMenu menu(this);
//       menu.addAction(rmbAddScene);
       menu.addAction(rmbLoadObject);
//       menu.addAction(rmbAddBarrier);
//       menu.addAction(rmbAddBody);
       menu.addAction(rmbAddFire);
       menu.addAction(rmbAddPartSys);
       menu.addAction(rmbAddWaveSys);
//       menu.addAction(rmbAddCamera);
//       menu.addAction(rmbViewCamera);
//       menu.addAction(rmbAddFog);
//       menu.addAction(rmbAddPlayer);
//       menu.addAction(rmbAddSky);
//       menu.addAction(rmbAddShader);
//       menu.addAction(rmbAddCursor);
       menu.addAction(rmbAddSpl);
       menu.addAction(rmbAddQts);
       menu.addAction(rmbAddPython);
//       menu.addAction(rmbAddSound);
//       menu.addAction(rmbAddMedia);
//       menu.addAction(rmbAddGUITXT);
//       menu.addAction(rmbAddGUIInput);
//       menu.addAction(rmbAddGUIButton);
//       menu.addAction(rmbAddGUIOSButton);
//       menu.addAction(rmbAddLamp);
       menu.addAction(rmbDelete);
       menu.exec(mapToGlobal(pos));
    }
    if(item->text(1)=="MEDIA")
    {
       QMenu menu(this);
//       menu.addAction(rmbAddScene);
       menu.addAction(rmbLoadObject);
//       menu.addAction(rmbAddBarrier);
//       menu.addAction(rmbAddBody);
       menu.addAction(rmbAddFire);
       menu.addAction(rmbAddPartSys);
       menu.addAction(rmbAddWaveSys);
//       menu.addAction(rmbAddCamera);
//       menu.addAction(rmbViewCamera);
//       menu.addAction(rmbAddFog);
//       menu.addAction(rmbAddPlayer);
//       menu.addAction(rmbAddSky);
//       menu.addAction(rmbAddShader);
//       menu.addAction(rmbAddCursor);
       menu.addAction(rmbAddSpl);
       menu.addAction(rmbAddQts);
       menu.addAction(rmbAddPython);
//       menu.addAction(rmbAddSound);
//       menu.addAction(rmbAddMedia);
//       menu.addAction(rmbAddGUITXT);
//       menu.addAction(rmbAddGUIInput);
//       menu.addAction(rmbAddGUIButton);
//       menu.addAction(rmbAddGUIOSButton);
//       menu.addAction(rmbAddLamp);
       menu.addAction(rmbDelete);
       menu.exec(mapToGlobal(pos));
    }
    if(item->text(1)=="SPL")
    {
       QMenu menu(this);
//       menu.addAction(rmbAddScene);
//       menu.addAction(rmbLoadObject);
//       menu.addAction(rmbAddBarrier);
//       menu.addAction(rmbAddBody);
//       menu.addAction(rmbAddFire);
//       menu.addAction(rmbAddPartSys);
//       menu.addAction(rmbAddWaveSys);
//       menu.addAction(rmbAddCamera);
//       menu.addAction(rmbViewCamera);
//       menu.addAction(rmbAddFog);
//       menu.addAction(rmbAddPlayer);
//       menu.addAction(rmbAddSky);
//       menu.addAction(rmbAddShader);
//       menu.addAction(rmbAddCursor);
       menu.addAction(rmbAddSpl);
//       menu.addAction(rmbAddQts);
//       menu.addAction(rmbAddPython);
//       menu.addAction(rmbAddSound);
//       menu.addAction(rmbAddMedia);
//       menu.addAction(rmbAddGUITXT);
//       menu.addAction(rmbAddGUIInput);
//       menu.addAction(rmbAddGUIButton);
//       menu.addAction(rmbAddGUIOSButton);
//       menu.addAction(rmbAddLamp);
       menu.addAction(rmbDelete);
       menu.exec(mapToGlobal(pos));
    }
    if(item->text(1)=="JS")
    {
       QMenu menu(this);
//       menu.addAction(rmbAddScene);
//       menu.addAction(rmbLoadObject);
//       menu.addAction(rmbAddBarrier);
//       menu.addAction(rmbAddBody);
//       menu.addAction(rmbAddFire);
//       menu.addAction(rmbAddPartSys);
//       menu.addAction(rmbAddWaveSys);
//       menu.addAction(rmbAddCamera);
//       menu.addAction(rmbViewCamera);
//       menu.addAction(rmbAddFog);
//       menu.addAction(rmbAddPlayer);
//       menu.addAction(rmbAddSky);
//       menu.addAction(rmbAddShader);
//       menu.addAction(rmbAddCursor);
//       menu.addAction(rmbAddSpl);
       menu.addAction(rmbAddQts);
//       menu.addAction(rmbAddPython);
//       menu.addAction(rmbAddSound);
//       menu.addAction(rmbAddMedia);
//       menu.addAction(rmbAddGUITXT);
//       menu.addAction(rmbAddGUIInput);
//       menu.addAction(rmbAddGUIButton);
//       menu.addAction(rmbAddGUIOSButton);
//       menu.addAction(rmbAddLamp);
       menu.addAction(rmbDelete);
       menu.exec(mapToGlobal(pos));
    }
    if(item->text(1)=="GLOBAL")
    {
       QMenu menu(this);
//       menu.addAction(rmbAddScene);
//       menu.addAction(rmbLoadObject);
//       menu.addAction(rmbAddBarrier);
//       menu.addAction(rmbAddBody);
//       menu.addAction(rmbAddFire);
//       menu.addAction(rmbAddPartSys);
//       menu.addAction(rmbAddWaveSys);
//       menu.addAction(rmbAddCamera);
//       menu.addAction(rmbViewCamera);
//       menu.addAction(rmbAddFog);
//       menu.addAction(rmbAddPlayer);
//       menu.addAction(rmbAddSky);
//       menu.addAction(rmbAddShader);
//       menu.addAction(rmbAddCursor);
//       menu.addAction(rmbAddSpl);
//       menu.addAction(rmbAddQts);
//       menu.addAction(rmbAddPython);
//       menu.addAction(rmbAddSound);
//       menu.addAction(rmbAddMedia);
//       menu.addAction(rmbAddGUITXT);
//       menu.addAction(rmbAddGUIInput);
//       menu.addAction(rmbAddGUIButton);
//       menu.addAction(rmbAddGUIOSButton);
//       menu.addAction(rmbAddLamp);
//       menu.addAction(rmbDelete);
       menu.exec(mapToGlobal(pos));
    }
    if(item->text(1)=="SHADER")
    {
       QMenu menu(this);
//       menu.addAction(rmbAddScene);
//       menu.addAction(rmbLoadObject);
//       menu.addAction(rmbAddBarrier);
//       menu.addAction(rmbAddBody);
//       menu.addAction(rmbAddFire);
//       menu.addAction(rmbAddPartSys);
//       menu.addAction(rmbAddWaveSys);
//       menu.addAction(rmbAddCamera);
//       menu.addAction(rmbViewCamera);
//       menu.addAction(rmbAddFog);
//       menu.addAction(rmbAddPlayer);
//       menu.addAction(rmbAddSky);
//       menu.addAction(rmbAddShader);
//       menu.addAction(rmbAddCursor);
       menu.addAction(rmbAddSpl);
       menu.addAction(rmbAddQts);
       menu.addAction(rmbAddPython);
//       menu.addAction(rmbAddSound);
//       menu.addAction(rmbAddMedia);
//       menu.addAction(rmbAddGUITXT);
//       menu.addAction(rmbAddGUIInput);
//       menu.addAction(rmbAddGUIButton);
//       menu.addAction(rmbAddGUIOSButton);
//       menu.addAction(rmbAddLamp);
       menu.addAction(rmbDelete);
       menu.exec(mapToGlobal(pos));
    }
    if(item->text(1)=="CURSOR")
    {
       QMenu menu(this);
//       menu.addAction(rmbAddScene);
//       menu.addAction(rmbLoadObject);
//       menu.addAction(rmbAddBarrier);
//       menu.addAction(rmbAddBody);
//       menu.addAction(rmbAddFire);
//       menu.addAction(rmbAddPartSys);
//       menu.addAction(rmbAddWaveSys);
//       menu.addAction(rmbAddCamera);
//       menu.addAction(rmbViewCamera);
//       menu.addAction(rmbAddFog);
//       menu.addAction(rmbAddPlayer);
//       menu.addAction(rmbAddSky);
//       menu.addAction(rmbAddShader);
//       menu.addAction(rmbAddCursor);
       menu.addAction(rmbAddSpl);
       menu.addAction(rmbAddQts);
       menu.addAction(rmbAddPython);
//       menu.addAction(rmbAddSound);
//       menu.addAction(rmbAddMedia);
//       menu.addAction(rmbAddGUITXT);
//       menu.addAction(rmbAddGUIInput);
//       menu.addAction(rmbAddGUIButton);
//       menu.addAction(rmbAddGUIOSButton);
//       menu.addAction(rmbAddLamp);
       menu.addAction(rmbDelete);
       menu.exec(mapToGlobal(pos));
    }
   }
}

void OpmlTree::slotViewCamera()
{
    qWarning( "Slot ViewCamera  !" );

       if(folderitem != NULL)
       {
          qWarning( "Object ok  !" );
          ((FolderListItem *)folderitem)->viewCamera();
       }
}

void OpmlTree::slotLoadObject()
{
    qWarning( "Slot LoadObject  !" );

       if(folderitem != NULL)
       {
          qWarning( "Object ok  !" );
          ((FolderListItem *)folderitem)->addObject("OBJECT");
       }          
}

void OpmlTree::slotAddBarrier()
{
    qWarning( "Slot AddBarrier  !" );

       if(folderitem != NULL)
       {
          qWarning( "Object ok  !" );
          ((FolderListItem *)folderitem)->addObject("BARRIER");
       }
}

void OpmlTree::slotAddBody()
{
    qWarning( "Slot AddBody  !" );

       if(folderitem != NULL)
       {
          qWarning( "Object ok  !" );
          ((FolderListItem *)folderitem)->addObject("BODY");
       }
}

void OpmlTree::slotAddLamp()
{
    qWarning( "Slot AddLamp  !" );

       if(folderitem != NULL)
       {
          qWarning( "Object ok  !" );
          ((FolderListItem *)folderitem)->addObject("LAMP");
       }
}

void OpmlTree::slotAddFire()
{
    qWarning( "Slot AddFire  !" );

       if(folderitem != NULL)
       {
          qWarning( "Object ok  !" );
          ((FolderListItem *)folderitem)->addObject("FIRE");
       }
}

void OpmlTree::slotAddPartSys()
{
    qWarning( "Slot AddPartSys  !" );

       if(folderitem != NULL)
       {
          qWarning( "Object ok  !" );
          ((FolderListItem *)folderitem)->addObject("PARTSYS");
       }
}

void OpmlTree::slotAddWaveSys()
{
    qWarning( "Slot AddWaveSys  !" );

       if(folderitem != NULL)
       {
          qWarning( "Object ok  !" );
          ((FolderListItem *)folderitem)->addObject("WAVESYS");
       }
}

void OpmlTree::slotAddCamera()
{
    qWarning( "Slot AddCamera  !" );

       if(folderitem != NULL)
       {
          qWarning( "Object ok  !" );
          ((FolderListItem *)folderitem)->addObject("CAMERA");
       }
}

void OpmlTree::slotAddFog()
{
    qWarning( "Slot AddFog  !" );

       if(folderitem != NULL)
       {
          qWarning( "Object ok  !" );
          ((FolderListItem *)folderitem)->addObject("FOG");
       }
}

void OpmlTree::slotAddPlayer()
{
    qWarning( "Slot AddPlayer  !" );

       if(folderitem != NULL)
       {
          qWarning( "Object ok  !" );
          ((FolderListItem *)folderitem)->addObject("PLAYER");
       }
}

void OpmlTree::slotAddSky()
{
    qWarning( "Slot AddSky  !" );

       if(folderitem != NULL)
       {
          qWarning( "Object ok  !" );
          ((FolderListItem *)folderitem)->addObject("SKY");
       }
}

void OpmlTree::slotAddScene()
{
    qWarning( "Slot AddScene  !" );

       if(folderitem != NULL)
       {
          qWarning( "Object ok  !" );
          ((FolderListItem *)folderitem)->addObject("SCENE");
       }
}

void OpmlTree::slotAddShader()
{
    qWarning( "Slot AddShader  !" );

       if(folderitem != NULL)
       {
          qWarning( "Object ok  !" );
          ((FolderListItem *)folderitem)->addObject("SHADER");
       }
}

void OpmlTree::slotAddCursor()
{
    qWarning( "Slot AddCursor  !" );

       if(folderitem != NULL)
       {
          qWarning( "Object ok  !" );
          ((FolderListItem *)folderitem)->addObject("CURSOR");
       }
}

void OpmlTree::slotAddSpl()
{
    qWarning( "Slot AddSpl  !" );

       if(folderitem != NULL)
       {
          qWarning( "Object ok  !" );
          ((FolderListItem *)folderitem)->addObject("SPL");
       }
}

void OpmlTree::slotAddQts()
{
    qWarning( "Slot AddQts  !" );

       if(folderitem != NULL)
       {
          qWarning( "Object ok  !" );
          ((FolderListItem *)folderitem)->addObject("JS");
       }
}

void OpmlTree::slotAddPython()
{
    qWarning( "Slot AddPython  !" );

       if(folderitem != NULL)
       {
          qWarning( "Object ok  !" );
          ((FolderListItem *)folderitem)->addObject("PYTHON");
       }
}

void OpmlTree::slotAddSound()
{
    qWarning( "Slot AddSound  !" );

       if(folderitem != NULL)
       {
          qWarning( "Object ok  !" );
          ((FolderListItem *)folderitem)->addObject("SOUND");
       }
}

void OpmlTree::slotAddMedia()
{
    qWarning( "Slot AddMedia  !" );

       if(folderitem != NULL)
       {
          qWarning( "Object ok  !" );
          ((FolderListItem *)folderitem)->addObject("MEDIA");
       }
}

void OpmlTree::slotAddGUITXT()
{
    qWarning( "Slot AddGUITXT  !" );

       if(folderitem != NULL)
       {
          qWarning( "Object ok  !" );
          ((FolderListItem *)folderitem)->addObject("GUI-TXT");
       }
}

void OpmlTree::slotAddGUIInput()
{
    qWarning( "Slot AddGUIInput  !" );

       if(folderitem != NULL)
       {
          qWarning( "Object ok  !" );
          ((FolderListItem *)folderitem)->addObject("GUI-INPUT");
       }
}

void OpmlTree::slotAddGUIButton()
{
    qWarning( "Slot AddGUIButton  !" );

       if(folderitem != NULL)
       {
          qWarning( "Object ok  !" );
          ((FolderListItem *)folderitem)->addObject("GUI-BUTTON");
       }
}

void OpmlTree::slotAddGUIOSButton()
{
    qWarning( "Slot AddGUIOSButton  !" );

       if(folderitem != NULL)
       {
          qWarning( "Object ok  !" );
          ((FolderListItem *)folderitem)->addObject("GUI-OSBUTTON");
       }
}

void OpmlTree::slotDelete()
{
    qWarning( "Slot Delete  !" );

       if(folderitem != NULL)
       {
          qWarning( "Delete ok experimental !" );
          FolderListItem * myparent = (FolderListItem *)folderitem->parent ();
          myparent->takeChild ( myparent->indexOfChild ((FolderListItem *)folderitem ) );
          g_gl->redrawScene();
          if(folderitem != NULL){
           //    delete folderitem;  // nessesary h.k.
          }
       }
}

int OpmlTree::getScene()
{
  QList<QTreeWidgetItem *> foundlst=findItems("GLOBAL",Qt::MatchFixedString,1);
  if(!foundlst.isEmpty()){
	return ((FolderListItem *)(foundlst.first ()))->GetValue("sscene").toInt();
  }
  qWarning( "cannt find GLOBAL -> sscene");
  qWarning( "use id %i",DEFAULTSTARTID);
  return DEFAULTSTARTID; // Scene1
}

FolderListItem *OpmlTree::getStart()
{
  int mid=0;
  FolderListItem * i=NULL;

  mid =  getScene();
  i=((FolderListItem *)invisibleRootItem ())->search_id((FolderListItem *) invisibleRootItem (),mid);
  if(i != NULL && i->text(1) == "SCENE"){
     return i;
  }
  qWarning( "cant find Start ID %i, i use default ID %i",mid,DEFAULTSTARTID);
  mid = DEFAULTSTARTID;
  i=((FolderListItem *)invisibleRootItem ())->search_id((FolderListItem *) invisibleRootItem (), mid);
  if(i != NULL && i->text(1) == "SCENE"){
     return i;
  }
  qWarning( "cant find default Start ID %i, I will use the first scene",mid);

  QList<QTreeWidgetItem *> foundlst=findItems("SCENE",Qt::MatchFixedString,1);
  if(!foundlst.isEmpty()){
	return ((FolderListItem *)(foundlst.first ()));
  }
  QMessageBox::about(this,tr("Exit..."),
                     tr("QCake\n Version " QCAKEVERSION
                     "\nI cant finde the start scene, aborting"));
  qWarning( "exit");
  exit ( 0 ) ; // error
  return NULL; // Scene1
}
