/****************************************************************************
**
** Copyright (C) 2019 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
****************************************************************************/

#pragma once

#include <qmlitemnode.h>

#include <QDir>
#include <QObject>
#include <QStringList>
#include <QUrl>
#include <QtQml>

class FileResourcesModel : public QObject
{
    Q_OBJECT

    Q_PROPERTY(QString fileName READ fileName WRITE setFileNameStr NOTIFY fileNameChanged)
    Q_PROPERTY(QString filter READ filter WRITE setFilter)
    Q_PROPERTY(QVariant modelNodeBackendProperty READ modelNodeBackend WRITE setModelNodeBackend NOTIFY modelNodeBackendChanged)
    Q_PROPERTY(QUrl path READ path WRITE setPath)
    Q_PROPERTY(QUrl docPath READ docPath)
    Q_PROPERTY(QStringList fullPathModel READ fullPathModel NOTIFY fullPathModelChanged)
    Q_PROPERTY(QStringList fileNameModel READ fileNameModel NOTIFY fileNameModelChanged)

public:
    explicit FileResourcesModel(QObject *parent = nullptr);

    void setModelNodeBackend(const QVariant &modelNodeBackend);
    QString fileName() const;
    void setFileName(const QUrl &fileName);
    void setFileNameStr(const QString &fileName);
    void setPath(const QUrl &url);
    QUrl path() const;
    QUrl docPath() const;
    void setFilter(const QString &filter);
    QString filter() const;
    QStringList fullPathModel() const;
    QStringList fileNameModel() const;
    void setupModel();
    void refreshModel();

    Q_INVOKABLE void openFileDialog();

    static void registerDeclarativeType();

signals:
    void fileNameChanged(const QUrl &fileName);
    void modelNodeBackendChanged();
    void fullPathModelChanged();
    void fileNameModelChanged();

private:
    QVariant modelNodeBackend() const;

private:
    QUrl m_fileName;
    QUrl m_path;
    QDir m_dirPath;
    QDir m_docPath;
    QString m_filter;
    QString m_currentPath;
    QString m_lastResourcePath;
    QStringList m_fullPathModel;
    QStringList m_fileNameModel;
};

QML_DECLARE_TYPE(FileResourcesModel)
