/*
  const.hh, copyright (c) 2006 by Vincent Fourmond: 
  The class definitions for constant values.
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details (in the COPYING file).
  
*/

/* expression.hh should be included */

namespace SCalc {
  /** 
      The class that represents a value 
  */
  class Const : public  Expression {
  protected:
    double value;
  public:
    Const(Session * s, double v) : Expression(s) {value = v;};
    virtual ~Const() {;};
    virtual double evaluate(const double *, const double *) { return value;};
    virtual void dump(::std::ostream & stream);

    /// Const-related functions
    virtual int is_null() { return value == 0;};
    virtual int is_id() { return value == 1.0;};
    virtual int is_const() { return 1;};

    virtual Expression * copy() { return new Const(session(), value);};

    virtual std::string pretty_print(); 

  };

  class Null : public Expression {
  public:
    Null(Session * s) : Expression(s) {;};
    virtual ~Null() {;};
    virtual double evaluate(const double *, const double *) { return 0.0;};
    virtual void dump(::std::ostream & stream);

    /// Const-related functions
    virtual int is_null() { return 1;};
    virtual int is_const() { return 1;};

    virtual Expression * copy() { return new Null(session());};
    virtual std::string pretty_print() {return std::string("0");};
  };
};
