// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2008 - INRIA - Pierre MARECHAL <pierre.marechal@inria.fr>
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- CLI SHELL MODE -->

// Tests 1
// =============================================================================

// test 1.1

A = [0 1 0 1];
B = [0 0 1 1];
C = [0 1 1 1];

if or(bitor(A, B) <> C)  then pause, end
if typeof(C) <> typeof(A) then pause, end
if typeof(C) <> typeof(B) then pause, end

// test 1.2

A = uint8([0 1 0 1]);
B = uint8([0 0 1 1]);
C = uint8([0 1 1 1]);

if or(bitor(A, B) <> C)  then pause, end
if typeof(C) <> typeof(A) then pause, end
if typeof(C) <> typeof(B) then pause, end

// test 1.3

A = uint16([0 1 0 1]);
B = uint16([0 0 1 1]);
C = uint16([0 1 1 1]);

if or(bitor(A, B) <> C)  then pause, end
if typeof(C) <> typeof(A) then pause, end
if typeof(C) <> typeof(B) then pause, end

// test 1.4

A = uint32([0 1 0 1]);
B = uint32([0 0 1 1]);
C = uint32([0 1 1 1]);

if or(bitor(A, B) <> C)  then pause, end
if typeof(C) <> typeof(A) then pause, end
if typeof(C) <> typeof(B) then pause, end

// test 1.5

A = [0 1 ; 0 1];
B = [0 0 ; 1 1];
C = [0 1 ; 1 1];

if or(bitor(A, B) <> C)  then pause, end
if typeof(C) <> typeof(A) then pause, end
if typeof(C) <> typeof(B) then pause, end

// test 1.6

A = uint8([0 1 ; 0 1]);
B = uint8([0 0 ; 1 1]);
C = uint8([0 1 ; 1 1]);

if or(bitor(A, B) <> C)  then pause, end
if typeof(C) <> typeof(A) then pause, end
if typeof(C) <> typeof(B) then pause, end

// test 1.7

A = uint16([0 1 ; 0 1]);
B = uint16([0 0 ; 1 1]);
C = uint16([0 1 ; 1 1]);

if or(bitor(A, B) <> C)  then pause, end
if typeof(C) <> typeof(A) then pause, end
if typeof(C) <> typeof(B) then pause, end

// test 1.8

A = uint32([0 1 ; 0 1]);
B = uint32([0 0 ; 1 1]);
C = uint32([0 1 ; 1 1]);

if or(bitor(A, B) <> C)  then pause, end
if typeof(C) <> typeof(A) then pause, end
if typeof(C) <> typeof(B) then pause, end

// test 1.9

A = [0 ; 1 ; 0 ; 1];
B = [0 ; 0 ; 1 ; 1];
C = [0 ; 1 ; 1 ; 1];

if or(bitor(A, B) <> C)  then pause, end
if typeof(C) <> typeof(A) then pause, end
if typeof(C) <> typeof(B) then pause, end

// test 1.6

A = uint8([0 ; 1 ; 0 ; 1]);
B = uint8([0 ; 0 ; 1 ; 1]);
C = uint8([0 ; 1 ; 1 ; 1]);

if or(bitor(A, B) <> C)  then pause, end
if typeof(C) <> typeof(A) then pause, end
if typeof(C) <> typeof(B) then pause, end

// test 1.7

A = uint16([0 ; 1 ; 0 ; 1]);
B = uint16([0 ; 0 ; 1 ; 1]);
C = uint16([0 ; 1 ; 1 ; 1]);

if or(bitor(A, B) <> C)  then pause, end
if typeof(C) <> typeof(A) then pause, end
if typeof(C) <> typeof(B) then pause, end

// test 1.8

A = uint32([0 ; 1 ; 0 ; 1]);
B = uint32([0 ; 0 ; 1 ; 1]);
C = uint32([0 ; 1 ; 1 ; 1]);

if or(bitor(A, B) <> C)  then pause, end
if typeof(C) <> typeof(A) then pause, end
if typeof(C) <> typeof(B) then pause, end


// Tests 2
// =============================================================================

// test 2.1

A = [0 1 0 1];
B = uint8([0 0 1 1]);

if execstr("bitor(A, B);","errcatch") == 0 then pause, end

// test 2.1

A = uint8([0 1 0 1]);
B = uint16([0 0 1 1]);

if execstr("bitor(A, B);","errcatch") == 0 then pause, end

// test 2.1

A = uint16([0 1 0 1]);
B = uint32([0 0 1 1]);

if execstr("bitor(A, B);","errcatch") == 0 then pause, end

// test 2.1

A = uint32([0 1 0 1]);
B = [0 0 1 1];

if execstr("bitor(A, B);","errcatch") == 0 then pause, end


// Tests 3
// =============================================================================

// test 3.1

A = abs(floor(1000 * rand(100,20)));
B = abs(floor(1000 * rand(100,20)));
C = bitor(A,B);

if or( size(A)<>size(B) ) then pause, end

// test 3.2

A = uint8(abs(floor(1000 * rand(100,20))));
B = uint8(abs(floor(1000 * rand(100,20))));
C = bitor(A,B);

if or( size(A)<>size(B) ) then pause, end

// test 3.3

A = uint16(abs(floor(1000 * rand(100,20))));
B = uint16(abs(floor(1000 * rand(100,20))));
C = bitor(A,B);

if or( size(A)<>size(B) ) then pause, end

// test 3.4

A = uint32(abs(floor(1000 * rand(100,20))));
B = uint32(abs(floor(1000 * rand(100,20))));
C = bitor(A,B);

if or( size(A)<>size(B) ) then pause, end

// Test 4
// =============================================================================

A = [ ..
    299.    258.    314.    359.    616.    152.    834.    68.     175.    734.    749.    976.    261.    214.    94.     217.    754.    245.    693.    557.  ; ..
    409.    783.    234.    932.    811.    552.    272.    375.    551.    373.    477.    784.    736.    15.     712.    419.    204.    949.    12.     682.  ; ..
    261.    273.    627.    652.    209.    280.    855.    221.    243.    720.    430.    936.    767.    48.     191.    731.    896.    18.     372.    527.  ; ..
    646.    848.    629.    446.    624.    194.    89.     948.    217.    786.    873.    374.    400.    215.    302.    766.    804.    442.    285.    476.  ; ..
    654.    127.    42.     559.    679.    811.    872.    769.    604.    453.    47.     220.    447.    333.    385.    915.    418.    270.    85.     583.  ; ..
    560.    432.    600.    158.    280.    327.    874.    625.    689.    178.    600.    19.     444.    423.    303.    128.    653.    420.    394.    99.   ; ..
    161.    739.    408.    134.    775.    955.    86.     133.    207.    589.    276.    644.    312.    819.    190.    996.    999.    969.    776.    353.  ; ..
    765.    53.     958.    530.    658.    567.    665.    447.    672.    549.    132.    651.    4.      114.    379.    941.    971.    713.    490.    395.  ; ..
    697.    613.    118.    798.    627.    430.    475.    538.    286.    324.    750.    550.    701.    298.    567.    106.    189.    483.    25.     793.  ; ..
    89.     809.    27.     587.    151.    393.    839.    811.    452.    286.    304.    23.     501.    770.    658.    467.    482.    771.    246.    464.  ; ..
    198.    192.    364.    532.    417.    391.    730.    442.    274.    992.    529.    85.     786.    984.    805.    23.     867.    843.    185.    994.  ; ..
    259.    541.    18.     303.    656.    875.    990.    0.      347.    357.    376.    801.    735.    490.    643.    878.    319.    587.    287.    152.  ; ..
    509.    415.    752.    82.     540.    526.    638.    658.    966.    193.    488.    221.    473.    160.    131.    80.     627.    399.    464.    959.  ; ..
    167.    286.    292.    201.    715.    985.    230.    174.    792.    303.    914.    245.    945.    427.    225.    920.    110.    401.    873.    999.  ; ..
    340.    511.    379.    221.    206.    132.    488.    450.    888.    4.      664.    41.     652.    387.    620.    998.    2.      873.    998.    347.  ; ..
    895.    767.    977.    562.    323.    323.    165.    765.    843.    849.    546.    963.    938.    980.    650.    195.    653.    131.    503.    220.  ; ..
    667.    378.    74.     594.    248.    601.    77.     723.    984.    815.    6.      21.     240.    909.    668.    987.    357.    587.    33.     127.  ; ..
    25.     934.    150.    336.    74.     154.    443.    790.    951.    998.    174.    670.    292.    482.    672.    424.    340.    202.    314.    513.  ; ..
    31.     488.    191.    944.    278.    751.    925.    113.    495.    689.    377.    76.     653.    665.    141.    868.    811.    725.    582.    886.  ; ..
    427.    998.    456.    225.    892.    31.     275.    852.    313.    652.    564.    34.     993.    246.    407.    45.     764.    445.    354.    343.  ; ..
    108.    593.    580.    61.     718.    140.    942.    652.    683.    265.    647.    444.    449.    771.    627.    649.    29.     372.    573.    579.  ; ..
    767.    892.    475.    334.    514.    573.    668.    396.    876.    24.     506.    323.    509.    899.    448.    58.     395.    648.    715.    774.  ; ..
    373.    995.    364.    956.    981.    351.    157.    269.    143.    430.    484.    356.    377.    915.    403.    238.    629.    11.     91.     145.  ; ..
    151.    481.    266.    111.    930.    313.    117.    979.    997.    273.    556.    689.    92.     986.    587.    992.    953.    294.    152.    792.  ; ..
    721.    77.     478.    875.    541.    562.    820.    835.    301.    650.    504.    355.    300.    207.    115.    255.    500.    605.    84.     53.   ; ..
    539.    68.     214.    955.    98.     536.    11.     867.    752.    733.    815.    298.    978.    631.    768.    114.    800.    714.    995.    136.  ; ..
    145.    567.    792.    271.    225.    858.    442.    355.    681.    444.    94.     318.    786.    911.    234.    507.    84.     713.    310.    822.  ; ..
    745.    599.    365.    664.    288.    836.    28.     930.    794.    749.    46.     83.     931.    575.    589.    469.    336.    233.    728.    53.   ; ..
    257.    106.    548.    68.     115.    204.    609.    511.    922.    248.    823.    262.    976.    691.    320.    29.     835.    587.    676.    306.  ; ..
    770.    381.    844.    771.    219.    382.    9.      531.    351.    276.    557.    505.    146.    903.    742.    790.    853.    837.    521.    654.  ; ..
    997.    259.    58.     886.    395.    969.    997.    454.    871.    307.    393.    61.     41.     727.    498.    93.     134.    389.    864.    331.  ; ..
    845.    6.      504.    575.    678.    609.    267.    800.    331.    11.     584.    214.    770.    298.    903.    748.    395.    210.    46.     920.  ; ..
    646.    810.    600.    729.    615.    937.    384.    948.    593.    645.    756.    781.    405.    875.    670.    467.    226.    760.    617.    627.  ; ..
    720.    266.    563.    265.    318.    59.     756.    76.     436.    716.    295.    882.    114.    379.    853.    192.    874.    640.    22.     402.  ; ..
    674.    124.    517.    290.    650.    84.     915.    23.     282.    854.    893.    784.    485.    87.     175.    82.     635.    489.    632.    163.  ; ..
    354.    187.    518.    781.    840.    296.    931.    485.    497.    427.    773.    403.    830.    635.    764.    916.    747.    97.     968.    466.  ; ..
    327.    112.    124.    957.    342.    503.    810.    555.    205.    975.    61.     382.    163.    225.    300.    234.    409.    241.    82.     382.  ; ..
    23.     664.    936.    844.    491.    38.     344.    243.    922.    383.    447.    270.    844.    446.    513.    898.    986.    644.    451.    205.  ; ..
    593.    145.    411.    132.    974.    78.     500.    146.    292.    278.    476.    121.    102.    310.    625.    147.    762.    635.    721.    900.  ; ..
    924.    430.    751.    807.    771.    799.    864.    389.    914.    513.    174.    867.    514.    588.    543.    816.    603.    129.    643.    844.  ; ..
    672.    614.    228.    945.    547.    181.    239.    481.    205.    849.    836.    22.     590.    727.    936.    320.    684.    801.    680.    194.  ; ..
    484.    216.    206.    500.    208.    312.    864.    40.     21.     168.    461.    674.    244.    314.    918.    768.    617.    671.    15.     514.  ; ..
    641.    968.    900.    371.    797.    247.    871.    646.    56.     797.    91.     714.    323.    178.    865.    88.     148.    194.    832.    203.  ; ..
    594.    663.    567.    914.    981.    590.    538.    815.    312.    252.    56.     856.    392.    491.    864.    427.    873.    710.    485.    412.  ; ..
    106.    519.    458.    287.    327.    848.    45.     827.    772.    79.     884.    754.    732.    752.    784.    546.    129.    379.    373.    843.  ; ..
    808.    867.    999.    316.    852.    684.    656.    680.    90.     994.    127.    139.    812.    166.    914.    255.    452.    178.    97.     639.  ; ..
    516.    287.    322.    770.    554.    275.    196.    909.    769.    697.    440.    880.    499.    574.    216.    824.    72.     10.     365.    652.  ; ..
    61.     143.    418.    27.     254.    767.    369.    13.     275.    17.     448.    319.    445.    304.    901.    638.    399.    572.    219.    129.  ; ..
    16.     187.    588.    110.    674.    63.     317.    50.     515.    773.    802.    897.    196.    684.    519.    7.      101.    734.    853.    491.  ; ..
    509.    619.    630.    558.    308.    73.     52.     977.    395.    177.    243.    944.    88.     72.     93.     901.    64.     222.    285.    54.   ; ..
    469.    217.    542.    54.     17.     567.    365.    760.    83.     137.    493.    687.    904.    240.    157.    193.    547.    620.    109.    749.  ; ..
    528.    445.    451.    915.    864.    283.    429.    348.    335.    544.    478.    559.    522.    828.    832.    910.    283.    731.    943.    703.  ; ..
    33.     408.    985.    108.    295.    241.    496.    641.    309.    911.    395.    874.    501.    390.    967.    563.    616.    310.    10.     313.  ; ..
    711.    636.    740.    559.    312.    44.     314.    408.    519.    888.    365.    351.    607.    884.    846.    262.    928.    288.    226.    2.    ; ..
    790.    497.    722.    600.    728.    794.    480.    237.    9.      518.    190.    325.    598.    489.    735.    399.    640.    799.    866.    952.  ; ..
    623.    739.    101.    588.    735.    343.    47.     566.    868.    947.    452.    867.    477.    829.    912.    768.    765.    234.    706.    451.  ; ..
    799.    0.      631.    93.     262.    521.    49.     703.    353.    992.    488.    304.    41.     136.    576.    949.    704.    932.    537.    135.  ; ..
    42.     428.    478.    116.    784.    302.    998.    566.    623.    448.    840.    604.    598.    832.    580.    972.    41.     685.    524.    108.  ; ..
    867.    878.    372.    991.    411.    984.    990.    602.    153.    795.    155.    70.     1.      222.    367.    442.    888.    792.    833.    68.   ; ..
    345.    809.    666.    369.    506.    415.    235.    611.    776.    218.    663.    588.    976.    542.    146.    608.    644.    148.    533.    351.  ; ..
    798.    819.    405.    135.    124.    424.    764.    492.    51.     832.    761.    445.    235.    42.     260.    618.    337.    401.    314.    174.  ; ..
    372.    326.    944.    619.    861.    347.    448.    217.    286.    661.    868.    427.    124.    42.     828.    155.    868.    748.    405.    229.  ; ..
    186.    525.    12.     276.    670.    18.     807.    441.    635.    553.    781.    722.    521.    95.     383.    390.    131.    65.     116.    862.  ; ..
    505.    795.    299.    636.    965.    834.    435.    979.    413.    199.    368.    584.    406.    502.    13.     781.    682.    763.    405.    244.  ; ..
    342.    772.    709.    901.    545.    890.    787.    525.    795.    131.    671.    576.    961.    666.    730.    899.    10.     608.    624.    470.  ; ..
    582.    973.    114.    632.    856.    17.     656.    690.    136.    919.    778.    705.    895.    690.    463.    929.    841.    544.    359.    254.  ; ..
    92.     791.    288.    280.    840.    859.    269.    187.    524.    200.    522.    841.    71.     167.    158.    826.    620.    915.    185.    211.  ; ..
    639.    109.    423.    678.    825.    469.    543.    68.     732.    494.    936.    579.    893.    204.    225.    431.    993.    491.    128.    657.  ; ..
    328.    929.    42.     285.    76.     791.    965.    359.    266.    880.    69.     423.    880.    811.    885.    567.    589.    240.    823.    105.  ; ..
    103.    53.     971.    144.    842.    146.    191.    806.    999.    281.    277.    602.    472.    13.     742.    187.    111.    316.    492.    75.   ; ..
    671.    196.    899.    820.    334.    367.    270.    914.    139.    116.    739.    627.    841.    893.    166.    314.    746.    795.    650.    659.  ; ..
    850.    523.    3.      638.    312.    420.    678.    491.    112.    282.    605.    342.    874.    525.    985.    43.     846.    407.    582.    228.  ; ..
    830.    330.    611.    908.    150.    511.    599.    615.    328.    216.    614.    209.    726.    157.    366.    422.    497.    679.    540.    803.  ; ..
    438.    956.    51.     210.    112.    37.     432.    67.     780.    260.    844.    804.    73.     901.    392.    408.    790.    376.    787.    442.  ; ..
    587.    957.    164.    154.    309.    48.     414.    753.    62.     111.    939.    794.    136.    784.    806.    235.    218.    693.    167.    713.  ; ..
    561.    860.    672.    30.     534.    209.    672.    834.    842.    496.    842.    183.    195.    403.    705.    180.    894.    924.    310.    176.  ; ..
    141.    583.    570.    603.    900.    686.    218.    364.    111.    813.    553.    434.    169.    796.    867.    961.    853.    189.    16.     3.    ; ..
    384.    633.    128.    196.    196.    994.    803.    342.    793.    524.    38.     132.    715.    278.    458.    689.    388.    667.    13.     931.  ; ..
    228.    923.    585.    512.    29.     560.    544.    761.    201.    26.     761.    274.    657.    601.    349.    826.    52.     403.    846.    718.  ; ..
    636.    296.    160.    776.    95.     439.    744.    805.    733.    356.    760.    721.    213.    736.    668.    371.    258.    548.    923.    815.  ; ..
    355.    835.    985.    462.    883.    708.    432.    443.    393.    406.    988.    970.    338.    277.    296.    752.    643.    988.    661.    7.    ; ..
    168.    322.    262.    353.    689.    603.    250.    736.    761.    243.    893.    216.    887.    2.      141.    731.    677.    717.    484.    735.  ; ..
    991.    237.    239.    64.     731.    353.    461.    592.    750.    820.    537.    104.    46.     401.    833.    780.    200.    37.     989.    667.  ; ..
    846.    707.    6.      240.    926.    394.    326.    268.    813.    705.    558.    413.    863.    956.    589.    629.    465.    207.    273.    557.  ; ..
    73.     223.    120.    547.    316.    68.     497.    821.    856.    532.    202.    568.    600.    256.    379.    588.    523.    290.    429.    277.  ; ..
    235.    390.    915.    935.    583.    7.      665.    894.    206.    283.    151.    479.    499.    492.    325.    1.      687.    199.    401.    501.  ; ..
    61.     593.    348.    148.    369.    250.    216.    819.    392.    0.      790.    333.    47.     298.    277.    233.    176.    624.    501.    776.  ; ..
    143.    53.     16.     235.    803.    533.    517.    112.    584.    127.    467.    783.    157.    266.    550.    554.    688.    98.     884.    383.  ; ..
    339.    392.    130.    862.    903.    148.    656.    583.    309.    101.    157.    375.    692.    329.    802.    23.     348.    916.    110.    503.  ; ..
    880.    4.      366.    578.    334.    875.    480.    433.    445.    989.    535.    128.    308.    810.    40.     774.    64.     813.    986.    931.  ; ..
    525.    421.    877.    122.    63.     345.    784.    243.    579.    721.    495.    286.    122.    283.    21.     497.    510.    133.    833.    175.  ; ..
    714.    262.    438.    461.    519.    369.    122.    434.    820.    310.    161.    855.    92.     0.      277.    497.    275.    538.    598.    255.  ; ..
    389.    174.    762.    661.    867.    552.    863.    651.    497.    867.    738.    545.    791.    159.    481.    389.    16.     568.    125.    511.  ; ..
    463.    837.    142.    172.    381.    295.    151.    740.    916.    751.    786.    372.    544.    413.    545.    285.    501.    722.    126.    363.  ; ..
    164.    830.    488.    675.    596.    37.     483.    38.     249.    412.    463.    52.     885.    928.    577.    376.    382.    771.    777.    564.  ; ..
    288.    573.    325.    348.    180.    679.    758.    998.    345.    629.    101.    723.    430.    65.     231.    758.    14.     781.    901.    426.  ; ..
    320.    26.     161.    718.    258.    565.    985.    814.    556.    417.    854.    548.    625.    484.    57.     871.    726.    359.    921.    615.  ; ..
    421.    547.    679.    916.    334.    303.    749.    837.    44.     90.     688.    603.    959.    290.    287.    714.    468.    239.    754.    58.   ; ..
    758.    684.    708.    930.    819.    563.    980.    70.     806.    264.    677.    512.    160.    339.    797.    412.    280.    892.    985.    167.  ; ..
    650.    822.    51.     774.    588.    531.    988.    444.    791.    415.    785.    759.    317.    958.    470.    279.    128.    269.    909.    126.  ];

B = [ ..
    511.    299.    529.    766.    739.    39.     125.    996.    368.    699.    914.    155.    428.    455.    616.    283.    424.    803.    615.    922.  ; ..
    403.    223.    453.    985.    260.    337.    35.     632.    64.     113.    551.    688.    331.    580.    463.    859.    689.    839.    780.    362.  ; ..
    827.    66.     978.    614.    218.    678.    161.    20.     560.    768.    596.    890.    553.    53.     853.    856.    480.    429.    772.    419.  ; ..
    589.    677.    202.    42.     319.    256.    772.    61.     840.    507.    931.    68.     147.    638.    708.    406.    269.    599.    98.     105.  ; ..
    298.    994.    102.    50.     811.    524.    521.    618.    997.    538.    934.    439.    592.    754.    812.    889.    399.    300.    884.    943.  ; ..
    750.    321.    48.     310.    370.    948.    80.     245.    226.    670.    818.    373.    979.    272.    977.    20.     120.    839.    539.    242.  ; ..
    605.    885.    102.    86.     269.    308.    723.    151.    307.    253.    61.     463.    588.    379.    777.    270.    910.    368.    147.    532.  ; ..
    889.    20.     483.    246.    947.    795.    186.    755.    81.     768.    113.    88.     853.    511.    339.    190.    319.    312.    374.    662.  ; ..
    724.    518.    73.     894.    321.    922.    883.    758.    406.    470.    227.    179.    192.    567.    854.    768.    53.     626.    860.    333.  ; ..
    122.    726.    397.    287.    566.    459.    294.    34.     257.    61.     855.    504.    806.    761.    605.    73.     869.    799.    550.    568.  ; ..
    702.    915.    256.    290.    123.    780.    939.    129.    985.    639.    863.    33.     535.    680.    742.    203.    797.    457.    750.    890.  ; ..
    562.    646.    707.    169.    769.    226.    84.     970.    964.    322.    252.    971.    760.    240.    574.    836.    239.    469.    818.    351.  ; ..
    250.    477.    828.    368.    794.    940.    381.    978.    719.    681.    475.    998.    863.    319.    31.     551.    822.    570.    913.    43.   ; ..
    485.    2.      265.    453.    408.    613.    387.    298.    231.    101.    675.    471.    193.    689.    892.    701.    297.    835.    0.      390.  ; ..
    59.     763.    740.    509.    933.    443.    469.    678.    101.    757.    858.    193.    778.    385.    10.     915.    297.    213.    829.    602.  ; ..
    464.    368.    504.    384.    164.    290.    303.    505.    725.    900.    670.    738.    185.    477.    373.    457.    513.    458.    56.     130.  ; ..
    27.     748.    605.    327.    664.    860.    805.    229.    783.    334.    335.    607.    373.    898.    564.    739.    274.    976.    896.    785.  ; ..
    822.    203.    393.    286.    820.    856.    1.      856.    651.    735.    897.    974.    737.    489.    385.    907.    483.    719.    192.    307.  ; ..
    485.    963.    211.    267.    26.     905.    63.     266.    993.    875.    65.     625.    529.    379.    420.    953.    737.    473.    975.    100.  ; ..
    862.    5.      297.    449.    803.    679.    343.    818.    257.    94.     694.    717.    922.    623.    515.    97.     404.    265.    816.    470.  ; ..
    382.    72.     303.    20.     784.    533.    143.    609.    203.    458.    301.    204.    678.    959.    238.    267.    689.    937.    49.     233.  ; ..
    715.    389.    169.    756.    727.    788.    186.    267.    643.    929.    527.    430.    497.    189.    221.    100.    27.     120.    432.    738.  ; ..
    647.    819.    212.    895.    358.    713.    298.    260.    240.    712.    118.    350.    699.    857.    60.     981.    446.    584.    499.    55.   ; ..
    192.    133.    0.      22.     166.    403.    566.    520.    858.    848.    849.    904.    747.    928.    279.    444.    687.    694.    600.    943.  ; ..
    897.    99.     69.     333.    903.    197.    327.    123.    715.    40.     90.     269.    693.    775.    938.    811.    732.    926.    177.    356.  ; ..
    663.    854.    477.    8.      304.    187.    928.    77.     632.    990.    670.    266.    601.    550.    507.    947.    82.     46.     599.    822.  ; ..
    767.    541.    101.    94.     47.     704.    96.     452.    535.    500.    868.    705.    610.    593.    450.    716.    799.    385.    707.    773.  ; ..
    486.    204.    314.    298.    575.    404.    854.    43.     389.    61.     382.    374.    181.    588.    339.    497.    546.    456.    442.    621.  ; ..
    686.    965.    283.    749.    721.    203.    728.    552.    515.    403.    165.    819.    396.    768.    694.    945.    827.    974.    731.    983.  ; ..
    854.    259.    424.    411.    547.    831.    435.    292.    221.    576.    864.    325.    925.    746.    221.    207.    349.    701.    92.     182.  ; ..
    371.    538.    721.    326.    337.    877.    355.    779.    357.    946.    475.    910.    872.    490.    596.    836.    813.    842.    410.    945.  ; ..
    918.    17.     81.     719.    235.    392.    203.    474.    305.    289.    602.    729.    20.     814.    342.    123.    84.     105.    235.    261.  ; ..
    956.    2.      998.    638.    592.    246.    503.    6.      610.    455.    484.    746.    333.    287.    330.    752.    308.    466.    841.    172.  ; ..
    597.    418.    188.    671.    395.    833.    409.    798.    488.    80.     286.    95.     78.     307.    841.    263.    226.    487.    391.    266.  ; ..
    943.    194.    655.    391.    827.    136.    535.    617.    290.    430.    832.    561.    294.    742.    751.    180.    134.    665.    523.    49.   ; ..
    435.    988.    665.    431.    236.    357.    227.    998.    522.    999.    994.    41.     567.    335.    145.    994.    426.    281.    578.    727.  ; ..
    454.    671.    465.    947.    500.    200.    393.    272.    820.    927.    60.     304.    130.    737.    296.    959.    963.    675.    933.    508.  ; ..
    154.    937.    681.    253.    105.    707.    15.     962.    420.    629.    526.    982.    385.    549.    427.    574.    858.    359.    943.    479.  ; ..
    808.    984.    404.    12.     327.    736.    555.    452.    336.    292.    668.    896.    153.    449.    229.    104.    775.    774.    90.     296.  ; ..
    962.    209.    832.    459.    994.    745.    28.     950.    601.    367.    586.    261.    58.     299.    169.    864.    889.    232.    629.    637.  ; ..
    883.    315.    811.    905.    368.    144.    43.     535.    483.    168.    443.    357.    109.    649.    800.    214.    39.     604.    4.      892.  ; ..
    175.    421.    260.    805.    124.    888.    774.    110.    714.    405.    157.    351.    115.    199.    367.    774.    293.    256.    594.    827.  ; ..
    104.    260.    341.    802.    159.    786.    825.    301.    53.     544.    174.    173.    673.    46.     114.    316.    427.    921.    580.    432.  ; ..
    119.    747.    98.     71.     90.     751.    410.    912.    209.    57.     530.    564.    243.    59.     852.    657.    177.    88.     918.    691.  ; ..
    891.    823.    471.    824.    324.    670.    468.    578.    494.    607.    697.    483.    595.    796.    808.    577.    328.    247.    146.    938.  ; ..
    452.    490.    205.    820.    149.    920.    94.     123.    638.    518.    822.    542.    656.    441.    522.    616.    452.    830.    280.    304.  ; ..
    185.    569.    779.    424.    272.    647.    780.    720.    883.    851.    490.    15.     59.     371.    211.    57.     705.    356.    796.    241.  ; ..
    955.    164.    16.     293.    993.    706.    906.    848.    326.    978.    373.    603.    582.    787.    652.    334.    70.     847.    601.    660.  ; ..
    715.    801.    480.    591.    995.    83.     734.    54.     749.    472.    989.    508.    8.      926.    31.     839.    407.    850.    431.    561.  ; ..
    234.    295.    173.    250.    613.    34.     655.    847.    202.    132.    50.     594.    856.    109.    972.    501.    165.    188.    204.    718.  ; ..
    292.    821.    997.    318.    0.      567.    741.    726.    493.    134.    906.    42.     925.    724.    81.     949.    162.    844.    251.    120.  ; ..
    633.    724.    357.    46.     614.    24.     582.    735.    174.    473.    972.    125.    39.     411.    596.    9.      589.    550.    116.    488.  ; ..
    92.     342.    197.    953.    436.    566.    460.    911.    597.    853.    361.    591.    343.    234.    469.    746.    637.    277.    731.    854.  ; ..
    787.    779.    363.    286.    312.    329.    376.    562.    334.    81.     527.    887.    261.    224.    87.     798.    950.    864.    219.    192.  ; ..
    834.    186.    570.    810.    805.    409.    454.    510.    480.    625.    113.    671.    465.    762.    506.    374.    419.    893.    334.    529.  ; ..
    558.    249.    673.    876.    178.    677.    91.     658.    323.    915.    545.    943.    937.    823.    808.    278.    89.     607.    711.    492.  ; ..
    509.    987.    573.    176.    783.    917.    233.    582.    392.    717.    792.    428.    113.    140.    624.    736.    11.     67.     577.    842.  ; ..
    453.    376.    589.    29.     381.    286.    172.    202.    294.    688.    28.     421.    452.    616.    145.    681.    787.    744.    617.    54.   ; ..
    142.    22.     846.    976.    861.    794.    156.    246.    293.    731.    348.    386.    203.    569.    215.    708.    257.    537.    136.    700.  ; ..
    909.    106.    203.    747.    369.    674.    940.    848.    962.    167.    805.    705.    843.    839.    15.     240.    259.    751.    818.    126.  ; ..
    400.    979.    549.    186.    223.    948.    530.    17.     735.    953.    144.    689.    370.    489.    968.    264.    446.    277.    651.    214.  ; ..
    897.    393.    3.      268.    357.    824.    225.    565.    30.     994.    753.    955.    212.    842.    217.    695.    590.    160.    75.     335.  ; ..
    9.      721.    909.    77.     816.    528.    495.    873.    701.    535.    785.    355.    678.    752.    243.    277.    4.      521.    258.    415.  ; ..
    45.     277.    580.    861.    230.    496.    445.    615.    784.    899.    656.    454.    942.    873.    491.    168.    495.    580.    728.    263.  ; ..
    386.    391.    673.    771.    380.    139.    235.    165.    508.    47.     79.     271.    888.    751.    761.    338.    610.    708.    2.      622.  ; ..
    786.    772.    664.    87.     527.    614.    991.    222.    717.    137.    252.    718.    743.    110.    527.    771.    597.    876.    940.    592.  ; ..
    892.    775.    882.    934.    567.    633.    174.    171.    660.    302.    9.      716.    895.    897.    730.    351.    78.     212.    452.    223.  ; ..
    746.    994.    326.    974.    772.    977.    344.    659.    469.    201.    423.    427.    889.    801.    395.    300.    616.    158.    562.    488.  ; ..
    134.    234.    546.    949.    699.    645.    354.    988.    286.    489.    546.    458.    93.     320.    808.    322.    882.    602.    577.    641.  ; ..
    594.    462.    694.    511.    297.    888.    655.    348.    175.    80.     694.    920.    632.    442.    20.     921.    400.    174.    606.    275.  ; ..
    90.     942.    904.    58.     410.    848.    634.    992.    920.    802.    909.    397.    890.    236.    538.    46.     14.     106.    448.    921.  ; ..
    775.    905.    592.    183.    777.    586.    524.    725.    220.    484.    72.     74.     594.    974.    989.    731.    387.    650.    967.    350.  ; ..
    951.    130.    169.    94.     940.    240.    14.     607.    224.    495.    932.    597.    853.    513.    256.    636.    537.    415.    169.    990.  ; ..
    774.    115.    225.    921.    789.    436.    256.    185.    395.    421.    667.    775.    819.    789.    347.    311.    836.    776.    173.    360.  ; ..
    769.    829.    631.    918.    392.    925.    642.    968.    215.    826.    855.    784.    261.    871.    506.    462.    825.    261.    791.    654.  ; ..
    709.    235.    113.    646.    749.    577.    849.    62.     341.    123.    405.    768.    905.    858.    700.    858.    826.    453.    555.    48.   ; ..
    694.    648.    803.    906.    357.    303.    347.    678.    10.     135.    461.    364.    705.    346.    26.     421.    747.    741.    367.    93.   ; ..
    4.      334.    852.    448.    392.    31.     205.    371.    897.    492.    249.    254.    249.    308.    989.    944.    445.    801.    130.    460.  ; ..
    154.    756.    596.    144.    223.    570.    118.    572.    382.    711.    484.    113.    996.    383.    695.    903.    46.     496.    54.     473.  ; ..
    527.    914.    855.    207.    488.    989.    543.    667.    297.    827.    685.    157.    669.    264.    482.    355.    754.    792.    505.    532.  ; ..
    86.     898.    426.    831.    667.    437.    343.    577.    987.    475.    954.    230.    622.    703.    963.    779.    496.    3.      610.    595.  ; ..
    725.    176.    835.    70.     480.    992.    402.    840.    127.    482.    561.    289.    454.    535.    735.    675.    734.    496.    266.    144.  ; ..
    751.    224.    289.    51.     574.    384.    39.     834.    250.    241.    943.    907.    447.    198.    475.    528.    291.    711.    256.    695.  ; ..
    908.    143.    307.    394.    263.    949.    104.    777.    255.    179.    669.    652.    137.    638.    472.    148.    568.    254.    329.    460.  ; ..
    45.     472.    382.    8.      402.    801.    275.    502.    24.     816.    526.    207.    909.    966.    308.    667.    1.      986.    925.    904.  ; ..
    694.    141.    732.    629.    22.     99.     686.    517.    620.    775.    517.    655.    769.    666.    245.    763.    946.    936.    529.    673.  ; ..
    928.    852.    277.    299.    126.    629.    783.    600.    648.    748.    939.    312.    799.    522.    778.    274.    687.    163.    827.    911.  ; ..
    718.    361.    902.    758.    35.     261.    217.    573.    551.    347.    507.    998.    176.    383.    383.    360.    692.    225.    268.    15.   ; ..
    113.    326.    324.    361.    731.    779.    787.    86.     237.    628.    316.    484.    326.    727.    579.    57.     729.    816.    467.    374.  ; ..
    774.    364.    723.    487.    294.    590.    831.    531.    149.    261.    999.    228.    410.    655.    899.    692.    567.    443.    58.     868.  ; ..
    706.    112.    233.    47.     198.    175.    734.    642.    367.    771.    432.    669.    868.    210.    384.    387.    3.      45.     978.    985.  ; ..
    650.    86.     530.    24.     717.    739.    633.    571.    68.     404.    496.    411.    258.    674.    615.    682.    688.    701.    262.    20.   ; ..
    570.    708.    27.     903.    356.    43.     233.    597.    160.    261.    858.    32.     23.     652.    463.    437.    615.    477.    425.    204.  ; ..
    666.    225.    302.    36.     427.    453.    799.    154.    565.    795.    168.    861.    121.    370.    662.    472.    278.    907.    110.    347.  ; ..
    109.    708.    193.    443.    299.    468.    505.    484.    427.    111.    324.    181.    581.    408.    562.    426.    842.    213.    810.    880.  ; ..
    490.    602.    609.    21.     933.    256.    479.    675.    980.    250.    130.    240.    705.    747.    557.    157.    490.    439.    1.      336.  ; ..
    344.    706.    183.    867.    564.    631.    370.    345.    446.    57.     169.    774.    399.    103.    804.    259.    557.    455.    413.    661.  ; ..
    818.    97.     593.    788.    989.    726.    479.    194.    568.    565.    131.    581.    625.    503.    187.    141.    587.    755.    81.     832.  ; ..
    900.    954.    907.    786.    461.    861.    625.    273.    491.    623.    972.    993.    973.    305.    930.    52.     728.    401.    999.    674.  ; ..
    968.    950.    687.    858.    232.    981.    983.    341.    846.    588.    438.    629.    141.    119.    38.     835.    725.    922.    986.    10.   ];

 C  = [ ..
    511.     299.     827.     1023.    747.     191.     895.     996.     511.     767.     1023.    987.     429.     471.     638.     475.     1018.    1015.    759.     959.   ; ..
    411.     991.     495.     1021.    815.     889.     307.     895.     615.     373.     1023.    944.     1003.    591.     975.     1019.    765.     1015.    780.     1002.  ; ..
    831.     339.     1011.    750.     219.     958.     1015.    221.     755.     976.     1022.    1018.    767.     53.      1023.    987.     992.     447.     884.     943.   ; ..
    719.     1013.    767.     446.     895.     450.     861.     957.     985.     1019.    1003.    374.     403.     767.     1006.    1022.    813.     1023.    383.     509.   ; ..
    942.     1023.    110.     575.     943.     815.     873.     875.     1021.    991.     943.     511.     1023.    1023.    941.     1019.    431.     302.     885.     1007.  ; ..
    766.     497.     632.     446.     378.     1015.    890.     757.     755.     702.     890.     375.     1023.    439.     1023.    148.     765.     999.     923.     243.   ; ..
    765.     1015.    510.     214.     783.     959.     727.     151.     511.     765.     317.     975.     892.     891.     959.     1006.    1007.    1017.    923.     885.   ; ..
    1021.    53.      1023.    758.     947.     831.     699.     1023.    753.     805.     245.     731.     853.     511.     379.     959.     1023.    1017.    510.     927.   ; ..
    765.     615.     127.     894.     883.     958.     1019.    766.     414.     470.     751.     695.     765.     831.     887.     874.     189.     1011.    861.     861.   ; ..
    123.     1023.    415.     863.     695.     459.     871.     811.     453.     319.     887.     511.     1015.    1019.    735.     475.     999.     799.     758.     1016.  ; ..
    766.     979.     364.     822.     507.     911.     1019.    443.     987.     1023.    863.     117.     791.     1016.    999.     223.     895.     971.     767.     1018.  ; ..
    819.     671.     723.     431.     913.     1003.    990.     970.     991.     359.     508.     1003.    767.     506.     703.     878.     511.     991.     831.     479.   ; ..
    511.     479.     1020.    370.     798.     942.     895.     978.     975.     745.     507.     1023.    991.     447.     159.     631.     887.     959.     977.     959.   ; ..
    487.     286.     301.     461.     987.     1021.    487.     430.     1023.    367.     947.     503.     1009.    955.     1021.    957.     367.     979.     873.     999.   ; ..
    383.     1023.    1023.    509.     1007.    447.     509.     998.     893.     757.     986.     233.     910.     387.     622.     1015.    299.     1021.    1023.    859.   ; ..
    1023.    1023.    1017.    946.     487.     355.     431.     1021.    991.     981.     702.     995.     955.     989.     1023.    459.     653.     459.     511.     222.   ; ..
    667.     1022.    607.     855.     760.     861.     877.     759.     991.     879.     335.     607.     501.     911.     700.     1019.    375.     987.     929.     895.   ; ..
    831.     1007.    415.     350.     894.     986.     443.     862.     959.     1023.    943.     990.     997.     491.     929.     939.     503.     719.     506.     819.   ; ..
    511.     1003.    255.     955.     286.     1007.    959.     379.     1007.    1019.    377.     637.     669.     1019.    429.     1021.    1003.    989.     975.     886.   ; ..
    1023.    999.     489.     481.     895.     703.     343.     886.     313.     734.     694.     751.     1019.    767.     919.     109.     1020.    445.     882.     471.   ; ..
    382.     601.     879.     61.      990.     669.     943.     749.     747.     459.     943.     508.     999.     959.     767.     907.     701.     1021.    573.     747.   ; ..
    767.     1021.    507.     1022.    727.     829.     702.     399.     1007.    953.     1023.    495.     509.     959.     477.     126.     411.     760.     1019.    998.   ; ..
    1015.    1011.    508.     1023.    1015.    991.     447.     269.     255.     1006.    502.     382.     1019.    987.     447.     1023.    1023.    587.     507.     183.   ; ..
    215.     485.     266.     127.     934.     443.     631.     987.     1023.    849.     893.     953.     767.     1018.    863.     1020.    959.     950.     728.     959.   ; ..
    977.     111.     479.     879.     927.     759.     887.     891.     1007.    682.     506.     367.     957.     975.     1019.    1023.    1020.    991.     245.     373.   ; ..
    671.     854.     479.     955.     370.     699.     939.     879.     760.     991.     959.     298.     987.     631.     1019.    1011.    882.     750.     1015.    958.   ; ..
    767.     575.     893.     351.     239.     986.     506.     487.     703.     508.     894.     1023.    882.     991.     490.     1023.    863.     969.     1015.    823.   ; ..
    1007.    735.     383.     954.     831.     980.     862.     939.     927.     765.     382.     375.     951.     639.     863.     501.     882.     489.     1018.    637.   ; ..
    943.     1007.    831.     749.     755.     207.     761.     1023.    923.     507.     951.     823.     988.     947.     1014.    957.     891.     975.     767.     1015.  ; ..
    854.     383.     1004.    923.     763.     895.     443.     823.     479.     852.     877.     509.     927.     1007.    767.     991.     861.     1021.    605.     702.   ; ..
    1015.    795.     763.     886.     475.     1005.    999.     975.     871.     947.     475.     959.     873.     1023.    1014.    861.     943.     975.     1018.    1019.  ; ..
    991.     23.      505.     767.     751.     1001.    459.     1018.    379.     299.     602.     735.     790.     814.     983.     767.     479.     251.     239.     925.   ; ..
    958.     810.     1022.    767.     631.     1023.    503.     950.     627.     967.     1012.    1007.    477.     895.     990.     1011.    502.     1018.    873.     767.   ; ..
    725.     426.     703.     927.     447.     891.     1021.    862.     508.     732.     319.     895.     126.     379.     861.     455.     1002.    999.     407.     410.   ; ..
    943.     254.     655.     423.     955.     220.     919.     639.     314.     1022.    893.     817.     487.     759.     751.     246.     767.     1017.    635.     179.   ; ..
    499.     1023.    671.     943.     1004.    365.     995.     999.     1019.    1007.    999.     443.     831.     895.     765.     1014.    1003.    377.     970.     983.   ; ..
    455.     767.     509.     959.     502.     511.     939.     827.     1021.    991.     61.      382.     163.     737.     300.     1023.    987.     755.     1015.    510.   ; ..
    159.     953.     937.     1021.    491.     743.     351.     1011.    958.     895.     959.     990.     973.     959.     939.     958.     986.     999.     1007.    479.   ; ..
    889.     985.     415.     140.     975.     750.     1023.    470.     372.     310.     988.     1017.    255.     503.     757.     251.     1023.    895.     731.     940.   ; ..
    990.     511.     1007.    1007.    995.     1023.    892.     951.     987.     879.     750.     871.     570.     879.     703.     880.     891.     233.     759.     893.   ; ..
    1011.    895.     1007.    953.     883.     181.     239.     1015.    495.     1017.    1023.    375.     623.     735.     936.     470.     687.     893.     684.     1022.  ; ..
    495.     509.     462.     1013.    252.     888.     870.     110.     735.     445.     477.     1023.    247.     511.     1023.    774.     877.     927.     607.     827.   ; ..
    745.     972.     981.     883.     927.     1015.    895.     943.     61.      829.     255.     751.     995.     190.     883.     380.     447.     987.     836.     507.   ; ..
    631.     767.     631.     983.     991.     751.     922.     959.     505.     253.     570.     892.     507.     507.     884.     955.     1017.    734.     1015.    959.   ; ..
    891.     823.     479.     831.     327.     990.     509.     891.     1006.    607.     1021.    1011.    735.     1020.    824.     611.     457.     511.     503.     1003.  ; ..
    1004.    1003.    1007.    828.     981.     956.     734.     763.     638.     998.     895.     671.     956.     447.     922.     767.     452.     958.     377.     895.   ; ..
    701.     831.     843.     938.     826.     919.     972.     989.     883.     1019.    506.     895.     507.     895.     219.     825.     713.     366.     893.     765.   ; ..
    959.     175.     434.     319.     1023.    767.     1019.    861.     343.     979.     501.     895.     1023.    819.     909.     894.     463.     895.     731.     661.   ; ..
    731.     955.     1004.    623.     995.     127.     1023.    54.      751.     989.     1023.    1021.    204.     958.     543.     839.     503.     990.     1023.    1019.  ; ..
    511.     879.     767.     766.     885.     107.     703.     991.     459.     181.     243.     1010.    856.     109.     989.     1013.    229.     254.     477.     766.   ; ..
    501.     1021.    1023.    318.     17.      567.     1005.    766.     511.     143.     1007.    687.     925.     756.     221.     1013.    675.     876.     255.     765.   ; ..
    633.     1021.    487.     959.     870.     283.     1007.    991.     495.     1017.    990.     639.     559.     959.     852.     911.     863.     767.     1023.    1023.  ; ..
    125.     478.     989.     1021.    439.     759.     508.     911.     885.     991.     491.     879.     503.     494.     983.     763.     637.     311.     731.     895.   ; ..
    983.     895.     1007.    831.     312.     365.     378.     954.     847.     889.     879.     895.     863.     1012.    863.     798.     950.     864.     251.     194.   ; ..
    854.     507.     762.     890.     1021.    923.     486.     511.     489.     631.     255.     991.     983.     1019.    1023.    511.     931.     895.     878.     953.   ; ..
    623.     763.     741.     876.     767.     1015.    127.     694.     871.     947.     997.     1007.    1021.    831.     952.     790.     765.     767.     711.     495.   ; ..
    1023.    987.     639.     253.     783.     925.     249.     767.     489.     1005.    1016.    444.     121.     140.     624.     1013.    715.     999.     601.     975.   ; ..
    495.     508.     991.     125.     893.     318.     1006.    766.     879.     1008.    860.     1021.    982.     872.     725.     1005.    827.     749.     621.     126.   ; ..
    1007.    894.     894.     991.     991.     986.     990.     766.     445.     987.     479.     454.     203.     767.     511.     1022.    889.     793.     969.     764.   ; ..
    989.     875.     731.     1019.    507.     959.     1007.    883.     970.     255.     951.     717.     987.     863.     159.     752.     903.     767.     823.     383.   ; ..
    926.     1011.    949.     191.     255.     956.     766.     509.     767.     1017.    761.     957.     507.     491.     972.     874.     511.     405.     955.     254.   ; ..
    1013.    463.     947.     879.     893.     891.     481.     765.     286.     1015.    1013.    955.     252.     874.     1021.    703.     878.     748.     479.     495.   ; ..
    187.     733.     909.     349.     958.     530.     1007.    1017.    767.     575.     797.     1011.    687.     767.     511.     407.     135.     585.     374.     991.   ; ..
    509.     799.     879.     893.     999.     1010.    447.     1015.    925.     967.     1008.    974.     958.     1023.    495.     941.     1007.    767.     989.     503.   ; ..
    470.     903.     741.     903.     893.     1019.    1019.    685.     1023.    175.     735.     847.     1017.    767.     763.     979.     618.     740.     626.     1022.  ; ..
    854.     973.     762.     639.     863.     631.     991.     766.     717.     927.     1022.    719.     1023.    766.     975.     931.     861.     876.     1007.    766.   ; ..
    892.     791.     882.     958.     895.     891.     431.     187.     668.     494.     523.     973.     895.     935.     734.     895.     622.     983.     509.     223.   ; ..
    767.     1007.    487.     1006.    829.     981.     863.     727.     989.     495.     943.     1003.    893.     1005.    491.     431.     1001.    511.     690.     1017.  ; ..
    462.     1003.    554.     957.     767.     919.     999.     1023.    286.     1017.    615.     495.     893.     875.     893.     887.     895.     762.     887.     745.   ; ..
    631.     511.     1023.    511.     875.     1018.    703.     894.     1007.    345.     951.     986.     1016.    447.     758.     955.     511.     446.     1022.    347.   ; ..
    735.     1006.    907.     830.     478.     895.     894.     1010.    923.     886.     1007.    1023.    891.     1021.    702.     318.     750.     891.     970.     923.   ; ..
    855.     907.     595.     767.     825.     1006.    686.     1023.    252.     510.     605.     350.     890.     975.     989.     763.     975.     927.     967.     510.   ; ..
    959.     458.     747.     990.     958.     511.     607.     639.     488.     511.     998.     725.     983.     669.     366.     1022.    1017.    959.     701.     1023.  ; ..
    950.     1023.    243.     987.     885.     437.     432.     251.     911.     421.     991.     807.     891.     917.     475.     447.     854.     888.     959.     506.   ; ..
    843.     957.     759.     926.     445.     957.     926.     1017.    255.     895.     1023.    794.     397.     887.     1022.    495.     1019.    949.     951.     719.   ; ..
    757.     1023.    753.     670.     767.     721.     1009.    894.     863.     507.     991.     951.     971.     987.     765.     1022.    894.     989.     831.     176.   ; ..
    703.     719.     827.     987.     997.     943.     475.     1006.    111.     943.     1005.    510.     745.     862.     891.     997.     1023.    765.     383.     95.    ; ..
    388.     895.     980.     452.     460.     1023.    1007.    375.     921.     1004.    255.     254.     763.     310.     991.     945.     445.     955.     143.     1007.  ; ..
    254.     1023.    605.     656.     223.     570.     630.     765.     511.     735.     1021.    371.     1013.    895.     1023.    959.     62.      499.     894.     991.   ; ..
    639.     954.     1015.    975.     511.     1023.    767.     959.     1021.    895.     765.     733.     733.     1000.    1022.    371.     1010.    828.     1019.    831.   ; ..
    375.     963.     1019.    1023.    1019.    1013.    503.     1019.    987.     479.     1022.    1006.    894.     959.     1003.    1019.    1011.    991.     759.     599.   ; ..
    765.     498.     839.     359.     1009.    1019.    506.     1000.    767.     499.     893.     505.     1015.    535.     735.     763.     767.     1021.    494.     735.   ; ..
    1023.    237.     495.     115.     767.     481.     495.     850.     766.     1013.    959.     1003.    447.     471.     987.     796.     491.     743.     989.     703.   ; ..
    974.     719.     311.     506.     927.     959.     366.     781.     1023.    755.     703.     925.     991.     1022.    989.     757.     1017.    255.     345.     1005.  ; ..
    109.     479.     382.     555.     446.     869.     499.     1015.    856.     820.     718.     767.     989.     966.     383.     735.     523.     1018.    957.     925.   ; ..
    767.     399.     991.     1015.    599.     103.     703.     895.     750.     799.     663.     991.     1011.    1022.    501.     763.     959.     1007.    913.     1013.  ; ..
    957.     853.     349.     447.     383.     767.     991.     891.     904.     748.     959.     381.     831.     810.     799.     507.     703.     755.     1023.    911.   ; ..
    719.     381.     918.     767.     803.     789.     733.     637.     623.     383.     507.     1007.    189.     383.     895.     874.     692.     227.     892.     383.   ; ..
    371.     462.     454.     895.     991.     927.     915.     599.     509.     629.     445.     503.     1014.    991.     867.     63.      989.     948.     511.     503.   ; ..
    886.     364.     1023.    999.     366.     879.     1023.    947.     445.     989.     1015.    228.     446.     943.     939.     950.     631.     959.     1018.    999.   ; ..
    719.     501.     1005.    127.     255.     511.     990.     755.     879.     979.     511.     927.     894.     475.     405.     499.     511.     173.     979.     1023.  ; ..
    714.     342.     950.     477.     719.     1011.    635.     955.     884.     438.     497.     991.     350.     674.     887.     1019.    947.     703.     854.     255.   ; ..
    959.     750.     763.     919.     871.     555.     1023.    735.     497.     871.     1018.    545.     791.     671.     495.     437.     631.     1021.    509.     511.   ; ..
    991.     997.     430.     172.     511.     487.     927.     766.     949.     1023.    954.     893.     633.     511.     695.     477.     503.     987.     126.     379.   ; ..
    237.     1022.    489.     955.     895.     501.     507.     486.     507.     511.     463.     181.     885.     952.     627.     506.     894.     983.     811.     884.   ; ..
    490.     639.     869.     349.     949.     935.     1023.    999.     989.     767.     231.     755.     1007.    747.     751.     767.     494.     959.     901.     506.   ; ..
    344.     730.     183.     1007.    822.     631.     1019.    895.     958.     441.     1023.    806.     1023.    487.     829.     871.     767.     487.     925.     759.   ; ..
    951.     611.     759.     916.     991.     1023.    1023.    967.     572.     639.     691.     607.     1023.    503.     447.     719.     991.     767.     755.     890.   ; ..
    1014.    958.     975.     946.     1023.    895.     1013.    343.     1007.    879.     1005.    993.     1005.    371.     959.     444.     984.     1021.    1023.    679.   ; ..
    970.     950.     703.     862.     748.     983.     991.     509.     863.     991.     951.     759.     445.     1023.    502.     855.     725.     927.     991.     126. ];

if or( bitor(A,B) <> C ) then pause, end
