/* ====================================================================
 * Copyright (c) 2003-2006, 2008  Martin Hauner
 *                                http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_MOVECMD_H
#define _SC_MOVECMD_H

// sc
#include "ScCmd.h"
class CmdResultCallback;
class MoveParam;

/**
 * Command for movying files in a working copy or a repository.
 */
class MoveCmd : public ScCmd
{
public:
  /**
   * Construct a MoveCmd.
   *
   * \param param the parameters for the command.
   * \param cb the callback that gets called when the command has finished.
   * The command takes ownership the callback.
   */
  MoveCmd( MoveParam* param, CmdResultCallback* cb );
  ~MoveCmd();

  void run();

  MoveParam* getParam() const;

private:
  // in
  MoveParam*         _param;

  // out
  CmdResultCallback* _cb;
};

#endif // _SC_MOVECMD_H
