#!/usr/bin/env python

import os, sys, re, shutil, time
from glob import glob

do_print = False
filenames = []
flags = []
args = sys.argv[1:]
for arg in args:
    if arg == "print":
        do_print = True
    elif arg.endswith(".ufl"):
        assert os.path.exists(arg)
        filenames.append(arg)
    elif os.path.isdir(arg):
        filenames.extend(glob(os.path.join(arg, "*.ufl")))
    else:
        flags.append(arg)

if not filenames:
    filenames = glob(os.path.join("ufl", "*.ufl"))
filenames = sorted(filenames)

flags = " ".join(flags)

def basename(fn):
    n = os.path.basename(fn)
    b, e = os.path.splitext(n)
    return b

# In case the directory is missing:
try:
    os.mkdir("generated_code")
except:
    pass

timing = []
codepaths = []
fails = []
for fn in filenames:
    print 
    print "--- Handling file", fn
    output = "generated_code/%s" % basename(fn)
    
    # NB! Deleting old contents!
    shutil.rmtree(output, ignore_errors=True)
    
    # Run compilation command
    cmd = "sfc %s -o%s %s" % (flags, output, fn)
    t = -time.time()
    ok = os.system(cmd)
    t += time.time()
    if ok != 0:
        fails.append(fn)
    else:
        codepaths.append(output)
        timing.append("%8.1f seconds to compile %s." % (t, fn))

# Print tabulate_tensor implementations
if do_print:
    for p in codepaths:
        files = glob(os.path.join(p, "*integral*.cpp"))
        cmd = "print_tabulate_tensors %s" % " ".join(files)
        ok = os.system(cmd)
        if ok != 0:
            print "Failed to print tabulate_tensor for ", p
            print "cmd =", cmd


if timing:
    print
    print "--- Timing of each sfc run:"
    print "\n".join(timing)

if fails:
    print
    print "--- The following files failed:"
    print "\n".join(fails)
    print

