from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


ISO8601_PAT = _Mock()

date_default = _Mock()

encode_images = _Mock()

encodebytes = _Mock()

extract_dates = _Mock()

iteritems = _Mock()

json_clean = _Mock()

math = _Mock()

parse_date = _Mock()

py3compat = _Mock()

re = _Mock()

rekey = _Mock()

squash_dates = _Mock()

string_types = _Mock()

types = _Mock()

DEFAULT_ENCODING = 'utf-8'

ISO8601 = '%Y-%m-%dT%H:%M:%S.%f'

JPEG = '\xff\xd8'

JPEG64 = '/9'

PDF64 = 'JVBER'

PNG = '\x89PNG\r\n\x1a\n'

PNG64 = 'iVBORw0KG'

next_attr_name = 'next'

class datetime(_Mock):
  pass


class unicode_type(_Mock):
  pass


