
TDC ?= theme-d-compile
TDL ?= theme-d-link
MODULE_PATH ?= ..:

#RUNTIME_PRETTY_BACKTRACE := --runtime-pretty-backtrace
RUNTIME_PRETTY_BACKTRACE :=
#MODULE_DEBUG_OUTPUT := --module-debug-output
MODULE_DEBUG_OUTPUT :=

.PHONY : all clean modules split-compiler split-linker

PROGRAMS := theme-d-compile-b theme-d-link-b

COMMON_MODULES := \
  address-environment address-table binder builtins cloning \
  common \
  common-procedure-utilities \
  compiler-constructors \
  configuration constructors cycles debug entities \
  errors-common expression-rebinding \
  expression-translation expressions fields hash-tables instances \
  translator-keywords \
  letrec-compilation letrec-env \
  param-cache parametrized-definitions \
  parametrized-instances pcode-common representation \
  special-procedures symbol-table target-object-printing \
  time translation-common type-system type-translation var-names \
  platform-specific statprof-work parameters

COMPILER_MODULES := \
  compilation-errors compilation-utilities compiler-core-def \
  compilation1 compilation2 compile-unit \
  interface-pcode-reading \
  macro-base macro-base2 macro-config macro-language macros \
  phase2-compilation primitive-expansion

ALL_COMPILER_MODULES := $(COMMON_MODULES) $(COMPILER_MODULES)

LINKER_MODULES := \
  linker-core-def linker-errors implementation-pcode-reading \
  link-program link-program-split linker-instantiation \
  scheme0-target-compilation \
  scheme-target-common scheme-target-compilation scheme-target-objects \
  stripping target-compilation-common tree-il-target-compilation

ALL_LINKER_MODULES := $(COMMON_MODULES) $(LINKER_MODULES)

ALL_MODULES := $(COMMON_MODULES) $(COMPILER_MODULES) $(LINKER_MODULES)

all : theme-d-compile-b.go theme-d-link-b.go

modules : \
  $(patsubst %,%.tci,$(ALL_MODULES)) $(patsubst %,%.tcb,$(ALL_MODULES)) \
  theme-d-compile-b.tcp theme-d-link-b.tcp

clean :
	rm -f *.tci
	rm -f *.tcb
	rm -f *.tcp
	rm -f *.go

theme-d-compile-b.go : theme-d-compile-b.tcp \
  $(patsubst %,%.tci,$(ALL_COMPILER_MODULES)) \
  $(patsubst %,%.tcb,$(ALL_COMPILER_MODULES))
	$(TDL) -m $(MODULE_PATH) --backtrace -l 2 \
	--duplicates="merge-generics replace warn last" \
	$(EXTRA_LINK_OPTIONS) \
	$(MODULE_DEBUG_OUTPUT) $(RUNTIME_PRETTY_BACKTRACE) \
	-x "(srfi srfi-19)" -x "(theme-d util time-wrapper)" \
	-x "(theme-d util statprof-work)" $<

split-compiler :
	-rm theme-d-compile-b.build/*
	$(TDL) --split -m $(MODULE_PATH) --backtrace -l 2 \
	--duplicates="merge-generics replace warn last" \
	$(EXTRA_LINK_OPTIONS) \
	$(MODULE_DEBUG_OUTPUT) $(RUNTIME_PRETTY_BACKTRACE) \
	-x "(srfi srfi-19)" -x "(theme-d util time-wrapper)" \
	-x "(theme-d util statprof-work)" theme-d-compile-b.tcp

theme-d-link-b.go : theme-d-link-b.tcp \
  $(patsubst %,%.tci,$(ALL_LINKER_MODULES)) \
  $(patsubst %,%.tcb,$(ALL_LINKER_MODULES))
	$(TDL) -m $(MODULE_PATH) --backtrace -l 2 \
	--duplicates="merge-generics replace warn last" \
	$(EXTRA_LINK_OPTIONS) \
	$(MODULE_DEBUG_OUTPUT) $(RUNTIME_PRETTY_BACKTRACE) \
	-x "(srfi srfi-19)" -x "(theme-d util time-wrapper)" \
	-x "(theme-d util statprof-work)" $<

split-linker :
	-rm theme-d-link-b.build/*
	$(TDL) --split -m $(MODULE_PATH) --backtrace -l 2 \
	--duplicates="merge-generics replace warn last" \
	$(EXTRA_LINK_OPTIONS) \
	$(MODULE_DEBUG_OUTPUT) $(RUNTIME_PRETTY_BACKTRACE) \
	-x "(srfi srfi-19)" -x "(theme-d util time-wrapper)" \
	-x "(theme-d util statprof-work)" theme-d-link-b.tcp

%.tci : %.thi
	$(TDC) -m $(MODULE_PATH) $(EXTRA_COMP_OPTIONS) -o $@ $<

%.tcb : %.thb %.tci
	$(TDC) -m $(MODULE_PATH) $(EXTRA_COMP_OPTIONS) -o $@ $<

%.tcp : %.thp
	$(TDC) -m $(MODULE_PATH) $(EXTRA_COMP_OPTIONS) -o $@ $<

theme-d-compile-b.tcp : theme-d-compile-b.thp \
  $(patsubst %,%.tci,$(ALL_COMPILER_MODULES))

theme-d-link-b.tcp : theme-d-link-b.thp \
  $(patsubst %,%.tci,$(ALL_LINKER_MODULES))

address-environment.tci : address-table.tci entities.tci \
  symbol-table.tci hash-tables.tci binder.tci

address-environment.tcb : type-system.tci representation.tci common.tci

address-table.tci : hash-tables.tci entities.tci translator-keywords.tci

address-table.tcb : common.tci

binder.tci : entities.tci expressions.tci param-cache.tci hash-tables.tci

binder.tcb : cloning.tci

builtins.tci : symbol-table.tci

builtins.tcb : representation.tci special-procedures.tci entities.tci

cloning.tci : binder.tci entities.tci expressions.tci

cloning.tcb : common.tci representation.tci expressions.tci cycles.tci \
  expression-translation.tci type-translation.tci translation-common.tci \
  common-procedure-utilities.tci expression-rebinding.tci type-system.tci \
  constructors.tci parametrized-instances.tci special-procedures.tci \
  hash-tables.tci \
  debug.tci

common.tcb : parameters.tci

common-procedure-utilities.tci : binder.tci entities.tci expressions.tci \
  address-environment.tci instances.tci parametrized-definitions.tci

common-procedure-utilities.tcb : type-translation.tci representation.tci \
  cloning.tci type-system.tci translation-common.tci common.tci debug.tci

compilation-errors.tci : compiler-core-def.tci

compilation-errors.tcb : errors-common.tci macros.tci common.tci \
  hash-tables.tci entities.tci target-object-printing.tci \
  var-names.tci representation.tci platform-specific.tci

compilation-utilities.tci : common.tci entities.tci expressions.tci \
  compiler-core-def.tci symbol-table.tci

compilation-utilities.tcb : representation.tci translator-keywords.tci type-system.tci \
  translation-common.tci hash-tables.tci pcode-common.tci \
  address-environment.tci debug.tci

compilation1.tci : entities.tci compiler-core-def.tci common.tci \
  symbol-table.tci expressions.tci

compilation1.tcb : compilation2.tci translator-keywords.tci representation.tci \
  letrec-compilation.tci compilation-utilities.tci \
  type-system.tci constructors.tci compiler-constructors.tci \
  type-translation.tci \
  translation-common.tci common-procedure-utilities.tci letrec-env.tci \
  cloning.tci expression-translation.tci special-procedures.tci fields.tci \
  debug.tci

compilation2.tci : entities.tci common.tci compiler-core-def.tci \
  symbol-table.tci

compilation2.tcb : compilation1.tci expressions.tci representation.tci \
  type-system.tci compilation-utilities.tci type-translation.tci \
  expression-translation.tci hash-tables.tci common-procedure-utilities.tci \
  translator-keywords.tci translation-common.tci cloning.tci parametrized-instances.tci \
  address-environment.tci address-table.tci interface-pcode-reading.tci \
  constructors.tci compiler-constructors.tci macros.tci \
  pcode-common.tci common.tci parameters.tci debug.tci time.tci

compile-unit.tcb : compiler-core-def.tci parameters.tci entities.tci \
  param-cache.tci symbol-table.tci \
  address-environment.tci binder.tci translator-keywords.tci builtins.tci \
  hash-tables.tci compilation2.tci common.tci pcode-common.tci \
  phase2-compilation.tci representation.tci macros.tci debug.tci \
  compilation-errors.tci macro-base.tci cycles.tci

compiler-constructors.tci : compiler-core-def.tci symbol-table.tci \
  common.tci entities.tci expressions.tci

compiler-constructors.tcb : constructors.tci type-translation.tci \
  type-system.tci representation.tci compilation1.tci binder.tci \
  compilation-utilities.tci compiler-core-def.tci \
  common-procedure-utilities.tci parametrized-instances.tci \
  parametrized-definitions.tci cloning.tci hash-tables.tci debug.tci

compiler-core-def.tci : common.tci translator-keywords.tci entities.tci \
  address-environment.tci symbol-table.tci binder.tci hash-tables.tci \
  letrec-env.tci

compiler-core-def.tcb : debug.tci

constructors.tci : entities.tci binder.tci expressions.tci

constructors.tcb : type-translation.tci representation.tci type-system.tci \
  cloning.tci common.tci parametrized-definitions.tci debug.tci

cycles.tci : entities.tci binder.tci representation.tci hash-tables.tci

cycles.tcb : type-system.tci expressions.tci cloning.tci common.tci \
  debug.tci

entities.tci : common.tci

entities.tcb : representation.tci

errors-common.tci : entities.tci

errors-common.tcb : target-object-printing.tci translator-keywords.tci \
  expressions.tci var-names.tci type-translation.tci representation.tci

expression-rebinding.tci : entities.tci expressions.tci binder.tci

expression-rebinding.tcb : expression-translation.tci representation.tci

expression-translation.tci : entities.tci expressions.tci binder.tci

expression-translation.tcb : translation-common.tci common.tci \
  representation.tci type-system.tci type-translation.tci \
  common-procedure-utilities.tci cloning.tci parametrized-definitions.tci \
  special-procedures.tci debug.tci

expressions.tci : common.tci entities.tci

expressions.tcb : representation.tci

fields.tci : compiler-core-def.tci entities.tci expressions.tci

fields.tcb : common.tci type-system.tci special-procedures.tci \
  representation.tci hash-tables.tci debug.tci

hash-tables.tci : entities.tci common.tci

instances.tci : entities.tci

interface-pcode-reading.tci : common.tci compiler-core-def.tci entities.tci

interface-pcode-reading.tcb : parameters.tci entities.tci \
  address-environment.tci \
  symbol-table.tci hash-tables.tci macros.tci \
  type-translation.tci type-system.tci expressions.tci constructors.tci \
  translator-keywords.tci parametrized-instances.tci representation.tci \
  expression-translation.tci common-procedure-utilities.tci \
  compilation-utilities.tci pcode-common.tci common.tci debug.tci

translator-keywords.tci : entities.tci symbol-table.tci

translator-keywords.tcb : representation.tci

letrec-compilation.tci : letrec-env.tci compiler-core-def.tci \
  common.tci entities.tci expressions.tci symbol-table.tci

letrec-compilation.tcb : compilation1.tci type-system.tci representation.tci \
  binder.tci common.tci

letrec-env.tci : entities.tci

macro-base.tci : common.tci hash-tables.tci entities.tci platform-specific.tci

macro-base.tcb : macro-config.tci macro-language.tci primitive-expansion.tci \
  var-names.tci translator-keywords.tci debug.tci macro-base2.tci

macro-base2.tci : common.tci macro-base.tci

macro-base2.tcb : entities.tci translator-keywords.tci macro-language.tci \
  hash-tables.tci primitive-expansion.tci debug.tci

macro-language.tcb : macro-base.tci macro-base2.tci common.tci \
  hash-tables.tci debug.tci

macros.tci : macro-config.tci macro-base.tci macro-base2.tci

param-cache.tci : entities.tci

param-cache.tcb : common.tci representation.tci

parametrized-definitions.tci : entities.tci binder.tci instances.tci

parametrized-definitions.tcb : \
  common.tci \
  representation.tci \
  expressions.tci \
  type-translation.tci \
  expression-translation.tci \
  cloning.tci \
  type-system.tci \
  cycles.tci \
  common-procedure-utilities.tci \
  param-cache.tci \
  special-procedures.tci \
  parametrized-instances.tci \
  translation-common.tci \
  hash-tables.tci \
  translator-keywords.tci \
  constructors.tci \
  pcode-common.tci \
  debug.tci

parametrized-instances.tci : common.tci entities.tci binder.tci

parametrized-instances.tcb : parametrized-definitions.tci translator-keywords.tci \
  translation-common.tci representation.tci constructors.tci type-system.tci \
  common-procedure-utilities.tci expressions.tci param-cache.tci \
  type-translation.tci debug.tci

pcode-common.tci : common.tci entities.tci

pcode-common.tcb : representation.tci

phase2-compilation.tci : compiler-core-def.tci symbol-table.tci entities.tci

phase2-compilation.tcb : common.tci pcode-common.tci representation.tci \
  type-system.tci expressions.tci cycles.tci hash-tables.tci debug.tci \
  time.tci

primitive-expansion.tci : macro-base.tci

primitive-expansion.tcb : macro-base2.tci common.tci translator-keywords.tci debug.tci

representation.tci : common.tci entities.tci expressions.tci

representation.tcb : translator-keywords.tci debug.tci

special-procedures.tci : entities.tci expressions.tci binder.tci

special-procedures.tcb : representation.tci type-translation.tci \
  type-system.tci cloning.tci common.tci debug.tci

symbol-table.tci : common.tci entities.tci hash-tables.tci

target-object-printing.tcb : entities.tci representation.tci \
  common.tci macros.tci type-system.tci

translation-common.tci : common.tci entities.tci binder.tci expressions.tci

translation-common.tcb : type-translation.tci type-system.tci \
  representation.tci

type-system.tci : entities.tci binder.tci expressions.tci

type-system.tcb : representation.tci parametrized-definitions.tci \
  common.tci cloning.tci common-procedure-utilities.tci \
  type-translation.tci cycles.tci target-object-printing.tci debug.tci

type-translation.tci : entities.tci binder.tci instances.tci

type-translation.tcb : representation.tci type-system.tci cloning.tci \
  common-procedure-utilities.tci constructors.tci parametrized-instances.tci \
  parametrized-definitions.tci param-cache.tci common.tci

var-names.tci : hash-tables.tci

macros-work.tci : common.tci hash-tables.tci entities.tci

macros-work.tcb : macro-config.tci var-names.tci debug.tci

linker-core-def.tci : entities.tci expressions.tci hash-tables.tci \
  param-cache.tci cycles.tci binder.tci common.tci address-environment.tci \
  instances.tci

linker-core-def.tcb : debug.tci

linker-errors.tci : linker-core-def.tci debug.tci

linker-errors.tcb : errors-common.tci target-object-printing.tci \
  representation.tci entities.tci expressions.tci common.tci instances.tci

implementation-pcode-reading.tci : linker-core-def.tci common.tci entities.tci \
  address-environment.tci

implementation-pcode-reading.tcb : binder.tci representation.tci \
  expressions.tci type-system.tci translator-keywords.tci parametrized-instances.tci \
  type-translation.tci expression-translation.tci \
  common-procedure-utilities.tci constructors.tci cloning.tci \
  translation-common.tci hash-tables.tci errors-common.tci pcode-common.tci \
  debug.tci

link-program.tci : linker-core-def.tci common.tci symbol-table.tci \
  target-compilation-common.tci

link-program.tcb : parameters.tci target-compilation-common.tci entities.tci \
  scheme0-target-compilation.tci scheme-target-common.tci \
  scheme-target-compilation.tci tree-il-target-compilation.tci \
  expressions.tci \
  translation-common.tci debug.tci implementation-pcode-reading.tci \
  symbol-table.tci param-cache.tci hash-tables.tci cycles.tci binder.tci \
  special-procedures.tci translator-keywords.tci builtins.tci stripping.tci \
  linker-instantiation.tci configuration.tci linker-errors.tci time.tci

link-program-split.tci : linker-core-def.tci common.tci

link-program-split.tcb : link-program.tci stripping.tci \
  implementation-pcode-reading.tci translation-common.tci \
  configuration.tci tree-il-target-compilation.tci entities.tci \
  target-compilation-common.tci scheme-target-common.tci \
  address-environment.tci hash-tables.tci linker-instantiation.tci \
  parameters.tci symbol-table.tci translator-keywords.tci \
  builtins.tci linker-errors.tci debug.tci

linker-instantiation.tci : entities.tci instances.tci linker-core-def.tci

linker-instantiation.tcb : parametrized-definitions.tci cloning.tci \
  binder.tci representation.tci expressions.tci stripping.tci \
  hash-tables.tci debug.tci

scheme0-target-compilation.tci : \
  linker-core-def.tci target-compilation-common.tci entities.tci \
  linker-instantiation.tci

scheme0-target-compilation.tcb : \
  common.tci scheme-target-common.tci scheme-target-objects.tci \
  representation.tci expressions.tci common-procedure-utilities.tci \
  stripping.tci type-system.tci special-procedures.tci param-cache.tci \
  target-object-printing.tci debug.tci

scheme-target-compilation.tci : \
  linker-core-def.tci entities.tci target-compilation-common.tci

scheme-target-compilation.tcb : \
  scheme-target-common.tci scheme-target-objects.tci expressions.tci \
  type-system.tci representation.tci hash-tables.tci common.tci \
  stripping.tci special-procedures.tci param-cache.tci debug.tci

scheme-target-common.tci : target-compilation-common.tci \
  entities.tci expressions.tci linker-core-def.tci instances.tci \
  linker-instantiation.tci

scheme-target-common.tcb : target-compilation-common.tci type-translation.tci \
  type-system.tci common.tci stripping.tci pcode-common.tci \
  representation.tci cycles.tci parametrized-definitions.tci \
  scheme-target-objects.tci cycles.tci hash-tables.tci debug.tci

scheme-target-objects.tci : entities.tci target-compilation-common.tci \
  linker-core-def.tci expressions.tci

scheme-target-objects.tcb : common.tci representation.tci cloning.tci \
  type-system.tci scheme-target-common.tci hash-tables.tci \
  pcode-common.tci debug.tci

stripping.tci : entities.tci linker-core-def.tci hash-tables.tci \
  expressions.tci

stripping.tcb : representation.tci cloning.tci debug.tci

target-compilation-common.tci : entities.tci linker-core-def.tci \
  binder.tci instances.tci hash-tables.tci

target-compilation-common.tcb : representation.tci common.tci cloning.tci \
  type-system.tci special-procedures.tci address-environment.tci \
  address-table.tci

tree-il-target-compilation.tci : linker-core-def.tci entities.tci \
  target-compilation-common.tci

tree-il-target-compilation.tcb : representation.tci \
  parametrized-definitions.tci binder.tci type-system.tci hash-tables.tci \
  expressions.tci common.tci type-translation.tci param-cache.tci \
  stripping.tci special-procedures.tci cloning.tci cycles.tci \
  instances.tci linker-instantiation.tci debug.tci
