/***************************************************************************
                          dcwidget.h  -  description
                             -------------------
    begin                : Don Mai 30 2002
    copyright            : (C) 2002 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCWIDGET_H
#define DCWIDGET_H

#include <q3listview.h>

// it's for ulonglong
#include <dclib/dcos.h>

class QProgressBar;

/**
  *@author Mathias Küster
  */

class DC_QNumericSortItem {
public:
	/** */
	int mycol;
	/** */
	ulonglong myvalue;
	/** construtor */
	DC_QNumericSortItem() { mycol=-1;myvalue=0; };
	/** destructor */
	virtual ~DC_QNumericSortItem() {};

	/** */
	int mycompare( ulonglong other ) const;
};

class DC_QListViewItem : public Q3ListViewItem, public DC_QNumericSortItem {
public:
	/** construtor */
	DC_QListViewItem( Q3ListView * parent ) : Q3ListViewItem(parent) {};
	/** construtor */
	DC_QListViewItem( Q3ListViewItem * parent ) : Q3ListViewItem(parent) {};
	/** destructor */
	virtual ~DC_QListViewItem() {};

	/** */
	virtual int compare( Q3ListViewItem * i, int col, bool ascending ) const;
	/** */
	virtual QString key( int column, bool ascending ) const;
};

class DC_ListResult : public DC_QListViewItem {
public:
        /** construtor */
        DC_ListResult ( Q3ListView * parent ) : DC_QListViewItem (parent) { };
        /** construtor */
        DC_ListResult ( Q3ListViewItem * parent ) : DC_QListViewItem (parent) { };
        /** destructor */
        virtual ~DC_ListResult() { };

        /** */
        void paintCell( QPainter * p, const QColorGroup & cg, int column, int width, int align );
	/** Re-implemented to fix sorting by slots */
	QString key( int n, bool ascending ) const;
};

class DC_QProgressListItem : public Q3ListViewItem
{
public:
	/** construtor */
	DC_QProgressListItem( DC_QProgressListItem * parent, int column = 0 );
	/** construtor */
	DC_QProgressListItem( Q3ListViewItem * parent, int column = 0 );
	/** construtor */
	DC_QProgressListItem( Q3ListView * parent, int column = 0 );
	/** destructor */
	virtual ~DC_QProgressListItem();
	
	/** */
	virtual void paintCell( QPainter *,  const QColorGroup & cg,
			int column, int width, int alignment );
	/** */
	virtual void paintFocus( QPainter *, const QColorGroup & cg,
					const QRect & r );
	/** */
	virtual int width( const QFontMetrics&, const Q3ListView*, int column) const;
	/** */
	virtual void setup();

	/** */
	virtual int rtti() const;
	/** */
	void SetProgressEnable( bool b ) { m_bProgressEnable=b; }
	/** */
	void setProgress( int i );
	/** */
	void resetProgress();
	/** Reimplemented so sorting is by download/upload + percentage complete */
	virtual QString key( int n, bool ascending ) const;
	/** Set transfer state letter to d for download, u for upload etc. for sorting */
	void setTransferState( QString s );

private:
	/** */
	void init();
	/** */
	int m_nColumn;
	/** */
	bool m_bProgressEnable;
	/** */
	QProgressBar * m_ProgressBar;
	/** Needed for sorting transfers by upload/download */
	QString sTransferState;
};

#endif
