/*
 * Decompiled with CFR 0.152.
 */
import edu.hws.jcm.awt.Controller;
import edu.hws.jcm.awt.DisplayLabel;
import edu.hws.jcm.awt.JCMPanel;
import edu.hws.jcm.awt.Tie;
import edu.hws.jcm.awt.VariableInput;
import edu.hws.jcm.awt.VariableSlider;
import edu.hws.jcm.data.Constant;
import edu.hws.jcm.data.Expression;
import edu.hws.jcm.data.Function;
import edu.hws.jcm.data.ParseError;
import edu.hws.jcm.data.SimpleFunction;
import edu.hws.jcm.data.Value;
import edu.hws.jcm.data.ValueMath;
import edu.hws.jcm.draw.CoordinateRect;
import edu.hws.jcm.draw.DrawGeometric;
import edu.hws.jcm.draw.Graph1D;
import edu.hws.jcm.functions.WrapperFunction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Label;
import java.util.StringTokenizer;

public class SimpleGraph
extends GenericGraphApplet {
    private VariableInput xInput;
    private Function func;
    private Graph1D graph;
    private DrawGeometric point;
    private DrawGeometric vLine;
    private DrawGeometric hLine;

    protected void setUpCanvas() {
        Object object;
        super.setUpCanvas();
        if (this.functionInput != null) {
            this.func = this.functionInput.getFunction(this.xVar);
        } else {
            object = this.getParameter("Function", " abs(" + this.xVar.getName() + ") ^ " + this.xVar.getName());
            SimpleFunction simpleFunction = new SimpleFunction((Expression)this.parser.parse((String)object), this.xVar);
            this.func = new WrapperFunction(simpleFunction);
        }
        this.graph = new Graph1D(this.func);
        object = this.getColorParam("GraphColor");
        if (object != null) {
            this.graph.setColor((Color)object);
        }
        if (!"no".equalsIgnoreCase(this.getParameter("ShowPoint", "yes"))) {
            this.vLine = new DrawGeometric();
            this.hLine = new DrawGeometric();
            this.point = new DrawGeometric();
            this.canvas.add(this.vLine);
            this.canvas.add(this.hLine);
            this.canvas.add(this.point);
        }
        this.canvas.add(this.graph);
    }

    protected void setUpMainPanel() {
        super.setUpMainPanel();
        if ("no".equalsIgnoreCase(this.getParameter("ShowPoint", "yes"))) {
            return;
        }
        this.xInput = new VariableInput();
        this.xInput.setInputStyle(1);
        CoordinateRect coordinateRect = this.canvas.getCoordinateRect();
        VariableSlider variableSlider = new VariableSlider(coordinateRect.getValueObject(0), coordinateRect.getValueObject(1));
        ValueMath valueMath = new ValueMath(this.func, variableSlider);
        DisplayLabel displayLabel = new DisplayLabel(" y = #", valueMath);
        JCMPanel jCMPanel = new JCMPanel(1, 3);
        jCMPanel.setBackground(this.getColorParam("PanelBackground", Color.lightGray));
        JCMPanel jCMPanel2 = new JCMPanel();
        String string = this.getParameter("Variable", "x");
        jCMPanel2.add((Component)new Label(" " + string + " = ", 1), "West");
        jCMPanel2.add((Component)this.xInput, "Center");
        jCMPanel.add(variableSlider);
        jCMPanel.add(jCMPanel2);
        jCMPanel.add(displayLabel);
        if (this.inputPanel == null) {
            this.mainPanel.add((Component)jCMPanel, "South");
        } else {
            this.inputPanel.setBackground(this.getColorParam("PanelBackground", Color.lightGray));
            this.inputPanel.add((Component)jCMPanel, "South");
        }
        this.hLine.setPoints((Value)new Constant(0.0), (Value)valueMath, variableSlider, valueMath);
        this.hLine.setPoints((Value)new Constant(0.0), (Value)valueMath, variableSlider, valueMath);
        this.point.setShape(11);
        this.point.setPoints((Value)variableSlider, (Value)valueMath, 5, 5);
        this.point.setLineWidth(3);
        this.vLine.setPoints((Value)variableSlider, (Value)new Constant(0.0), variableSlider, valueMath);
        Color color = this.getColorParam("LineColor", Color.lightGray);
        this.vLine.setColor(color);
        this.hLine.setColor(color);
        color = this.getColorParam("DotColor", Color.gray);
        this.point.setColor(color);
        Controller controller = new Controller();
        this.xInput.setOnTextChange(controller);
        variableSlider.setOnUserAction(controller);
        coordinateRect.setOnChange(controller);
        controller.add(this.xInput);
        controller.add(variableSlider);
        controller.add(new Tie(variableSlider, this.xInput));
        controller.add(this.hLine);
        controller.add(this.vLine);
        controller.add(this.point);
        controller.add(displayLabel);
        this.mainController.add(controller);
        this.mainController.remove(this.canvas);
        this.mainController.add(this.graph);
    }

    protected void doLoadExample(String string) {
        Object object;
        int n = string.indexOf(";");
        double[] dArray = new double[]{-5.0, 5.0, -5.0, 5.0};
        if (n > 0) {
            object = string.substring(n + 1);
            string = string.substring(0, n);
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, " ,");
            if (stringTokenizer.countTokens() >= 4) {
                for (int i = 0; i < 4; ++i) {
                    try {
                        Double d = new Double(stringTokenizer.nextToken());
                        dArray[i] = d;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (stringTokenizer.countTokens() > 0 && this.xInput != null) {
                    try {
                        Double d = new Double(stringTokenizer.nextToken());
                        this.xInput.setVal(d);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.functionInput != null) {
            this.functionInput.setText(string);
        } else {
            try {
                object = new SimpleFunction((Expression)this.parser.parse(string), this.xVar);
                ((WrapperFunction)this.func).setFunction((Function)object);
            }
            catch (ParseError parseError) {
                // empty catch block
            }
        }
        object = this.canvas.getCoordinateRect(0);
        ((CoordinateRect)object).setLimits(dArray);
        ((CoordinateRect)object).setRestoreBuffer();
        this.mainController.compute();
    }
}

