/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.draw;

import edu.hws.jcm.awt.Computable;
import edu.hws.jcm.data.Function;
import edu.hws.jcm.draw.Drawable;
import java.awt.Color;
import java.awt.Graphics;

public class VectorField
extends Drawable
implements Computable {
    public static final int ARROWS = 0;
    public static final int LINES = 1;
    public static final int CLAMPED_VECTORS = 2;
    public static final int SCALED_LINES = 3;
    public static final int SCALED_VECTORS = 4;
    private int style;
    private Function xFunc;
    private Function yFunc;
    private Color graphColor = Color.lightGray;
    private boolean changed;
    private transient int[][] data;
    private int pixelSpacing = 30;

    public VectorField() {
        this(null, null, 0);
    }

    public VectorField(Function function, Function function2) {
        this(function, function2, 0);
    }

    public VectorField(Function function, Function function2, int n) {
        if (function != null && function.getArity() != 2 || function2 != null && function2.getArity() != 2) {
            throw new IllegalArgumentException("Internal Error:  The functions that define a vector must be functions of two variables.");
        }
        this.xFunc = function;
        this.yFunc = function2;
        this.style = n;
        this.changed = true;
    }

    public void setColor(Color color) {
        if (color != null & !color.equals(this.graphColor)) {
            this.graphColor = color;
            this.needsRedraw();
        }
    }

    public Color getColor() {
        return this.graphColor;
    }

    public synchronized void setFunctions(Function function, Function function2) {
        this.setXFunction(function);
        this.setYFunction(function2);
    }

    public synchronized void setXFunction(Function function) {
        if (function != null && function.getArity() != 2) {
            throw new IllegalArgumentException("Internal Error:  VectorField can only use functions of two variables.");
        }
        if (function != this.xFunc) {
            this.xFunc = function;
            this.changed = true;
            this.needsRedraw();
        }
    }

    public synchronized void setYFunction(Function function) {
        if (function != null && function.getArity() != 1) {
            throw new IllegalArgumentException("Internal Error:  VectorField can only use functions of two variables.");
        }
        if (function != this.yFunc) {
            this.yFunc = function;
            this.changed = true;
            this.needsRedraw();
        }
    }

    public Function getXFunction() {
        return this.xFunc;
    }

    public Function getYFunction() {
        return this.yFunc;
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int n) {
        if (this.style != n) {
            this.style = n;
            this.changed = true;
            this.needsRedraw();
        }
    }

    public int getPixelSpacing() {
        return this.pixelSpacing;
    }

    public void setPixelSpacing(int n) {
        if (n < 5) {
            n = 5;
        } else if (n > 200) {
            n = 200;
        }
        if (n != this.pixelSpacing) {
            this.pixelSpacing = n;
            this.changed = true;
            this.needsRedraw();
        }
    }

    public synchronized void compute() {
        this.setup();
        this.needsRedraw();
        this.changed = false;
    }

    public synchronized void draw(Graphics graphics, boolean bl) {
        if (this.changed || bl || this.data == null) {
            this.setup();
            this.changed = false;
        }
        if (this.data == null) {
            return;
        }
        graphics.setColor(this.graphColor);
        boolean bl2 = this.style == 0 || this.style == 2 || this.style == 4;
        for (int i = 0; i < this.data.length; ++i) {
            int[] nArray = this.data[i];
            if (nArray[0] == Integer.MIN_VALUE) continue;
            graphics.drawLine(nArray[0], nArray[1], nArray[2], nArray[3]);
            if (!bl2 || nArray[4] == Integer.MIN_VALUE) continue;
            graphics.drawLine(nArray[2], nArray[3], nArray[4], nArray[5]);
            graphics.drawLine(nArray[2], nArray[3], nArray[6], nArray[7]);
        }
    }

    private void setup() {
        double d;
        int n;
        if (this.xFunc == null || this.yFunc == null || this.coords == null) {
            this.data = null;
            return;
        }
        boolean bl = this.style == 0 || this.style == 2 || this.style == 4;
        double[] dArray = new double[2];
        int n2 = this.coords.getWidth() / this.pixelSpacing + 2;
        int n3 = this.coords.getHeight() / this.pixelSpacing + 2;
        double d2 = (double)this.pixelSpacing * this.coords.getPixelWidth();
        double d3 = (double)this.pixelSpacing * this.coords.getPixelHeight();
        double d4 = (this.coords.getXmax() + this.coords.getXmin() - (double)n2 * d2) / 2.0;
        double d5 = (this.coords.getYmax() + this.coords.getYmin() - (double)n3 * d3) / 2.0;
        this.data = new int[n2 * n3][bl ? 8 : 4];
        double[][] dArray2 = new double[n2][n3];
        double[][] dArray3 = new double[n2][n3];
        double d6 = this.coords.getPixelWidth();
        double d7 = this.coords.getPixelHeight();
        double d8 = 0.0;
        for (n = 0; n < n2; ++n) {
            double d9;
            dArray[0] = d9 = d4 + (double)n * d2;
            for (int i = 0; i < n3; ++i) {
                double d10;
                dArray[1] = d10 = d5 + (double)i * d3;
                dArray2[n][i] = this.xFunc.getVal(dArray);
                dArray3[n][i] = this.yFunc.getVal(dArray);
                if (Double.isNaN(dArray2[n][i]) || Double.isNaN(dArray3[n][i]) || Double.isInfinite(dArray2[n][i]) || Double.isInfinite(dArray3[n][i])) continue;
                dArray2[n][i] = dArray2[n][i] / d6;
                dArray3[n][i] = -dArray3[n][i] / d7;
                d = dArray2[n][i] * dArray2[n][i] + dArray3[n][i] * dArray3[n][i];
                if (!(d > d8)) continue;
                d8 = d;
            }
        }
        d8 = Math.sqrt(d8);
        n = 0;
        for (int i = 0; i < n2; ++i) {
            double d11 = d4 + (double)i * d2;
            int n4 = this.coords.xToPixel(d11);
            for (int j = 0; j < n3; ++j) {
                d = d5 + (double)j * d3;
                int n5 = this.coords.yToPixel(d);
                int[] nArray = this.data[n];
                ++n;
                if (Double.isNaN(dArray2[i][j]) || Double.isNaN(dArray3[i][j]) || Double.isInfinite(dArray2[i][j]) || Double.isInfinite(dArray3[i][j])) {
                    nArray[i] = Integer.MIN_VALUE;
                    continue;
                }
                double d12 = Math.sqrt(dArray2[i][j] * dArray2[i][j] + dArray3[i][j] * dArray3[i][j]);
                if (d12 < 1.0E-15 || d8 == 0.0 && (this.style == 3 || this.style == 4)) {
                    nArray[0] = nArray[2] = n4;
                    nArray[1] = nArray[3] = n5;
                    if (!bl) continue;
                    nArray[4] = Integer.MIN_VALUE;
                    continue;
                }
                boolean bl2 = false;
                switch (this.style) {
                    case 0: {
                        double d13 = 0.8 * (double)this.pixelSpacing * dArray2[i][j] / d12;
                        double d14 = 0.8 * (double)this.pixelSpacing * dArray3[i][j] / d12;
                        nArray[0] = n4;
                        nArray[1] = n5;
                        nArray[2] = (int)((double)n4 + d13);
                        nArray[3] = (int)((double)n5 + d14);
                        break;
                    }
                    case 1: {
                        double d13 = 0.8 * (double)this.pixelSpacing * dArray2[i][j] / d12 / 2.0;
                        double d14 = 0.8 * (double)this.pixelSpacing * dArray3[i][j] / d12 / 2.0;
                        nArray[0] = (int)((double)n4 - d13);
                        nArray[1] = (int)((double)n5 - d14);
                        nArray[2] = (int)((double)n4 + d13);
                        nArray[3] = (int)((double)n5 + d14);
                        break;
                    }
                    case 2: {
                        double d15 = d12;
                        if (d15 > 0.9 * (double)this.pixelSpacing) {
                            d15 = 0.9 * (double)this.pixelSpacing;
                            bl2 = true;
                        }
                        double d13 = dArray2[i][j] / d12 * d15;
                        double d14 = dArray3[i][j] / d12 * d15;
                        nArray[0] = n4;
                        nArray[1] = n5;
                        nArray[2] = (int)((double)n4 + d13);
                        nArray[3] = (int)((double)n5 + d14);
                        break;
                    }
                    case 3: {
                        double d15 = d12 / d8 * (double)this.pixelSpacing;
                        double d13 = dArray2[i][j] / d12 * d15 / 2.0;
                        double d14 = dArray3[i][j] / d12 * d15 / 2.0;
                        nArray[0] = (int)((double)n4 - d13);
                        nArray[1] = (int)((double)n5 - d14);
                        nArray[2] = (int)((double)n4 + d13);
                        nArray[3] = (int)((double)n5 + d14);
                        break;
                    }
                    case 4: {
                        double d15 = d12 / d8 * (double)this.pixelSpacing;
                        double d13 = dArray2[i][j] / d12 * d15;
                        double d14 = dArray3[i][j] / d12 * d15;
                        nArray[0] = n4;
                        nArray[1] = n5;
                        nArray[2] = (int)((double)n4 + d13);
                        nArray[3] = (int)((double)n5 + d14);
                    }
                }
                if (!bl) continue;
                int n6 = (nArray[2] - nArray[0]) / 5;
                int n7 = (nArray[3] - nArray[1]) / 5;
                if (bl2 || n6 == 0 && n7 == 0) {
                    nArray[4] = Integer.MIN_VALUE;
                    continue;
                }
                nArray[4] = nArray[2] + n7 - n6;
                nArray[5] = nArray[3] - n6 - n7;
                nArray[6] = nArray[2] - n6 - n7;
                nArray[7] = nArray[3] + n6 - n7;
            }
        }
    }
}

