/*
 * $Id: control.c,v 1.1 2000/08/07 22:23:57 emmerson Exp $
 */

/*LINTLIBRARY*/

#include "gks.h"
#include "xgks.h"

extern int	gks_errno;


    void
gopen_gks(
    const char	*err_file,	/* name of error file                    */
    /*ARGSUSED*/
    size_t	mem_units	/* number of units of memory available
				   for buffer space                      */)
{
    FILE	*efile	= err_file == NULL || *err_file == 0
				? stderr
				: fopen(err_file, "w");

    gks_errno	= gopengks((Gfile*)efile, (Glong)mem_units);
}


    void
gclose_gks(void)
{
    gks_errno	= gclosegks();
}

 
    void
gopen_ws(
    Gint	ws_id,		/* workstation identifier   */
    const void	*conn_id,	/* connection identifier    */
    Gint	ws_type		/* workstation type         */)
{
    static const char	*ws_types[]	= {"", NULL, "WISS", "MI", "MO"};

    if (ws_type < 1 || ws_type > 4)
	ws_type	= 0;

    gks_errno	= gopenws(ws_id, (Gchar*)conn_id, (Gchar*)ws_types[ws_type]);
}


    void
gclose_ws(
    Gint	ws_id		/* workstation identifier   */)
{
    gks_errno	= gclosews(ws_id);
}


    void
gactivate_ws(
    Gint	ws_id		/* workstation identifier   */)
{
    gks_errno	= gactivatews(ws_id);
}


    void
gdeactivate_ws(
     Gint	ws_id		/* workstation identifier   */)
{
    gks_errno	= gdeactivatews(ws_id);
}


    void
gclear_ws(
    Gint	ws_id,		/* workstation identifier   */
    Gctrl_flag	ctrl_flag	/* control flag             */)
{
    gks_errno	= gclearws(ws_id, (Gclrflag)ctrl_flag);
}


    void
gredraw_all_segs_ws(
    Gint	ws_id		/* workstation identifier   */)
{
    gks_errno	= gredrawsegws(ws_id);
}


    void
gupd_ws(
    Gint	ws_id,		/* workstation identifier     */
    Gupd_regen_flag
		upd_regen_flag	/* update regeneration flag   */)
{
    gks_errno	= gupdatews(ws_id, upd_regen_flag == GFLAG_PERFORM
				? GPERFORM
				: GPOSTPONE);
}


    void
gset_defer_st(
    Gint	ws_id,		/* workstation identifier       */
    Gdefer_mode	defer_mode,	/* deferral mode                */
    Girg_mode	irg_mode	/* implicit regeneration mode   */)
{
    gks_errno	= gsetdeferst(ws_id, (Gdefmode)defer_mode, (Girgmode)irg_mode);
}


#if 0		/* Function already in '88 API */
    void
gmessage(
    Gint	ws_id,		/* workstation identifier   */
    const char	*message	/* message string           */)
{
}
#endif


    void
gescape(
    /*ARGSUSED*/
    Gint		func_id,	/* escape function identifier       */
    const Gescape_in_data
			*in_data,	/* escape input data record         */
    Gstore		store,		/* handle to Store object           */
    Gescape_out_data	**out_data	/* OUT  escape output data record   */)
{
}
