#Copyright (c) 2014-2018 Tom Schoonjans
#All rights reserved.

#Redistribution and use in source and binary forms, with or without
#modification, are permitted provided that the following conditions are met:
#    * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
#    * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
#    * The names of the contributors may not be used to endorse or promote products derived from this software without specific prior written permission.

#THIS SOFTWARE IS PROVIDED BY Tom Schoonjans ''AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL Tom Schoonjans BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

cdef extern from "config.h":
    char *__version__ "VERSION"

cdef extern from "xraylib-error.h" nogil:
    cdef enum xrl_error_code:
        XRL_ERROR_MEMORY
        XRL_ERROR_INVALID_ARGUMENT
        XRL_ERROR_IO
        XRL_ERROR_TYPE
        XRL_ERROR_UNSUPPORTED
        XRL_ERROR_RUNTIME

    ctypedef struct xrl_error:
        xrl_error_code code
        char *message

cdef extern from "xraylib.h" nogil:
    void XRayInit()
    void SetHardExit(int hard_exit)
    void SetExitStatus(int exit_status)
    int GetExitStatus()
    void SetErrorMessages(int status)
    int GetErrorMessages()
    double AtomicWeight(int Z, xrl_error **error)
    double ElementDensity(int Z, xrl_error **error)
    double CS_KN(double arg1, xrl_error **error)
    double DCS_Thoms(double arg1, xrl_error **error)
    double CS_Total(int arg1, double arg2, xrl_error **error)
    double CS_Photo(int arg1, double arg2, xrl_error **error)
    double CS_Rayl(int arg1, double arg2, xrl_error **error)
    double CS_Compt(int arg1, double arg2, xrl_error **error)
    double CS_Energy(int arg1, double arg2, xrl_error **error)
    double CSb_Total(int arg1, double arg2, xrl_error **error)
    double CSb_Photo(int arg1, double arg2, xrl_error **error)
    double CSb_Rayl(int arg1, double arg2, xrl_error **error)
    double CSb_Compt(int arg1, double arg2, xrl_error **error)
    double FF_Rayl(int arg1, double arg2, xrl_error **error)
    double SF_Compt(int arg1, double arg2, xrl_error **error)
    double Fi(int arg1, double arg2, xrl_error **error)
    double Fii(int arg1, double arg2, xrl_error **error)
    double CS_Photo_Total(int arg1, double arg2, xrl_error **error)
    double CSb_Photo_Total(int arg1, double arg2, xrl_error **error)
    double CS_Total_Kissel(int arg1, double arg2, xrl_error **error)
    double CSb_Total_Kissel(int arg1, double arg2, xrl_error **error)
    double ComptonProfile(int arg1, double arg2, xrl_error **error)
    double LineEnergy(int arg1, int arg2, xrl_error **error)
    double FluorYield(int arg1, int arg2, xrl_error **error)
    double CosKronTransProb(int arg1, int arg2, xrl_error **error)
    double EdgeEnergy(int arg1, int arg2, xrl_error **error)
    double JumpFactor(int arg1, int arg2, xrl_error **error)
    double RadRate(int arg1, int arg2, xrl_error **error)
    double ElectronConfig(int arg1, int arg2, xrl_error **error)
    double AtomicLevelWidth(int arg1, int arg2, xrl_error **error)
    double AugerRate(int arg1, int arg2, xrl_error **error)
    double AugerYield(int arg1, int arg2, xrl_error **error)
    double DCS_KN(double arg1, double arg2, xrl_error **error)
    double DCSP_Thoms(double arg1, double arg2, xrl_error **error)
    double MomentTransf(double arg1, double arg2, xrl_error **error)
    double ComptonEnergy(double arg1, double arg2, xrl_error **error)
    double DCS_Rayl(int arg1, double arg2, double arg3, xrl_error **error)
    double DCS_Compt(int arg1, double arg2, double arg3, xrl_error **error)
    double DCSb_Rayl(int arg1, double arg2, double arg3, xrl_error **error)
    double DCSb_Compt(int arg1, double arg2, double arg3, xrl_error **error)
    double DCSP_KN(double arg1, double arg2, double arg3, xrl_error **error)
    double CS_FluorLine(int arg1, double arg2, double arg3, xrl_error **error)
    double CSb_FluorLine(int arg1, double arg2, double arg3, xrl_error **error)
    double CS_Photo_Partial(int arg1, double arg2, double arg3, xrl_error **error)
    double CSb_Photo_Partial(int arg1, double arg2, double arg3, xrl_error **error)
    double CS_FluorLine_Kissel(int arg1, double arg2, double arg3, xrl_error **error)
    double CSb_FluorLine_Kissel(int arg1, double arg2, double arg3, xrl_error **error)
    double CS_FluorLine_Kissel_Cascade(int arg1, double arg2, double arg3, xrl_error **error)
    double CSb_FluorLine_Kissel_Cascade(int arg1, double arg2, double arg3, xrl_error **error)
    double CS_FluorLine_Kissel_no_Cascade(int arg1, double arg2, double arg3, xrl_error **error)
    double CSb_FluorLine_Kissel_no_Cascade(int arg1, double arg2, double arg3, xrl_error **error)
    double CS_FluorLine_Kissel_Nonradiative_Cascade(int arg1, double arg2, double arg3, xrl_error **error)
    double CSb_FluorLine_Kissel_Nonradiative_Cascade(int arg1, double arg2, double arg3, xrl_error **error)
    double CS_FluorLine_Kissel_Radiative_Cascade(int arg1, double arg2, double arg3, xrl_error **error)
    double CSb_FluorLine_Kissel_Radiative_Cascade(int arg1, double arg2, double arg3, xrl_error **error)
    double ComptonProfile_Partial(int arg1, double arg2, double arg3, xrl_error **error)
    double DCSP_Rayl(int arg1, double arg2, double arg3, double arg4, xrl_error **error)
    double DCSP_Compt(int arg1, double arg2, double arg3, double arg4, xrl_error **error)
    double DCSPb_Rayl(int arg1, double arg2, double arg3, double arg4, xrl_error **error)
    double DCSPb_Compt(int arg1, double arg2, double arg3, double arg4, xrl_error **error)


    int XRAYLIB_MAJOR "XRAYLIB_MAJOR"
    int XRAYLIB_MINOR "XRAYLIB_MINOR"
    double AVOGNUM "AVOGNUM"
    double KEV2ANGST "KEV2ANGST"
    double MEC2 "MEC2"
    double RE2 "RE2"
    double R_E "R_E"
    int KA_LINE "KA_LINE"
    int KB_LINE "KB_LINE"
    int LA_LINE "LA_LINE"
    int LB_LINE "LB_LINE"
    int KA1_LINE "KA1_LINE"
    int KA2_LINE "KA2_LINE"
    int KB1_LINE "KB1_LINE"
    int KB2_LINE "KB2_LINE"
    int KB3_LINE "KB3_LINE"
    int KB4_LINE "KB4_LINE"
    int KB5_LINE "KB5_LINE"
    int LA1_LINE "LA1_LINE"
    int LA2_LINE "LA2_LINE"
    int LB1_LINE "LB1_LINE"
    int LB2_LINE "LB2_LINE"
    int LB3_LINE "LB3_LINE"
    int LB4_LINE "LB4_LINE"
    int LB5_LINE "LB5_LINE"
    int LB6_LINE "LB6_LINE"
    int LB7_LINE "LB7_LINE"
    int LB9_LINE "LB9_LINE"
    int LB10_LINE "LB10_LINE"
    int LB15_LINE "LB15_LINE"
    int LB17_LINE "LB17_LINE"
    int LG1_LINE "LG1_LINE"
    int LG2_LINE "LG2_LINE"
    int LG3_LINE "LG3_LINE"
    int LG4_LINE "LG4_LINE"
    int LG5_LINE "LG5_LINE"
    int LG6_LINE "LG6_LINE"
    int LG8_LINE "LG8_LINE"
    int LE_LINE "LE_LINE"
    int LL_LINE "LL_LINE"
    int LS_LINE "LS_LINE"
    int LT_LINE "LT_LINE"
    int LU_LINE "LU_LINE"
    int LV_LINE "LV_LINE"
    int MA1_LINE "MA1_LINE"
    int MA2_LINE "MA2_LINE"
    int MB_LINE "MB_LINE"
    int MG_LINE "MG_LINE"
    int FL12_TRANS "FL12_TRANS"
    int FL13_TRANS "FL13_TRANS"
    int FLP13_TRANS "FLP13_TRANS"
    int FL23_TRANS "FL23_TRANS"
    int FM12_TRANS "FM12_TRANS"
    int FM13_TRANS "FM13_TRANS"
    int FM14_TRANS "FM14_TRANS"
    int FM15_TRANS "FM15_TRANS"
    int FM23_TRANS "FM23_TRANS"
    int FM24_TRANS "FM24_TRANS"
    int FM25_TRANS "FM25_TRANS"
    int FM34_TRANS "FM34_TRANS"
    int FM35_TRANS "FM35_TRANS"
    int FM45_TRANS "FM45_TRANS"
    int K_L1L1_AUGER "K_L1L1_AUGER"
    int K_L1L2_AUGER "K_L1L2_AUGER"
    int K_L1L3_AUGER "K_L1L3_AUGER"
    int K_L1M1_AUGER "K_L1M1_AUGER"
    int K_L1M2_AUGER    "K_L1M2_AUGER"
    int K_L1M3_AUGER    "K_L1M3_AUGER"
    int K_L1M4_AUGER    "K_L1M4_AUGER"
    int K_L1M5_AUGER    "K_L1M5_AUGER"
    int K_L1N1_AUGER    "K_L1N1_AUGER"
    int K_L1N2_AUGER    "K_L1N2_AUGER"
    int K_L1N3_AUGER   "K_L1N3_AUGER"
    int K_L1N4_AUGER   "K_L1N4_AUGER"
    int K_L1N5_AUGER   "K_L1N5_AUGER"
    int K_L1N6_AUGER   "K_L1N6_AUGER"
    int K_L1N7_AUGER   "K_L1N7_AUGER"
    int K_L1O1_AUGER   "K_L1O1_AUGER"
    int K_L1O2_AUGER   "K_L1O2_AUGER"
    int K_L1O3_AUGER   "K_L1O3_AUGER"
    int K_L1O4_AUGER   "K_L1O4_AUGER"
    int K_L1O5_AUGER   "K_L1O5_AUGER"
    int K_L1O6_AUGER   "K_L1O6_AUGER"
    int K_L1O7_AUGER   "K_L1O7_AUGER"
    int K_L1P1_AUGER   "K_L1P1_AUGER"
    int K_L1P2_AUGER   "K_L1P2_AUGER"
    int K_L1P3_AUGER   "K_L1P3_AUGER"
    int K_L1P4_AUGER   "K_L1P4_AUGER"
    int K_L1P5_AUGER   "K_L1P5_AUGER"
    int K_L1Q1_AUGER   "K_L1Q1_AUGER"
    int K_L1Q2_AUGER   "K_L1Q2_AUGER"
    int K_L1Q3_AUGER   "K_L1Q3_AUGER"
    int K_L2L1_AUGER   "K_L2L1_AUGER"
    int K_L2L2_AUGER   "K_L2L2_AUGER"
    int K_L2L3_AUGER   "K_L2L3_AUGER"
    int K_L2M1_AUGER   "K_L2M1_AUGER"
    int K_L2M2_AUGER   "K_L2M2_AUGER"
    int K_L2M3_AUGER   "K_L2M3_AUGER"
    int K_L2M4_AUGER   "K_L2M4_AUGER"
    int K_L2M5_AUGER   "K_L2M5_AUGER"
    int K_L2N1_AUGER   "K_L2N1_AUGER"
    int K_L2N2_AUGER   "K_L2N2_AUGER"
    int K_L2N3_AUGER   "K_L2N3_AUGER"
    int K_L2N4_AUGER   "K_L2N4_AUGER"
    int K_L2N5_AUGER   "K_L2N5_AUGER"
    int K_L2N6_AUGER   "K_L2N6_AUGER"
    int K_L2N7_AUGER   "K_L2N7_AUGER"
    int K_L2O1_AUGER   "K_L2O1_AUGER"
    int K_L2O2_AUGER   "K_L2O2_AUGER"
    int K_L2O3_AUGER   "K_L2O3_AUGER"
    int K_L2O4_AUGER   "K_L2O4_AUGER"
    int K_L2O5_AUGER   "K_L2O5_AUGER"
    int K_L2O6_AUGER   "K_L2O6_AUGER"
    int K_L2O7_AUGER   "K_L2O7_AUGER"
    int K_L2P1_AUGER   "K_L2P1_AUGER"
    int K_L2P2_AUGER   "K_L2P2_AUGER"
    int K_L2P3_AUGER   "K_L2P3_AUGER"
    int K_L2P4_AUGER   "K_L2P4_AUGER"
    int K_L2P5_AUGER   "K_L2P5_AUGER"
    int K_L2Q1_AUGER   "K_L2Q1_AUGER"
    int K_L2Q2_AUGER   "K_L2Q2_AUGER"
    int K_L2Q3_AUGER   "K_L2Q3_AUGER"
    int K_L3L1_AUGER   "K_L3L1_AUGER"
    int K_L3L2_AUGER   "K_L3L2_AUGER"
    int K_L3L3_AUGER   "K_L3L3_AUGER"
    int K_L3M1_AUGER   "K_L3M1_AUGER"
    int K_L3M2_AUGER   "K_L3M2_AUGER"
    int K_L3M3_AUGER   "K_L3M3_AUGER"
    int K_L3M4_AUGER   "K_L3M4_AUGER"
    int K_L3M5_AUGER   "K_L3M5_AUGER"
    int K_L3N1_AUGER   "K_L3N1_AUGER"
    int K_L3N2_AUGER   "K_L3N2_AUGER"
    int K_L3N3_AUGER   "K_L3N3_AUGER"
    int K_L3N4_AUGER   "K_L3N4_AUGER"
    int K_L3N5_AUGER   "K_L3N5_AUGER"
    int K_L3N6_AUGER   "K_L3N6_AUGER"
    int K_L3N7_AUGER   "K_L3N7_AUGER"
    int K_L3O1_AUGER   "K_L3O1_AUGER"
    int K_L3O2_AUGER   "K_L3O2_AUGER"
    int K_L3O3_AUGER   "K_L3O3_AUGER"
    int K_L3O4_AUGER   "K_L3O4_AUGER"
    int K_L3O5_AUGER   "K_L3O5_AUGER"
    int K_L3O6_AUGER   "K_L3O6_AUGER"
    int K_L3O7_AUGER   "K_L3O7_AUGER"
    int K_L3P1_AUGER   "K_L3P1_AUGER"
    int K_L3P2_AUGER   "K_L3P2_AUGER"
    int K_L3P3_AUGER   "K_L3P3_AUGER"
    int K_L3P4_AUGER   "K_L3P4_AUGER"
    int K_L3P5_AUGER   "K_L3P5_AUGER"
    int K_L3Q1_AUGER   "K_L3Q1_AUGER"
    int K_L3Q2_AUGER   "K_L3Q2_AUGER"
    int K_L3Q3_AUGER   "K_L3Q3_AUGER"
    int K_M1L1_AUGER   "K_M1L1_AUGER"
    int K_M1L2_AUGER   "K_M1L2_AUGER"
    int K_M1L3_AUGER   "K_M1L3_AUGER"
    int K_M1M1_AUGER   "K_M1M1_AUGER"
    int K_M1M2_AUGER   "K_M1M2_AUGER"
    int K_M1M3_AUGER   "K_M1M3_AUGER"
    int K_M1M4_AUGER   "K_M1M4_AUGER"
    int K_M1M5_AUGER   "K_M1M5_AUGER"
    int K_M1N1_AUGER   "K_M1N1_AUGER"
    int K_M1N2_AUGER   "K_M1N2_AUGER"
    int K_M1N3_AUGER  "K_M1N3_AUGER"
    int K_M1N4_AUGER  "K_M1N4_AUGER"
    int K_M1N5_AUGER  "K_M1N5_AUGER"
    int K_M1N6_AUGER  "K_M1N6_AUGER"
    int K_M1N7_AUGER  "K_M1N7_AUGER"
    int K_M1O1_AUGER  "K_M1O1_AUGER"
    int K_M1O2_AUGER  "K_M1O2_AUGER"
    int K_M1O3_AUGER  "K_M1O3_AUGER"
    int K_M1O4_AUGER  "K_M1O4_AUGER"
    int K_M1O5_AUGER  "K_M1O5_AUGER"
    int K_M1O6_AUGER  "K_M1O6_AUGER"
    int K_M1O7_AUGER  "K_M1O7_AUGER"
    int K_M1P1_AUGER  "K_M1P1_AUGER"
    int K_M1P2_AUGER  "K_M1P2_AUGER"
    int K_M1P3_AUGER  "K_M1P3_AUGER"
    int K_M1P4_AUGER  "K_M1P4_AUGER"
    int K_M1P5_AUGER  "K_M1P5_AUGER"
    int K_M1Q1_AUGER  "K_M1Q1_AUGER"
    int K_M1Q2_AUGER  "K_M1Q2_AUGER"
    int K_M1Q3_AUGER  "K_M1Q3_AUGER"
    int K_M2L1_AUGER  "K_M2L1_AUGER"
    int K_M2L2_AUGER  "K_M2L2_AUGER"
    int K_M2L3_AUGER  "K_M2L3_AUGER"
    int K_M2M1_AUGER  "K_M2M1_AUGER"
    int K_M2M2_AUGER  "K_M2M2_AUGER"
    int K_M2M3_AUGER  "K_M2M3_AUGER"
    int K_M2M4_AUGER  "K_M2M4_AUGER"
    int K_M2M5_AUGER  "K_M2M5_AUGER"
    int K_M2N1_AUGER  "K_M2N1_AUGER"
    int K_M2N2_AUGER  "K_M2N2_AUGER"
    int K_M2N3_AUGER  "K_M2N3_AUGER"
    int K_M2N4_AUGER  "K_M2N4_AUGER"
    int K_M2N5_AUGER  "K_M2N5_AUGER"
    int K_M2N6_AUGER  "K_M2N6_AUGER"
    int K_M2N7_AUGER  "K_M2N7_AUGER"
    int K_M2O1_AUGER  "K_M2O1_AUGER"
    int K_M2O2_AUGER  "K_M2O2_AUGER"
    int K_M2O3_AUGER  "K_M2O3_AUGER"
    int K_M2O4_AUGER  "K_M2O4_AUGER"
    int K_M2O5_AUGER  "K_M2O5_AUGER"
    int K_M2O6_AUGER  "K_M2O6_AUGER"
    int K_M2O7_AUGER  "K_M2O7_AUGER"
    int K_M2P1_AUGER  "K_M2P1_AUGER"
    int K_M2P2_AUGER  "K_M2P2_AUGER"
    int K_M2P3_AUGER  "K_M2P3_AUGER"
    int K_M2P4_AUGER  "K_M2P4_AUGER"
    int K_M2P5_AUGER  "K_M2P5_AUGER"
    int K_M2Q1_AUGER  "K_M2Q1_AUGER"
    int K_M2Q2_AUGER  "K_M2Q2_AUGER"
    int K_M2Q3_AUGER  "K_M2Q3_AUGER"
    int K_M3L1_AUGER  "K_M3L1_AUGER"
    int K_M3L2_AUGER  "K_M3L2_AUGER"
    int K_M3L3_AUGER  "K_M3L3_AUGER"
    int K_M3M1_AUGER  "K_M3M1_AUGER"
    int K_M3M2_AUGER  "K_M3M2_AUGER"
    int K_M3M3_AUGER  "K_M3M3_AUGER"
    int K_M3M4_AUGER  "K_M3M4_AUGER"
    int K_M3M5_AUGER  "K_M3M5_AUGER"
    int K_M3N1_AUGER  "K_M3N1_AUGER"
    int K_M3N2_AUGER  "K_M3N2_AUGER"
    int K_M3N3_AUGER  "K_M3N3_AUGER"
    int K_M3N4_AUGER  "K_M3N4_AUGER"
    int K_M3N5_AUGER  "K_M3N5_AUGER"
    int K_M3N6_AUGER  "K_M3N6_AUGER"
    int K_M3N7_AUGER  "K_M3N7_AUGER"
    int K_M3O1_AUGER  "K_M3O1_AUGER"
    int K_M3O2_AUGER  "K_M3O2_AUGER"
    int K_M3O3_AUGER  "K_M3O3_AUGER"
    int K_M3O4_AUGER  "K_M3O4_AUGER"
    int K_M3O5_AUGER  "K_M3O5_AUGER"
    int K_M3O6_AUGER  "K_M3O6_AUGER"
    int K_M3O7_AUGER  "K_M3O7_AUGER"
    int K_M3P1_AUGER  "K_M3P1_AUGER"
    int K_M3P2_AUGER  "K_M3P2_AUGER"
    int K_M3P3_AUGER  "K_M3P3_AUGER"
    int K_M3P4_AUGER  "K_M3P4_AUGER"
    int K_M3P5_AUGER  "K_M3P5_AUGER"
    int K_M3Q1_AUGER  "K_M3Q1_AUGER"
    int K_M3Q2_AUGER  "K_M3Q2_AUGER"
    int K_M3Q3_AUGER  "K_M3Q3_AUGER"
    int K_M4L1_AUGER  "K_M4L1_AUGER"
    int K_M4L2_AUGER  "K_M4L2_AUGER"
    int K_M4L3_AUGER  "K_M4L3_AUGER"
    int K_M4M1_AUGER  "K_M4M1_AUGER"
    int K_M4M2_AUGER  "K_M4M2_AUGER"
    int K_M4M3_AUGER  "K_M4M3_AUGER"
    int K_M4M4_AUGER  "K_M4M4_AUGER"
    int K_M4M5_AUGER  "K_M4M5_AUGER"
    int K_M4N1_AUGER  "K_M4N1_AUGER"
    int K_M4N2_AUGER  "K_M4N2_AUGER"
    int K_M4N3_AUGER  "K_M4N3_AUGER"
    int K_M4N4_AUGER  "K_M4N4_AUGER"
    int K_M4N5_AUGER  "K_M4N5_AUGER"
    int K_M4N6_AUGER  "K_M4N6_AUGER"
    int K_M4N7_AUGER  "K_M4N7_AUGER"
    int K_M4O1_AUGER  "K_M4O1_AUGER"
    int K_M4O2_AUGER  "K_M4O2_AUGER"
    int K_M4O3_AUGER  "K_M4O3_AUGER"
    int K_M4O4_AUGER  "K_M4O4_AUGER"
    int K_M4O5_AUGER  "K_M4O5_AUGER"
    int K_M4O6_AUGER  "K_M4O6_AUGER"
    int K_M4O7_AUGER  "K_M4O7_AUGER"
    int K_M4P1_AUGER  "K_M4P1_AUGER"
    int K_M4P2_AUGER  "K_M4P2_AUGER"
    int K_M4P3_AUGER  "K_M4P3_AUGER"
    int K_M4P4_AUGER  "K_M4P4_AUGER"
    int K_M4P5_AUGER  "K_M4P5_AUGER"
    int K_M4Q1_AUGER  "K_M4Q1_AUGER"
    int K_M4Q2_AUGER  "K_M4Q2_AUGER"
    int K_M4Q3_AUGER  "K_M4Q3_AUGER"
    int K_M5L1_AUGER  "K_M5L1_AUGER"
    int K_M5L2_AUGER  "K_M5L2_AUGER"
    int K_M5L3_AUGER  "K_M5L3_AUGER"
    int K_M5M1_AUGER  "K_M5M1_AUGER"
    int K_M5M2_AUGER  "K_M5M2_AUGER"
    int K_M5M3_AUGER  "K_M5M3_AUGER"
    int K_M5M4_AUGER  "K_M5M4_AUGER"
    int K_M5M5_AUGER  "K_M5M5_AUGER"
    int K_M5N1_AUGER  "K_M5N1_AUGER"
    int K_M5N2_AUGER  "K_M5N2_AUGER"
    int K_M5N3_AUGER  "K_M5N3_AUGER"
    int K_M5N4_AUGER  "K_M5N4_AUGER"
    int K_M5N5_AUGER  "K_M5N5_AUGER"
    int K_M5N6_AUGER  "K_M5N6_AUGER"
    int K_M5N7_AUGER  "K_M5N7_AUGER"
    int K_M5O1_AUGER  "K_M5O1_AUGER"
    int K_M5O2_AUGER  "K_M5O2_AUGER"
    int K_M5O3_AUGER  "K_M5O3_AUGER"
    int K_M5O4_AUGER  "K_M5O4_AUGER"
    int K_M5O5_AUGER  "K_M5O5_AUGER"
    int K_M5O6_AUGER  "K_M5O6_AUGER"
    int K_M5O7_AUGER  "K_M5O7_AUGER"
    int K_M5P1_AUGER  "K_M5P1_AUGER"
    int K_M5P2_AUGER  "K_M5P2_AUGER"
    int K_M5P3_AUGER  "K_M5P3_AUGER"
    int K_M5P4_AUGER  "K_M5P4_AUGER"
    int K_M5P5_AUGER  "K_M5P5_AUGER"
    int K_M5Q1_AUGER  "K_M5Q1_AUGER"
    int K_M5Q2_AUGER  "K_M5Q2_AUGER"
    int K_M5Q3_AUGER  "K_M5Q3_AUGER"
    int L1_L2L2_AUGER  "L1_L2L2_AUGER"
    int L1_L2L3_AUGER  "L1_L2L3_AUGER"
    int L1_L2M1_AUGER  "L1_L2M1_AUGER"
    int L1_L2M2_AUGER  "L1_L2M2_AUGER"
    int L1_L2M3_AUGER  "L1_L2M3_AUGER"
    int L1_L2M4_AUGER  "L1_L2M4_AUGER"
    int L1_L2M5_AUGER  "L1_L2M5_AUGER"
    int L1_L2N1_AUGER  "L1_L2N1_AUGER"
    int L1_L2N2_AUGER  "L1_L2N2_AUGER"
    int L1_L2N3_AUGER  "L1_L2N3_AUGER"
    int L1_L2N4_AUGER  "L1_L2N4_AUGER"
    int L1_L2N5_AUGER  "L1_L2N5_AUGER"
    int L1_L2N6_AUGER  "L1_L2N6_AUGER"
    int L1_L2N7_AUGER  "L1_L2N7_AUGER"
    int L1_L2O1_AUGER  "L1_L2O1_AUGER"
    int L1_L2O2_AUGER  "L1_L2O2_AUGER"
    int L1_L2O3_AUGER  "L1_L2O3_AUGER"
    int L1_L2O4_AUGER  "L1_L2O4_AUGER"
    int L1_L2O5_AUGER  "L1_L2O5_AUGER"
    int L1_L2O6_AUGER  "L1_L2O6_AUGER"
    int L1_L2O7_AUGER  "L1_L2O7_AUGER"
    int L1_L2P1_AUGER  "L1_L2P1_AUGER"
    int L1_L2P2_AUGER  "L1_L2P2_AUGER"
    int L1_L2P3_AUGER  "L1_L2P3_AUGER"
    int L1_L2P4_AUGER  "L1_L2P4_AUGER"
    int L1_L2P5_AUGER  "L1_L2P5_AUGER"
    int L1_L2Q1_AUGER  "L1_L2Q1_AUGER"
    int L1_L2Q2_AUGER  "L1_L2Q2_AUGER"
    int L1_L2Q3_AUGER  "L1_L2Q3_AUGER"
    int L1_L3L2_AUGER  "L1_L3L2_AUGER"
    int L1_L3L3_AUGER  "L1_L3L3_AUGER"
    int L1_L3M1_AUGER  "L1_L3M1_AUGER"
    int L1_L3M2_AUGER  "L1_L3M2_AUGER"
    int L1_L3M3_AUGER  "L1_L3M3_AUGER"
    int L1_L3M4_AUGER  "L1_L3M4_AUGER"
    int L1_L3M5_AUGER  "L1_L3M5_AUGER"
    int L1_L3N1_AUGER  "L1_L3N1_AUGER"
    int L1_L3N2_AUGER  "L1_L3N2_AUGER"
    int L1_L3N3_AUGER  "L1_L3N3_AUGER"
    int L1_L3N4_AUGER  "L1_L3N4_AUGER"
    int L1_L3N5_AUGER  "L1_L3N5_AUGER"
    int L1_L3N6_AUGER  "L1_L3N6_AUGER"
    int L1_L3N7_AUGER  "L1_L3N7_AUGER"
    int L1_L3O1_AUGER  "L1_L3O1_AUGER"
    int L1_L3O2_AUGER  "L1_L3O2_AUGER"
    int L1_L3O3_AUGER  "L1_L3O3_AUGER"
    int L1_L3O4_AUGER  "L1_L3O4_AUGER"
    int L1_L3O5_AUGER  "L1_L3O5_AUGER"
    int L1_L3O6_AUGER  "L1_L3O6_AUGER"
    int L1_L3O7_AUGER  "L1_L3O7_AUGER"
    int L1_L3P1_AUGER  "L1_L3P1_AUGER"
    int L1_L3P2_AUGER  "L1_L3P2_AUGER"
    int L1_L3P3_AUGER  "L1_L3P3_AUGER"
    int L1_L3P4_AUGER  "L1_L3P4_AUGER"
    int L1_L3P5_AUGER  "L1_L3P5_AUGER"
    int L1_L3Q1_AUGER  "L1_L3Q1_AUGER"
    int L1_L3Q2_AUGER  "L1_L3Q2_AUGER"
    int L1_L3Q3_AUGER  "L1_L3Q3_AUGER"
    int L1_M1L2_AUGER  "L1_M1L2_AUGER"
    int L1_M1L3_AUGER  "L1_M1L3_AUGER"
    int L1_M1M1_AUGER  "L1_M1M1_AUGER"
    int L1_M1M2_AUGER  "L1_M1M2_AUGER"
    int L1_M1M3_AUGER  "L1_M1M3_AUGER"
    int L1_M1M4_AUGER  "L1_M1M4_AUGER"
    int L1_M1M5_AUGER  "L1_M1M5_AUGER"
    int L1_M1N1_AUGER  "L1_M1N1_AUGER"
    int L1_M1N2_AUGER  "L1_M1N2_AUGER"
    int L1_M1N3_AUGER  "L1_M1N3_AUGER"
    int L1_M1N4_AUGER  "L1_M1N4_AUGER"
    int L1_M1N5_AUGER  "L1_M1N5_AUGER"
    int L1_M1N6_AUGER  "L1_M1N6_AUGER"
    int L1_M1N7_AUGER  "L1_M1N7_AUGER"
    int L1_M1O1_AUGER  "L1_M1O1_AUGER"
    int L1_M1O2_AUGER  "L1_M1O2_AUGER"
    int L1_M1O3_AUGER  "L1_M1O3_AUGER"
    int L1_M1O4_AUGER  "L1_M1O4_AUGER"
    int L1_M1O5_AUGER  "L1_M1O5_AUGER"
    int L1_M1O6_AUGER  "L1_M1O6_AUGER"
    int L1_M1O7_AUGER  "L1_M1O7_AUGER"
    int L1_M1P1_AUGER  "L1_M1P1_AUGER"
    int L1_M1P2_AUGER  "L1_M1P2_AUGER"
    int L1_M1P3_AUGER  "L1_M1P3_AUGER"
    int L1_M1P4_AUGER  "L1_M1P4_AUGER"
    int L1_M1P5_AUGER  "L1_M1P5_AUGER"
    int L1_M1Q1_AUGER  "L1_M1Q1_AUGER"
    int L1_M1Q2_AUGER  "L1_M1Q2_AUGER"
    int L1_M1Q3_AUGER  "L1_M1Q3_AUGER"
    int L1_M2L2_AUGER  "L1_M2L2_AUGER"
    int L1_M2L3_AUGER  "L1_M2L3_AUGER"
    int L1_M2M1_AUGER  "L1_M2M1_AUGER"
    int L1_M2M2_AUGER  "L1_M2M2_AUGER"
    int L1_M2M3_AUGER  "L1_M2M3_AUGER"
    int L1_M2M4_AUGER  "L1_M2M4_AUGER"
    int L1_M2M5_AUGER  "L1_M2M5_AUGER"
    int L1_M2N1_AUGER  "L1_M2N1_AUGER"
    int L1_M2N2_AUGER  "L1_M2N2_AUGER"
    int L1_M2N3_AUGER  "L1_M2N3_AUGER"
    int L1_M2N4_AUGER  "L1_M2N4_AUGER"
    int L1_M2N5_AUGER  "L1_M2N5_AUGER"
    int L1_M2N6_AUGER  "L1_M2N6_AUGER"
    int L1_M2N7_AUGER  "L1_M2N7_AUGER"
    int L1_M2O1_AUGER  "L1_M2O1_AUGER"
    int L1_M2O2_AUGER  "L1_M2O2_AUGER"
    int L1_M2O3_AUGER  "L1_M2O3_AUGER"
    int L1_M2O4_AUGER  "L1_M2O4_AUGER"
    int L1_M2O5_AUGER  "L1_M2O5_AUGER"
    int L1_M2O6_AUGER  "L1_M2O6_AUGER"
    int L1_M2O7_AUGER  "L1_M2O7_AUGER"
    int L1_M2P1_AUGER  "L1_M2P1_AUGER"
    int L1_M2P2_AUGER  "L1_M2P2_AUGER"
    int L1_M2P3_AUGER  "L1_M2P3_AUGER"
    int L1_M2P4_AUGER  "L1_M2P4_AUGER"
    int L1_M2P5_AUGER  "L1_M2P5_AUGER"
    int L1_M2Q1_AUGER  "L1_M2Q1_AUGER"
    int L1_M2Q2_AUGER  "L1_M2Q2_AUGER"
    int L1_M2Q3_AUGER  "L1_M2Q3_AUGER"
    int L1_M3L2_AUGER  "L1_M3L2_AUGER"
    int L1_M3L3_AUGER  "L1_M3L3_AUGER"
    int L1_M3M1_AUGER  "L1_M3M1_AUGER"
    int L1_M3M2_AUGER  "L1_M3M2_AUGER"
    int L1_M3M3_AUGER  "L1_M3M3_AUGER"
    int L1_M3M4_AUGER  "L1_M3M4_AUGER"
    int L1_M3M5_AUGER  "L1_M3M5_AUGER"
    int L1_M3N1_AUGER  "L1_M3N1_AUGER"
    int L1_M3N2_AUGER  "L1_M3N2_AUGER"
    int L1_M3N3_AUGER  "L1_M3N3_AUGER"
    int L1_M3N4_AUGER  "L1_M3N4_AUGER"
    int L1_M3N5_AUGER  "L1_M3N5_AUGER"
    int L1_M3N6_AUGER  "L1_M3N6_AUGER"
    int L1_M3N7_AUGER  "L1_M3N7_AUGER"
    int L1_M3O1_AUGER  "L1_M3O1_AUGER"
    int L1_M3O2_AUGER  "L1_M3O2_AUGER"
    int L1_M3O3_AUGER  "L1_M3O3_AUGER"
    int L1_M3O4_AUGER  "L1_M3O4_AUGER"
    int L1_M3O5_AUGER  "L1_M3O5_AUGER"
    int L1_M3O6_AUGER  "L1_M3O6_AUGER"
    int L1_M3O7_AUGER  "L1_M3O7_AUGER"
    int L1_M3P1_AUGER  "L1_M3P1_AUGER"
    int L1_M3P2_AUGER  "L1_M3P2_AUGER"
    int L1_M3P3_AUGER  "L1_M3P3_AUGER"
    int L1_M3P4_AUGER  "L1_M3P4_AUGER"
    int L1_M3P5_AUGER  "L1_M3P5_AUGER"
    int L1_M3Q1_AUGER  "L1_M3Q1_AUGER"
    int L1_M3Q2_AUGER  "L1_M3Q2_AUGER"
    int L1_M3Q3_AUGER  "L1_M3Q3_AUGER"
    int L1_M4L2_AUGER  "L1_M4L2_AUGER"
    int L1_M4L3_AUGER  "L1_M4L3_AUGER"
    int L1_M4M1_AUGER  "L1_M4M1_AUGER"
    int L1_M4M2_AUGER  "L1_M4M2_AUGER"
    int L1_M4M3_AUGER  "L1_M4M3_AUGER"
    int L1_M4M4_AUGER  "L1_M4M4_AUGER"
    int L1_M4M5_AUGER  "L1_M4M5_AUGER"
    int L1_M4N1_AUGER  "L1_M4N1_AUGER"
    int L1_M4N2_AUGER  "L1_M4N2_AUGER"
    int L1_M4N3_AUGER  "L1_M4N3_AUGER"
    int L1_M4N4_AUGER  "L1_M4N4_AUGER"
    int L1_M4N5_AUGER  "L1_M4N5_AUGER"
    int L1_M4N6_AUGER  "L1_M4N6_AUGER"
    int L1_M4N7_AUGER  "L1_M4N7_AUGER"
    int L1_M4O1_AUGER  "L1_M4O1_AUGER"
    int L1_M4O2_AUGER  "L1_M4O2_AUGER"
    int L1_M4O3_AUGER  "L1_M4O3_AUGER"
    int L1_M4O4_AUGER  "L1_M4O4_AUGER"
    int L1_M4O5_AUGER  "L1_M4O5_AUGER"
    int L1_M4O6_AUGER  "L1_M4O6_AUGER"
    int L1_M4O7_AUGER  "L1_M4O7_AUGER"
    int L1_M4P1_AUGER  "L1_M4P1_AUGER"
    int L1_M4P2_AUGER  "L1_M4P2_AUGER"
    int L1_M4P3_AUGER  "L1_M4P3_AUGER"
    int L1_M4P4_AUGER  "L1_M4P4_AUGER"
    int L1_M4P5_AUGER  "L1_M4P5_AUGER"
    int L1_M4Q1_AUGER  "L1_M4Q1_AUGER"
    int L1_M4Q2_AUGER  "L1_M4Q2_AUGER"
    int L1_M4Q3_AUGER  "L1_M4Q3_AUGER"
    int L1_M5L2_AUGER  "L1_M5L2_AUGER"
    int L1_M5L3_AUGER  "L1_M5L3_AUGER"
    int L1_M5M1_AUGER  "L1_M5M1_AUGER"
    int L1_M5M2_AUGER  "L1_M5M2_AUGER"
    int L1_M5M3_AUGER  "L1_M5M3_AUGER"
    int L1_M5M4_AUGER  "L1_M5M4_AUGER"
    int L1_M5M5_AUGER  "L1_M5M5_AUGER"
    int L1_M5N1_AUGER  "L1_M5N1_AUGER"
    int L1_M5N2_AUGER  "L1_M5N2_AUGER"
    int L1_M5N3_AUGER  "L1_M5N3_AUGER"
    int L1_M5N4_AUGER  "L1_M5N4_AUGER"
    int L1_M5N5_AUGER  "L1_M5N5_AUGER"
    int L1_M5N6_AUGER  "L1_M5N6_AUGER"
    int L1_M5N7_AUGER  "L1_M5N7_AUGER"
    int L1_M5O1_AUGER  "L1_M5O1_AUGER"
    int L1_M5O2_AUGER  "L1_M5O2_AUGER"
    int L1_M5O3_AUGER  "L1_M5O3_AUGER"
    int L1_M5O4_AUGER  "L1_M5O4_AUGER"
    int L1_M5O5_AUGER  "L1_M5O5_AUGER"
    int L1_M5O6_AUGER  "L1_M5O6_AUGER"
    int L1_M5O7_AUGER  "L1_M5O7_AUGER"
    int L1_M5P1_AUGER  "L1_M5P1_AUGER"
    int L1_M5P2_AUGER  "L1_M5P2_AUGER"
    int L1_M5P3_AUGER  "L1_M5P3_AUGER"
    int L1_M5P4_AUGER  "L1_M5P4_AUGER"
    int L1_M5P5_AUGER  "L1_M5P5_AUGER"
    int L1_M5Q1_AUGER  "L1_M5Q1_AUGER"
    int L1_M5Q2_AUGER  "L1_M5Q2_AUGER"
    int L1_M5Q3_AUGER  "L1_M5Q3_AUGER"
    int L2_L3L3_AUGER  "L2_L3L3_AUGER"
    int L2_L3M1_AUGER  "L2_L3M1_AUGER"
    int L2_L3M2_AUGER  "L2_L3M2_AUGER"
    int L2_L3M3_AUGER  "L2_L3M3_AUGER"
    int L2_L3M4_AUGER  "L2_L3M4_AUGER"
    int L2_L3M5_AUGER  "L2_L3M5_AUGER"
    int L2_L3N1_AUGER  "L2_L3N1_AUGER"
    int L2_L3N2_AUGER  "L2_L3N2_AUGER"
    int L2_L3N3_AUGER  "L2_L3N3_AUGER"
    int L2_L3N4_AUGER  "L2_L3N4_AUGER"
    int L2_L3N5_AUGER  "L2_L3N5_AUGER"
    int L2_L3N6_AUGER  "L2_L3N6_AUGER"
    int L2_L3N7_AUGER  "L2_L3N7_AUGER"
    int L2_L3O1_AUGER  "L2_L3O1_AUGER"
    int L2_L3O2_AUGER  "L2_L3O2_AUGER"
    int L2_L3O3_AUGER  "L2_L3O3_AUGER"
    int L2_L3O4_AUGER  "L2_L3O4_AUGER"
    int L2_L3O5_AUGER  "L2_L3O5_AUGER"
    int L2_L3O6_AUGER  "L2_L3O6_AUGER"
    int L2_L3O7_AUGER  "L2_L3O7_AUGER"
    int L2_L3P1_AUGER  "L2_L3P1_AUGER"
    int L2_L3P2_AUGER  "L2_L3P2_AUGER"
    int L2_L3P3_AUGER  "L2_L3P3_AUGER"
    int L2_L3P4_AUGER  "L2_L3P4_AUGER"
    int L2_L3P5_AUGER  "L2_L3P5_AUGER"
    int L2_L3Q1_AUGER  "L2_L3Q1_AUGER"
    int L2_L3Q2_AUGER  "L2_L3Q2_AUGER"
    int L2_L3Q3_AUGER  "L2_L3Q3_AUGER"
    int L2_M1L3_AUGER  "L2_M1L3_AUGER"
    int L2_M1M1_AUGER  "L2_M1M1_AUGER"
    int L2_M1M2_AUGER  "L2_M1M2_AUGER"
    int L2_M1M3_AUGER  "L2_M1M3_AUGER"
    int L2_M1M4_AUGER  "L2_M1M4_AUGER"
    int L2_M1M5_AUGER  "L2_M1M5_AUGER"
    int L2_M1N1_AUGER  "L2_M1N1_AUGER"
    int L2_M1N2_AUGER  "L2_M1N2_AUGER"
    int L2_M1N3_AUGER  "L2_M1N3_AUGER"
    int L2_M1N4_AUGER  "L2_M1N4_AUGER"
    int L2_M1N5_AUGER  "L2_M1N5_AUGER"
    int L2_M1N6_AUGER  "L2_M1N6_AUGER"
    int L2_M1N7_AUGER  "L2_M1N7_AUGER"
    int L2_M1O1_AUGER  "L2_M1O1_AUGER"
    int L2_M1O2_AUGER  "L2_M1O2_AUGER"
    int L2_M1O3_AUGER  "L2_M1O3_AUGER"
    int L2_M1O4_AUGER  "L2_M1O4_AUGER"
    int L2_M1O5_AUGER  "L2_M1O5_AUGER"
    int L2_M1O6_AUGER  "L2_M1O6_AUGER"
    int L2_M1O7_AUGER  "L2_M1O7_AUGER"
    int L2_M1P1_AUGER  "L2_M1P1_AUGER"
    int L2_M1P2_AUGER  "L2_M1P2_AUGER"
    int L2_M1P3_AUGER  "L2_M1P3_AUGER"
    int L2_M1P4_AUGER  "L2_M1P4_AUGER"
    int L2_M1P5_AUGER  "L2_M1P5_AUGER"
    int L2_M1Q1_AUGER  "L2_M1Q1_AUGER"
    int L2_M1Q2_AUGER  "L2_M1Q2_AUGER"
    int L2_M1Q3_AUGER  "L2_M1Q3_AUGER"
    int L2_M2L3_AUGER  "L2_M2L3_AUGER"
    int L2_M2M1_AUGER  "L2_M2M1_AUGER"
    int L2_M2M2_AUGER  "L2_M2M2_AUGER"
    int L2_M2M3_AUGER  "L2_M2M3_AUGER"
    int L2_M2M4_AUGER  "L2_M2M4_AUGER"
    int L2_M2M5_AUGER  "L2_M2M5_AUGER"
    int L2_M2N1_AUGER  "L2_M2N1_AUGER"
    int L2_M2N2_AUGER  "L2_M2N2_AUGER"
    int L2_M2N3_AUGER  "L2_M2N3_AUGER"
    int L2_M2N4_AUGER  "L2_M2N4_AUGER"
    int L2_M2N5_AUGER  "L2_M2N5_AUGER"
    int L2_M2N6_AUGER  "L2_M2N6_AUGER"
    int L2_M2N7_AUGER  "L2_M2N7_AUGER"
    int L2_M2O1_AUGER  "L2_M2O1_AUGER"
    int L2_M2O2_AUGER  "L2_M2O2_AUGER"
    int L2_M2O3_AUGER  "L2_M2O3_AUGER"
    int L2_M2O4_AUGER  "L2_M2O4_AUGER"
    int L2_M2O5_AUGER  "L2_M2O5_AUGER"
    int L2_M2O6_AUGER  "L2_M2O6_AUGER"
    int L2_M2O7_AUGER  "L2_M2O7_AUGER"
    int L2_M2P1_AUGER  "L2_M2P1_AUGER"
    int L2_M2P2_AUGER  "L2_M2P2_AUGER"
    int L2_M2P3_AUGER  "L2_M2P3_AUGER"
    int L2_M2P4_AUGER  "L2_M2P4_AUGER"
    int L2_M2P5_AUGER  "L2_M2P5_AUGER"
    int L2_M2Q1_AUGER  "L2_M2Q1_AUGER"
    int L2_M2Q2_AUGER  "L2_M2Q2_AUGER"
    int L2_M2Q3_AUGER  "L2_M2Q3_AUGER"
    int L2_M3L3_AUGER  "L2_M3L3_AUGER"
    int L2_M3M1_AUGER  "L2_M3M1_AUGER"
    int L2_M3M2_AUGER  "L2_M3M2_AUGER"
    int L2_M3M3_AUGER  "L2_M3M3_AUGER"
    int L2_M3M4_AUGER  "L2_M3M4_AUGER"
    int L2_M3M5_AUGER  "L2_M3M5_AUGER"
    int L2_M3N1_AUGER  "L2_M3N1_AUGER"
    int L2_M3N2_AUGER  "L2_M3N2_AUGER"
    int L2_M3N3_AUGER  "L2_M3N3_AUGER"
    int L2_M3N4_AUGER  "L2_M3N4_AUGER"
    int L2_M3N5_AUGER  "L2_M3N5_AUGER"
    int L2_M3N6_AUGER  "L2_M3N6_AUGER"
    int L2_M3N7_AUGER  "L2_M3N7_AUGER"
    int L2_M3O1_AUGER  "L2_M3O1_AUGER"
    int L2_M3O2_AUGER  "L2_M3O2_AUGER"
    int L2_M3O3_AUGER  "L2_M3O3_AUGER"
    int L2_M3O4_AUGER  "L2_M3O4_AUGER"
    int L2_M3O5_AUGER  "L2_M3O5_AUGER"
    int L2_M3O6_AUGER  "L2_M3O6_AUGER"
    int L2_M3O7_AUGER  "L2_M3O7_AUGER"
    int L2_M3P1_AUGER  "L2_M3P1_AUGER"
    int L2_M3P2_AUGER  "L2_M3P2_AUGER"
    int L2_M3P3_AUGER  "L2_M3P3_AUGER"
    int L2_M3P4_AUGER  "L2_M3P4_AUGER"
    int L2_M3P5_AUGER  "L2_M3P5_AUGER"
    int L2_M3Q1_AUGER  "L2_M3Q1_AUGER"
    int L2_M3Q2_AUGER  "L2_M3Q2_AUGER"
    int L2_M3Q3_AUGER  "L2_M3Q3_AUGER"
    int L2_M4L3_AUGER  "L2_M4L3_AUGER"
    int L2_M4M1_AUGER  "L2_M4M1_AUGER"
    int L2_M4M2_AUGER  "L2_M4M2_AUGER"
    int L2_M4M3_AUGER  "L2_M4M3_AUGER"
    int L2_M4M4_AUGER  "L2_M4M4_AUGER"
    int L2_M4M5_AUGER  "L2_M4M5_AUGER"
    int L2_M4N1_AUGER  "L2_M4N1_AUGER"
    int L2_M4N2_AUGER  "L2_M4N2_AUGER"
    int L2_M4N3_AUGER  "L2_M4N3_AUGER"
    int L2_M4N4_AUGER  "L2_M4N4_AUGER"
    int L2_M4N5_AUGER  "L2_M4N5_AUGER"
    int L2_M4N6_AUGER  "L2_M4N6_AUGER"
    int L2_M4N7_AUGER  "L2_M4N7_AUGER"
    int L2_M4O1_AUGER  "L2_M4O1_AUGER"
    int L2_M4O2_AUGER  "L2_M4O2_AUGER"
    int L2_M4O3_AUGER  "L2_M4O3_AUGER"
    int L2_M4O4_AUGER  "L2_M4O4_AUGER"
    int L2_M4O5_AUGER  "L2_M4O5_AUGER"
    int L2_M4O6_AUGER  "L2_M4O6_AUGER"
    int L2_M4O7_AUGER  "L2_M4O7_AUGER"
    int L2_M4P1_AUGER  "L2_M4P1_AUGER"
    int L2_M4P2_AUGER  "L2_M4P2_AUGER"
    int L2_M4P3_AUGER  "L2_M4P3_AUGER"
    int L2_M4P4_AUGER  "L2_M4P4_AUGER"
    int L2_M4P5_AUGER  "L2_M4P5_AUGER"
    int L2_M4Q1_AUGER  "L2_M4Q1_AUGER"
    int L2_M4Q2_AUGER  "L2_M4Q2_AUGER"
    int L2_M4Q3_AUGER  "L2_M4Q3_AUGER"
    int L2_M5L3_AUGER  "L2_M5L3_AUGER"
    int L2_M5M1_AUGER  "L2_M5M1_AUGER"
    int L2_M5M2_AUGER  "L2_M5M2_AUGER"
    int L2_M5M3_AUGER  "L2_M5M3_AUGER"
    int L2_M5M4_AUGER  "L2_M5M4_AUGER"
    int L2_M5M5_AUGER  "L2_M5M5_AUGER"
    int L2_M5N1_AUGER  "L2_M5N1_AUGER"
    int L2_M5N2_AUGER  "L2_M5N2_AUGER"
    int L2_M5N3_AUGER  "L2_M5N3_AUGER"
    int L2_M5N4_AUGER  "L2_M5N4_AUGER"
    int L2_M5N5_AUGER  "L2_M5N5_AUGER"
    int L2_M5N6_AUGER  "L2_M5N6_AUGER"
    int L2_M5N7_AUGER  "L2_M5N7_AUGER"
    int L2_M5O1_AUGER  "L2_M5O1_AUGER"
    int L2_M5O2_AUGER  "L2_M5O2_AUGER"
    int L2_M5O3_AUGER  "L2_M5O3_AUGER"
    int L2_M5O4_AUGER  "L2_M5O4_AUGER"
    int L2_M5O5_AUGER  "L2_M5O5_AUGER"
    int L2_M5O6_AUGER  "L2_M5O6_AUGER"
    int L2_M5O7_AUGER  "L2_M5O7_AUGER"
    int L2_M5P1_AUGER  "L2_M5P1_AUGER"
    int L2_M5P2_AUGER  "L2_M5P2_AUGER"
    int L2_M5P3_AUGER  "L2_M5P3_AUGER"
    int L2_M5P4_AUGER  "L2_M5P4_AUGER"
    int L2_M5P5_AUGER  "L2_M5P5_AUGER"
    int L2_M5Q1_AUGER  "L2_M5Q1_AUGER"
    int L2_M5Q2_AUGER  "L2_M5Q2_AUGER"
    int L2_M5Q3_AUGER  "L2_M5Q3_AUGER"
    int L3_M1M1_AUGER  "L3_M1M1_AUGER"
    int L3_M1M2_AUGER  "L3_M1M2_AUGER"
    int L3_M1M3_AUGER  "L3_M1M3_AUGER"
    int L3_M1M4_AUGER  "L3_M1M4_AUGER"
    int L3_M1M5_AUGER  "L3_M1M5_AUGER"
    int L3_M1N1_AUGER  "L3_M1N1_AUGER"
    int L3_M1N2_AUGER  "L3_M1N2_AUGER"
    int L3_M1N3_AUGER  "L3_M1N3_AUGER"
    int L3_M1N4_AUGER  "L3_M1N4_AUGER"
    int L3_M1N5_AUGER  "L3_M1N5_AUGER"
    int L3_M1N6_AUGER  "L3_M1N6_AUGER"
    int L3_M1N7_AUGER  "L3_M1N7_AUGER"
    int L3_M1O1_AUGER  "L3_M1O1_AUGER"
    int L3_M1O2_AUGER  "L3_M1O2_AUGER"
    int L3_M1O3_AUGER  "L3_M1O3_AUGER"
    int L3_M1O4_AUGER  "L3_M1O4_AUGER"
    int L3_M1O5_AUGER  "L3_M1O5_AUGER"
    int L3_M1O6_AUGER  "L3_M1O6_AUGER"
    int L3_M1O7_AUGER  "L3_M1O7_AUGER"
    int L3_M1P1_AUGER  "L3_M1P1_AUGER"
    int L3_M1P2_AUGER  "L3_M1P2_AUGER"
    int L3_M1P3_AUGER  "L3_M1P3_AUGER"
    int L3_M1P4_AUGER  "L3_M1P4_AUGER"
    int L3_M1P5_AUGER  "L3_M1P5_AUGER"
    int L3_M1Q1_AUGER  "L3_M1Q1_AUGER"
    int L3_M1Q2_AUGER  "L3_M1Q2_AUGER"
    int L3_M1Q3_AUGER  "L3_M1Q3_AUGER"
    int L3_M2M1_AUGER  "L3_M2M1_AUGER"
    int L3_M2M2_AUGER  "L3_M2M2_AUGER"
    int L3_M2M3_AUGER  "L3_M2M3_AUGER"
    int L3_M2M4_AUGER  "L3_M2M4_AUGER"
    int L3_M2M5_AUGER  "L3_M2M5_AUGER"
    int L3_M2N1_AUGER  "L3_M2N1_AUGER"
    int L3_M2N2_AUGER  "L3_M2N2_AUGER"
    int L3_M2N3_AUGER  "L3_M2N3_AUGER"
    int L3_M2N4_AUGER  "L3_M2N4_AUGER"
    int L3_M2N5_AUGER  "L3_M2N5_AUGER"
    int L3_M2N6_AUGER  "L3_M2N6_AUGER"
    int L3_M2N7_AUGER  "L3_M2N7_AUGER"
    int L3_M2O1_AUGER  "L3_M2O1_AUGER"
    int L3_M2O2_AUGER  "L3_M2O2_AUGER"
    int L3_M2O3_AUGER  "L3_M2O3_AUGER"
    int L3_M2O4_AUGER  "L3_M2O4_AUGER"
    int L3_M2O5_AUGER  "L3_M2O5_AUGER"
    int L3_M2O6_AUGER  "L3_M2O6_AUGER"
    int L3_M2O7_AUGER  "L3_M2O7_AUGER"
    int L3_M2P1_AUGER  "L3_M2P1_AUGER"
    int L3_M2P2_AUGER  "L3_M2P2_AUGER"
    int L3_M2P3_AUGER  "L3_M2P3_AUGER"
    int L3_M2P4_AUGER  "L3_M2P4_AUGER"
    int L3_M2P5_AUGER  "L3_M2P5_AUGER"
    int L3_M2Q1_AUGER  "L3_M2Q1_AUGER"
    int L3_M2Q2_AUGER  "L3_M2Q2_AUGER"
    int L3_M2Q3_AUGER  "L3_M2Q3_AUGER"
    int L3_M3M1_AUGER  "L3_M3M1_AUGER"
    int L3_M3M2_AUGER  "L3_M3M2_AUGER"
    int L3_M3M3_AUGER  "L3_M3M3_AUGER"
    int L3_M3M4_AUGER  "L3_M3M4_AUGER"
    int L3_M3M5_AUGER  "L3_M3M5_AUGER"
    int L3_M3N1_AUGER  "L3_M3N1_AUGER"
    int L3_M3N2_AUGER  "L3_M3N2_AUGER"
    int L3_M3N3_AUGER  "L3_M3N3_AUGER"
    int L3_M3N4_AUGER  "L3_M3N4_AUGER"
    int L3_M3N5_AUGER  "L3_M3N5_AUGER"
    int L3_M3N6_AUGER  "L3_M3N6_AUGER"
    int L3_M3N7_AUGER  "L3_M3N7_AUGER"
    int L3_M3O1_AUGER  "L3_M3O1_AUGER"
    int L3_M3O2_AUGER  "L3_M3O2_AUGER"
    int L3_M3O3_AUGER  "L3_M3O3_AUGER"
    int L3_M3O4_AUGER  "L3_M3O4_AUGER"
    int L3_M3O5_AUGER  "L3_M3O5_AUGER"
    int L3_M3O6_AUGER  "L3_M3O6_AUGER"
    int L3_M3O7_AUGER  "L3_M3O7_AUGER"
    int L3_M3P1_AUGER  "L3_M3P1_AUGER"
    int L3_M3P2_AUGER  "L3_M3P2_AUGER"
    int L3_M3P3_AUGER  "L3_M3P3_AUGER"
    int L3_M3P4_AUGER  "L3_M3P4_AUGER"
    int L3_M3P5_AUGER  "L3_M3P5_AUGER"
    int L3_M3Q1_AUGER  "L3_M3Q1_AUGER"
    int L3_M3Q2_AUGER  "L3_M3Q2_AUGER"
    int L3_M3Q3_AUGER  "L3_M3Q3_AUGER"
    int L3_M4M1_AUGER  "L3_M4M1_AUGER"
    int L3_M4M2_AUGER  "L3_M4M2_AUGER"
    int L3_M4M3_AUGER  "L3_M4M3_AUGER"
    int L3_M4M4_AUGER  "L3_M4M4_AUGER"
    int L3_M4M5_AUGER  "L3_M4M5_AUGER"
    int L3_M4N1_AUGER  "L3_M4N1_AUGER"
    int L3_M4N2_AUGER  "L3_M4N2_AUGER"
    int L3_M4N3_AUGER  "L3_M4N3_AUGER"
    int L3_M4N4_AUGER  "L3_M4N4_AUGER"
    int L3_M4N5_AUGER  "L3_M4N5_AUGER"
    int L3_M4N6_AUGER  "L3_M4N6_AUGER"
    int L3_M4N7_AUGER  "L3_M4N7_AUGER"
    int L3_M4O1_AUGER  "L3_M4O1_AUGER"
    int L3_M4O2_AUGER  "L3_M4O2_AUGER"
    int L3_M4O3_AUGER  "L3_M4O3_AUGER"
    int L3_M4O4_AUGER  "L3_M4O4_AUGER"
    int L3_M4O5_AUGER  "L3_M4O5_AUGER"
    int L3_M4O6_AUGER  "L3_M4O6_AUGER"
    int L3_M4O7_AUGER  "L3_M4O7_AUGER"
    int L3_M4P1_AUGER  "L3_M4P1_AUGER"
    int L3_M4P2_AUGER  "L3_M4P2_AUGER"
    int L3_M4P3_AUGER  "L3_M4P3_AUGER"
    int L3_M4P4_AUGER  "L3_M4P4_AUGER"
    int L3_M4P5_AUGER  "L3_M4P5_AUGER"
    int L3_M4Q1_AUGER  "L3_M4Q1_AUGER"
    int L3_M4Q2_AUGER  "L3_M4Q2_AUGER"
    int L3_M4Q3_AUGER  "L3_M4Q3_AUGER"
    int L3_M5M1_AUGER  "L3_M5M1_AUGER"
    int L3_M5M2_AUGER  "L3_M5M2_AUGER"
    int L3_M5M3_AUGER  "L3_M5M3_AUGER"
    int L3_M5M4_AUGER  "L3_M5M4_AUGER"
    int L3_M5M5_AUGER  "L3_M5M5_AUGER"
    int L3_M5N1_AUGER  "L3_M5N1_AUGER"
    int L3_M5N2_AUGER  "L3_M5N2_AUGER"
    int L3_M5N3_AUGER  "L3_M5N3_AUGER"
    int L3_M5N4_AUGER  "L3_M5N4_AUGER"
    int L3_M5N5_AUGER  "L3_M5N5_AUGER"
    int L3_M5N6_AUGER  "L3_M5N6_AUGER"
    int L3_M5N7_AUGER  "L3_M5N7_AUGER"
    int L3_M5O1_AUGER  "L3_M5O1_AUGER"
    int L3_M5O2_AUGER  "L3_M5O2_AUGER"
    int L3_M5O3_AUGER  "L3_M5O3_AUGER"
    int L3_M5O4_AUGER  "L3_M5O4_AUGER"
    int L3_M5O5_AUGER  "L3_M5O5_AUGER"
    int L3_M5O6_AUGER  "L3_M5O6_AUGER"
    int L3_M5O7_AUGER  "L3_M5O7_AUGER"
    int L3_M5P1_AUGER  "L3_M5P1_AUGER"
    int L3_M5P2_AUGER  "L3_M5P2_AUGER"
    int L3_M5P3_AUGER  "L3_M5P3_AUGER"
    int L3_M5P4_AUGER  "L3_M5P4_AUGER"
    int L3_M5P5_AUGER  "L3_M5P5_AUGER"
    int L3_M5Q1_AUGER  "L3_M5Q1_AUGER"
    int L3_M5Q2_AUGER  "L3_M5Q2_AUGER"
    int L3_M5Q3_AUGER  "L3_M5Q3_AUGER"
    int M1_M2M2_AUGER  "M1_M2M2_AUGER"
    int M1_M2M3_AUGER  "M1_M2M3_AUGER"
    int M1_M2M4_AUGER  "M1_M2M4_AUGER"
    int M1_M2M5_AUGER  "M1_M2M5_AUGER"
    int M1_M2N1_AUGER  "M1_M2N1_AUGER"
    int M1_M2N2_AUGER  "M1_M2N2_AUGER"
    int M1_M2N3_AUGER  "M1_M2N3_AUGER"
    int M1_M2N4_AUGER  "M1_M2N4_AUGER"
    int M1_M2N5_AUGER  "M1_M2N5_AUGER"
    int M1_M2N6_AUGER  "M1_M2N6_AUGER"
    int M1_M2N7_AUGER  "M1_M2N7_AUGER"
    int M1_M2O1_AUGER  "M1_M2O1_AUGER"
    int M1_M2O2_AUGER  "M1_M2O2_AUGER"
    int M1_M2O3_AUGER  "M1_M2O3_AUGER"
    int M1_M2O4_AUGER  "M1_M2O4_AUGER"
    int M1_M2O5_AUGER  "M1_M2O5_AUGER"
    int M1_M2O6_AUGER  "M1_M2O6_AUGER"
    int M1_M2O7_AUGER  "M1_M2O7_AUGER"
    int M1_M2P1_AUGER  "M1_M2P1_AUGER"
    int M1_M2P2_AUGER  "M1_M2P2_AUGER"
    int M1_M2P3_AUGER  "M1_M2P3_AUGER"
    int M1_M2P4_AUGER  "M1_M2P4_AUGER"
    int M1_M2P5_AUGER  "M1_M2P5_AUGER"
    int M1_M2Q1_AUGER  "M1_M2Q1_AUGER"
    int M1_M2Q2_AUGER  "M1_M2Q2_AUGER"
    int M1_M2Q3_AUGER  "M1_M2Q3_AUGER"
    int M1_M3M2_AUGER  "M1_M3M2_AUGER"
    int M1_M3M3_AUGER  "M1_M3M3_AUGER"
    int M1_M3M4_AUGER  "M1_M3M4_AUGER"
    int M1_M3M5_AUGER  "M1_M3M5_AUGER"
    int M1_M3N1_AUGER  "M1_M3N1_AUGER"
    int M1_M3N2_AUGER  "M1_M3N2_AUGER"
    int M1_M3N3_AUGER  "M1_M3N3_AUGER"
    int M1_M3N4_AUGER  "M1_M3N4_AUGER"
    int M1_M3N5_AUGER  "M1_M3N5_AUGER"
    int M1_M3N6_AUGER  "M1_M3N6_AUGER"
    int M1_M3N7_AUGER  "M1_M3N7_AUGER"
    int M1_M3O1_AUGER  "M1_M3O1_AUGER"
    int M1_M3O2_AUGER  "M1_M3O2_AUGER"
    int M1_M3O3_AUGER  "M1_M3O3_AUGER"
    int M1_M3O4_AUGER  "M1_M3O4_AUGER"
    int M1_M3O5_AUGER  "M1_M3O5_AUGER"
    int M1_M3O6_AUGER  "M1_M3O6_AUGER"
    int M1_M3O7_AUGER  "M1_M3O7_AUGER"
    int M1_M3P1_AUGER  "M1_M3P1_AUGER"
    int M1_M3P2_AUGER  "M1_M3P2_AUGER"
    int M1_M3P3_AUGER  "M1_M3P3_AUGER"
    int M1_M3P4_AUGER  "M1_M3P4_AUGER"
    int M1_M3P5_AUGER  "M1_M3P5_AUGER"
    int M1_M3Q1_AUGER  "M1_M3Q1_AUGER"
    int M1_M3Q2_AUGER  "M1_M3Q2_AUGER"
    int M1_M3Q3_AUGER  "M1_M3Q3_AUGER"
    int M1_M4M2_AUGER  "M1_M4M2_AUGER"
    int M1_M4M3_AUGER  "M1_M4M3_AUGER"
    int M1_M4M4_AUGER  "M1_M4M4_AUGER"
    int M1_M4M5_AUGER  "M1_M4M5_AUGER"
    int M1_M4N1_AUGER  "M1_M4N1_AUGER"
    int M1_M4N2_AUGER  "M1_M4N2_AUGER"
    int M1_M4N3_AUGER  "M1_M4N3_AUGER"
    int M1_M4N4_AUGER  "M1_M4N4_AUGER"
    int M1_M4N5_AUGER  "M1_M4N5_AUGER"
    int M1_M4N6_AUGER  "M1_M4N6_AUGER"
    int M1_M4N7_AUGER  "M1_M4N7_AUGER"
    int M1_M4O1_AUGER  "M1_M4O1_AUGER"
    int M1_M4O2_AUGER  "M1_M4O2_AUGER"
    int M1_M4O3_AUGER  "M1_M4O3_AUGER"
    int M1_M4O4_AUGER  "M1_M4O4_AUGER"
    int M1_M4O5_AUGER  "M1_M4O5_AUGER"
    int M1_M4O6_AUGER  "M1_M4O6_AUGER"
    int M1_M4O7_AUGER  "M1_M4O7_AUGER"
    int M1_M4P1_AUGER  "M1_M4P1_AUGER"
    int M1_M4P2_AUGER  "M1_M4P2_AUGER"
    int M1_M4P3_AUGER  "M1_M4P3_AUGER"
    int M1_M4P4_AUGER  "M1_M4P4_AUGER"
    int M1_M4P5_AUGER  "M1_M4P5_AUGER"
    int M1_M4Q1_AUGER  "M1_M4Q1_AUGER"
    int M1_M4Q2_AUGER  "M1_M4Q2_AUGER"
    int M1_M4Q3_AUGER  "M1_M4Q3_AUGER"
    int M1_M5M2_AUGER  "M1_M5M2_AUGER"
    int M1_M5M3_AUGER  "M1_M5M3_AUGER"
    int M1_M5M4_AUGER  "M1_M5M4_AUGER"
    int M1_M5M5_AUGER  "M1_M5M5_AUGER"
    int M1_M5N1_AUGER  "M1_M5N1_AUGER"
    int M1_M5N2_AUGER  "M1_M5N2_AUGER"
    int M1_M5N3_AUGER  "M1_M5N3_AUGER"
    int M1_M5N4_AUGER  "M1_M5N4_AUGER"
    int M1_M5N5_AUGER  "M1_M5N5_AUGER"
    int M1_M5N6_AUGER  "M1_M5N6_AUGER"
    int M1_M5N7_AUGER  "M1_M5N7_AUGER"
    int M1_M5O1_AUGER  "M1_M5O1_AUGER"
    int M1_M5O2_AUGER  "M1_M5O2_AUGER"
    int M1_M5O3_AUGER  "M1_M5O3_AUGER"
    int M1_M5O4_AUGER  "M1_M5O4_AUGER"
    int M1_M5O5_AUGER  "M1_M5O5_AUGER"
    int M1_M5O6_AUGER  "M1_M5O6_AUGER"
    int M1_M5O7_AUGER  "M1_M5O7_AUGER"
    int M1_M5P1_AUGER  "M1_M5P1_AUGER"
    int M1_M5P2_AUGER  "M1_M5P2_AUGER"
    int M1_M5P3_AUGER  "M1_M5P3_AUGER"
    int M1_M5P4_AUGER  "M1_M5P4_AUGER"
    int M1_M5P5_AUGER  "M1_M5P5_AUGER"
    int M1_M5Q1_AUGER  "M1_M5Q1_AUGER"
    int M1_M5Q2_AUGER  "M1_M5Q2_AUGER"
    int M1_M5Q3_AUGER  "M1_M5Q3_AUGER"
    int M2_M3M3_AUGER  "M2_M3M3_AUGER"
    int M2_M3M4_AUGER  "M2_M3M4_AUGER"
    int M2_M3M5_AUGER  "M2_M3M5_AUGER"
    int M2_M3N1_AUGER  "M2_M3N1_AUGER"
    int M2_M3N2_AUGER  "M2_M3N2_AUGER"
    int M2_M3N3_AUGER  "M2_M3N3_AUGER"
    int M2_M3N4_AUGER  "M2_M3N4_AUGER"
    int M2_M3N5_AUGER  "M2_M3N5_AUGER"
    int M2_M3N6_AUGER  "M2_M3N6_AUGER"
    int M2_M3N7_AUGER  "M2_M3N7_AUGER"
    int M2_M3O1_AUGER  "M2_M3O1_AUGER"
    int M2_M3O2_AUGER  "M2_M3O2_AUGER"
    int M2_M3O3_AUGER  "M2_M3O3_AUGER"
    int M2_M3O4_AUGER  "M2_M3O4_AUGER"
    int M2_M3O5_AUGER  "M2_M3O5_AUGER"
    int M2_M3O6_AUGER  "M2_M3O6_AUGER"
    int M2_M3O7_AUGER  "M2_M3O7_AUGER"
    int M2_M3P1_AUGER  "M2_M3P1_AUGER"
    int M2_M3P2_AUGER  "M2_M3P2_AUGER"
    int M2_M3P3_AUGER  "M2_M3P3_AUGER"
    int M2_M3P4_AUGER  "M2_M3P4_AUGER"
    int M2_M3P5_AUGER  "M2_M3P5_AUGER"
    int M2_M3Q1_AUGER  "M2_M3Q1_AUGER"
    int M2_M3Q2_AUGER  "M2_M3Q2_AUGER"
    int M2_M3Q3_AUGER  "M2_M3Q3_AUGER"
    int M2_M4M3_AUGER  "M2_M4M3_AUGER"
    int M2_M4M4_AUGER  "M2_M4M4_AUGER"
    int M2_M4M5_AUGER  "M2_M4M5_AUGER"
    int M2_M4N1_AUGER  "M2_M4N1_AUGER"
    int M2_M4N2_AUGER  "M2_M4N2_AUGER"
    int M2_M4N3_AUGER  "M2_M4N3_AUGER"
    int M2_M4N4_AUGER  "M2_M4N4_AUGER"
    int M2_M4N5_AUGER  "M2_M4N5_AUGER"
    int M2_M4N6_AUGER  "M2_M4N6_AUGER"
    int M2_M4N7_AUGER  "M2_M4N7_AUGER"
    int M2_M4O1_AUGER  "M2_M4O1_AUGER"
    int M2_M4O2_AUGER  "M2_M4O2_AUGER"
    int M2_M4O3_AUGER  "M2_M4O3_AUGER"
    int M2_M4O4_AUGER  "M2_M4O4_AUGER"
    int M2_M4O5_AUGER  "M2_M4O5_AUGER"
    int M2_M4O6_AUGER  "M2_M4O6_AUGER"
    int M2_M4O7_AUGER  "M2_M4O7_AUGER"
    int M2_M4P1_AUGER  "M2_M4P1_AUGER"
    int M2_M4P2_AUGER  "M2_M4P2_AUGER"
    int M2_M4P3_AUGER  "M2_M4P3_AUGER"
    int M2_M4P4_AUGER  "M2_M4P4_AUGER"
    int M2_M4P5_AUGER  "M2_M4P5_AUGER"
    int M2_M4Q1_AUGER  "M2_M4Q1_AUGER"
    int M2_M4Q2_AUGER  "M2_M4Q2_AUGER"
    int M2_M4Q3_AUGER  "M2_M4Q3_AUGER"
    int M2_M5M3_AUGER  "M2_M5M3_AUGER"
    int M2_M5M4_AUGER  "M2_M5M4_AUGER"
    int M2_M5M5_AUGER  "M2_M5M5_AUGER"
    int M2_M5N1_AUGER  "M2_M5N1_AUGER"
    int M2_M5N2_AUGER  "M2_M5N2_AUGER"
    int M2_M5N3_AUGER  "M2_M5N3_AUGER"
    int M2_M5N4_AUGER  "M2_M5N4_AUGER"
    int M2_M5N5_AUGER  "M2_M5N5_AUGER"
    int M2_M5N6_AUGER  "M2_M5N6_AUGER"
    int M2_M5N7_AUGER  "M2_M5N7_AUGER"
    int M2_M5O1_AUGER  "M2_M5O1_AUGER"
    int M2_M5O2_AUGER  "M2_M5O2_AUGER"
    int M2_M5O3_AUGER  "M2_M5O3_AUGER"
    int M2_M5O4_AUGER  "M2_M5O4_AUGER"
    int M2_M5O5_AUGER  "M2_M5O5_AUGER"
    int M2_M5O6_AUGER  "M2_M5O6_AUGER"
    int M2_M5O7_AUGER  "M2_M5O7_AUGER"
    int M2_M5P1_AUGER  "M2_M5P1_AUGER"
    int M2_M5P2_AUGER  "M2_M5P2_AUGER"
    int M2_M5P3_AUGER  "M2_M5P3_AUGER"
    int M2_M5P4_AUGER  "M2_M5P4_AUGER"
    int M2_M5P5_AUGER  "M2_M5P5_AUGER"
    int M2_M5Q1_AUGER  "M2_M5Q1_AUGER"
    int M2_M5Q2_AUGER  "M2_M5Q2_AUGER"
    int M2_M5Q3_AUGER  "M2_M5Q3_AUGER"
    int M3_M4M4_AUGER  "M3_M4M4_AUGER"
    int M3_M4M5_AUGER  "M3_M4M5_AUGER"
    int M3_M4N1_AUGER  "M3_M4N1_AUGER"
    int M3_M4N2_AUGER  "M3_M4N2_AUGER"
    int M3_M4N3_AUGER  "M3_M4N3_AUGER"
    int M3_M4N4_AUGER  "M3_M4N4_AUGER"
    int M3_M4N5_AUGER  "M3_M4N5_AUGER"
    int M3_M4N6_AUGER  "M3_M4N6_AUGER"
    int M3_M4N7_AUGER  "M3_M4N7_AUGER"
    int M3_M4O1_AUGER  "M3_M4O1_AUGER"
    int M3_M4O2_AUGER  "M3_M4O2_AUGER"
    int M3_M4O3_AUGER  "M3_M4O3_AUGER"
    int M3_M4O4_AUGER  "M3_M4O4_AUGER"
    int M3_M4O5_AUGER  "M3_M4O5_AUGER"
    int M3_M4O6_AUGER  "M3_M4O6_AUGER"
    int M3_M4O7_AUGER  "M3_M4O7_AUGER"
    int M3_M4P1_AUGER  "M3_M4P1_AUGER"
    int M3_M4P2_AUGER  "M3_M4P2_AUGER"
    int M3_M4P3_AUGER  "M3_M4P3_AUGER"
    int M3_M4P4_AUGER  "M3_M4P4_AUGER"
    int M3_M4P5_AUGER  "M3_M4P5_AUGER"
    int M3_M4Q1_AUGER  "M3_M4Q1_AUGER"
    int M3_M4Q2_AUGER  "M3_M4Q2_AUGER"
    int M3_M4Q3_AUGER  "M3_M4Q3_AUGER"
    int M3_M5M4_AUGER  "M3_M5M4_AUGER"
    int M3_M5M5_AUGER  "M3_M5M5_AUGER"
    int M3_M5N1_AUGER  "M3_M5N1_AUGER"
    int M3_M5N2_AUGER  "M3_M5N2_AUGER"
    int M3_M5N3_AUGER  "M3_M5N3_AUGER"
    int M3_M5N4_AUGER  "M3_M5N4_AUGER"
    int M3_M5N5_AUGER  "M3_M5N5_AUGER"
    int M3_M5N6_AUGER  "M3_M5N6_AUGER"
    int M3_M5N7_AUGER  "M3_M5N7_AUGER"
    int M3_M5O1_AUGER  "M3_M5O1_AUGER"
    int M3_M5O2_AUGER  "M3_M5O2_AUGER"
    int M3_M5O3_AUGER  "M3_M5O3_AUGER"
    int M3_M5O4_AUGER  "M3_M5O4_AUGER"
    int M3_M5O5_AUGER  "M3_M5O5_AUGER"
    int M3_M5O6_AUGER  "M3_M5O6_AUGER"
    int M3_M5O7_AUGER  "M3_M5O7_AUGER"
    int M3_M5P1_AUGER  "M3_M5P1_AUGER"
    int M3_M5P2_AUGER  "M3_M5P2_AUGER"
    int M3_M5P3_AUGER  "M3_M5P3_AUGER"
    int M3_M5P4_AUGER  "M3_M5P4_AUGER"
    int M3_M5P5_AUGER  "M3_M5P5_AUGER"
    int M3_M5Q1_AUGER  "M3_M5Q1_AUGER"
    int M3_M5Q2_AUGER  "M3_M5Q2_AUGER"
    int M3_M5Q3_AUGER  "M3_M5Q3_AUGER"
    int M4_M5M5_AUGER  "M4_M5M5_AUGER"
    int M4_M5N1_AUGER  "M4_M5N1_AUGER"
    int M4_M5N2_AUGER  "M4_M5N2_AUGER"
    int M4_M5N3_AUGER  "M4_M5N3_AUGER"
    int M4_M5N4_AUGER  "M4_M5N4_AUGER"
    int M4_M5N5_AUGER  "M4_M5N5_AUGER"
    int M4_M5N6_AUGER  "M4_M5N6_AUGER"
    int M4_M5N7_AUGER  "M4_M5N7_AUGER"
    int M4_M5O1_AUGER  "M4_M5O1_AUGER"
    int M4_M5O2_AUGER  "M4_M5O2_AUGER"
    int M4_M5O3_AUGER  "M4_M5O3_AUGER"
    int M4_M5O4_AUGER  "M4_M5O4_AUGER"
    int M4_M5O5_AUGER  "M4_M5O5_AUGER"
    int M4_M5O6_AUGER  "M4_M5O6_AUGER"
    int M4_M5O7_AUGER  "M4_M5O7_AUGER"
    int M4_M5P1_AUGER  "M4_M5P1_AUGER"
    int M4_M5P2_AUGER  "M4_M5P2_AUGER"
    int M4_M5P3_AUGER  "M4_M5P3_AUGER"
    int M4_M5P4_AUGER  "M4_M5P4_AUGER"
    int M4_M5P5_AUGER  "M4_M5P5_AUGER"
    int M4_M5Q1_AUGER  "M4_M5Q1_AUGER"
    int M4_M5Q2_AUGER  "M4_M5Q2_AUGER"
    int M4_M5Q3_AUGER  "M4_M5Q3_AUGER"
    int KL1_LINE "KL1_LINE"
    int KL2_LINE "KL2_LINE"
    int KL3_LINE "KL3_LINE"
    int KM1_LINE "KM1_LINE"
    int KM2_LINE "KM2_LINE"
    int KM3_LINE "KM3_LINE"
    int KM4_LINE "KM4_LINE"
    int KM5_LINE "KM5_LINE"
    int KN1_LINE "KN1_LINE"
    int KN2_LINE "KN2_LINE"
    int KN3_LINE "KN3_LINE"
    int KN4_LINE "KN4_LINE"
    int KN5_LINE "KN5_LINE"
    int KN6_LINE "KN6_LINE"
    int KN7_LINE "KN7_LINE"
    int KO_LINE "KO_LINE"
    int KO1_LINE "KO1_LINE"
    int KO2_LINE "KO2_LINE"
    int KO3_LINE "KO3_LINE"
    int KO4_LINE "KO4_LINE"
    int KO5_LINE "KO5_LINE"
    int KO6_LINE "KO6_LINE"
    int KO7_LINE "KO7_LINE"
    int KP_LINE "KP_LINE"
    int KP1_LINE "KP1_LINE"
    int KP2_LINE "KP2_LINE"
    int KP3_LINE "KP3_LINE"
    int KP4_LINE "KP4_LINE"
    int KP5_LINE "KP5_LINE"
    int L1L2_LINE "L1L2_LINE"
    int L1L3_LINE "L1L3_LINE"
    int L1M1_LINE "L1M1_LINE"
    int L1M2_LINE "L1M2_LINE"
    int L1M3_LINE "L1M3_LINE"
    int L1M4_LINE "L1M4_LINE"
    int L1M5_LINE "L1M5_LINE"
    int L1N1_LINE "L1N1_LINE"
    int L1N2_LINE "L1N2_LINE"
    int L1N3_LINE "L1N3_LINE"
    int L1N4_LINE "L1N4_LINE"
    int L1N5_LINE "L1N5_LINE"
    int L1N6_LINE "L1N6_LINE"
    int L1N67_LINE "L1N67_LINE"
    int L1N7_LINE "L1N7_LINE"
    int L1O1_LINE "L1O1_LINE"
    int L1O2_LINE "L1O2_LINE"
    int L1O3_LINE "L1O3_LINE"
    int L1O4_LINE "L1O4_LINE"
    int L1O45_LINE "L1O45_LINE"
    int L1O5_LINE "L1O5_LINE"
    int L1O6_LINE "L1O6_LINE"
    int L1O7_LINE "L1O7_LINE"
    int L1P1_LINE "L1P1_LINE"
    int L1P2_LINE "L1P2_LINE"
    int L1P23_LINE "L1P23_LINE"
    int L1P3_LINE "L1P3_LINE"
    int L1P4_LINE "L1P4_LINE"
    int L1P5_LINE "L1P5_LINE"
    int L2L3_LINE "L2L3_LINE"
    int L2M1_LINE "L2M1_LINE"
    int L2M2_LINE "L2M2_LINE"
    int L2M3_LINE "L2M3_LINE"
    int L2M4_LINE "L2M4_LINE"
    int L2M5_LINE "L2M5_LINE"
    int L2N1_LINE "L2N1_LINE"
    int L2N2_LINE "L2N2_LINE"
    int L2N3_LINE "L2N3_LINE"
    int L2N4_LINE "L2N4_LINE"
    int L2N5_LINE "L2N5_LINE"
    int L2N6_LINE "L2N6_LINE"
    int L2N7_LINE "L2N7_LINE"
    int L2O1_LINE "L2O1_LINE"
    int L2O2_LINE "L2O2_LINE"
    int L2O3_LINE "L2O3_LINE"
    int L2O4_LINE "L2O4_LINE"
    int L2O5_LINE "L2O5_LINE"
    int L2O6_LINE "L2O6_LINE"
    int L2O7_LINE "L2O7_LINE"
    int L2P1_LINE "L2P1_LINE"
    int L2P2_LINE "L2P2_LINE"
    int L2P23_LINE "L2P23_LINE"
    int L2P3_LINE "L2P3_LINE"
    int L2P4_LINE "L2P4_LINE"
    int L2P5_LINE "L2P5_LINE"
    int L2Q1_LINE "L2Q1_LINE"
    int L3M1_LINE "L3M1_LINE"
    int L3M2_LINE "L3M2_LINE"
    int L3M3_LINE "L3M3_LINE"
    int L3M4_LINE "L3M4_LINE"
    int L3M5_LINE "L3M5_LINE"
    int L3N1_LINE "L3N1_LINE"
    int L3N2_LINE "L3N2_LINE"
    int L3N3_LINE "L3N3_LINE"
    int L3N4_LINE "L3N4_LINE"
    int L3N5_LINE "L3N5_LINE"
    int L3N6_LINE "L3N6_LINE"
    int L3N7_LINE "L3N7_LINE"
    int L3O1_LINE "L3O1_LINE"
    int L3O2_LINE "L3O2_LINE"
    int L3O3_LINE "L3O3_LINE"
    int L3O4_LINE "L3O4_LINE"
    int L3O45_LINE "L3O45_LINE"
    int L3O5_LINE "L3O5_LINE"
    int L3O6_LINE "L3O6_LINE"
    int L3O7_LINE "L3O7_LINE"
    int L3P1_LINE "L3P1_LINE"
    int L3P2_LINE "L3P2_LINE"
    int L3P23_LINE "L3P23_LINE"
    int L3P3_LINE "L3P3_LINE"
    int L3P4_LINE "L3P4_LINE"
    int L3P45_LINE "L3P45_LINE"
    int L3P5_LINE "L3P5_LINE"
    int L3Q1_LINE "L3Q1_LINE"
    int M1M2_LINE "M1M2_LINE"
    int M1M3_LINE "M1M3_LINE"
    int M1M4_LINE "M1M4_LINE"
    int M1M5_LINE "M1M5_LINE"
    int M1N1_LINE "M1N1_LINE"
    int M1N2_LINE "M1N2_LINE"
    int M1N3_LINE "M1N3_LINE"
    int M1N4_LINE "M1N4_LINE"
    int M1N5_LINE "M1N5_LINE"
    int M1N6_LINE "M1N6_LINE"
    int M1N7_LINE "M1N7_LINE"
    int M1O1_LINE "M1O1_LINE"
    int M1O2_LINE "M1O2_LINE"
    int M1O3_LINE "M1O3_LINE"
    int M1O4_LINE "M1O4_LINE"
    int M1O5_LINE "M1O5_LINE"
    int M1O6_LINE "M1O6_LINE"
    int M1O7_LINE "M1O7_LINE"
    int M1P1_LINE "M1P1_LINE"
    int M1P2_LINE "M1P2_LINE"
    int M1P3_LINE "M1P3_LINE"
    int M1P4_LINE "M1P4_LINE"
    int M1P5_LINE "M1P5_LINE"
    int M2M3_LINE "M2M3_LINE"
    int M2M4_LINE "M2M4_LINE"
    int M2M5_LINE "M2M5_LINE"
    int M2N1_LINE "M2N1_LINE"
    int M2N2_LINE "M2N2_LINE"
    int M2N3_LINE "M2N3_LINE"
    int M2N4_LINE "M2N4_LINE"
    int M2N5_LINE "M2N5_LINE"
    int M2N6_LINE "M2N6_LINE"
    int M2N7_LINE "M2N7_LINE"
    int M2O1_LINE "M2O1_LINE"
    int M2O2_LINE "M2O2_LINE"
    int M2O3_LINE "M2O3_LINE"
    int M2O4_LINE "M2O4_LINE"
    int M2O5_LINE "M2O5_LINE"
    int M2O6_LINE "M2O6_LINE"
    int M2O7_LINE "M2O7_LINE"
    int M2P1_LINE "M2P1_LINE"
    int M2P2_LINE "M2P2_LINE"
    int M2P3_LINE "M2P3_LINE"
    int M2P4_LINE "M2P4_LINE"
    int M2P5_LINE "M2P5_LINE"
    int M3M4_LINE "M3M4_LINE"
    int M3M5_LINE "M3M5_LINE"
    int M3N1_LINE "M3N1_LINE"
    int M3N2_LINE "M3N2_LINE"
    int M3N3_LINE "M3N3_LINE"
    int M3N4_LINE "M3N4_LINE"
    int M3N5_LINE "M3N5_LINE"
    int M3N6_LINE "M3N6_LINE"
    int M3N7_LINE "M3N7_LINE"
    int M3O1_LINE "M3O1_LINE"
    int M3O2_LINE "M3O2_LINE"
    int M3O3_LINE "M3O3_LINE"
    int M3O4_LINE "M3O4_LINE"
    int M3O5_LINE "M3O5_LINE"
    int M3O6_LINE "M3O6_LINE"
    int M3O7_LINE "M3O7_LINE"
    int M3P1_LINE "M3P1_LINE"
    int M3P2_LINE "M3P2_LINE"
    int M3P3_LINE "M3P3_LINE"
    int M3P4_LINE "M3P4_LINE"
    int M3P5_LINE "M3P5_LINE"
    int M3Q1_LINE "M3Q1_LINE"
    int M4M5_LINE "M4M5_LINE"
    int M4N1_LINE "M4N1_LINE"
    int M4N2_LINE "M4N2_LINE"
    int M4N3_LINE "M4N3_LINE"
    int M4N4_LINE "M4N4_LINE"
    int M4N5_LINE "M4N5_LINE"
    int M4N6_LINE "M4N6_LINE"
    int M4N7_LINE "M4N7_LINE"
    int M4O1_LINE "M4O1_LINE"
    int M4O2_LINE "M4O2_LINE"
    int M4O3_LINE "M4O3_LINE"
    int M4O4_LINE "M4O4_LINE"
    int M4O5_LINE "M4O5_LINE"
    int M4O6_LINE "M4O6_LINE"
    int M4O7_LINE "M4O7_LINE"
    int M4P1_LINE "M4P1_LINE"
    int M4P2_LINE "M4P2_LINE"
    int M4P3_LINE "M4P3_LINE"
    int M4P4_LINE "M4P4_LINE"
    int M4P5_LINE "M4P5_LINE"
    int M5N1_LINE "M5N1_LINE"
    int M5N2_LINE "M5N2_LINE"
    int M5N3_LINE "M5N3_LINE"
    int M5N4_LINE "M5N4_LINE"
    int M5N5_LINE "M5N5_LINE"
    int M5N6_LINE "M5N6_LINE"
    int M5N7_LINE "M5N7_LINE"
    int M5O1_LINE "M5O1_LINE"
    int M5O2_LINE "M5O2_LINE"
    int M5O3_LINE "M5O3_LINE"
    int M5O4_LINE "M5O4_LINE"
    int M5O5_LINE "M5O5_LINE"
    int M5O6_LINE "M5O6_LINE"
    int M5O7_LINE "M5O7_LINE"
    int M5P1_LINE "M5P1_LINE"
    int M5P2_LINE "M5P2_LINE"
    int M5P3_LINE "M5P3_LINE"
    int M5P4_LINE "M5P4_LINE"
    int M5P5_LINE "M5P5_LINE"
    int N1N2_LINE "N1N2_LINE"
    int N1N3_LINE "N1N3_LINE"
    int N1N4_LINE "N1N4_LINE"
    int N1N5_LINE "N1N5_LINE"
    int N1N6_LINE "N1N6_LINE"
    int N1N7_LINE "N1N7_LINE"
    int N1O1_LINE "N1O1_LINE"
    int N1O2_LINE "N1O2_LINE"
    int N1O3_LINE "N1O3_LINE"
    int N1O4_LINE "N1O4_LINE"
    int N1O5_LINE "N1O5_LINE"
    int N1O6_LINE "N1O6_LINE"
    int N1O7_LINE "N1O7_LINE"
    int N1P1_LINE "N1P1_LINE"
    int N1P2_LINE "N1P2_LINE"
    int N1P3_LINE "N1P3_LINE"
    int N1P4_LINE "N1P4_LINE"
    int N1P5_LINE "N1P5_LINE"
    int N2N3_LINE "N2N3_LINE"
    int N2N4_LINE "N2N4_LINE"
    int N2N5_LINE "N2N5_LINE"
    int N2N6_LINE "N2N6_LINE"
    int N2N7_LINE "N2N7_LINE"
    int N2O1_LINE "N2O1_LINE"
    int N2O2_LINE "N2O2_LINE"
    int N2O3_LINE "N2O3_LINE"
    int N2O4_LINE "N2O4_LINE"
    int N2O5_LINE "N2O5_LINE"
    int N2O6_LINE "N2O6_LINE"
    int N2O7_LINE "N2O7_LINE"
    int N2P1_LINE "N2P1_LINE"
    int N2P2_LINE "N2P2_LINE"
    int N2P3_LINE "N2P3_LINE"
    int N2P4_LINE "N2P4_LINE"
    int N2P5_LINE "N2P5_LINE"
    int N3N4_LINE "N3N4_LINE"
    int N3N5_LINE "N3N5_LINE"
    int N3N6_LINE "N3N6_LINE"
    int N3N7_LINE "N3N7_LINE"
    int N3O1_LINE "N3O1_LINE"
    int N3O2_LINE "N3O2_LINE"
    int N3O3_LINE "N3O3_LINE"
    int N3O4_LINE "N3O4_LINE"
    int N3O5_LINE "N3O5_LINE"
    int N3O6_LINE "N3O6_LINE"
    int N3O7_LINE "N3O7_LINE"
    int N3P1_LINE "N3P1_LINE"
    int N3P2_LINE "N3P2_LINE"
    int N3P3_LINE "N3P3_LINE"
    int N3P4_LINE "N3P4_LINE"
    int N3P5_LINE "N3P5_LINE"
    int N4N5_LINE "N4N5_LINE"
    int N4N6_LINE "N4N6_LINE"
    int N4N7_LINE "N4N7_LINE"
    int N4O1_LINE "N4O1_LINE"
    int N4O2_LINE "N4O2_LINE"
    int N4O3_LINE "N4O3_LINE"
    int N4O4_LINE "N4O4_LINE"
    int N4O5_LINE "N4O5_LINE"
    int N4O6_LINE "N4O6_LINE"
    int N4O7_LINE "N4O7_LINE"
    int N4P1_LINE "N4P1_LINE"
    int N4P2_LINE "N4P2_LINE"
    int N4P3_LINE "N4P3_LINE"
    int N4P4_LINE "N4P4_LINE"
    int N4P5_LINE "N4P5_LINE"
    int N5N6_LINE "N5N6_LINE"
    int N5N7_LINE "N5N7_LINE"
    int N5O1_LINE "N5O1_LINE"
    int N5O2_LINE "N5O2_LINE"
    int N5O3_LINE "N5O3_LINE"
    int N5O4_LINE "N5O4_LINE"
    int N5O5_LINE "N5O5_LINE"
    int N5O6_LINE "N5O6_LINE"
    int N5O7_LINE "N5O7_LINE"
    int N5P1_LINE "N5P1_LINE"
    int N5P2_LINE "N5P2_LINE"
    int N5P3_LINE "N5P3_LINE"
    int N5P4_LINE "N5P4_LINE"
    int N5P5_LINE "N5P5_LINE"
    int N6N7_LINE "N6N7_LINE"
    int N6O1_LINE "N6O1_LINE"
    int N6O2_LINE "N6O2_LINE"
    int N6O3_LINE "N6O3_LINE"
    int N6O4_LINE "N6O4_LINE"
    int N6O5_LINE "N6O5_LINE"
    int N6O6_LINE "N6O6_LINE"
    int N6O7_LINE "N6O7_LINE"
    int N6P1_LINE "N6P1_LINE"
    int N6P2_LINE "N6P2_LINE"
    int N6P3_LINE "N6P3_LINE"
    int N6P4_LINE "N6P4_LINE"
    int N6P5_LINE "N6P5_LINE"
    int N7O1_LINE "N7O1_LINE"
    int N7O2_LINE "N7O2_LINE"
    int N7O3_LINE "N7O3_LINE"
    int N7O4_LINE "N7O4_LINE"
    int N7O5_LINE "N7O5_LINE"
    int N7O6_LINE "N7O6_LINE"
    int N7O7_LINE "N7O7_LINE"
    int N7P1_LINE "N7P1_LINE"
    int N7P2_LINE "N7P2_LINE"
    int N7P3_LINE "N7P3_LINE"
    int N7P4_LINE "N7P4_LINE"
    int N7P5_LINE "N7P5_LINE"
    int O1O2_LINE "O1O2_LINE"
    int O1O3_LINE "O1O3_LINE"
    int O1O4_LINE "O1O4_LINE"
    int O1O5_LINE "O1O5_LINE"
    int O1O6_LINE "O1O6_LINE"
    int O1O7_LINE "O1O7_LINE"
    int O1P1_LINE "O1P1_LINE"
    int O1P2_LINE "O1P2_LINE"
    int O1P3_LINE "O1P3_LINE"
    int O1P4_LINE "O1P4_LINE"
    int O1P5_LINE "O1P5_LINE"
    int O2O3_LINE "O2O3_LINE"
    int O2O4_LINE "O2O4_LINE"
    int O2O5_LINE "O2O5_LINE"
    int O2O6_LINE "O2O6_LINE"
    int O2O7_LINE "O2O7_LINE"
    int O2P1_LINE "O2P1_LINE"
    int O2P2_LINE "O2P2_LINE"
    int O2P3_LINE "O2P3_LINE"
    int O2P4_LINE "O2P4_LINE"
    int O2P5_LINE "O2P5_LINE"
    int O3O4_LINE "O3O4_LINE"
    int O3O5_LINE "O3O5_LINE"
    int O3O6_LINE "O3O6_LINE"
    int O3O7_LINE "O3O7_LINE"
    int O3P1_LINE "O3P1_LINE"
    int O3P2_LINE "O3P2_LINE"
    int O3P3_LINE "O3P3_LINE"
    int O3P4_LINE "O3P4_LINE"
    int O3P5_LINE "O3P5_LINE"
    int O4O5_LINE "O4O5_LINE"
    int O4O6_LINE "O4O6_LINE"
    int O4O7_LINE "O4O7_LINE"
    int O4P1_LINE "O4P1_LINE"
    int O4P2_LINE "O4P2_LINE"
    int O4P3_LINE "O4P3_LINE"
    int O4P4_LINE "O4P4_LINE"
    int O4P5_LINE "O4P5_LINE"
    int O5O6_LINE "O5O6_LINE"
    int O5O7_LINE "O5O7_LINE"
    int O5P1_LINE "O5P1_LINE"
    int O5P2_LINE "O5P2_LINE"
    int O5P3_LINE "O5P3_LINE"
    int O5P4_LINE "O5P4_LINE"
    int O5P5_LINE "O5P5_LINE"
    int O6O7_LINE "O6O7_LINE"
    int O6P4_LINE "O6P4_LINE"
    int O6P5_LINE "O6P5_LINE"
    int O7P4_LINE "O7P4_LINE"
    int O7P5_LINE "O7P5_LINE"
    int P1P2_LINE "P1P2_LINE"
    int P1P3_LINE "P1P3_LINE"
    int P1P4_LINE "P1P4_LINE"
    int P1P5_LINE "P1P5_LINE"
    int P2P3_LINE "P2P3_LINE"
    int P2P4_LINE "P2P4_LINE"
    int P2P5_LINE "P2P5_LINE"
    int P3P4_LINE "P3P4_LINE"
    int P3P5_LINE "P3P5_LINE"
    int K_SHELL "K_SHELL"
    int L1_SHELL "L1_SHELL"
    int L2_SHELL "L2_SHELL"
    int L3_SHELL "L3_SHELL"
    int M1_SHELL "M1_SHELL"
    int M2_SHELL "M2_SHELL"
    int M3_SHELL "M3_SHELL"
    int M4_SHELL "M4_SHELL"
    int M5_SHELL "M5_SHELL"
    int N1_SHELL "N1_SHELL"
    int N2_SHELL "N2_SHELL"
    int N3_SHELL "N3_SHELL"
    int N4_SHELL "N4_SHELL"
    int N5_SHELL "N5_SHELL"
    int N6_SHELL "N6_SHELL"
    int N7_SHELL "N7_SHELL"
    int O1_SHELL "O1_SHELL"
    int O2_SHELL "O2_SHELL"
    int O3_SHELL "O3_SHELL"
    int O4_SHELL "O4_SHELL"
    int O5_SHELL "O5_SHELL"
    int O6_SHELL "O6_SHELL"
    int O7_SHELL "O7_SHELL"
    int P1_SHELL "P1_SHELL"
    int P2_SHELL "P2_SHELL"
    int P3_SHELL "P3_SHELL"
    int P4_SHELL "P4_SHELL"
    int P5_SHELL "P5_SHELL"
    int Q1_SHELL "Q1_SHELL"
    int Q2_SHELL "Q2_SHELL"
    int Q3_SHELL "Q3_SHELL"
