package ONVIF::Analytics::Types::SearchScope;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %IncludedSources_of :ATTR(:get<IncludedSources>);
my %IncludedRecordings_of :ATTR(:get<IncludedRecordings>);
my %RecordingInformationFilter_of :ATTR(:get<RecordingInformationFilter>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        IncludedSources
        IncludedRecordings
        RecordingInformationFilter
        Extension

    ) ],
    {
        'IncludedSources' => \%IncludedSources_of,
        'IncludedRecordings' => \%IncludedRecordings_of,
        'RecordingInformationFilter' => \%RecordingInformationFilter_of,
        'Extension' => \%Extension_of,
    },
    {
        'IncludedSources' => 'ONVIF::Analytics::Types::SourceReference',
        'IncludedRecordings' => 'ONVIF::Analytics::Types::RecordingReference',
        'RecordingInformationFilter' => 'ONVIF::Analytics::Types::XPathExpression',
        'Extension' => 'ONVIF::Analytics::Types::SearchScopeExtension',
    },
    {

        'IncludedSources' => 'IncludedSources',
        'IncludedRecordings' => 'IncludedRecordings',
        'RecordingInformationFilter' => 'RecordingInformationFilter',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Analytics::Types::SearchScope

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
SearchScope from the namespace http://www.onvif.org/ver10/schema.

A structure for defining a limited scope when searching in recorded data.




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * IncludedSources


=item * IncludedRecordings


=item * RecordingInformationFilter


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Analytics::Types::SearchScope
   IncludedSources =>  { # ONVIF::Analytics::Types::SourceReference
     Token => $some_value, # ReferenceToken
   },
   IncludedRecordings => $some_value, # RecordingReference
   RecordingInformationFilter => $some_value, # XPathExpression
   Extension =>  { # ONVIF::Analytics::Types::SearchScopeExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

