/* SPDX-License-Identifier: MIT */
/*
 * Copyright © 2023 Intel Corporation
 */

#ifndef _XE_GPU_COMMANDS_H_
#define _XE_GPU_COMMANDS_H_

#include "regs/xe_reg_defs.h"

#define XY_CTRL_SURF_COPY_BLT		((2 << 29) | (0x48 << 22) | 3)
#define   SRC_ACCESS_TYPE_SHIFT		21
#define   DST_ACCESS_TYPE_SHIFT		20
#define   CCS_SIZE_MASK			GENMASK(17, 8)
#define   XE2_CCS_SIZE_MASK		GENMASK(18, 9)
#define   XY_CTRL_SURF_MOCS_MASK	GENMASK(31, 26)
#define   XE2_XY_CTRL_SURF_MOCS_INDEX_MASK	GENMASK(31, 28)
#define   NUM_CCS_BYTES_PER_BLOCK	256
#define   NUM_BYTES_PER_CCS_BYTE(_xe)	(GRAPHICS_VER(_xe) >= 20 ? 512 : 256)

#define XY_FAST_COLOR_BLT_CMD		(2 << 29 | 0x44 << 22)
#define   XY_FAST_COLOR_BLT_DEPTH_32	(2 << 19)
#define   XY_FAST_COLOR_BLT_DW		16
#define   XY_FAST_COLOR_BLT_MOCS_MASK	GENMASK(27, 22)
#define   XE2_XY_FAST_COLOR_BLT_MOCS_INDEX_MASK	GENMASK(27, 24)
#define   XY_FAST_COLOR_BLT_MEM_TYPE_SHIFT 31

#define XY_FAST_COPY_BLT_CMD		(2 << 29 | 0x42 << 22)
#define   XY_FAST_COPY_BLT_DEPTH_32	(3<<24)
#define   XY_FAST_COPY_BLT_D1_SRC_TILE4	REG_BIT(31)
#define   XY_FAST_COPY_BLT_D1_DST_TILE4	REG_BIT(30)
#define   XE2_XY_FAST_COPY_BLT_MOCS_INDEX_MASK	GENMASK(23, 20)

#define	PVC_MEM_SET_CMD		(2 << 29 | 0x5b << 22)
#define   PVC_MEM_SET_CMD_LEN_DW	7
#define   PVC_MEM_SET_MATRIX		REG_BIT(17)
#define   PVC_MEM_SET_DATA_FIELD	GENMASK(31, 24)
/* Bspec lists field as [6:0], but index alone is from [6:1] */
#define   PVC_MEM_SET_MOCS_INDEX_MASK	GENMASK(6, 1)
#define   XE2_MEM_SET_MOCS_INDEX_MASK	GENMASK(6, 3)

#define GFX_OP_PIPE_CONTROL(len)	((0x3<<29)|(0x3<<27)|(0x2<<24)|((len)-2))

#define	  PIPE_CONTROL0_HDC_PIPELINE_FLUSH		BIT(9)	/* gen12 */

#define   PIPE_CONTROL_COMMAND_CACHE_INVALIDATE		(1<<29)
#define   PIPE_CONTROL_TILE_CACHE_FLUSH			(1<<28)
#define   PIPE_CONTROL_AMFS_FLUSH			(1<<25)
#define   PIPE_CONTROL_GLOBAL_GTT_IVB			(1<<24)
#define   PIPE_CONTROL_LRI_POST_SYNC			BIT(23)
#define   PIPE_CONTROL_STORE_DATA_INDEX			(1<<21)
#define   PIPE_CONTROL_CS_STALL				(1<<20)
#define   PIPE_CONTROL_GLOBAL_SNAPSHOT_RESET		(1<<19)
#define	  PIPE_CONTROL_TLB_INVALIDATE			BIT(18)
#define   PIPE_CONTROL_PSD_SYNC				(1<<17)
#define   PIPE_CONTROL_QW_WRITE				(1<<14)
#define   PIPE_CONTROL_DEPTH_STALL			(1<<13)
#define   PIPE_CONTROL_RENDER_TARGET_CACHE_FLUSH	(1<<12)
#define   PIPE_CONTROL_INSTRUCTION_CACHE_INVALIDATE	(1<<11)
#define   PIPE_CONTROL_TEXTURE_CACHE_INVALIDATE		(1<<10)
#define   PIPE_CONTROL_INDIRECT_STATE_DISABLE		(1<<9)
#define   PIPE_CONTROL_FLUSH_ENABLE			(1<<7)
#define   PIPE_CONTROL_DC_FLUSH_ENABLE			(1<<5)
#define   PIPE_CONTROL_VF_CACHE_INVALIDATE		(1<<4)
#define   PIPE_CONTROL_CONST_CACHE_INVALIDATE		(1<<3)
#define   PIPE_CONTROL_STATE_CACHE_INVALIDATE		(1<<2)
#define   PIPE_CONTROL_STALL_AT_SCOREBOARD		(1<<1)
#define   PIPE_CONTROL_DEPTH_CACHE_FLUSH		(1<<0)

#endif
