; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -tailcallopt -mattr=+sse2 -mtriple=x86_64-apple-darwin | FileCheck %s

; Check that x86-64 tail calls support x86_fp80 and v2f32 types. (Tail call
; calling convention out of sync with standard c calling convention on x86_64)
; Bug 4278.

declare fastcc double @tailcallee(x86_fp80, <2 x float>)

define fastcc double @tailcall() {
; CHECK-LABEL: tailcall:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    subq $40, %rsp
; CHECK-NEXT:    .cfi_def_cfa_offset 48
; CHECK-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; CHECK-NEXT:    movq %rax, {{[0-9]+}}(%rsp)
; CHECK-NEXT:    fld1
; CHECK-NEXT:    fstpt {{[0-9]+}}(%rsp)
; CHECK-NEXT:    movaps {{.*#+}} xmm0 = <1.0E+0,1.0E+0,u,u>
; CHECK-NEXT:    addq $24, %rsp
; CHECK-NEXT:    jmp _tailcallee ## TAILCALL
entry:
  %tmp = fpext float 1.000000e+00 to x86_fp80
	%tmp2 = tail call fastcc double @tailcallee( x86_fp80 %tmp,  <2 x float> <float 1.000000e+00, float 1.000000e+00>)
	ret double %tmp2
}
