// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple powerpc64le-linux-unknown -target-cpu future \
// RUN:   -emit-llvm -o - %s | FileCheck %s


// CHECK-LABEL: @test_dmr_copy(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[PTR1_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[PTR2_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store ptr [[PTR1:%.*]], ptr [[PTR1_ADDR]], align 8
// CHECK-NEXT:    store ptr [[PTR2:%.*]], ptr [[PTR2_ADDR]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[PTR1_ADDR]], align 8
// CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds <1024 x i1>, ptr [[TMP0]], i64 2
// CHECK-NEXT:    [[TMP1:%.*]] = load <1024 x i1>, ptr [[ADD_PTR]], align 128
// CHECK-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[PTR2_ADDR]], align 8
// CHECK-NEXT:    [[ADD_PTR1:%.*]] = getelementptr inbounds <1024 x i1>, ptr [[TMP2]], i64 1
// CHECK-NEXT:    store <1024 x i1> [[TMP1]], ptr [[ADD_PTR1]], align 128
// CHECK-NEXT:    ret void
//
void test_dmr_copy(__dmr1024 *ptr1, __dmr1024 *ptr2) {
  *(ptr2 + 1) = *(ptr1 + 2);
}

// CHECK-LABEL: @test_dmr_typedef(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[INP_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[OUTP_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[VDMRIN:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[VDMROUT:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store ptr [[INP:%.*]], ptr [[INP_ADDR]], align 8
// CHECK-NEXT:    store ptr [[OUTP:%.*]], ptr [[OUTP_ADDR]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[INP_ADDR]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[VDMRIN]], align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[OUTP_ADDR]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[VDMROUT]], align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[VDMRIN]], align 8
// CHECK-NEXT:    [[TMP3:%.*]] = load <1024 x i1>, ptr [[TMP2]], align 128
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[VDMROUT]], align 8
// CHECK-NEXT:    store <1024 x i1> [[TMP3]], ptr [[TMP4]], align 128
// CHECK-NEXT:    ret void
//
void test_dmr_typedef(int *inp, int *outp) {
  __dmr1024 *vdmrin = (__dmr1024 *)inp;
  __dmr1024 *vdmrout = (__dmr1024 *)outp;
  *vdmrout = *vdmrin;
}

// CHECK-LABEL: @test_dmr_arg(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VDMR_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[PTR_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[VDMRP:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store ptr [[VDMR:%.*]], ptr [[VDMR_ADDR]], align 8
// CHECK-NEXT:    store ptr [[PTR:%.*]], ptr [[PTR_ADDR]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[PTR_ADDR]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[VDMRP]], align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[VDMR_ADDR]], align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load <1024 x i1>, ptr [[TMP1]], align 128
// CHECK-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[VDMRP]], align 8
// CHECK-NEXT:    store <1024 x i1> [[TMP2]], ptr [[TMP3]], align 128
// CHECK-NEXT:    ret void
//
void test_dmr_arg(__dmr1024 *vdmr, int *ptr) {
  __dmr1024 *vdmrp = (__dmr1024 *)ptr;
  *vdmrp = *vdmr;
}

// CHECK-LABEL: @test_dmr_const_arg(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VDMR_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[PTR_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[VDMRP:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store ptr [[VDMR:%.*]], ptr [[VDMR_ADDR]], align 8
// CHECK-NEXT:    store ptr [[PTR:%.*]], ptr [[PTR_ADDR]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[PTR_ADDR]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[VDMRP]], align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[VDMR_ADDR]], align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load <1024 x i1>, ptr [[TMP1]], align 128
// CHECK-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[VDMRP]], align 8
// CHECK-NEXT:    store <1024 x i1> [[TMP2]], ptr [[TMP3]], align 128
// CHECK-NEXT:    ret void
//
void test_dmr_const_arg(const __dmr1024 *const vdmr, int *ptr) {
  __dmr1024 *vdmrp = (__dmr1024 *)ptr;
  *vdmrp = *vdmr;
}

// CHECK-LABEL: @test_dmr_array_arg(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[VDMRA_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[PTR_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[VDMRP:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store ptr [[VDMRA:%.*]], ptr [[VDMRA_ADDR]], align 8
// CHECK-NEXT:    store ptr [[PTR:%.*]], ptr [[PTR_ADDR]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[PTR_ADDR]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[VDMRP]], align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[VDMRA_ADDR]], align 8
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds <1024 x i1>, ptr [[TMP1]], i64 0
// CHECK-NEXT:    [[TMP2:%.*]] = load <1024 x i1>, ptr [[ARRAYIDX]], align 128
// CHECK-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[VDMRP]], align 8
// CHECK-NEXT:    store <1024 x i1> [[TMP2]], ptr [[TMP3]], align 128
// CHECK-NEXT:    ret void
//
void test_dmr_array_arg(__dmr1024 vdmra[], int *ptr) {
  __dmr1024 *vdmrp = (__dmr1024 *)ptr;
  *vdmrp = vdmra[0];
}

// CHECK-LABEL: @test_dmr_ret(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[PTR_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[VDMRP:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store ptr [[PTR:%.*]], ptr [[PTR_ADDR]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[PTR_ADDR]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[VDMRP]], align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[VDMRP]], align 8
// CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds <1024 x i1>, ptr [[TMP1]], i64 2
// CHECK-NEXT:    ret ptr [[ADD_PTR]]
//
__dmr1024 *test_dmr_ret(int *ptr) {
  __dmr1024 *vdmrp = (__dmr1024 *)ptr;
  return vdmrp + 2;
}

// CHECK-LABEL: @test_dmr_ret_const(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[PTR_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[VDMRP:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store ptr [[PTR:%.*]], ptr [[PTR_ADDR]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[PTR_ADDR]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[VDMRP]], align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[VDMRP]], align 8
// CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds <1024 x i1>, ptr [[TMP1]], i64 2
// CHECK-NEXT:    ret ptr [[ADD_PTR]]
//
const __dmr1024 *test_dmr_ret_const(int *ptr) {
  __dmr1024 *vdmrp = (__dmr1024 *)ptr;
  return vdmrp + 2;
}

// CHECK-LABEL: @test_dmr_sizeof_alignof(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[PTR_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[VDMRP:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[VDMR:%.*]] = alloca <1024 x i1>, align 128
// CHECK-NEXT:    [[SIZET:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[ALIGNT:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[SIZEV:%.*]] = alloca i32, align 4
// CHECK-NEXT:    [[ALIGNV:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store ptr [[PTR:%.*]], ptr [[PTR_ADDR]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[PTR_ADDR]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[VDMRP]], align 8
// CHECK-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[VDMRP]], align 8
// CHECK-NEXT:    [[TMP2:%.*]] = load <1024 x i1>, ptr [[TMP1]], align 128
// CHECK-NEXT:    store <1024 x i1> [[TMP2]], ptr [[VDMR]], align 128
// CHECK-NEXT:    store i32 128, ptr [[SIZET]], align 4
// CHECK-NEXT:    store i32 128, ptr [[ALIGNT]], align 4
// CHECK-NEXT:    store i32 128, ptr [[SIZEV]], align 4
// CHECK-NEXT:    store i32 128, ptr [[ALIGNV]], align 4
// CHECK-NEXT:    [[TMP3:%.*]] = load i32, ptr [[SIZET]], align 4
// CHECK-NEXT:    [[TMP4:%.*]] = load i32, ptr [[ALIGNT]], align 4
// CHECK-NEXT:    [[ADD:%.*]] = add i32 [[TMP3]], [[TMP4]]
// CHECK-NEXT:    [[TMP5:%.*]] = load i32, ptr [[SIZEV]], align 4
// CHECK-NEXT:    [[ADD1:%.*]] = add i32 [[ADD]], [[TMP5]]
// CHECK-NEXT:    [[TMP6:%.*]] = load i32, ptr [[ALIGNV]], align 4
// CHECK-NEXT:    [[ADD2:%.*]] = add i32 [[ADD1]], [[TMP6]]
// CHECK-NEXT:    ret i32 [[ADD2]]
//
int test_dmr_sizeof_alignof(int *ptr) {
  __dmr1024 *vdmrp = (__dmr1024 *)ptr;
  __dmr1024 vdmr = *vdmrp;
  unsigned sizet = sizeof(__dmr1024);
  unsigned alignt = __alignof__(__dmr1024);
   unsigned sizev = sizeof(vdmr);
  unsigned alignv = __alignof__(vdmr);
  return sizet + alignt + sizev + alignv;
}
