/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.StorageFormat;

public class StorageFormatManager {
    private List myStorageFormats = CollectionsFactory.current().createList();
    private StorageFormat myDefaultStorageFormat;

    public void addStorageFormat(StorageFormat storageFormat) {
        this.myStorageFormats.add(storageFormat);
    }

    public void removeStorageFormat(StorageFormat storageFormat) {
        this.myStorageFormats.remove(storageFormat);
    }

    public boolean containsStorageFormat(StorageFormat storageFormat) {
        return this.myStorageFormats.contains(storageFormat);
    }

    public void setDefaultStorageFormat(StorageFormat storageFormat) {
        this.myDefaultStorageFormat = storageFormat;
    }

    public StorageFormat getDefaultStorageFormat() {
        return this.myDefaultStorageFormat;
    }

    public void registerFileFilters(JFileChooser jFileChooser) {
        if (jFileChooser.getDialogType() == 0) {
            StorageFormat storageFormat;
            Iterator iterator = this.myStorageFormats.iterator();
            while (iterator.hasNext()) {
                storageFormat = (StorageFormat)iterator.next();
                if (!storageFormat.isRestoreFormat()) continue;
                jFileChooser.addChoosableFileFilter(storageFormat.getFileFilter());
            }
            storageFormat = this.getDefaultStorageFormat();
            if (storageFormat != null && storageFormat.isRestoreFormat()) {
                jFileChooser.setFileFilter(storageFormat.getFileFilter());
            }
        } else if (jFileChooser.getDialogType() == 1) {
            StorageFormat storageFormat;
            Iterator iterator = this.myStorageFormats.iterator();
            while (iterator.hasNext()) {
                storageFormat = (StorageFormat)iterator.next();
                if (!storageFormat.isStoreFormat()) continue;
                jFileChooser.addChoosableFileFilter(storageFormat.getFileFilter());
            }
            storageFormat = this.getDefaultStorageFormat();
            if (storageFormat != null && storageFormat.isStoreFormat()) {
                jFileChooser.setFileFilter(storageFormat.getFileFilter());
            }
        } else {
            StorageFormat storageFormat;
            Iterator iterator = this.myStorageFormats.iterator();
            while (iterator.hasNext()) {
                storageFormat = (StorageFormat)iterator.next();
                jFileChooser.addChoosableFileFilter(storageFormat.getFileFilter());
            }
            storageFormat = this.getDefaultStorageFormat();
            if (storageFormat != null) {
                jFileChooser.setFileFilter(storageFormat.getFileFilter());
            }
        }
    }

    public StorageFormat findStorageFormat(FileFilter fileFilter) {
        Iterator iterator = this.myStorageFormats.iterator();
        StorageFormat storageFormat = null;
        while (iterator.hasNext()) {
            storageFormat = (StorageFormat)iterator.next();
            if (!storageFormat.getFileFilter().equals(fileFilter)) continue;
            return storageFormat;
        }
        return null;
    }

    public StorageFormat findStorageFormat(File file) {
        Iterator iterator = this.myStorageFormats.iterator();
        while (iterator.hasNext()) {
            StorageFormat storageFormat = (StorageFormat)iterator.next();
            if (!storageFormat.getFileFilter().accept(file)) continue;
            return storageFormat;
        }
        return null;
    }
}

