//------------------------------------------------------------------------------
// <copyright file="XmlTypeCode.cs" company="Microsoft">
//     Copyright (c) Microsoft Corporation.  All rights reserved.
// </copyright> 
// <owner current="true" primary="true">[....]</owner>                                                               
//------------------------------------------------------------------------------

namespace System.Xml.Schema {

    /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode"]/*' />
    public enum XmlTypeCode {
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.None"]/*' />
        None,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.Item"]/*' />
        Item,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.Node"]/*' />
        Node,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.Document"]/*' />
        Document,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.Element"]/*' />
        Element,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.Attribute"]/*' />
        Attribute,

        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.Namespace"]/*' />
        Namespace,

        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.ProcessingInstruction"]/*' />
        ProcessingInstruction,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.Comment"]/*' />
        Comment,

        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.Text"]/*' />
        Text,

        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.AnyAtomicType"]/*' />
        AnyAtomicType,

        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.UntypedAtomic"]/*' />
        UntypedAtomic,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.String"]/*' />
        String,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.Boolean"]/*' />
        Boolean,

        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.Decimal"]/*' />
        Decimal,

        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.Float"]/*' />
        Float,

        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.Double"]/*' />
        Double,

        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.Duration"]/*' />
        Duration,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.DateTime"]/*' />
        DateTime,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.Time"]/*' />
        Time,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.Date"]/*' />
        Date,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.GYearMonth"]/*' />
        GYearMonth,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.GYear"]/*' />
        GYear,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.GMonthDay"]/*' />
        GMonthDay,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.GDay"]/*' />
        GDay,

        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.GMonth"]/*' />
        GMonth,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.HexBinary"]/*' />
        HexBinary,

        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.Base64Binary"]/*' />
        Base64Binary,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.AnyUri"]/*' />
        AnyUri,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.QName"]/*' />
        QName,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.Notation"]/*' />
        Notation,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.NormalizedString"]/*' />
        NormalizedString,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.Token"]/*' />
        Token,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.Language"]/*' />
        Language,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.NmToken"]/*' />
        NmToken,

        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.Name"]/*' />
        Name,

        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.NCName"]/*' />
        NCName,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.Id"]/*' />
        Id,

        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.Idref"]/*' />
        Idref,

        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.Entity"]/*' />
        Entity,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.Integer"]/*' />
        Integer,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.NonPositiveInteger"]/*' />
        NonPositiveInteger,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.NegativeInteger"]/*' />
        NegativeInteger,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.Long"]/*' />
        Long,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.Int"]/*' />
        Int,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.Short"]/*' />
        Short,

        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.Byte"]/*' />
        Byte,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.NonNegativeInteger"]/*' />
        NonNegativeInteger,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.UnsignedLong"]/*' />
        UnsignedLong,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.UnsignedInt"]/*' />
        UnsignedInt,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.UnsignedShort"]/*' />
        UnsignedShort,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.UnsignedByte"]/*' />
        UnsignedByte,

        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.PositiveInteger"]/*' />
        PositiveInteger,
        
        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.YearMonthDuration"]/*' />
        YearMonthDuration,

        /// <include file='doc\XmlTypeCode.uex' path='docs/doc[@for="XmlTypeCode.DayTimeDuration"]/*' />
        DayTimeDuration,

    }

}
