/*      -*- linux-c -*-
 *
 * (C) Copyright IBM Corp. 2004
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  This
 * file and program are licensed under a BSD style license.  See
 * the Copying file included with the OpenHPI distribution for
 * full licensing terms.
 *
 * Author(s):
 *      Steve Sherman <stevees@us.ibm.com> 
 */

/******************************************************************* 
 * WARNING! This file is auto-magically generated by:
 *          ./SaHpi2code.pl. 
 *          Do not change this file manually. Update script instead
 *******************************************************************/

#include <stdio.h>
#include <string.h>

#include <SaHpi.h>
#include <oh_utils.h>

#define BAD_ENUM_VALUE -1

int main(int argc, char **argv) 
{
        char *expected_str;
        char *str;

        /* AtcaHpiLedColorT - ATCAHPI_LED_COLOR_RESERVED testcase */
        {
	        AtcaHpiLedColorT value = ATCAHPI_LED_COLOR_RESERVED;
		AtcaHpiLedColorT enum_type;
                expected_str = "COLOR_RESERVED";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_atcahpiledcolor(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_atcahpiledcolor(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (ATCAHPI_LED_COLOR_RESERVED != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* AtcaHpiLedColorT - ATCAHPI_LED_COLOR_BLUE testcase */
        {
	        AtcaHpiLedColorT value = ATCAHPI_LED_COLOR_BLUE;
		AtcaHpiLedColorT enum_type;
                expected_str = "COLOR_BLUE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_atcahpiledcolor(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_atcahpiledcolor(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (ATCAHPI_LED_COLOR_BLUE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* AtcaHpiLedColorT - ATCAHPI_LED_COLOR_RED testcase */
        {
	        AtcaHpiLedColorT value = ATCAHPI_LED_COLOR_RED;
		AtcaHpiLedColorT enum_type;
                expected_str = "COLOR_RED";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_atcahpiledcolor(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_atcahpiledcolor(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (ATCAHPI_LED_COLOR_RED != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* AtcaHpiLedColorT - ATCAHPI_LED_COLOR_GREEN testcase */
        {
	        AtcaHpiLedColorT value = ATCAHPI_LED_COLOR_GREEN;
		AtcaHpiLedColorT enum_type;
                expected_str = "COLOR_GREEN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_atcahpiledcolor(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_atcahpiledcolor(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (ATCAHPI_LED_COLOR_GREEN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* AtcaHpiLedColorT - ATCAHPI_LED_COLOR_AMBER testcase */
        {
	        AtcaHpiLedColorT value = ATCAHPI_LED_COLOR_AMBER;
		AtcaHpiLedColorT enum_type;
                expected_str = "COLOR_AMBER";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_atcahpiledcolor(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_atcahpiledcolor(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (ATCAHPI_LED_COLOR_AMBER != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* AtcaHpiLedColorT - ATCAHPI_LED_COLOR_ORANGE testcase */
        {
	        AtcaHpiLedColorT value = ATCAHPI_LED_COLOR_ORANGE;
		AtcaHpiLedColorT enum_type;
                expected_str = "COLOR_ORANGE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_atcahpiledcolor(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_atcahpiledcolor(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (ATCAHPI_LED_COLOR_ORANGE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* AtcaHpiLedColorT - ATCAHPI_LED_COLOR_WHITE testcase */
        {
	        AtcaHpiLedColorT value = ATCAHPI_LED_COLOR_WHITE;
		AtcaHpiLedColorT enum_type;
                expected_str = "COLOR_WHITE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_atcahpiledcolor(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_atcahpiledcolor(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (ATCAHPI_LED_COLOR_WHITE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* AtcaHpiLedColorT - ATCAHPI_LED_COLOR_NO_CHANGE testcase */
        {
	        AtcaHpiLedColorT value = ATCAHPI_LED_COLOR_NO_CHANGE;
		AtcaHpiLedColorT enum_type;
                expected_str = "COLOR_NO_CHANGE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_atcahpiledcolor(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_atcahpiledcolor(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (ATCAHPI_LED_COLOR_NO_CHANGE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* AtcaHpiLedColorT - ATCAHPI_LED_COLOR_USE_DEFAULT testcase */
        {
	        AtcaHpiLedColorT value = ATCAHPI_LED_COLOR_USE_DEFAULT;
		AtcaHpiLedColorT enum_type;
                expected_str = "COLOR_USE_DEFAULT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_atcahpiledcolor(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_atcahpiledcolor(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (ATCAHPI_LED_COLOR_USE_DEFAULT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* AtcaHpiLedColorT - Default testcase */
        {
	        AtcaHpiLedColorT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_atcahpiledcolor(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* AtcaHpiLedColorT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		AtcaHpiLedColorT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_atcahpiledcolor(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* AtcaHpiLedColorT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_atcahpiledcolor(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* AtcaHpiResourceLedModeT - ATCAHPI_LED_AUTO testcase */
        {
	        AtcaHpiResourceLedModeT value = ATCAHPI_LED_AUTO;
		AtcaHpiResourceLedModeT enum_type;
                expected_str = "AUTO";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_atcahpiresourceledmode(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_atcahpiresourceledmode(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (ATCAHPI_LED_AUTO != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* AtcaHpiResourceLedModeT - ATCAHPI_LED_MANUAL testcase */
        {
	        AtcaHpiResourceLedModeT value = ATCAHPI_LED_MANUAL;
		AtcaHpiResourceLedModeT enum_type;
                expected_str = "MANUAL";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_atcahpiresourceledmode(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_atcahpiresourceledmode(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (ATCAHPI_LED_MANUAL != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* AtcaHpiResourceLedModeT - ATCAHPI_LED_LAMP_TEST testcase */
        {
	        AtcaHpiResourceLedModeT value = ATCAHPI_LED_LAMP_TEST;
		AtcaHpiResourceLedModeT enum_type;
                expected_str = "LAMP_TEST";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_atcahpiresourceledmode(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_atcahpiresourceledmode(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (ATCAHPI_LED_LAMP_TEST != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* AtcaHpiResourceLedModeT - Default testcase */
        {
	        AtcaHpiResourceLedModeT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_atcahpiresourceledmode(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* AtcaHpiResourceLedModeT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		AtcaHpiResourceLedModeT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_atcahpiresourceledmode(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* AtcaHpiResourceLedModeT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_atcahpiresourceledmode(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* AtcaHpiLedBrSupportT - ATCAHPI_LED_BR_SUPPORTED testcase */
        {
	        AtcaHpiLedBrSupportT value = ATCAHPI_LED_BR_SUPPORTED;
		AtcaHpiLedBrSupportT enum_type;
                expected_str = "BR_SUPPORTED";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_atcahpiledbrsupport(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_atcahpiledbrsupport(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (ATCAHPI_LED_BR_SUPPORTED != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* AtcaHpiLedBrSupportT - ATCAHPI_LED_BR_NOT_SUPPORTED testcase */
        {
	        AtcaHpiLedBrSupportT value = ATCAHPI_LED_BR_NOT_SUPPORTED;
		AtcaHpiLedBrSupportT enum_type;
                expected_str = "BR_NOT_SUPPORTED";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_atcahpiledbrsupport(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_atcahpiledbrsupport(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (ATCAHPI_LED_BR_NOT_SUPPORTED != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* AtcaHpiLedBrSupportT - ATCAHPI_LED_BR_UNKNOWN testcase */
        {
	        AtcaHpiLedBrSupportT value = ATCAHPI_LED_BR_UNKNOWN;
		AtcaHpiLedBrSupportT enum_type;
                expected_str = "BR_UNKNOWN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_atcahpiledbrsupport(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_atcahpiledbrsupport(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (ATCAHPI_LED_BR_UNKNOWN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* AtcaHpiLedBrSupportT - Default testcase */
        {
	        AtcaHpiLedBrSupportT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_atcahpiledbrsupport(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* AtcaHpiLedBrSupportT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		AtcaHpiLedBrSupportT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_atcahpiledbrsupport(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* AtcaHpiLedBrSupportT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_atcahpiledbrsupport(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* AtcaHpiEntityTypeT - ATCAHPI_ENT_POWER_ENTRY_MODULE_SLOT testcase */
        {
	        AtcaHpiEntityTypeT value = ATCAHPI_ENT_POWER_ENTRY_MODULE_SLOT;
		AtcaHpiEntityTypeT enum_type;
                expected_str = "POWER_ENTRY_MODULE_SLOT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_atcahpientitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_atcahpientitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (ATCAHPI_ENT_POWER_ENTRY_MODULE_SLOT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* AtcaHpiEntityTypeT - ATCAHPI_ENT_SHELF_FRU_DEVICE_SLOT testcase */
        {
	        AtcaHpiEntityTypeT value = ATCAHPI_ENT_SHELF_FRU_DEVICE_SLOT;
		AtcaHpiEntityTypeT enum_type;
                expected_str = "SHELF_FRU_DEVICE_SLOT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_atcahpientitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_atcahpientitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (ATCAHPI_ENT_SHELF_FRU_DEVICE_SLOT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* AtcaHpiEntityTypeT - ATCAHPI_ENT_SHELF_MANAGER_SLOT testcase */
        {
	        AtcaHpiEntityTypeT value = ATCAHPI_ENT_SHELF_MANAGER_SLOT;
		AtcaHpiEntityTypeT enum_type;
                expected_str = "SHELF_MANAGER_SLOT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_atcahpientitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_atcahpientitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (ATCAHPI_ENT_SHELF_MANAGER_SLOT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* AtcaHpiEntityTypeT - ATCAHPI_ENT_FAN_TRAY_SLOT testcase */
        {
	        AtcaHpiEntityTypeT value = ATCAHPI_ENT_FAN_TRAY_SLOT;
		AtcaHpiEntityTypeT enum_type;
                expected_str = "FAN_TRAY_SLOT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_atcahpientitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_atcahpientitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (ATCAHPI_ENT_FAN_TRAY_SLOT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* AtcaHpiEntityTypeT - ATCAHPI_ENT_FAN_FILTER_TRAY_SLOT testcase */
        {
	        AtcaHpiEntityTypeT value = ATCAHPI_ENT_FAN_FILTER_TRAY_SLOT;
		AtcaHpiEntityTypeT enum_type;
                expected_str = "FAN_FILTER_TRAY_SLOT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_atcahpientitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_atcahpientitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (ATCAHPI_ENT_FAN_FILTER_TRAY_SLOT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* AtcaHpiEntityTypeT - ATCAHPI_ENT_ALARM_SLOT testcase */
        {
	        AtcaHpiEntityTypeT value = ATCAHPI_ENT_ALARM_SLOT;
		AtcaHpiEntityTypeT enum_type;
                expected_str = "ALARM_SLOT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_atcahpientitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_atcahpientitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (ATCAHPI_ENT_ALARM_SLOT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* AtcaHpiEntityTypeT - ATCAHPI_ENT_AMC_SLOT testcase */
        {
	        AtcaHpiEntityTypeT value = ATCAHPI_ENT_AMC_SLOT;
		AtcaHpiEntityTypeT enum_type;
                expected_str = "AMC_SLOT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_atcahpientitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_atcahpientitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (ATCAHPI_ENT_AMC_SLOT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* AtcaHpiEntityTypeT - ATCAHPI_ENT_PMC_SLOT testcase */
        {
	        AtcaHpiEntityTypeT value = ATCAHPI_ENT_PMC_SLOT;
		AtcaHpiEntityTypeT enum_type;
                expected_str = "PMC_SLOT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_atcahpientitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_atcahpientitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (ATCAHPI_ENT_PMC_SLOT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* AtcaHpiEntityTypeT - ATCAHPI_ENT_RTM_SLOT testcase */
        {
	        AtcaHpiEntityTypeT value = ATCAHPI_ENT_RTM_SLOT;
		AtcaHpiEntityTypeT enum_type;
                expected_str = "RTM_SLOT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_atcahpientitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_atcahpientitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (ATCAHPI_ENT_RTM_SLOT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* AtcaHpiEntityTypeT - ATCAHPI_ENT_PICMG_FRONT_BLADE testcase */
        {
	        AtcaHpiEntityTypeT value = ATCAHPI_ENT_PICMG_FRONT_BLADE;
		AtcaHpiEntityTypeT enum_type;
                expected_str = "PICMG_FRONT_BLADE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_atcahpientitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_atcahpientitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (ATCAHPI_ENT_PICMG_FRONT_BLADE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* AtcaHpiEntityTypeT - ATCAHPI_ENT_SHELF_FRU_DEVICE testcase */
        {
	        AtcaHpiEntityTypeT value = ATCAHPI_ENT_SHELF_FRU_DEVICE;
		AtcaHpiEntityTypeT enum_type;
                expected_str = "SHELF_FRU_DEVICE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_atcahpientitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_atcahpientitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (ATCAHPI_ENT_SHELF_FRU_DEVICE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* AtcaHpiEntityTypeT - ATCAHPI_ENT_FILTRATION_UNIT testcase */
        {
	        AtcaHpiEntityTypeT value = ATCAHPI_ENT_FILTRATION_UNIT;
		AtcaHpiEntityTypeT enum_type;
                expected_str = "FILTRATION_UNIT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_atcahpientitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_atcahpientitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (ATCAHPI_ENT_FILTRATION_UNIT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* AtcaHpiEntityTypeT - ATCAHPI_ENT_AMC testcase */
        {
	        AtcaHpiEntityTypeT value = ATCAHPI_ENT_AMC;
		AtcaHpiEntityTypeT enum_type;
                expected_str = "AMC";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_atcahpientitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_atcahpientitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (ATCAHPI_ENT_AMC != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* AtcaHpiEntityTypeT - Default testcase */
        {
	        AtcaHpiEntityTypeT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_atcahpientitytype(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* AtcaHpiEntityTypeT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		AtcaHpiEntityTypeT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_atcahpientitytype(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* AtcaHpiEntityTypeT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_atcahpientitytype(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        return 0;
}
