/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM)

#include "JSNavigatorUserMediaError.h"

#include "NavigatorUserMediaError.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSNavigatorUserMediaError);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSNavigatorUserMediaErrorTableValues[3] =
{
    { "code", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorUserMediaErrorCode), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorUserMediaErrorConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSNavigatorUserMediaErrorTable = { 5, 3, JSNavigatorUserMediaErrorTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSNavigatorUserMediaErrorConstructorTableValues[2] =
{
    { "PERMISSION_DENIED", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorUserMediaErrorPERMISSION_DENIED), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSNavigatorUserMediaErrorConstructorTable = { 2, 1, JSNavigatorUserMediaErrorConstructorTableValues, 0 };

COMPILE_ASSERT(1 == NavigatorUserMediaError::PERMISSION_DENIED, NavigatorUserMediaErrorEnumPERMISSION_DENIEDIsWrongUseDontCheckEnums);

class JSNavigatorUserMediaErrorConstructor : public DOMConstructorObject {
public:
    JSNavigatorUserMediaErrorConstructor(JSC::ExecState*, JSC::Structure*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount, &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSNavigatorUserMediaErrorConstructor::s_info = { "NavigatorUserMediaErrorConstructor", &DOMConstructorObject::s_info, &JSNavigatorUserMediaErrorConstructorTable, 0 };

JSNavigatorUserMediaErrorConstructor::JSNavigatorUserMediaErrorConstructor(ExecState* exec, Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSNavigatorUserMediaErrorPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSNavigatorUserMediaErrorConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSNavigatorUserMediaErrorConstructor, JSDOMWrapper>(exec, &JSNavigatorUserMediaErrorConstructorTable, this, propertyName, slot);
}

bool JSNavigatorUserMediaErrorConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSNavigatorUserMediaErrorConstructor, JSDOMWrapper>(exec, &JSNavigatorUserMediaErrorConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSNavigatorUserMediaErrorPrototypeTableValues[2] =
{
    { "PERMISSION_DENIED", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorUserMediaErrorPERMISSION_DENIED), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSNavigatorUserMediaErrorPrototypeTable = { 2, 1, JSNavigatorUserMediaErrorPrototypeTableValues, 0 };
const ClassInfo JSNavigatorUserMediaErrorPrototype::s_info = { "NavigatorUserMediaErrorPrototype", &JSC::JSObjectWithGlobalObject::s_info, &JSNavigatorUserMediaErrorPrototypeTable, 0 };

JSObject* JSNavigatorUserMediaErrorPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSNavigatorUserMediaError>(exec, globalObject);
}

bool JSNavigatorUserMediaErrorPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSNavigatorUserMediaErrorPrototype, JSObject>(exec, &JSNavigatorUserMediaErrorPrototypeTable, this, propertyName, slot);
}

bool JSNavigatorUserMediaErrorPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSNavigatorUserMediaErrorPrototype, JSObject>(exec, &JSNavigatorUserMediaErrorPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSNavigatorUserMediaError::s_info = { "NavigatorUserMediaError", &JSDOMWrapper::s_info, &JSNavigatorUserMediaErrorTable, 0 };

JSNavigatorUserMediaError::JSNavigatorUserMediaError(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<NavigatorUserMediaError> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
    ASSERT(inherits(&s_info));
}

JSObject* JSNavigatorUserMediaError::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSNavigatorUserMediaErrorPrototype(exec->globalData(), globalObject, JSNavigatorUserMediaErrorPrototype::createStructure(globalObject->globalData(), globalObject->objectPrototype()));
}

bool JSNavigatorUserMediaError::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSNavigatorUserMediaError, Base>(exec, &JSNavigatorUserMediaErrorTable, this, propertyName, slot);
}

bool JSNavigatorUserMediaError::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSNavigatorUserMediaError, Base>(exec, &JSNavigatorUserMediaErrorTable, this, propertyName, descriptor);
}

JSValue jsNavigatorUserMediaErrorCode(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSNavigatorUserMediaError* castedThis = static_cast<JSNavigatorUserMediaError*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    NavigatorUserMediaError* imp = static_cast<NavigatorUserMediaError*>(castedThis->impl());
    JSValue result = jsNumber(imp->code());
    return result;
}


JSValue jsNavigatorUserMediaErrorConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSNavigatorUserMediaError* domObject = static_cast<JSNavigatorUserMediaError*>(asObject(slotBase));
    return JSNavigatorUserMediaError::getConstructor(exec, domObject->globalObject());
}

JSValue JSNavigatorUserMediaError::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSNavigatorUserMediaErrorConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

// Constant getters

JSValue jsNavigatorUserMediaErrorPERMISSION_DENIED(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, NavigatorUserMediaError* impl)
{
    return wrap<JSNavigatorUserMediaError>(exec, globalObject, impl);
}

NavigatorUserMediaError* toNavigatorUserMediaError(JSC::JSValue value)
{
    return value.inherits(&JSNavigatorUserMediaError::s_info) ? static_cast<JSNavigatorUserMediaError*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(MEDIA_STREAM)
