/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.config;

import amazon.fws.clicommando.config.ColumnConfig;
import amazon.fws.clicommando.config.ExampleConfig;
import amazon.fws.clicommando.config.OutputFormatConfig;
import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputDescriptionConfig {
    private String name;
    private String tableName;
    private String helpRef;
    private String emptyResult;
    private List<ExampleConfig> outputExamples;
    private List<ColumnConfig> columns;
    private List<OutputFormatConfig> tables;

    public OutputDescriptionConfig(String name, String tableName, String helpRef, String emptyResult) {
        this.name = name;
        this.tableName = tableName;
        this.helpRef = helpRef;
        this.emptyResult = emptyResult;
        this.columns = new ArrayList<ColumnConfig>();
        this.outputExamples = new ArrayList<ExampleConfig>();
        this.tables = new ArrayList<OutputFormatConfig>();
    }

    public Integer getSortByColumn() {
        Integer index = null;
        for (int i = 0; i < this.getColumns().size(); ++i) {
            ColumnConfig col = this.getColumns().get(i);
            if (col.getSortBy() == null) continue;
            index = i;
            break;
        }
        return index;
    }

    public List<ExampleConfig> getOutputExamples() {
        return this.outputExamples;
    }

    public void addOutputExamples(ExampleConfig outputExample) {
        this.outputExamples.add(outputExample);
    }

    public String getHelpRef() {
        return this.helpRef;
    }

    public String getEmptyResult() {
        return this.emptyResult;
    }

    public String getName() {
        return this.name;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<ColumnConfig> getColumns() {
        return this.getColumnsByType(ColumnConfig.ColumnListType.ALL);
    }

    public boolean doesColumnExist(String colHeader) {
        boolean ret = false;
        for (ColumnConfig col : this.columns) {
            if (!col.getHeader().equals(colHeader)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public ColumnConfig getColumn(String colHeader) {
        ColumnConfig ret = null;
        for (ColumnConfig col : this.columns) {
            if (!col.getHeader().equals(colHeader)) continue;
            ret = col;
            break;
        }
        if (ret == null) {
            throw new ConfigurationErrorException("The output description '" + this.getName() + "' doesn't have a column header named '" + colHeader + "'");
        }
        return ret;
    }

    public List<OutputFormatConfig> getTables() {
        return this.tables;
    }

    public void addTable(OutputFormatConfig outFormat) {
        this.tables.add(outFormat);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columns == null ? 0 : ((Object)this.columns).hashCode());
        result = 31 * result + (this.emptyResult == null ? 0 : this.emptyResult.hashCode());
        result = 31 * result + (this.helpRef == null ? 0 : this.helpRef.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.outputExamples == null ? 0 : ((Object)this.outputExamples).hashCode());
        result = 31 * result + (this.tables == null ? 0 : ((Object)this.tables).hashCode());
        result = 31 * result + (this.tableName == null ? 0 : this.tableName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputDescriptionConfig)) {
            return false;
        }
        OutputDescriptionConfig other = (OutputDescriptionConfig)obj;
        if (this.columns == null ? other.columns != null : !((Object)this.columns).equals(other.columns)) {
            return false;
        }
        if (this.emptyResult == null ? other.emptyResult != null : !this.emptyResult.equals(other.emptyResult)) {
            return false;
        }
        if (this.helpRef == null ? other.helpRef != null : !this.helpRef.equals(other.helpRef)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.outputExamples == null ? other.outputExamples != null : !((Object)this.outputExamples).equals(other.outputExamples)) {
            return false;
        }
        if (this.tables == null ? other.tables != null : !((Object)this.tables).equals(other.tables)) {
            return false;
        }
        return !(this.tableName == null ? other.tableName != null : !this.tableName.equals(other.tableName));
    }

    public void addColumn(ColumnConfig column) {
        this.columns.add(column);
    }

    public List<ColumnConfig> getColumnsByType(ColumnConfig.ColumnListType listType) {
        List<ColumnConfig> ret = null;
        if (listType == ColumnConfig.ColumnListType.ALL) {
            ret = this.columns;
        } else {
            ret = new ArrayList<ColumnConfig>();
            for (ColumnConfig col : this.columns) {
                if (col.getListColumn() != ColumnConfig.ColumnListType.SHORT) continue;
                ret.add(col);
            }
        }
        return ret;
    }
}

