/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_SB.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgScanBoolean(struct Cfg_Getopt * const optstru, int * const num);

  *	Interprete boolean option
 *	- If the option has an argument, optGetBoolean() must succeed, then the
 *		action is applied to the given value
 *	- If the option has no argument:
 *	-- If the option has an active boolean sign attched, its value is used.
 *	-- otherwise, the state of the option is toggled.
 *	Return:
 *		0: success
 *		1: no argument at all; *num not changed
 *		2: more than one word on line; *num not changed
 *		3: invalid argument; *num not changed

ob(ject): cfgScanBoolean
su(bsystem): cmdline
ty(pe): 
sy(nopsis): 
sh(ort description): Perform a boolean option
he(ader files): 
lo(ng description): Check if the current option is a boolean one and/or
	has a boolean modifier attached. If so, the \para{*num} value is
	modified according the rules.
pr(erequistes): 
va(lue): 0: success
	\item 1: no argument at all
	\item 2: more than one word specified as argument
	\item 3: invalid argument
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfg_sb.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <limits.h>
#include <portable.h>
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_SB.C 1.4 1999/12/13 02:22:05 ska Exp ska $";
#endif

int cfgScanBoolean(struct Cfg_Getopt * const optstru, int * const num)
{	int n, err;

	DBG_ENTER("cfgScanBoolean", Suppl_cmdline)

	assert(optstru);

	n = *num;
	switch(err = cfgGetBoolean(optstru, &n)) {
	case 1:		/* no argument at all */
		switch(optHasBool()) {
		case '+': /* true */
			*num = 1;
			DBG_RETURN_I( 0)
		case '-': /* false */
			*num = 0;
			DBG_RETURN_I( 0)
		}
		/* none --> toggle */
	toggle:
		*num = !*num;
		DBG_RETURN_I( 0)

	case 0:		/* OK */
		if(n == 2) goto toggle;
		*num = n;
		DBG_RETURN_I( 0)
	}

	DBG_RETURN_I( err)
}
