/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGIVERI.C $
   $Locker: ska $	$Name:  $	$State: Exp $

ob: cfgViewErrorINI
su: inifile
sh: Display the passed cfg error number in an human readeble form
lo: Display the passed cfg error number in an human readeble form.\par
	If \para{msg} != NULL, the string, a colon and a space preceeds the
	error string.
va: 0: on success
	\item else: on failure
re: cfgi_getErrorString
fi: cfgiveri.c
in:

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <stdio.h>
#include "inifile.loc"
#include "msgs.lng"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGIVERI.C 1.5 2001/02/27 01:27:46 ska Exp ska $";
#endif

int cfgViewErrorINI(const char * const msg, int errnr)
{	char *errstr;

	DBG_ENTER("cfgViewErrorINI", Suppl_inifile)
	DBG_ARGUMENTS( ("msg=\"%s\", errnr=%d", msg, errnr) )

	if(!errnr)		DBG_RETURN_I( 0)

	chkHeap
	if(msg) {
		fputs(msg, stderr);
		fputs(": ", stderr);
	}

	chkHeap
	if((errstr = cfgi_getErrorString(errnr)) != 0) {
		fputs(errstr, stderr);
		DBG_RETURN_I( 0)
	}

	chkHeap
	fputs(E_CFGunknown, stderr);
	DBG_RETURN_I( 1)
}
