#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Broken Sword 2 Remastered
# send your bug reports to contact@dotslashplay.it
###

script_version=20230824.1

GAME_ID='broken-sword-2-remastered'
GAME_NAME='Broken Sword Ⅱ: The Smoking Mirror - Remastered'

ARCHIVE_BASE_1='broken_sword_2_remastered_3_3_0_59987.sh'
ARCHIVE_BASE_1_MD5='7e9b9959778dfcf4b2e346dbe6657c3f'
ARCHIVE_BASE_1_SIZE='810000'
ARCHIVE_BASE_1_VERSION='3.3.0-gog59987'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/broken_sword_2__the_smoking_mirror'

ARCHIVE_BASE_0='gog_broken_sword_2_remastered_2.0.0.3.sh'
ARCHIVE_BASE_0_MD5='a67ce1d6a47b74281b6f230365fb296a'
ARCHIVE_BASE_0_SIZE='1400000'
ARCHIVE_BASE_0_VERSION='1.0.800-gog.2.0.0.3'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_BIN32_FILES='
BrokenSword2_i386'
CONTENT_GAME_BIN32_FILES_0='
BS2Remastered_i386'
CONTENT_GAME_BIN64_FILES='
BrokenSword2_x86_64'
CONTENT_GAME_DATA_FILES='
Audio
Comic
Game
Movies
Text
Data.dat
Legal.txt'
CONTENT_GAME_DATA_FILES_0='
Fonts
PC
Text
icon.bmp
bs2.ico
*.BUK
*.clu
*.dat
*.DAT
*.DIC'

APP_MAIN_EXE_BIN32='BrokenSword2_i386'
APP_MAIN_EXE_BIN32_0='BS2Remastered_i386'
APP_MAIN_EXE_BIN64='BrokenSword2_x86_64'
APP_MAIN_ICON='../support/icon.png'
APP_MAIN_ICON_0='icon.bmp'

PACKAGES_LIST='PKG_BIN32 PKG_BIN64 PKG_DATA'
PACKAGES_LIST_0='PKG_BIN32 PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN32_ARCH='32'
PKG_BIN64_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN32_DEPS="$PKG_BIN_DEPS"
PKG_BIN64_DEPS="$PKG_BIN_DEPS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libopenal.so.1
libpthread.so.0
librt.so.1
libstdc++.so.6'
PKG_BIN_DEPENDENCIES_LIBRARIES_0='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libopenal.so.1
libpthread.so.0
librt.so.1
libSDL-1.2.so.0
libstdc++.so.6'
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES_0="$PKG_BIN_DEPENDENCIES_LIBRARIES_0"
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

# Load common functions

target_version='2.24'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

APP_MAIN_EXE_BIN32=$(context_value 'APP_MAIN_EXE_BIN32')
for PKG in 'PKG_BIN32' 'PKG_BIN64'; do
	if packages_get_list | grep --quiet --fixed-strings --word-regexp "$(context_package)"; then
		launchers_write
	fi
done

# Build packages

packages_generation

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
