!{\src2tex{textfont=tt}}
!!****f* ABINIT/memerr
!! NAME
!! memerr
!!
!! FUNCTION
!!  This function deals with the failure of a memory allocation
!!  It writes a message reporting the name of the subroutine where 
!!  the allocation has failed and the dimension of the array.
!!  It uses leave_now to stop the code smoothly
!! 
!! COPYRIGHT
!!  Copyright (C) 2006-2007 ABINIT group (MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  sub_name=name of the subroutine where the allocation failed
!!  array_name=name of the array that has not been allocated
!!  size=total size fo the array
!!  kindp=string defining the kind of the array 
!!     sp  for single precision real
!!     spc for single precision complex
!!     dp  for double-precision real
!!     dpc for double-precision complex 
!!     
!! OUTPUT
!!  Only write and stop the code 
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!      anascr,findnq,rdscr,screening,sigma
!!
!! CHILDREN
!!      leave_new,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine memerr(sub_name,array_name,size_in,kindp)

 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: size_in
 character(len=*),intent(in) :: array_name,kindp,sub_name

!Local variables-------------------------------
!scalars
 integer :: ib
 character(len=500) :: message

! *************************************************************************
 
 if (trim(kindp)=='sp') then 
  !cannot use sp because it is commented in defs_basis.F90
  ib=kind(1.0) 
 else if (trim(kindp)=='spc') then
  !cannot use spc because it is commented in defs_basis.F90
  ib=kind((1.0d0,1.0d0))
 else if (trim(kindp)=='dp') then 
  ib=dp
 else if (trim(kindp)=='dpc') then
  ib=dpc 
 else if (trim(kindp)=='i1b') then 
  ib=i1b
 else if (trim(kindp)=='i2b') then 
  ib=i2b
 else if (trim(kindp)=='i4b') then 
  ib=i4b
 else 
  write(message,'(2a)')&
&  ' memerr: ERROR -',&
&  ' memerr called with a wrong value of spk'
  call wrtout(6,message,'COLL')
  call leave_new('COLL')
 end if 
 
 !write message and stop the code
 write(message,'(9a,f12.2,a)')ch10,&
& ' ',trim(sub_name),': ERROR -',ch10,&
& ' out of memory in ',trim(array_name),ch10,&
& ' requiring ',size_in*ib/(1024._dp**2),' Mb'
 call wrtout(6,message,'COLL')
 call leave_new('COLL')

end subroutine memerr
!!***
